<?php
/**
 * roja45productrental-cron
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  roja45productrental-cron
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

include(dirname(__FILE__) . '/../../config/config.inc.php');
include(dirname(__FILE__) . '/../../init.php');

/* Check to security token */
if (Tools::substr(Tools::encrypt('roja45productrental/cron'), 0, 10) != Tools::getValue('token') || !Module::isInstalled('roja45productrental')) {
    die('Roja45: Product Rental: Bad token for cron task.');
}

$roja45productrental = Module::getInstanceByName('roja45productrental');
/* Check if the module is enabled */
if ($roja45productrental->active) {
    $parameters = array();

    $parameters['process_payments'] = 1;
    $parameters['process_arrivals'] = 1;
    $parameters['process_reviews'] = 1;
    $parameters['process_abondoned'] = 1;

    if ($reference = Tools::getValue('reference')) {
        $parameters['reference'] = $reference;
    }
    $roja45productrental->cron = true;
    return (Tools::dieObject($roja45productrental->processCron($parameters), false));
}
