<?php
/**
 * Roja45ProductRental.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Roja45ProductRental
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * Roja45ProductRental.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Class
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

spl_autoload_register(function ($class_name) {
    if (file_exists(_PS_MODULE_DIR_ . 'roja45productrental/classes/' . $class_name . '.php')) {
        include _PS_MODULE_DIR_ . 'roja45productrental/classes/' . $class_name . '.php';
    } elseif (0 === strpos($class_name, 'Html2Text')) {
        if (file_exists(_PS_MODULE_DIR_ . 'roja45productrental/vendor/Html2Text/' . $class_name . '.php')) {
            require_once _PS_MODULE_DIR_ . 'roja45productrental/vendor/Html2Text/' . $class_name . '.php';
        }
    }
});

class Roja45ProductRental extends Module
{
    public $html;
    protected static $cache_enabled;

    public function __construct()
    {
        $this->name = 'roja45productrental';
        $this->tab = 'others';
        $this->version = '1.5.23';
        $this->author = 'Roja45';
        $this->is_eu_compatible = 1;
        $this->need_instance = 1;
        $this->bootstrap = true;
        $this->tabClassName = 'AdminProductRental';

        parent::__construct();

        $this->controllers = array(
            'ProductRentalFacetedSearch',
            'ProductRentalSearch',
            'ProductRentalFront',
        );

        $this->displayName = $this->l('Roja45: Product Rental');
        $this->description = $this->l('Rent and manage selected products from your catalog.');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->confirmUninstall = $this->l('Are you sure you want to delete all saved details?');
        $this->secure_key = Tools::encrypt($this->name);
        RojaFortyFiveProductRentalCore::validateUpdate($this);
        $this->module_key = '1df50d808125171c096efd49439b8b59';
        $this->author_address = '0xF3D82474F7BE4238658Bac2a21e8aD338B86447f';
    }

    public function install()
    {
        /*
         * Override if bugged version
        */
        if ((version_compare(_PS_VERSION_, '1.6.1.2', '>=') === true) && (version_compare(_PS_VERSION_, '1.6.1.10', '<=') === true)) {
            if (file_exists(_PS_MODULE_DIR_ . $this->name . '/override_16/classes/SpecificPrice.php')) {
                copy(_PS_MODULE_DIR_ . $this->name . '/override_16/classes/SpecificPrice.php', _PS_MODULE_DIR_ . $this->name . '/override/classes/SpecificPrice.php');
            }
        } elseif (version_compare(_PS_VERSION_, '1.6.1.10', '>') === true) {
            if (file_exists(_PS_MODULE_DIR_ . $this->name . '/override_16/classes/SpecificPrice.php') &&
                file_exists(_PS_MODULE_DIR_ . $this->name . '/override/classes/SpecificPrice.php')) {
                unlink(_PS_MODULE_DIR_ . $this->name . '/override/classes/SpecificPrice.php');
            }
        }

        if (!parent::install()
            || !$this->registerHooks()
            || !Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLED', 1)
            || !$this->installDb()
            || !$this->setGlobalVars()
            || !$this->populateDefaultData()
            || !$this->installTabs()
        ) {
            return false;
        }

        return true;
    }

    public function uninstall()
    {
        if (!$this->deleteDefaultData()
            || !$this->uninstallTabs()
            || !$this->uninstallDb()
            || !$this->removeGlobalVars()
            || !parent::uninstall()
        ) {
            return false;
        }
        /*
         * Override if bugged version
         */
        if ((version_compare(_PS_VERSION_, '1.6.1.2', '>=') === true) && (version_compare(_PS_VERSION_, '1.6.1.8', '<=') === true)) {
            if (file_exists(_PS_MODULE_DIR_ . $this->name . '/override')) {
                rename(_PS_MODULE_DIR_ . $this->name . '/override', _PS_MODULE_DIR_ . $this->name . '/override_16');
            }
        }
        return true;
    }

    public static function clearAllCached()
    {
        $module = Module::getInstanceByName('roja45productrental');
        $module->clearCache('homefeatured.tpl');
        $module->clearCache('tab.tpl', 'homefeatured-tab');
        $module->clearCache('displayHeader');
        $module->clearCache('displayTop');
        $module->clearCache('displayProductButtons');
        $module->clearCache('displayEnabledIndicator');
        $module->clearCache('displayRoja45RentalProductPrice');
        Cache::clean('roja45productrental_productprices');
    }

    public function clearCache($template)
    {
        parent::_clearCache($template);
    }

    public function renderWidget($hookName = null, array $configuration = array())
    {
        if ($hookName == null && isset($configuration['hook'])) {
            $hookName = $configuration['hook'];
        }

        if (!isset($configuration['cache_id'])) {
            $configuration['cache_id'] = null;
        }
        $variables = $this->getWidgetVariables($hookName, $configuration);
        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            $this->smarty->assign($variables);
            return $this->display(__FILE__, $hookName.'.tpl');
        } else {
            if (!$this->isCached(
                'module:'.$this->name.'/views/templates/hook/PS17_'.$hookName.'.tpl',
                $this->getCacheId($hookName)
            )) {
                $this->smarty->assign($variables);
            }
            return $this->fetch(
                'module:'.$this->name.'/views/templates/hook/PS17_'.$hookName.'.tpl',
                $configuration['cache_id']
            );
        }
    }

    public function getWidgetVariables($hookName = null, array $configuration = array())
    {
        if (in_array(
            $hookName,
            array(
                'displayProductButtons',
                'displayRoja45ProductPageGetAvailability',
            )
        )) {
            $this->getProductPageVariables($configuration['product']);
        } elseif (preg_match('/^displayProductRentalProductPage/', $hookName)) {
            $product = new Product($configuration['id_product'], false, $this->context->language->id);
            $this->getProductPageVariables($product);
        } elseif (preg_match('/^displayEnabledIndicator\d*$/', $hookName)) {
            $this->smarty->assign(array(
                'product' => $configuration['product'],
            ));
        } elseif (preg_match('/^displayCheckoutSummaryTop\d*$/', $hookName)) {
            $this->smarty->assign(array(
                'tmp' =>'',
            ));
        } elseif (preg_match('/^displayRoja45ProductListRentalBlock\d*$/', $hookName)) {
            $this->smarty->assign(array(
                'product' => $configuration['product'],
            ));
        } elseif (preg_match('/^displayRoja45RentalProductPrice\d*$/', $hookName)) {
            $price = ProductRentalRate::getLowestRateByGroup(
                $configuration['id_roja45_product'],
                $configuration['id_roja45_product_rateduration'],
                $configuration['group_ids']
            );
            $priceDisplay = Product::getTaxCalculationMethod((int) $this->context->cookie->id_customer);
            $with_tax = 0;
            $price_inc = 0;
            if (!$priceDisplay || $priceDisplay == 2) {
                $with_tax = 1;
                $id_address = null;
                if (Validate::isLoadedObject($this->context->cart)) {
                    $id_address = $this->context->cart->{Configuration::get('PS_TAX_ADDRESS_TYPE')};
                }

                // retrieve address informations
                $address = Address::initialize($id_address, true);
                if ($address === null) {
                    $address = new Address();
                }
                //$address->id_country = $id_country;
                //$address->id_state = $id_state;
                //$address->postcode = $zipcode;

                $tax_manager = TaxManagerFactory::getManager(
                    $address,
                    Product::getIdTaxRulesGroupByIdProduct((int)$configuration['product']->id, $this->context)
                );
                $product_tax_calculator = $tax_manager->getTaxCalculator();
                $price_inc = $product_tax_calculator->addTaxes($price['rate']);
            }
            if ($price) {
                $this->smarty->assign(array(
                    'with_tax' => $with_tax,
                    'price' => $price['rate'],
                    'price_inc' => $price_inc,
                    'price_formatted' => Tools::displayPrice(Tools::convertPrice($price['rate'])),
                    'price_inc_formatted' => Tools::displayPrice(Tools::convertPrice($price_inc)),
                ));
            }
        } elseif (preg_match('/^displayOrderConfirmation\d*$/', $hookName)) {
            $rental = $configuration['rental'];
            if ($rental->id_customer) {
                $link = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'customer_rentals'=>1
                    )
                );
                $this->smarty->assign(
                    array(
                        'id_roja45_product_rental' => $rental->id,
                        'account_link' => $link
                    )
                );
            }
            $this->smarty->assign($rental->getSummary());
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $delete_link = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'deleteProduct' => '1',
                    )
                );
            } else {
                $delete_link = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFront',
                    array(
                        'ajax' => 1,
                        'action' => 'deleteProduct',
                    )
                );
            }
            $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
            $this->smarty->assign(
                array(
                    'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                    'enable_address_block' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS'),
                    'display_tax' => $display_tax,
                    'delete_product_link' => $delete_link,
                    'link' => Context::getContext()->link,
                    'cartImage' => ImageType::getFormatedName('cart'),
                    'mediumImage' => ImageType::getFormatedName('medium'),
                    'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                    'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                )
            );
        } elseif (preg_match('/^displayRoja45ProductPrice\d*$/', $hookName)) {
            $this->smarty->assign(array(
                'product' => $configuration['product'],
            ));
        } else {
        }
    }

    public function getContent()
    {
        $this->html = RojaFortyFiveProductRentalCore::renderHeader($this);
        $this->processSubmit();
        $this->html .= $this->renderModuleForm();
        $this->html .= RojaFortyFiveProductRentalCore::renderFooter($this);
        return $this->html;
    }

    public function hookDisplayBackOfficeHeader($params)
    {
        if (version_compare(_PS_VERSION_, '1.7', '<') === true) {
            /* Set icon on menu bar */
            return $this->display(__FILE__, 'views/templates/admin/boheader.tpl');
        }
    }

    public function hookDisplayBackOfficeFooter($params)
    {
        if (!Configuration::get('ROJA45_MODULEMANAGER_INSTALLED')) {
            if (version_compare(_PS_VERSION_, '1.6.0.9', '<=') === true) {
                $this->smarty->assign(
                    array(
                        'requires_multiselect' => 1,
                    )
                );
            }
            return $this->display(__FILE__, 'hookRoja45ModalDialogs.tpl');
        }
    }

    public function hookDisplayHeader($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $page = $this->context->controller->php_self;
        if (!isset($page)) {
            if (isset($this->context->controller->page_name)) {
                $page = $this->context->controller->page_name;
            } else {
                return;
            }
        }

        $html = '';
        $use_js = Configuration::get('ROJA45_PRODUCTRENTAL_USEJS');

        $enabled_products = ProductRentalDetails::getEnabledProducts($this->context->shop->id);
        $token = Tools::getToken();
        $controller_url = $this->context->link->getModuleLink(
            'roja45productrental',
            'ProductRentalFront',
            array(
                'token' => $token
            )
        );

        if (version_compare(_PS_VERSION_, '1.7', '>') === true) {
            $search_controller_url = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFacetedSearch',
                array(
                    'token' => $token
                )
            );
            $this->context->controller->addJS($this->_path . 'views/js/PS17_roja45productrental.js');
            Media::addJsDefL(
                'roja45_unexpected_error',
                $this->l('An unexpected error has occurred, administrators have been informed.  We are sorry for the inconvenience, please try again later.')
            );
            Media::addJsDefL('roja45_button_text', $this->l('Rent Now'));
            Media::addJsDefL('roja45productrental_rental_link_text', $this->l('Rent Now'));
            Media::addJsDefL(
                'roja45_productrental_special_pricing',
                $this->l('Your selected dates have special prices applied.  You can review the details after adding your rental to the cart.')
            );
            Media::addJsDefL('roja45_productrental_prices_from', $this->l('From'));
            Media::addJsDefL(
                'roja45_productrental_collection_date_error',
                $this->l('Please provide the collection date.')
            );
            Media::addJsDefL('roja45_productrental_return_date_error', $this->l('Please provide the return date.'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_closed', $this->l('Store Closed'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_minduration', $this->l('Date Unavailable'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_maxduration', $this->l('Date Unavailable'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_available', $this->l('Date Available'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_unavailable', $this->l('Date Unavailable'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_checkin_only', $this->l('Collection After'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_checkout_only', $this->l('Return Only'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_num_available', $this->l('Available'));
            Media::addJsDefL('roja45_productrental_calendar_tooltip_last', $this->l('Last items available'));
            Media::addJsDefL('roja45_productrental_calendar_nowtext', $this->l('Now'));
            Media::addJsDefL('roja45_productrental_calendar_closetext', $this->l('Select'));
            Media::addJsDefL('roja45_productrental_calendar_timetext', $this->l('Time'));
            Media::addJsDefL('roja45_productrental_calendar_hourtext', $this->l('Hour'));
            Media::addJsDefL('roja45_productrental_calendar_minutetext', $this->l('Min'));
            Media::addJsDefL('roja45_productrental_insufficent_qty', $this->l('Insufficent items in stock'));
            Media::addJsDefL('roja45_button_text_close', $this->l('Close'));
            Media::addJsDefL('roja45_collection_date_error', $this->l('Please provide your return date.'));
            Media::addJsDefL('roja45_return_date_error', $this->l('Please provide your collection date.'));
            Media::addJsDefL('roja45_get_price_failed', $this->l('Unable to get the price at the moment. Please try again later.'));
            Media::addJsDefL('roja45_request_message_select', $this->l('Please select your models'));
            Media::addJsDefL('roja45_request_message_ready', $this->l('Great! Everything looks good, click reserve to secure your products.'));
            Media::addJsDefL('roja45_reservation_message_insufficent', $this->l('You have selected more products than are available for this model.'));
        } else {
            $search_controller_url = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalSearch',
                array(
                    'token' => $token
                )
            );
            $this->context->controller->addJS($this->_path . 'views/js/roja45productrental.js');
        }

        Media::addJsDef(array(
            'id_language' => $this->context->language->id,
            'roja45_rental_controller' => $controller_url,
            'roja45_rental_searchcontroller' => $search_controller_url,
            'roja45_rentable_products' => $enabled_products,
            'roja45_productrental_showrentallabel' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL'),
            'roja45_productrental_minimumduration' => Configuration::get('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION'),
            'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                $this->context->language->date_format_lite
            ),
            //'roja45_productrental_timeformat' => 'HH:mm',
            //'roja45_productrental_timestep' => 5,
            'roja45_productrental_showlivetotal' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE'),
            'roja45_productrental_idproductdeposit' => Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT'),
            //'roja45_productrental_samedayrentals' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS'),
            'roja45_productrental_preparationdays' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS'),
            'roja45_productrental_reconditiondays' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS'),
            'roja45_productrental_enabletimeselect' => (int) Configuration::get(
                'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
            ),
            'roja45_productrental_defaultcollectiontime' => Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME'),
            'roja45_productrental_defaultreturntime' => Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME'),
            'roja45_productrental_usecombintionqty' =>  Configuration::get('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY'),
            'roja45_productrental_selector_productlistitem' =>  Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR'),
            'roja45_productrental_selector_productpageaddtocartform' =>  Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR')
        ));
        if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
            $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
            Media::addJsDef(array(
                'roja45_id_product_deposit' => (int) $id_product_deposit,
            ));
        }

        $working_days = array();
        foreach (ProductRentalWorkingDay::getDays($this->context->language->id) as $working_day) {
            $working_days[$working_day['id_roja45_product_rental_workingday']] = array(
                'working_day' => (int) $working_day['is_working_day'],
                'allow_rentals' => (int) $working_day['allow_rentals'],
                'opening_time' => $working_day['opening_time'],
                'closing_time' => $working_day['closing_time']
            );
        }

        $this->context->smarty->assign(array(
            'roja45_working_days' => Tools::jsonEncode($working_days)
        ));

        if (!in_array($page, $this->getExceptions(Hook::getIdByName('displayTop')))) {
            $this->context->controller->addJqueryPlugin('validate');
            $this->context->controller->addJqueryUI('ui.effect');
            $this->context->controller->addJqueryUI('ui.datepicker');
            $this->context->controller->addJqueryUI('ui.tooltip');
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                if (Configuration::get(
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                )) {
                    $this->context->controller->registerJavascript(
                        'ui-timepicker-addon',
                        'modules/'.$this->name.'/vendor/timepicker/jquery.ui-timepicker-addon.js',
                        array(
                            'position' => 99,
                            'priority' => 99,
                        )
                    );
                    $this->context->controller->registerJavascript(
                        'ui-timepicker-addon-localizations',
                        'modules/'.$this->name.'/vendor/timepicker/localization/jquery-ui-timepicker-'.Context::getContext()->language->iso_code.'.js',
                        array(
                            'position' => 99,
                            'priority' => 99,
                        )
                    );
                }
            } else {
                $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                if (Configuration::get(
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                )) {
                    $this->context->controller->addJS(
                        $this->_path . 'vendor/timepicker/jquery.ui-timepicker-addon.js'
                    );
                    $this->context->controller->addJS(
                        $this->_path .
                        'vendor/timepicker/localization/jquery-ui-timepicker-' .
                        Context::getContext()->language->iso_code . '.js'
                    );
                }
            }

            $this->context->controller->addCSS($this->_path.'vendor/timepicker/jquery.ui-timepicker-addon.css', 'all');
        }
        switch ($page) {
            case 'index':
                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                    $this->context->controller->registerJavascript(
                        'jquery_ui_localizations',
                        'js/jquery/ui/i18n/jquery.ui.datepicker-'.Context::getContext()->language->iso_code.'.js',
                        null
                    );
                } else {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                    $this->context->controller->addJqueryPlugin('validate');
                    $this->context->controller->addJqueryUI('ui.effect');
                    $this->context->controller->addJqueryUI('ui.datepicker');
                    $this->context->controller->addJqueryUI('ui.tooltip');
                }
                break;
            case 'category':
                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                } else {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                }
                break;
            case 'search':
                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                } else {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                }
                break;
            case 'product':
                $prd_enabled = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
                if ($prd_enabled>0) {
                    $rentalproduct = new ProductRentalDetails(
                        $prd_enabled,
                        $this->context->language->id,
                        $this->context->shop->id
                    );
                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                    } else {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                    }

                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $this->context->controller->addJS(
                            $this->_path . 'views/js/PS17_roja45productrental_products.js'
                        );
                        $this->context->controller->registerJavascript(
                            'jquery_ui_localizations',
                            'js/jquery/ui/i18n/jquery.ui.datepicker-' . Context::getContext()->language->iso_code . '.js',
                            null
                        );
                        $this->context->controller->addCSS(
                            _PS_MODULE_DIR_ . $this->name . '/vendor/fullcalendar-3.9.0/fullcalendar.css'
                        );
                        $this->context->controller->registerJavascript(
                            'moment',
                            _PS_MODULE_DIR_ . $this->name . '/vendor/fullcalendar-3.9.0/lib/moment.min.js',
                            array(
                                'position' => 99,
                                'priority' => 99,
                            )
                        );
                        $this->context->controller->registerJavascript(
                            'fullcalendar',
                            _PS_MODULE_DIR_ . $this->name . '/vendor/fullcalendar-3.9.0/fullcalendar.js',
                            array(
                                'position' => 99,
                                'priority' => 99,
                            )
                        );
                        $this->context->controller->registerJavascript(
                            'fullcalendar-local-'.$this->context->language->iso_code,
                            _PS_MODULE_DIR_ . $this->name . '/vendor/fullcalendar-3.9.0/locale/' . $this->context->language->iso_code . '.js',
                            array(
                                'position' => 99,
                                'priority' => 99,
                            )
                        );
                        $this->context->controller->registerJavascript(
                            'ui-timepicker-addon',
                            'modules/'.$this->name.'/vendor/timepicker/jquery.ui-timepicker-addon.js',
                            array(
                                'position' => 99,
                                'priority' => 99,
                            )
                        );
                        $this->context->controller->registerJavascript(
                            'ui-timepicker-addon-localizations',
                            'modules/'.$this->name.'/vendor/timepicker/localization/jquery-ui-timepicker-'.Context::getContext()->language->iso_code.'.js',
                            array(
                                'position' => 99,
                                'priority' => 99,
                            )
                        );
                    } else {
                        $this->context->controller->addJS($this->_path . 'views/js/roja45productrental_products.js');
                        $this->context->controller->addJqueryUI('ui.effect');
                        $this->context->controller->addJqueryUI('ui.slider');
                        $this->context->controller->addJqueryUI('ui.datepicker');
                        $this->context->controller->addJqueryUI('ui.tooltip');
                        if (Configuration::get(
                            'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                        )) {
                            $this->context->controller->addJqueryPlugin(
                                'ui-timepicker-addon',
                                $this->_path . '/vendor/timepicker/'
                            );
                            $this->context->controller->addJqueryPlugin(
                                'jquery-ui-timepicker-' . Context::getContext()->language->iso_code . '.js',
                                $this->_path . 'vendor/timepicker/localization/'
                            );
                        }
                    }

                    $state = '';
                    $country = '';
                    if ($rentalproduct->country) {
                        $countryObj = new Country($rentalproduct->country, $this->context->language->id);
                        $country = $countryObj->name;
                    }
                    if ($rentalproduct->country) {
                        $stateObj = new State($rentalproduct->state, $this->context->language->id);
                        $state = $stateObj->name;
                    }
                    $this->context->smarty->assign(array(
                        'city' => $rentalproduct->city,
                        'country' => $country,
                        'state' => $state,
                        'postal_code' => $rentalproduct->postal_code,
                        'roja45_productrental_samedayrentals' => 'false',
                        'roja45_productrental_showlivetotal' => Configuration::get(
                            'ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE'
                        ),
                    ));
                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                        $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                        $this->context->smarty->assign(array(
                            'id_product_deposit' => $id_product_deposit,
                        ));
                    }

                    if (!$show_available = (int) Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY')) {
                        $show_available = 0;
                    }
                    if (!$last_products = (int) Configuration::get('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING')) {
                        $last_products = 1;
                    }
                    Media::addJsDefL('roja45_productrental_refresh', $this->l('Refresh'));

                    Media::addJsDef(array(
                        'roja45_productrental_calendaravailability' => $show_available,
                        'roja45_productrental_availability_warning' => $last_products,
                        'roja45_productrental_usejs' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_USEJS'),
                        'roja45_productrental_minimumduration' => $rentalproduct->minimum_duration,
                        'roja45_productrental_maximumduration' => $rentalproduct->maximum_duration,
                        'roja45_productrental_collectionafter' => $rentalproduct->collection_time,
                        'roja45_productrental_returnbefore' => $rentalproduct->return_time,
                    ));
                }
                break;
            case 'order':
                if ($use_js) {
                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                    } else {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                    }
                    $this->context->controller->addJS($this->_path . 'views/js/roja45productrental_order.js');
                    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                        $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                        $this->context->smarty->assign(array(
                            'id_product_deposit' => $id_product_deposit,
                        ));
                    }
                }
                break;
            case 'order-opc':
                if ($use_js) {
                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                    } else {
                        $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                    }
                    $this->context->controller->addJS($this->_path . 'views/js/roja45productrental_order.js');
                }
                break;
            case 'module-roja45productrental-ProductRentalFacetedSearchController':
                $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                break;
            case 'module-roja45productrental-ProductRentalFront':
                if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental17.css', 'all');
                } else {
                    $this->context->controller->addJqueryPlugin('ui.dialog');
                    $this->context->controller->addCSS($this->_path . 'views/css/roja45productrental.css', 'all');
                }
                if (Tools::getValue('search')) {
                } elseif (Tools::getValue('customer_rentals')) {
                    if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
                        $this->context->controller->addJS($this->_path . 'views/js/roja45productrental_bookings.js');
                    }
                } else {
                    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                        $this->context->controller->registerJavascript(
                            'jquery_ui_localizations',
                            'js/jquery/ui/i18n/jquery.ui.datepicker-'.Context::getContext()->language->iso_code.'.js',
                            null
                        );
                    } else {
                        $this->context->controller->addJqueryPlugin(
                            'validate'
                        );
                        $this->context->controller->addJqueryUI(
                            'ui.dialog'
                        );
                        $this->context->controller->addJqueryUI('ui.effect');
                        $this->context->controller->addJqueryUI('ui.slider');
                        $this->context->controller->addJqueryUI('ui.datepicker');
                    }
                    $this->context->controller->addJqueryPlugin(
                        'ui-timepicker-addon',
                        $this->_path.'vendor/timepicker/'
                    );
                    $this->context->controller->addJqueryPlugin(
                        'ui-timepicker-addon-localization',
                        $this->_path.'vendor/timepicker/localization/jquery-ui-timepicker-'.Context::getContext()->language->iso_code.'.js'
                    );
                    $this->context->controller->addJS($this->_path . 'views/js/roja45productrental_reservation.js');
                    $this->context->controller->addJS($this->_path . 'vendor/moment/moment.min.js');
                }
                break;
            default:
                break;
        }
        if (version_compare(_PS_VERSION_, '1.7', '<') === true) {
            $html .= $this->display(__FILE__, 'displayHeader.tpl');
        } else {
            $html .= $this->display(__FILE__, 'PS17_displayHeader.tpl');
        }

        return $html;
    }

    public function hookDisplayTop($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $page = $this->context->controller->php_self;
        if (!$page) {
            $page = $this->context->controller->page_name;
        }

        if (!$page || ($page=='pagenotfound')) {
            return;
        }

        $enabled_products = ProductRentalDetails::getEnabledProducts($this->context->shop->id);
        $html = '';
        if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLESEARCH') && count($enabled_products)) {
            $token = Tools::getToken();
            if (version_compare(_PS_VERSION_, '1.7', '>') === true) {
                $search_controller_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalFacetedSearch',
                    array(
                        'token' => $token
                    )
                );
            } else {
                $search_controller_url = $this->context->link->getModuleLink(
                    'roja45productrental',
                    'ProductRentalSearch',
                    array(
                        'token' => $token
                    )
                );
            }

            $this->smarty->assign(
                array(
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => ProductRentalRateDuration::DAILY,
                    'roja45_rental_searchcontroller' => $search_controller_url,
                    'ROJA45_PRODUCTRENTAL_SEARCHCATEGORY' => Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY'),
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT' => Configuration::get(
                        'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
                    ),
                    'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                        $this->context->language->date_format_lite
                    ),
                    'roja45_productrental_timeformat' => 'hh:mm',
                )
            );

            if ($collection_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_COLLECTION_DATE'
            )) {
                $collection_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $collection_date
                );
                if ($collection_date) {
                    $this->smarty->assign(
                        array(
                            'ROJA45_PRODUCTRENTAL_COLLECTION_DATE' => $collection_date->format($this->context->language->date_format_lite)
                        )
                    );
                }
            }

            if (!$collection_time = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_COLLECTION_TIME'
            )) {
                $collection_time = Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
            }
            $this->smarty->assign(
                array(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => $collection_time
                )
            );

            if ($return_date = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_RETURN_DATE'
            )) {
                $return_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $return_date
                );
                if ($return_date) {
                    $this->smarty->assign(
                        array(
                            'ROJA45_PRODUCTRENTAL_RETURN_DATE' => $return_date->format($this->context->language->date_format_lite)
                        )
                    );
                }
            }

            if (!$return_time = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_RETURN_TIME'
            )) {
                $return_time = Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME');
            }
            $this->smarty->assign(
                array(
                    'ROJA45_PRODUCTRENTAL_RETURN_TIME' => $return_time
                )
            );

            if ($qty = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_REQUESTED_QTY'
            )) {
                $this->smarty->assign(
                    array(
                        'ROJA45_PRODUCTRENTAL_REQUESTED_QTY' => $qty
                    )
                );
            }
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                $html .= $this->display(__FILE__, 'PS17_displayTop.tpl');
            } else {
                $html .= $this->display(__FILE__, 'displayTop.tpl');
            }
        }
        return $html;
    }

    public function hookDisplayTopColumn($params)
    {
        return $this->hookDisplayTop($params);
    }

    public function hookDisplayHome($params)
    {
        return $this->hookDisplayTop($params);
    }

    public function hookDisplayShoppingCartFooter($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
            'ROJA45_PRODUCTRENTAL_ID_RENTAL'
        );
        $rental = new ProductRentalRental($id_roja45_product_rental);
        if (Validate::isLoadedObject($rental)) {
            $this->getRentalSummary($rental);
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                //return $this->display(__FILE__, 'PS17_displayShoppingCartFooter.tpl');
                return '';
            } else {
                return $this->display(__FILE__, 'displayShoppingCartFooter.tpl');
            }
        }
    }

    public function hookDisplayProductRentalSummary($params)
    {
        if ($params['id_roja45_product_rental'] > 0) {
            $rental = new ProductRentalRental($params['id_roja45_product_rental']);
            $this->getRentalSummary($rental);
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                return $this->display(__FILE__, 'PS17_displayShoppingCartFooter.tpl');
            } else {
                return $this->display(__FILE__, 'displayShoppingCartFooter.tpl');
            }
        }
    }

    public function hookDisplayProductRentalProductPageCalendar($params)
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            $params['cache_id'] = $this->getCacheId('displayProductRentalProductPageCalendar');
            return $this->renderWidget('displayProductRentalProductPageCalendar', $params);
        }
    }

    public function hookDisplayProductRentalProductPageGetRates($params)
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            $params['cache_id'] = $this->getCacheId('displayProductRentalProductPageGetRates');
            return $this->renderWidget('displayProductRentalProductPageGetRates', $params);
        }
    }

    public function hookDisplayProductButtons($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
        if ($id_roja45_product && !Configuration::get('PS_CATALOG_MODE')) {
            $params['cache_id'] = null;
            return $this->renderWidget('displayProductButtons', $params);
        }
    }

    public function hookDisplayProductAdditionalInfo($params)
    {
        return $this->hookDisplayProductButtons($params);
    }

    public function hookDisplayProductReservation($params)
    {
        return $this->hookDisplayProductButtons($params);
    }

    public function hookDisplayProductTab($params)
    {
        $id_roja45_product = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
        if ($id_roja45_product) {
            $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);
            $this->smarty->assign(array(
                'number_of_models' => count($models),
                'id_lang' => $this->context->language->id,
            ));

            return $this->display(__FILE__, 'displayProductTab.tpl');
        }
    }

    public function hookDisplayProductTabContent($params)
    {
        $id_roja45_product = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
        if ($id_roja45_product) {
            $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);
            foreach ($models as &$model) {
                $modelObj = new ProductRentalModel($model['id_roja45_product_model']);
                $images = $modelObj->getImages($this->context->language->id, $model['id_product_attribute']);
                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
                    $rates = ProductRentalModel::getRates(
                        $model['id_roja45_product_model'],
                        $this->context->language->id
                    );
                    $model['rates'] = $rates;
                }

                $model['name'] = $modelObj->getModelName($this->context->language->id);
                $model['qty_available'] = $modelObj->getAvailableQuantity();
                $model['images'] = $images;
            }

            //$images = $models
            $this->smarty->assign(array(
                'link' => $this->context->link,
                'product' => $params['product'],
                'models' => $models,
                'use_price_periods' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING'),
                'smallSizeName' => ImageType::getFormatedName('small'),
                'smallSize' => Image::getSize(ImageType::getFormatedName('small')),
                'thickboxSizeName' => ImageType::getFormatedName('thickbox'),
                'thickboxSize' => Image::getSize(ImageType::getFormatedName('thickbox')),
                'id_lang' => $this->context->language->id,
            ));

            return $this->display(__FILE__, 'displayProductTabContent.tpl');
        }
    }

    public function hookDisplayProductExtraContent($params)
    {
        $id_roja45_product = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
        if ($id_roja45_product) {
            $extraContent = new \PrestaShop\PrestaShop\Core\Product\ProductExtraContent();
            $extraContent->setTitle($this->l('Calendar'));
            $extraContent->addAttr(array('id' => 'roja45productrental_calendar', 'class' => 'roja45productrental_calendar'));
            $content = $this->renderWidget('displayProductExtraContent_Calendar', $params);
            $extraContent->setContent($content);
            return array($extraContent);
        }

        return array();
    }

    public function hookDisplayOrderConfirmation($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if (!$this->active) {
            return;
        }

        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            $rental = ProductRentalRental::getRentalByOrderId($params['order']->id);
        } else {
            $rental = ProductRentalRental::getRentalByOrderId($params['objOrder']->id);
        }

        if (Validate::isLoadedObject($rental)) {
            RojaFortyFiveProductRentalCore::clearAllCustomerRequirements('ROJA45_PRODUCTRENTAL_');
            if (Validate::isLoadedObject($rental)) {
                $params['cache_id'] = null;
                $params['rental'] = $rental;
                return $this->renderWidget('displayOrderConfirmation', $params);
            }
        }
    }

    public function hookDisplayAdminProductsExtra($params)
    {
        if (ProductRentalDetails::isRentable($params['id_product'])) {
            $product = new Product((int)$params['id_product']);
            if (Validate::isLoadedObject($product)) {
                if (Shop::getContext() != Shop::CONTEXT_GROUP && Shop::getContext() != Shop::CONTEXT_ALL) {
                    return $this->renderProductForm((int)$params['id_product']);
                }
            }
        } else {
            return '<p>Disabled for performance reasons. Please enable in module settings if required.</p>';
        }
    }

    public function hookDisplayAdminOrder($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $rental = ProductRentalRental::getRentalByOrderId($params['id_order']);
        if ($rental) {
            $order = new Order($params['id_order'], $this->context->language->id);
            $customer = new Customer($rental->id_customer, $this->context->language->id);
            $address = new Address(Address::getFirstCustomerAddressId($customer->id));
            $data = $rental->getSummary();
            $this->smarty->assign($data);
            $this->smarty->assign(
                array(
                    'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                    'rental' => $rental,
                    'order' => $order,
                    'customer' => $customer,
                    'address' => $address,
                )
            );
            return $this->display(__FILE__, 'displayAdminOrder.tpl');
        }
    }

    public function hookDisplayCustomerAccount($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $this->smarty->assign(
            array(
                'id_language' => $this->context->language->id
            )
        );
        $params['cache_id'] = $this->getCacheId('displayCustomerAccount');
        return $this->renderWidget('displayCustomerAccount', $params);
    }

    public function hookDisplayProductListReviews($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if (!isset($this->context->controller->php_self)) {
            return;
        }
        $id_product = $params['product']['id_product'];
        if (ProductRentalDetails::isRentable($id_product)) {
            $params['cache_id'] = $this->getCacheId('displayEnabledIndicator');
            return $this->renderWidget('displayEnabledIndicator', $params);
        }
    }

    public function hookDisplayCheckoutSummaryTop($params)
    {
        if (!isset($this->context->controller->php_self)) {
            return;
        }
        $params['cache_id'] = $this->getCacheId('displayCheckoutSummaryTop');
        return $this->renderWidget('displayCheckoutSummaryTop', $params);
    }

    public function hookDisplayRoja45ProductRentalModelAdditionalContent($params)
    {
    }

    public function hookDisplayRoja45ModuleManager($params)
    {
        $return = $this->name;
        return $return;
    }

    public function hookDisplayRoja45ProductSummary($params)
    {
        //return $this->hookDisplayRightColumnProduct($params);
    }

    public function hookDisplayRoja45SearchBar($params)
    {
        return $this->hookDisplayTop($params);
    }

    public function hookDisplayRoja45ProductPageGetAvailability($params)
    {
        $id_roja45_product = ProductRentalDetails::isRentable(Tools::getValue('id_product'));
        if ($id_roja45_product) {
            $params['cache_id'] = $this->getCacheId('displayRoja45ProductPageGetAvailability');
            return $this->renderWidget('displayRoja45ProductPageGetAvailability', $params);
        } else {
            $params['cache_id'] = $this->getCacheId('displayRoja45ProductPageAddToCart');
            return $this->renderWidget('displayRoja45ProductPageAddToCart', $params);
        }
    }

    public function hookDisplayRoja45ProductListFlag($params)
    {
        $this->hookDisplayProductListReviews($params);
    }

    public function hookDisplayRoja45ProductListRentalBlock($params)
    {
        $id_product = $params['product']['id_product'];
        if (ProductRentalDetails::isRentable($id_product)) {
            $params['cache_id'] = $this->getCacheId('displayRoja45ProductListRentalBlock');
            return $this->renderWidget('displayRoja45ProductListRentalBlock', $params);
        } else {
            $params['cache_id'] = $this->getCacheId('displayRoja45ProductListAddToCartBlock');
            return $this->renderWidget('displayRoja45ProductListAddToCartBlock', $params);
        }
    }

    public function hookDisplayRoja45ProductRentalSummary($params)
    {
        return $this->createBookingSummary($params['cart']->id);
    }

    public function hookDisplayRoja45ProductPageExtraContent($params)
    {
        return $this->renderWidget('displayProductExtraContent_Calendar', $params);
    }

    public function hookDisplayRoja45RentalProductPrice($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if (!$this->active) {
            return;
        }
        $id_product = $params['product']['id_product'];
        if ($id_roja45_product = ProductRentalDetails::isRentable($id_product)) {
            $params['cache_id'] = null;
            $params['id_roja45_product'] = $id_roja45_product;
            $params['id_roja45_product_rateduration'] = ProductRentalRateDuration::getRateDurationId(
                ProductRentalRateDuration::DAILY
            );
            $params['group_ids'] = Customer::getGroupsStatic($this->context->customer->id);
            return $this->renderWidget('displayRoja45RentalProductPrice', $params);
        } else {
            return $this->renderWidget('displayRoja45ProductPrice', $params);
        }
    }

    public function hookActionRoja45ProductRentalAdditionalContentListModifier($params)
    {
        $rental_model = $params['rental_model'];
        foreach ($params['extras'] as &$extra) {
            if (is_numeric($extra['id_roja45_product_extra'])) {
                $extraObj = new ProductRentalExtra($extra['id_roja45_product_extra'], $this->context->language->id);
                $sql = '
                    SELECT ctl.name, ctl.description
                    FROM `'._DB_PREFIX_.'roja45_productrental_extra_chargetype` ct
                    LEFT JOIN `'._DB_PREFIX_.'roja45_productrental_extra_chargetype_lang` ctl
                    ON (ct.id_roja45_product_rental_extra_chargetype = ctl.id_roja45_product_rental_extra_chargetype)
                    WHERE ct.code = '.(int)$extraObj->id_roja45_productrental_extra_type.'
                    AND ctl.id_lang = '.(int)$this->context->language->id;
                $results = Db::getInstance()->getRow($sql);
                $extra['charge_name'] = $results['name'];
                $extra['charge_description'] = $results['description'];
                $extra['name'] = $extraObj->name;
                $extra['total'] =  $extraObj->calculateTotal($extra['rate'], $rental_model);
                $params['total_extras'] += $extra['total'];
            }
        }
        $params['hook_executed'] = true;
    }

    public function hookActionAdminControllerSetMedia($params)
    {
        if ($this->context->controller->controller_name == 'AdminModules' &&
            Tools::getValue('configure') == $this->name
        ) {
            $this->context->controller->addJS($this->_path . 'views/js/roja45moduleadmin.js');
            $this->context->controller->addJS($this->_path . 'vendor/riotjs/riot+compiler.min.js');
        }
    }

    public function hookActionProductListModifier($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        foreach ($params['cat_products'] as &$product) {
            $id_roja45_product = ProductRentalDetails::isRentable($product['id_product']);
            if ($id_roja45_product) {
                $product['available_for_order'] = 0;
            }
        }
    }

    public function hookActionAfterDeleteProductInCart($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }

        if ($id_roja45_product = ProductRentalDetails::isRentable($params['id_product'])) {
            $id_roja45_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL'
            );
            $this->deleteRentalEntry(
                $id_roja45_rental,
                $params['id_product'],
                $params['id_product_attribute'],
                false
            );
        }
        return true;
    }

    public function hookActionObjectProductInCartDeleteAfter($params)
    {
        $this->hookActionAfterDeleteProductInCart($params);
    }

    public function hookActionValidateOrder($params)
    {

        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
            'ROJA45_PRODUCTRENTAL_ID_RENTAL'
        );
        $product_rental = new ProductRentalRental($id_roja45_product_rental);
        if (Validate::isLoadedObject($product_rental)) {
            RojaFortyFiveProductRentalCore::clearCustomerRequirement('ROJA45_PRODUCTRENTAL_ID_RENTAL');
            RojaFortyFiveProductRentalCore::saveCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL_VALIDATED',
                $id_roja45_product_rental
            );
            //$product_rental->updateFromOrder($params['order']);
            $rental_products = $product_rental->getProducts();
            if (count($rental_products) > 0) {
                $stock_management_active = Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT');
                $product_rental->reference = Tools::strtoupper((Tools::passwdGen(9, 'NO_NUMERIC')));
                $product_rental->id_customer = (int)$params['order']->id_customer;
                $product_rental->save();
                $product_rental->setStatus(ProductRentalRentalStatus::$CCNF);

                $id_roja45_product_rental_payment = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT'
                );
                $product_rental_payment = new ProductRentalRentalPayment($id_roja45_product_rental_payment);
                $product_rental_payment->id_order = $params['order']->id;
                $product_rental_payment->date_due = date('Y-m-d H:i:s');
                $product_rental_payment->date_paid = date('Y-m-d H:i:s');
                $product_rental_payment->total = $params['order']->total_paid_tax_excl;
                $product_rental_payment->total_with_tax = $params['order']->total_paid_tax_incl;

                $requires_confirmation = false;
                foreach ($rental_products as $rental_product) {
                    $rental = new ProductRentalDetails($rental_product['id_roja45_product']);
                    if (!$rental->instant_rental) {
                        $requires_confirmation = true;
                    }
                    $product = new Product(
                        $rental_product['id_product'],
                        false,
                        Context::getContext()->language->id
                    );
                    $models = ProductRentalRentalModel::getModels($rental_product['id_roja45_product_rental_product']);
                    foreach ($models as $model) {
                        if ($stock_management_active && (int)$product->advanced_stock_management == 1) {
                            $sql = new DbQuery();
                            $sql->select('id_warehouse');
                            $sql->from('order_detail', 'od');
                            $sql->where('od.id_order=' . (int)$params['order']->id);
                            $sql->where('od.product_id=' . (int)$rental_product['id_product']);
                            $sql->where('od.product_attribute_id=' . (int)$model['id_product_attribute']);

                            $id_warehouse = Db::getInstance()->getValue($sql);
                            $warehouse = new Warehouse($id_warehouse);
                            $qty_in_cart = $model['qty'];
                            $price = str_replace(',', '.', $product->wholesale_price);
                            if ($price == 0) {
                                $price = 0.000001;
                            }

                            $super_admin_array = Employee::getEmployeesByProfile(_PS_ADMIN_PROFILE_, true);
                            $employee = new Employee($super_admin_array[0]['id_employee']);

                            $price = round((float)($price), 6);
                            $manager = StockManagerFactory::getManager();
                            $manager->addProduct(
                                $rental_product['id_product'],
                                $model['id_product_attribute'],
                                $warehouse,
                                $qty_in_cart,
                                Configuration::get('PS_STOCK_MVT_INC_REASON_DEFAULT'),
                                $price,
                                true,
                                null,
                                $employee
                            );
                        } else {
                            $stock_on_hand = (int)StockAvailable::getQuantityAvailableByProduct(
                                $rental_product['id_product'],
                                $model['id_product_attribute']
                            );
                            $qty_in_cart = $model['qty'];
                            $qty = $stock_on_hand + $qty_in_cart;
                            StockAvailable::setQuantity(
                                $rental_product['id_product'],
                                $model['id_product_attribute'],
                                $qty
                            );
                        }
                    }
                }

                $product_rental->setStatus(ProductRentalRentalStatus::$DPST);
                if ($params['order']->total_paid == $params['order']->total_paid_real) {
                    $product_rental_payment->completed = 1;
                    $product_rental->setStatus(ProductRentalRentalStatus::$PAYC);
                    if ($requires_confirmation) {
                        $product_rental->setStatus(ProductRentalRentalStatus::$PRES);
                    } elseif (Configuration::get('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')) {
                        $product_rental->setStatus(ProductRentalRentalStatus::$CONF);
                    }
                } else {
                    $product_rental_payment->completed = 0;
                    $product_rental->setStatus(ProductRentalRentalStatus::$PAYU);
                    if ($requires_confirmation) {
                        $product_rental->setStatus(ProductRentalRentalStatus::$PRES);
                    }
                }
                $product_rental_payment->save();
                SpecificPrice::deleteByIdCart($product_rental_payment->id_cart);
                RojaFortyFiveProductRentalCore::clearCustomerRequirement('ROJA45_PRODUCTRENTAL_ID_RENTAL_PAYMENT');
            }
            $send_email = (int) Configuration::get('ROJA45_PRODUCTRENTAL_SENDEMAIL');

           // if ($send_email == 0) {
                $contact = new Contact(
                    Configuration::get('ROJA45_PRODUCTRENTAL_CS_ACCOUNT'),
                    $this->context->language->id
                );
                $data = $product_rental->getSummary();
                $this->smarty->assign(array(
                    'reference' => $product_rental->reference
                ));

               // $subject = $this->l('New Rental Request') . ' ['.$product_rental->reference.'])';
                $this->smarty->assign(array(
                    'id_roja45_product_rental' => $product_rental->id_roja45_product_rental,
                    'cartImage' => ImageType::getFormatedName('cart'),
                    'mediumImage' => ImageType::getFormatedName('medium'),
                    'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                    'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
                ));
                $this->smarty->assign($data);
                $content = $this->display(__FILE__, 'emailTemplateAdminReservationSummary.tpl');
                $content_txt = new Html2Text($content);
                $content_txt = $content_txt->getText();

                $customer = new Customer($params['order']->id_customer);
                $address = new Address($params['order']->id_address_invoice);

                $email_params = array(
                    '{id_product}' => Tools::getValue('ID_PRODUCT'),
                    '{firstname}' => $customer->firstname,
                    '{lastname}' => $customer->lastname,
                    '{email}' => $customer->email,
                    '{content}' => $content,
                    '{content_txt}' => $content,
                    '{mobile}' => $address->phone_mobile,
                    '{telephone}' => $address->phone,
                    '{content_txt}' => $content_txt,
                    '{address_block_txt}' => $this->_getFormatedAddress($address, "\n"),
                    '{address_block_html}' => $this->_getFormatedAddress($address, '<br />', array(
                        'firstname' => '<span style="font-weight:bold;">%s</span>',
                        'lastname' => '<span style="font-weight:bold;">%s</span>',
                    )),
                );

                $sent = Mail::Send(
                    (int)Roja45ProductRental::getTemplateLangId(
                        'roja45adminbookingsummary',
                        $this->context->language->id
                    ),
                    'roja45adminbookingsummary',
                    Mail::l(
                        'New Rental Request',
                        (int)Context::getContext()->language->id,
                        Context::getContext()
                    ) . ' : [#tc' . $product_rental->reference . ']',
                    $email_params,
                    $contact->email,
                    $contact->name,
                    $contact->email,
                    $contact->name,
                    null,
                    null,
                    _PS_MODULE_DIR_ . 'roja45productrental/mails/',
                    false,
                    null,
                    null
                );

                if (!$sent) {
                    PrestaShopLogger::addLog(
                        'roja45ProductRental::hookActionValidateOrder - Email Not Sent',
                        1,
                        null,
                        'roja45ProductRental',
                        null,
                        true
                    );
                }
            //}
        }
    }

    public function hookActionOrderStatusPostUpdate($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $status = new OrderState(Configuration::get('ROJA45_PRODUCTRENTAL_SENDONSTATUS'));
        $id_order_state = $params['newOrderStatus']->id;
        switch ($id_order_state) {
            case $status->id:
                $product_rental = ProductRentalRental::getRentalByOrderId($params['id_order']);
                if (Validate::isLoadedObject($product_rental)) {
                    $id_roja45_product_payment = ProductRentalRentalPayment::getPaymentForOrderId($params['id_order']);
                    $rental_payment = new ProductRentalRentalPayment($id_roja45_product_payment);
                    if (Validate::isLoadedObject($rental_payment)) {
                        $order = new Order($params['id_order']);
                        if ($order->total_paid >= $order->total_paid_real) {
                            $rental_payment->completed = 1;
                            //$mysql_date_now = date('Y-m-d H:i:s');
                            //$rental_payment->paid_date = $mysql_date_now;
                            $update_order = Configuration::get('ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM');
                            if (!$update_order) {
                                $product_rental->setStatus(ProductRentalRentalStatus::$PAYC);
                            }
                            if (Configuration::get('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')) {
                                $product_rental->setStatus(ProductRentalRentalStatus::$CONF);
                            }
                        } else {
                            $rental_payment->completed = 0;
                            $product_rental->setStatus(ProductRentalRentalStatus::$PAYU);
                            // TODO - Set to check payments status, there's probably a problem if we hit this status
                        }
                        $rental_payment->save();
                    }
                }
                break;
        }
    }

    public function hookActionReserveProductPaymentAdditionalInfo($params)
    {
        $params['additional_info'] = $this->createBookingSummaryFromCart($params['id_cart']);
    }

    public function hookActionGetExtraMailTemplateVars($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if (
            $params['template'] == 'order_conf' ||
            $params['template'] == 'payment' ||
            $params['template'] == 'roja45paymentreceived' ||
            $params['template'] == 'rental_confirmed' ||
            $params['template'] == 'roja45reservationheld' ||
            $params['template'] == 'roja45reservationreceived'
        ) {
            $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL'
            );
            if (!$id_roja45_product_rental) {
                $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_RENTAL_VALIDATED'
                );
            }
            $rental = new ProductRentalRental($id_roja45_product_rental);
            if (Validate::isLoadedObject($rental)) {
                $extra_template_vars = $rental->getTemplateVars();
                $data = $rental->getSummary();
                $template_vars = array();
                $template_vars = array_merge($extra_template_vars, $template_vars);
                switch ($params['template']) {
                    case 'order_conf':
                        //$order_collection = Order::getByReference($params['template_vars']['{order_name}']);
                        $this->smarty->assign($data);
                        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                            $summary = $this->display(__FILE__, 'PS17_emailTemplateCustomerRentalSummary.tpl');
                        } else {
                            $summary = $this->display(__FILE__, 'emailTemplateCustomerRentalSummary.tpl');
                        }
                        $summaryTxt = new Html2Text($summary);
                        $summaryTxt = $summaryTxt->getText();
                        $order_conf_var = array(
                            '{summary_html}' => $summary,
                            '{summary_txt}' => $summaryTxt
                        );
                        $template_vars = array_merge($template_vars, $order_conf_var);
                        break;
                    case 'payment':
                        break;
                    case 'roja45paymentreceived':
                        break;
                    case 'rental_confirmed':
                        break;
                    case 'roja45reservationreceived':
                        //$summary = $this->createSummaryEmail($cart, 'emailTemplateCustomerReservationSummary.tpl');
                        break;
                    case 'roja45reservationheld':
                        break;
                }
                $params['extra_template_vars'] = $template_vars;
            }
        }
    }

    public function hookActionEmailAddAfterContent($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if ($params['template'] == 'order_conf' ||
            $params['template'] == 'roja45paymentreceived' ||
            $params['template'] == 'roja45reservationreceived' ||
            $params['template'] == 'payment'
        ) {
            $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                'ROJA45_PRODUCTRENTAL_ID_RENTAL'
            );
            if (!$id_roja45_product_rental) {
                $id_roja45_product_rental = RojaFortyFiveProductRentalCore::getCustomerRequirement(
                    'ROJA45_PRODUCTRENTAL_ID_RENTAL_VALIDATED'
                );
            }
            $product_rental = new ProductRentalRental($id_roja45_product_rental);
            if (Validate::isLoadedObject($product_rental)) {
                $iso = Language::getIsoById((int)$params['id_lang']);
                if (!$iso) {
                    Tools::dieOrLog(Tools::displayError('Error - No ISO code for email'), true);
                    return false;
                }

                switch ($params['template']) {
                    case 'roja45paymentreceived':
                        $this->getEmailTemplate(
                            'roja45paymentreceived',
                            (int)$params['id_lang'],
                            $params['template_html'],
                            $params['template_txt']
                        );
                        break;
                    case 'roja45requestreceived':
                        $this->getEmailTemplate(
                            'roja45requestreceived',
                            (int)$params['id_lang'],
                            $params['template_html'],
                            $params['template_txt']
                        );
                        break;
                    case 'roja45reservationunavailable':
                        $this->getEmailTemplate(
                            'roja45reservationunavailable',
                            (int)$params['id_lang'],
                            $params['template_html'],
                            $params['template_txt']
                        );
                        break;
                    case 'order_conf':
                        if (Configuration::get('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF') == 1) {
                            $iso_template = $iso . '/rental_request_received';

                            if (file_exists(_PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/' . $iso_template . '.txt') ||
                                file_exists(_PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/' . $iso_template . '.html')) {
                                $template_path = _PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/';
                            } elseif (file_exists(_PS_MODULE_DIR_ .$this->name . '/mails/' . $iso_template . '.txt') ||
                                file_exists(_PS_MODULE_DIR_ . $this->name . '/mails/' . $iso_template . '.html')) {
                                $template_path = _PS_MODULE_DIR_ . $this->name . '/mails/';
                            }
                            $template_html = Tools::file_get_contents($template_path . $iso_template . '.html');
                            $template_txt = strip_tags(html_entity_decode(Tools::file_get_contents($template_path . $iso_template . '.txt'), null, 'utf-8'));
                            $params['template_html'] = $template_html;
                            $params['template_txt'] = $template_txt;
                        }
                        break;
                    case 'payment':
                        if (Configuration::get('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT') == 1) {
                            $iso_template = $iso . '/roja45paymentreceived';
                            if (file_exists(_PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/' . $iso_template . '.txt') ||
                                file_exists(_PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/' . $iso_template . '.html')) {
                                $template_path = _PS_THEME_DIR_ . 'modules/' . $this->name . '/mails/';
                            } elseif (file_exists(_PS_MODULE_DIR_ .$this->name . '/mails/' . $iso_template . '.txt') ||
                                file_exists(_PS_MODULE_DIR_ . $this->name . '/mails/' . $iso_template . '.html')) {
                                $template_path = _PS_MODULE_DIR_ . $this->name . '/mails/';
                            }
                            $template_html = Tools::file_get_contents($template_path . $iso_template . '.html');
                            $template_txt = strip_tags(html_entity_decode(Tools::file_get_contents($template_path . $iso_template . '.txt'), null, 'utf-8'));
                            $params['template_html'] = $template_html;
                            $params['template_txt'] = $template_txt;
                        }
                        break;
                }
            }
        }
    }

    public function hookActionProductSave($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS')) {
            $id_roja45_product = ProductRentalDetails::isRentable($params['id_product']);
            if (!$id_roja45_product) {
                $rental_product = new ProductRentalDetails();
                if (!$rental_product->initialiseRental($params['id_product'])) {
                    Tools::error_log('Unable to initialise rental');
                }
            }
        }
    }

    public function hookActionProductUpdate($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product = ProductRentalDetails::isRentable($params['product']->id);
        if (Tools::getValue('roja45productrental_enabled')) {
            if (!(int)Tools::getValue('id_roja45_product') && (int)Tools::getValue('roja45productrental_enabled')) {
                $rental_product = new ProductRentalDetails();
                $rental_product->initialiseRental($params['product']->id);
            } elseif ($id_roja45_product) {
                $rental_product = new ProductRentalDetails(
                    $id_roja45_product,
                    (int)$this->context->language->id,
                    (int)$this->context->shop->id
                );
                $rental_product->enabled = (int)Tools::getValue('roja45productrental_enabled');
                $rental_product->save();

                // todo optional, update any info?
                // what to do if price has changed, update base rate?
            }
        }
    }

    public function hookActionObjectCombinationAddAfter($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product = ProductRentalDetails::isRentable($params['object']->id_product);
        if ($id_roja45_product) {
            $single_model = ProductRentalModel::getModelForAttributeId(
                $id_roja45_product,
                0
            );
            if ($single_model) {
                $modelObj = new ProductRentalModel($single_model);
                $modelObj->delete();
            }

            $product = new Product($params['object']->id_product, false);
            $id_roja45_product_model = ProductRentalModel::getModelForAttributeId(
                $id_roja45_product,
                $params['object']->id
            );
            if (!$id_roja45_product_model) {
                $modelObj = new ProductRentalModel();
                $modelObj->id_roja45_product = $id_roja45_product;
                $modelObj->id_product_attribute = $params['object']->id;
                $modelObj->qty_available = $params['object']->quantity;
                $modelObj->is_linked = 1;
                $modelObj->enabled = 1;
                // TODO - Not setting name
                //$modelObj->charge_type = ProductRentalRateType::DAILY;
                //$modelObj->minimum_duration = Configuration::get('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
                if ($modelObj->save()) {
                    $combination_price = (float)$product->price + (float)$params['object']->price;
                    $rate = new ProductRentalRate();
                    $rate->id_roja45_product = $id_roja45_product;
                    $rate->id_parent = $modelObj->id;
                    $rate->rate = (float)$combination_price;
                    $rate->id_type = 1;
                    $rate_type = new ProductRentalRateType(1);
                    $rate->name = $rate_type->name;
                    $rate->description = $rate_type->description;
                    $rate->save();
                }
            }
        }
    }

    public function hookActionProductAttributeUpdate($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        if (Configuration::get('PS_STOCK_MANAGEMENT') == 1) {
            $id_product = Tools::getValue('id_product');
            if ($id_roja45_product = ProductRentalDetails::isRentable($id_product)) {
                $id_roja45_product_model = ProductRentalModel::getModelForAttributeId(
                    $id_roja45_product,
                    $params['id_product_attribute']
                );
                if ($id_roja45_product_model) {
                    //$product = new Product();
                    //$combination = new Combination($params['id_product_attribute']);
                    $model = new ProductRentalModel($id_roja45_product_model);
                    if (Validate::isLoadedObject($model)) {
                        $quantity = StockAvailable::getQuantityAvailableByProduct(
                            $id_product,
                            $params['id_product_attribute']
                        );
                        $model->qty_available = $quantity;
                        $model->save();
                    }
                }
            }
        }
    }

    public function hookActionProductAttributeDelete($params)
    {
        if (!Module::isEnabled($this->name)) {
            return false;
        }
        $id_roja45_product = ProductRentalDetails::isRentable($params['id_product']);
        if ($id_roja45_product) {
            if ($params['deleteAllAttributes']) {
                $ids = ProductRentalModel::getProductModelIds($id_roja45_product);
                foreach ($ids as $id) {
                    $model = new ProductRentalModel($id['id_roja45_product_model']);
                    if (Validate::isLoadedObject($model)) {
                        $model->delete();
                    }
                }
            } else {
                $id_roja45_product_model = ProductRentalModel::getModelForAttributeId(
                    $id_roja45_product,
                    $params['id_product_attribute']
                );
                $model = new ProductRentalModel($id_roja45_product_model);
                if (Validate::isLoadedObject($model)) {
                    $model->delete();
                }
            }

            $ids = ProductRentalModel::getProductModelIds($id_roja45_product);
            if (!count($ids)) {
                $product = new Product($params['id_product'], false);
                $modelObj = new ProductRentalModel();
                $modelObj->id_roja45_product = $id_roja45_product;
                $modelObj->is_linked = 0;
                $modelObj->enabled = 1;
                //$modelObj->charge_type = ProductRentalRateType::DAILY;
                if ($modelObj->save()) {
                    $rate = new ProductRentalRate();
                    $rate->id_roja45_product = $id_roja45_product;
                    $rate->id_parent = $modelObj->id;
                    $rate->rate = (float)$product->price;
                    $rate->id_type = 1;
                    $rate_type = new ProductRentalRateType(1);
                    $rate->name = $rate_type->name;
                    $rate->description = $rate_type->description;
                    $rate->save();
                }
            }
        }
    }

    public function hookActionProductRentalSetStatusPAYCAfter($params)
    {
        if (false) {
            $payment = ProductRentalRentalPayment::getNextPayment($params['reservation']->id);
            $order = new Order($payment->id_order);
            $order_state = new OrderState(Configuration::get('PS_OS_PAYMENT'));
            if (Validate::isLoadedObject($order) && Validate::isLoadedObject($order_state)) {
                $current_order_state = $order->getCurrentOrderState();
                if ($current_order_state->id != $order_state->id) {
                    $history = new OrderHistory();
                    $history->id_order = $order->id;
                    $history->id_employee = (int)$this->context->employee->id;
                    $use_existings_payment = false;
                    if (!$order->hasInvoice()) {
                        $use_existings_payment = true;
                    }
                    $history->changeIdOrderState((int)$order_state->id, $order, $use_existings_payment);
                    $carrier = new Carrier($order->id_carrier, $order->id_lang);
                    $templateVars = array();
                    if ($history->id_order_state == Configuration::get('PS_OS_SHIPPING') && $order->shipping_number) {
                        $templateVars = array(
                            '{followup}' => str_replace('@', $order->shipping_number, $carrier->url)
                        );
                    }
                    $history->addWithemail(true, $templateVars);
                }
            }
        }
    }

    public function hookActionProductRentalSetStatusRETNAfter($params)
    {
        // todo - mark as returned
    }

    public function hookActionProductRentalSetStatusCCLDAfter($params)
    {
        // todo - mark as returned if necessary
    }

    public function hookActionAuthentication($params)
    {
        return true;
    }

    public function hookActionCustomerAccountAdd($params)
    {
        //$id_cart = $params['cart']->id;
        // get payment
        // add customer details
    }

    public function hookModuleRoutes($params)
    {
        return array(
            'module-roja45productrental-availability' => array(
                'controller' => 'ProductRentalFront',
                'rule' => 'product-rental/get-availability{/:rental_product}',
                'keywords' => array(
                    'rental_product' => array(
                        'regexp' => '[_a-zA-Z0-9_-]+',
                        'param' => 'property'
                    )
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'roja45productrental',
                    'getAvailability' => '1'
                )
            ),
            'module-roja45productrental-search' => array(
                'controller' => 'PropertyManagerFront',
                'rule' => 'product-rental/{action}',
                'keywords' => array(
                    'action' => array(
                        'regexp' => '\b(search)\b',
                        'param' => 'action'
                    )
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'roja45productrental',
                    'search' => '1'
                )
            ),
            'module-roja45productrental-ProductRentalFront' => array(
                'controller' => 'ProductRentalFront',
                'rule' => 'module/roja45productrental/ProductRentalFront',
                'keywords' => array(),
                'params' => array()
            ),
        );
    }

    public function hookActionDeleteGDPRCustomer($customer)
    {
        if (!empty($customer['email']) && Validate::isEmail($customer['email'])) {
            if (ProductRentalRental::deleteCustomerData($customer['email'])) {
                return Tools::jsonEncode(true);
            } else {
                return Tools::jsonEncode($this->l('Unable to delete customer data.'));
            }
        }
    }

    public function hookActionExportGDPRData($customer)
    {
        if (!empty($customer['email']) && Validate::isEmail($customer['email'])) {
            if ($json = ProductRentalRental::exportCustomerData($customer['email'])) {
                return $json;
            } else {
                return Tools::jsonEncode($this->l('Unable to export customer data.'));
            }
        }
    }

    public function hookActionEmailSendBefore($params)
    {
        if ($emails = explode(
            ',',
            str_replace(' ', '', Configuration::get('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS'))
        )) {
            if (in_array(
                $params['template'],
                $emails
            )) {
                return false;
            }
        }
        return true;
    }

    /**
     * Submit general configuration details.
     */
    public function processSubmitConfiguration()
    {
        $validationErrors = array();
        try {
            if (!count($validationErrors)) {
                $return = true;
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_CREATEMODELS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_CREATEMODELS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_DELETETABLES',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_DELETETABLES')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SENDEMAIL',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SENDEMAIL')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_CS_ACCOUNT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_CS_ACCOUNT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_USEJS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_USEJS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_INSTALLDATA',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_INSTALLDATA')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_VERSION',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_VERSION')
                );
                $minimum_duration = Tools::getValue('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION',
                    $minimum_duration
                );
                $maximum_duration = Tools::getValue('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION');
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION',
                    $maximum_duration
                );

                foreach (ProductRentalDetails::getRentalProducts($this->context->language->id) as $rental_product) {
                    $rental_product = new ProductRentalDetails($rental_product['id_roja45_product']);
                    if ($rental_product->minimum_duration == 1) {
                        $rental_product->minimum_duration = $minimum_duration;
                    }
                    if ($rental_product->maximum_duration == 0) {
                        $rental_product->maximum_duration = $maximum_duration;
                    }
                    $rental_product->save();
                }

                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SENDONSTATUS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SENDONSTATUS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_HASADDRESS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_HASADDRESS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_HASCONTACT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_HASCONTACT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_HASLOCATION',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_HASLOCATION')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_AUTOCONFIRM',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_LASTITEMSWARNING',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX')
                );
                if ($timeStr = Tools::getValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME')) {
                    $dateObj = DateTime::createFromFormat('d.m.Y H:i', '10.10.2010 ' . $timeStr);
                    if ($dateObj !== false) {
                        Configuration::updateValue(
                            'ROJA45_PRODUCTRENTAL_COLLECTIONTIME',
                            $timeStr
                        );
                    } else {
                        throw new Exception('Collection time format invalid');
                    }
                }
                if ($timeStr = Tools::getValue('ROJA45_PRODUCTRENTAL_RETURNTIME')) {
                    $dateObj = DateTime::createFromFormat('d.m.Y H:i', '10.10.2010 ' . $timeStr);
                    if ($dateObj !== false) {
                        Configuration::updateValue(
                            'ROJA45_PRODUCTRENTAL_RETURNTIME',
                            $timeStr
                        );
                    } else {
                        throw new Exception('Return time format invalid');
                    }
                }
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLESALES',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLESALES')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ALWAYSUSECART',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ALWAYSUSECART')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_DISPLAY_LABEL',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_USEPERIODPRICING',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SEARCHCATEGORY',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLESEARCH',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLESEARCH')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ABANDONEDAFTER',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_REMINDERAFTER',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_REMINDERAFTER')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PRESELECTRATE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PRESELECTRATE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_RECONDITIONDAYS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PREPARATIONDAYS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR')
                );
                Configuration::updateValue(
                    'ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR',
                    Tools::getValue('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR')
                );
                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                !(int) Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                    $deposit = new Product();
                    foreach ($this->context->controller->getLanguages() as $lang) {
                        $deposit->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositName',
                            $lang
                        );
                        $deposit->meta_title[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositName',
                            $lang
                        );
                        $deposit->description_short[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositDesc',
                            $lang
                        );
                        $deposit->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositDesc',
                            $lang
                        );
                        $deposit->meta_description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositDesc',
                            $lang
                        );
                        $deposit->link_rewrite[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'ProductDepositLink',
                            $lang
                        );
                    }
                    $deposit->reference = 'product_rental_deposit';
                    $deposit->price = 0.0;
                    $deposit->id_category_default = (int) Configuration::get('PS_HOME_CATEGORY');
                    $deposit->visibility = 'none';
                    $deposit->is_virtual = 1;
                    $deposit->id_tax_rules_group = Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX');
                    $deposit->advanced_stock_management = 0;

                    if ($deposit->add()) {
                        $id_shop_list = Shop::getContextListShopID();
                        foreach ($id_shop_list as $value) {
                            StockAvailable::setProductOutOfStock((int)$deposit->id, 1, $value);
                        }
                        $deposit->addToCategories(array((int) Configuration::get('PS_HOME_CATEGORY')));
                        $image = new Image();
                        $image->id_product = (int)($deposit->id);
                        $image->position = Image::getHighestPosition($deposit->id) + 1;

                        if (!Image::getCover($image->id_product)) {
                            $image->cover = 1;
                        } else {
                            $image->cover = 0;
                        }
                        if ($image->add()) {
                            $new_path = $image->getPathForCreation();
                            $formats = ImageType::getImagesTypes('products');
                            $error = 0;
                            foreach ($formats as $imageType) {
                                if (!ImageManager::resize(
                                    _PS_MODULE_DIR_ . $this->name . '/views/img/refundable_deposit.png',
                                    $new_path.'-'.Tools::stripslashes($imageType['name']).'.jpg',
                                    (int)$imageType['width'],
                                    (int)$imageType['height'],
                                    'jpg',
                                    false,
                                    $error
                                )) {
                                    switch ($error) {
                                        case ImageManager::ERROR_FILE_NOT_EXIST:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, the file does not exist anymore.'
                                            );
                                            break;
                                        case ImageManager::ERROR_FILE_WIDTH:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, the file width is 0px.'
                                            );
                                            break;
                                        case ImageManager::ERROR_MEMORY_LIMIT:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, check your memory limit.'
                                            );
                                            break;
                                        default:
                                            $validationErrors[] = Tools::displayError(
                                                'An error occurred while copying image.'
                                            );
                                            break;
                                    }
                                }
                            }

                            $stock_management_active = Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT');
                            if (!$stock_management_active || (int)$deposit->advanced_stock_management == 0) {
                                StockAvailable::setQuantity(
                                    (int)$deposit->id,
                                    null,
                                    9999
                                );
                            }
                        }
                        Configuration::updateValue(
                            'ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT',
                            $deposit->id
                        );
                    }
                } elseif ((int) !Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                    Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                    if ($id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                        $deposit = new Product($id_product_deposit);
                        $deposit->delete();
                    }
                    Configuration::deleteByName('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT');
                }

                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX') &&
                    Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                    if ($id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                        $deposit = new Product($id_product_deposit);
                        $deposit->id_tax_rules_group = Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX');
                        $deposit->save();
                    }
                }

                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS') == 1 &&
                    !Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT')) {
                    $payment = new Product();
                    foreach ($this->context->controller->getLanguages() as $lang) {
                        $payment->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentName',
                            $lang
                        );
                        $payment->meta_title[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentName',
                            $lang
                        );
                        $payment->description_short[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentDesc',
                            $lang
                        );
                        $payment->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentDesc',
                            $lang
                        );
                        $payment->meta_description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentDesc',
                            $lang
                        );
                        $payment->link_rewrite[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'RentalPaymentLink',
                            $lang
                        );
                    }
                    $payment->reference = 'product_rental_payment';
                    $payment->price = 0.0;
                    $payment->id_category_default = (int) Configuration::get('PS_HOME_CATEGORY');
                    $payment->visibility = 'none';
                    $payment->is_virtual = 1;
                    $payment->id_tax_rules_group = 0;
                    $payment->advanced_stock_management = 0;

                    if ($payment->add()) {
                        $id_shop_list = Shop::getContextListShopID();
                        foreach ($id_shop_list as $value) {
                            StockAvailable::setProductOutOfStock((int)$payment->id, 1, $value);
                        }
                        $payment->addToCategories(array((int) Configuration::get('PS_HOME_CATEGORY')));
                        $image = new Image();
                        $image->id_product = (int)($payment->id);
                        $image->position = Image::getHighestPosition($payment->id) + 1;

                        if (!Image::getCover($image->id_product)) {
                            $image->cover = 1;
                        } else {
                            $image->cover = 0;
                        }
                        if ($image->add()) {
                            $new_path = $image->getPathForCreation();
                            $formats = ImageType::getImagesTypes('products');
                            $error = 0;
                            foreach ($formats as $imageType) {
                                if (!ImageManager::resize(
                                    _PS_MODULE_DIR_ . $this->name . '/views/img/refundable_deposit.png',
                                    $new_path.'-'.Tools::stripslashes($imageType['name']).'.jpg',
                                    (int)$imageType['width'],
                                    (int)$imageType['height'],
                                    'jpg',
                                    false,
                                    $error
                                )) {
                                    switch ($error) {
                                        case ImageManager::ERROR_FILE_NOT_EXIST:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, the file does not exist anymore.'
                                            );
                                            break;
                                        case ImageManager::ERROR_FILE_WIDTH:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, the file width is 0px.'
                                            );
                                            break;
                                        case ImageManager::ERROR_MEMORY_LIMIT:
                                            $validationErrors[]  = Tools::displayError(
                                                'An error occurred while copying image, check your memory limit.'
                                            );
                                            break;
                                        default:
                                            $validationErrors[] = Tools::displayError(
                                                'An error occurred while copying image.'
                                            );
                                            break;
                                    }
                                }
                            }

                            $stock_management_active = Configuration::get('PS_ADVANCED_STOCK_MANAGEMENT');
                            if (!$stock_management_active || (int)$payment->advanced_stock_management == 0) {
                                StockAvailable::setQuantity(
                                    (int)$payment->id,
                                    null,
                                    9999
                                );
                            }
                        }
                        Configuration::updateValue(
                            'ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT',
                            $payment->id
                        );
                    }
                } elseif ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS') == 0 &&
                    Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT')) {
                    if ($id_product_payment = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT')) {
                        $payment = new Product($id_product_payment);
                        $payment->delete();
                        Configuration::deleteByName('ROJA45_PRODUCTRENTAL_IDPRODUCTOTHERPAYMENT');
                    }
                }
                if ($return) {
                    Roja45ProductRental::clearAllCached();
                    return true;
                } else {
                    if (count($validationErrors) == 0) {
                        $validationErrors[] = 'An unexpected error has occurred.';
                    }
                }
            }
            return $validationErrors;
        } catch (Exception $e) {
            $validationErrors = array();
            $validationErrors[] = $e->getMessage();
            return $validationErrors;
        }
    }

    public function deleteRentalEntry($id_roja45_rental, $id_product, $id_product_attribute, $update_cart)
    {
        if ($id_roja45_rental) {
            $rental = new ProductRentalRental($id_roja45_rental);
            $rental->deleteModel($id_product, $id_product_attribute);
            if ($update_cart) {
                $this->context->cart->deleteProduct($id_product, $id_product_attribute);
            }
            $rental = new ProductRentalRental($id_roja45_rental);
            $rental_object = Tools::jsonDecode($rental->toJSON($this->context->language->id));
            $rental_object = ProductRentalRental::validateRental($rental_object);

            if (!count((array)$rental_object->products)) {
                // TODO - Last product deleted, should we delete the rental entry as well??
                $rental->delete();
                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                    $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                    $this->context->cart->deleteProduct($id_product_deposit, 0);
                }
                return 0;
            } else {
                if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT') &&
                    $id_product_deposit = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                    $this->context->cart->deleteProduct($id_product_deposit, 0);
                    //SpecificPrice::deleteByProductId($id_product_deposit);
                    RojaFortyFiveProductRentalCore::deleteCustomerCartProductSpecificPrice(
                        (int)$this->context->customer->id,
                        (int)$this->context->cart->id,
                        $id_product_deposit,
                        null
                    );
                    if ($rental_object->total_damage_deposit_exc > 0) {
                        $specific_price = new SpecificPrice();
                        $specific_price->id_shop = $this->context->shop->id;
                        $specific_price->id_shop_group = $this->context->shop->id_shop_group;
                        $specific_price->id_currency = 0;
                        $specific_price->id_country = 0;
                        $specific_price->id_group = 0;
                        $specific_price->id_cart = (int)$this->context->cart->id;
                        $specific_price->id_customer = (int)$this->context->customer->id;
                        $specific_price->id_product = $id_product_deposit;
                        $specific_price->id_product_attribute = null;
                        $specific_price->price = (float) $rental_object->total_damage_deposit_exc;
                        $specific_price->from_quantity = 1;
                        $specific_price->reduction = 0;
                        $specific_price->reduction_type = 'amount';
                        $specific_price->reduction_tax = 0;
                        $specific_price->from = '0000-00-00 00:00:00';
                        $specific_price->to = '0000-00-00 00:00:00';
                        if ($specific_price->save()) {
                            $this->context->cart->updateQty(
                                1,
                                $id_product_deposit,
                                null,
                                null,
                                'up',
                                $this->context->shop->id
                            );
                        } else {
                            throw new Exception(
                                $this->l(
                                    'Unable to create cart specific price: [' . Db::getInstance()->getMsgError() . ']'
                                )
                            );
                        }
                    }
                }
                return count((array)$rental_object->products);
            }
        }
    }

    public function _getFormatedAddress(Address $the_address, $line_sep, $fields_style = array())
    {
        return AddressFormat::generateAddress($the_address, array('avoid' => array()), $line_sep, ' ', $fields_style);
    }

    public function sendAdminNotificationEmail()
    {
    }

    public function updateBookingStatus($id_order, $status)
    {
        $booking = ProductRentalRental::getRentalByOrderId($id_order);
        $booking->updateBookingStatus($status);
    }

    public function deleteBooking($id_order)
    {
        $booking = ProductRentalRental::getRentalByOrderId($id_order);
        $booking->delete();
    }

    public function createSummaryEmail($cart, $html)
    {
        $rental = ProductRentalRental::getRentalByCartId($cart->id);
        if (Validate::isLoadedObject($rental)) {
            $data = $rental->getSummary();
            $this->smarty->assign($data);
            if ($html) {
                return $this->display(__FILE__, 'hookSummaryEmail.tpl');
            } else {
                return $this->display(__FILE__, 'hookSummaryEmailTxt.tpl');
            }
        }
    }

    public function createBookingSummary($id_cart)
    {
        $rental = ProductRentalRental::getRentalByCartId($id_cart);
        if (Validate::isLoadedObject($rental)) {
            return $this->getRentalSummary($rental);
        }
    }

    public function renderModelAdditionalContent($model)
    {
        $available_addons = ProductRentalExtra::getExtras($this->context->language->id);
        $all_selected = ProductRentalModelExtra::getExtrasForModel(
            $model->id_roja45_product_model,
            $this->context->language->id
        );
        $selected_ids = array();
        $selected_addons = array();
        foreach ($all_selected as $selected) {
            $selected_ids[] = $selected['id_roja45_product_extra'];
            $selected_addons[$selected['id_roja45_product_extra']] = $selected;
        }
        $this->smarty->assign(
            array(
                'admin_link' => $this->context->link->getAdminLink('AdminProductRental', true),
            )
        );
        if (count($available_addons) > 0) {
            $this->smarty->assign(
                array(
                    'id_roja45_product_model' => $model->id_roja45_product_model,
                    'available_addons' => $available_addons,
                    'selected_ids' => $selected_ids,
                    'selected' => $selected_addons,
                    'currency' => $this->context->currency,
                )
            );
        }
        return $this->display(__FILE__, 'productrental_extras.tpl');
    }

    public function processCron($parameters)
    {
        $processed = ProductRentalRental::processRentals($parameters);
        if ($this->cron) {
            if ($processed) {
                die();
            } else {
                die("<pre style='color:#EE2711'>[ERROR]: </pre>");
            }
        } else {
            Tools::redirect(
                '/index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules').'&tab_module='.$this->tab.'&module_name='.$this->name
            );
        }
    }

    protected function processSubmit()
    {
        if (Tools::isSubmit('sent_register')) {
            if (Tools::getIsset('email') && Tools::getIsset('number_order')) {
                $params = array();
                $params['email'] = Tools::getValue('email');
                $params['number_order'] = Tools::getValue('number_order');
                $params['is_domain_test'] = (
                (Tools::getIsset('is_domain_test') && Tools::getValue('is_domain_test', 'off') == 'on') ? 1 : 0);

                if (!empty($params['email']) && !empty($params['number_order'])) {
                    $response = $this->jsonDecode($this->sendRequest($params));

                    if (is_object($response)) {
                        if ($response->code == self::CODE_ERROR) {
                            $this->errors[] = $response->message;
                        } elseif ($response->code == self::CODE_SUCCESS) {
                            $this->html .= $this->displayConfirmation($response->message);
                        }
                    }
                } else {
                    $this->errors[] = 'Please enter the information marked as mandatory for registration module.';
                }
            }
        } else {
            if (Tools::isSubmit('submitConfiguration')) {
                $returned = $this->processSubmitConfiguration();
                if (is_array($returned)) {
                    if (count($returned) > 0) {
                        foreach ($returned as $err) {
                            $this->html .= $this->displayError($err);
                        }
                    } else {
                        $this->html .= $this->displayError($this->l('Unable to save configuration.'));
                    }
                } elseif ($returned == true) {
                    $this->html .= $this->displayConfirmation($this->l('Settings updated'));
                } else {
                    $this->html .= $this->displayError($this->l('Unable to save configuration.'));
                }
            }
        }
    }

    protected function getEmailTemplateContent($template_name, $mail_type, $var)
    {
        $email_configuration = Configuration::get('PS_MAIL_TYPE');
        if ($email_configuration != $mail_type && $email_configuration != Mail::TYPE_BOTH) {
            return '';
        }

        $theme_template_path = _PS_THEME_DIR_ . 'mails' . DIRECTORY_SEPARATOR . $this->context->language->iso_code . DIRECTORY_SEPARATOR . $template_name;
        $default_mail_template_path = _PS_MAIL_DIR_ . $this->context->language->iso_code . DIRECTORY_SEPARATOR . $template_name;

        if (Tools::file_exists_cache($theme_template_path)) {
            $default_mail_template_path = $theme_template_path;
        }

        if (Tools::file_exists_cache($default_mail_template_path)) {
            $this->context->smarty->assign('list', $var);

            return $this->context->smarty->fetch($default_mail_template_path);
        }

        return '';
    }

    private function registerHooks()
    {
        if (!$this->registerHook('actionAdminControllerSetMedia')
            || !$this->registerHook('actionValidateOrder')
            || !$this->registerHook('actionOrderStatusPostUpdate')
            || !$this->registerHook('actionProductListModifier')
            || !$this->registerHook('actionEmailAddAfterContent')
            || !$this->registerHook('actionGetExtraMailTemplateVars')
            || !$this->registerHook('actionReserveProductPaymentAdditionalInfo')
            || !$this->registerHook('actionRoja45ProductRentalAdditionalContentListModifier')
            || !$this->registerHook('actionProductSave')
            || !$this->registerHook('actionProductUpdate')
            || !$this->registerHook('actionAuthentication')
            || !$this->registerHook('actionAttributeSave')
            || !$this->registerHook('actionObjectCombinationAddAfter')
            || !$this->registerHook('actionProductAttributeUpdate')
            || !$this->registerHook('actionCustomerAccountAdd')
            || !$this->registerHook('deleteProductAttribute')
            || !$this->registerHook('actionProductAttributeDelete')
            || !$this->registerHook('actionDeleteGDPRCustomer')
            || !$this->registerHook('actionExportGDPRData')
            || !$this->registerHook('actionProductRentalSetStatusPAYCAfter')
            || !$this->registerHook('actionRoja45ProductRentalPostProcessBefore')
            || !$this->registerHook('actionRoja45ProductRentalPostProcessAfter')
            || !$this->registerHook('actionProductRentalSetStatusRETNAfter')
            || !$this->registerHook('actionProductRentalSetStatusCCLDAfter')
            || !$this->registerHook('registerGDPRConsent')
            || !$this->registerHook('displayHeader')
            || !$this->registerHook('displayProductListReviews')
            || !$this->registerHook('displayAdminProductsExtra')
            || !$this->registerHook('displayProductTab')
            || !$this->registerHook('displayProductTabContent')
            || !$this->registerHook('displayProductExtraContent')
            || !$this->registerHook('displayProductReservation')
            || !$this->registerHook('displayBackOfficeHeader')
            || !$this->registerHook('displayCustomerAccount')
            || !$this->registerHook('displayOrderConfirmation')
            || !$this->registerHook('displayBackOfficeFooter')
            || !$this->registerHook('displayProductRentalSummary')
            || !$this->registerHook('displayRoja45ProductListFlag')
            || !$this->registerHook('displayRoja45SearchBar')
            || !$this->registerHook('displayRoja45ModuleManager')
            || !$this->registerHook('displayRoja45ProductRentalSummary')
            || !$this->registerHook('displayRoja45ProductRentalPluginTab')
            || !$this->registerHook('displayRoja45ProductRentalPluginTabContent')
            || !$this->registerHook('displayRoja45ProductPageGetAvailability')
            || !$this->registerHook('displayRoja45ProductListRentalBlock')
            || !$this->registerHook('displayRoja45RentalProductPrice')
        ) {
            return false;
        }

        if (version_compare(_PS_VERSION_, '1.7', '<') == true) {
            if (!$this->registerHook('displayShoppingCartFooter')
                || !$this->registerHook('actionAfterDeleteProductInCart')
                || !$this->registerHook('displayProductButtons')
                || !$this->registerHook('displayTop')) {
                return false;
            }
        }

        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            if (!$this->registerHook('displayProductRentalProductPageCalendar')
                || !$this->registerHook('displayProductRentalProductPageGetRates')
                || !$this->registerHook('actionDeleteProductInCartAfter')
                || !$this->registerHook('actionObjectProductInCartDeleteAfter')
                || !$this->registerHook('displayCheckoutSummaryTop')
                || !$this->registerHook('actionAuthentication')
                || !$this->registerHook('displayProductAdditionalInfo')
                || !$this->registerHook('actionEmailSendBefore')
                || !$this->registerHook('displayHome')) {
                return false;
            }
        }

        return true;
    }

    private function installDb()
    {
        $return = true;
        try {
            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_details` (
              `id_roja45_product` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_product` INT(10) UNSIGNED NOT NULL,
              `id_shop_default` INT(10) UNSIGNED NOT NULL,
              `id_paymentprofile` INT(10) UNSIGNED,
              `id_roja45_product_damagedeposit` INT(10) UNSIGNED,
              `id_roja45_product_overdueaction` INT(10) UNSIGNED,
              `address` TEXT,
              `address_2` TEXT,
              `city` VARCHAR(255),
              `area` INT(10),
              `country` VARCHAR(255),
              `state` VARCHAR(255),
              `postal_code` VARCHAR(255),
              `telephone_1` VARCHAR(255),
              `telephone_2` VARCHAR(255),
              `class` INT(10),
              `url` VARCHAR(255),
              `email` VARCHAR(255),
              `lat` VARCHAR(255),
              `lon` VARCHAR(255),
              `collection_time` VARCHAR(255),
              `return_time` VARCHAR(255),
              `instant_rental` TINYINT(1),
              `overdue_fine` DOUBLE(20,6),
              `minimum_duration` INT(10),
              `maximum_duration` INT(10),
              `enabled` TINYINT(1),
              PRIMARY KEY (`id_roja45_product`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_details_shop` (
              `id_roja45_product` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_shop` INT(10) UNSIGNED NOT NULL,
              `enabled` TINYINT(1),
              PRIMARY KEY (`id_roja45_product`, `id_shop`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_model` (
              `id_roja45_product_model` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_roja45_product` INT(10) UNSIGNED NOT NULL,
              `id_product_attribute` INT(10) UNSIGNED,
              `id_paymentprofile` INT(10) UNSIGNED,
              `name` VARCHAR(255),
              `reference` VARCHAR(255),
              `payment_profile_enabled` TINYINT(1),
              `service_charge` DOUBLE(20,6),
              `service_charge_type` INT(10),
              `qty_available` INT(10),
              `minimum_duration` INT(10),
              `booking_type` INT(10),
              `minimum_rate` DOUBLE(20,6),
              `minimum_rate_type` VARCHAR(255),
              `minimum_rate_enabled` TINYINT(1),
              `is_linked` TINYINT(1),
              `enabled` TINYINT(1),
              PRIMARY KEY (`id_roja45_product_model`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_model_lang` (
              `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `description` TEXT,
              PRIMARY KEY (`id_roja45_product_model`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_model_image` (
              `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
              `id_image` INT(10) UNSIGNED,
              `id_roja45_product` INT(10) UNSIGNED,
              `position` INT(10),
              `cover` TINYINT(1),
              PRIMARY KEY (`id_roja45_product_model`,`id_image`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile` (
                `id_roja45_product_paymentprofile` INT(10) unsigned NOT NULL auto_increment,
                `id_group` INT(10) unsigned NOT NULL,
                `type` INT(1),
                `position` INT(1),
                `number_payments` INT(10),
                `deposit_amount` DOUBLE(20,6),
                `deposit_type` INT(1),
                `days_until_reservation` INT(1),
                `payment_request_days` INT(10) NOT NULL DEFAULT 7,
                `enabled` TINYINT(1),
                PRIMARY KEY (`id_roja45_product_paymentprofile`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile_lang` (
              `id_roja45_product_paymentprofile` int(10) unsigned NOT NULL auto_increment,
              `id_lang` int(10) unsigned NOT NULL,
              `name` varchar(255),
              `description` text,
              PRIMARY KEY (`id_roja45_product_paymentprofile`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rategroup` (
              `id_roja45_product_rategroup` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_roja45_product_rate` INT(10),
              `id_group` INT(10),
              PRIMARY KEY (`id_roja45_product_rategroup`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass` (
              `id_roja45_product_rateclass` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `enabled` TINYINT(1),
              PRIMARY KEY (`id_roja45_product_rateclass`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass_lang` (
              `id_roja45_product_rateclass` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `name` VARCHAR(255),
              `description` VARCHAR(1024),
              PRIMARY KEY (`id_roja45_product_rateclass`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateduration` (
                  `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `type` INT(10) UNSIGNED NOT NULL,
                  `duration` INT(10) NOT NULL,
                  `active` TINYINT(1) NOT NULL,
                  PRIMARY KEY (`id_roja45_product_rateduration`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateduration_lang` (
                  `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_lang` INT(10) UNSIGNED NOT NULL,
                  `name` VARCHAR(255),
                  PRIMARY KEY (`id_roja45_product_rateduration`,`id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_ratetype` (
              `id_roja45_product_ratetype` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL,
              PRIMARY KEY (`id_roja45_product_ratetype`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_ratetype_lang` (
              `id_roja45_product_ratetype` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `name` VARCHAR(255),
              `description` VARCHAR(1024),
              PRIMARY KEY (`id_roja45_product_ratetype`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rate` (
              `id_roja45_product_rate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_roja45_product` INT(10) UNSIGNED NOT NULL,
              `id_parent` INT(10) UNSIGNED NOT NULL,
              `id_type` INT(10),
              `rate` DOUBLE(20,6),
              PRIMARY KEY (`id_roja45_product_rate`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rate_lang` (
                  `id_roja45_product_rate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_lang` INT(10) UNSIGNED NOT NULL,
                  `name` VARCHAR(255),
                  `description` VARCHAR(1024),
                  PRIMARY KEY (`id_roja45_product_rate`,`id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_daterate` (
                  `id_roja45_product_daterate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_roja45_product` INT(10) UNSIGNED NOT NULL,
                  `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
                  `id_roja45_product_rate` INT(10) UNSIGNED NOT NULL,
                  `date` DATE,
                  `rate` DOUBLE(20,6),
                  PRIMARY KEY (`id_roja45_product_daterate`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_productunavailable` (
                `id_roja45_product_unavailable` INT(10) unsigned NOT NULL auto_increment,
                `id_roja45_product` INT(10) unsigned NOT NULL,
                `id_roja45_product_model` INT(10) unsigned NOT NULL,
                `start_date` DATE,
                `end_date` DATE,
                `date_add` DATETIME,
                `date_upd` DATETIME,
                PRIMARY KEY (`id_roja45_product_unavailable`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rental` (
              `id_roja45_product_rental` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_customer` INT(10) UNSIGNED NOT NULL,
              `id_currency` INT(10) UNSIGNED NOT NULL,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `id_shop` INT(10) UNSIGNED NOT NULL,
              `id_roja45_product_rental_status` INT(10) UNSIGNED NOT NULL,
              `id_delivery_address` INT(10) UNSIGNED NOT NULL,
              `id_collection_address` INT(10) UNSIGNED NOT NULL,
              `reference` VARCHAR(255) NOT NULL,
              `type` INT(10),
              `total` DOUBLE(20,6),
              `modified` TINYINT(1),
              `cod` TINYINT(1),
              `uid` VARCHAR(255),
              `date_add` DATETIME,
              `date_upd` DATETIME,
              PRIMARY KEY (`id_roja45_product_rental`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` (
                `id_roja45_product_rental_product` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                `id_roja45_product_rental` INT(10) UNSIGNED NOT NULL,
                `id_roja45_product` INT(10) UNSIGNED NOT NULL,
                `id_product` INT(10) UNSIGNED,
                `id_paymentprofile` INT(10),
                `vouchers` VARCHAR(255),
                PRIMARY KEY (`id_roja45_product_rental_product`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` (
                `id_roja45_product_rental_model` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                `id_roja45_product_rental_product` INT(10) UNSIGNED NOT NULL,
                `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL,
                `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
                `id_product_attribute` INT(10) UNSIGNED,
                `start_date` DATE,
                `collection_time` TIME,
                `end_date` DATE,
                `return_time` TIME,
                `periods` INT(10) UNSIGNED NOT NULL,
                `qty` INT(10) UNSIGNED NOT NULL,
                `total` DOUBLE(20,6),
                `total_wt` DOUBLE(20,6),
                `damage_deposit` DOUBLE(20,6),
                `damage_deposit_inc` DOUBLE(20,6),
                `return_due` TINYINT(1),
                `out_for_rent` TINYINT(1),
                `overdue` TINYINT(1),
                `returned` TINYINT(1),
                `date_rtn` DATETIME,
                `date_add` DATETIME,
                `date_upd` DATETIME,
                PRIMARY KEY (`id_roja45_product_rental_model`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` (
                `id_roja45_product_rental_rate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                `id_roja45_product_rental_model` INT(10) UNSIGNED NOT NULL,
                `id_roja45_product_rate` INT(10) UNSIGNED NOT NULL,
                `entry` INT NOT NULL,
                `value` DOUBLE(20,6),
                `discount` DOUBLE(20,6),
                `total` DOUBLE(20,6),
                `tax` DOUBLE(20,6),
                `period` VARCHAR(255),
                `date_add` DATETIME,
                `date_upd` DATETIME,
                PRIMARY KEY (`id_roja45_product_rental_rate`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra` (
                `id_roja45_product_rental_extra` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                `id_roja45_product_rental_model` INT(10) UNSIGNED NOT NULL,
                `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL,
                `rate` DOUBLE(20,6),
                `tax` DOUBLE(20,6),
                `qty` INT(10) UNSIGNED NOT NULL,
                `total_deposit` DOUBLE(20,6),
                `total` DOUBLE(20,6),
                `discount` DOUBLE(20,6),
                `date_add` DATETIME,
                `date_upd` DATETIME,
                PRIMARY KEY (`id_roja45_product_rental_extra`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` (
                `id_roja45_product_rental_payment` int(10) unsigned NOT NULL auto_increment,
                `id_roja45_product_rental` int(10) unsigned NOT NULL,
                `id_cart` int(10) unsigned,
                `id_order` int(10) unsigned,
                `id_currency` int(10) unsigned,
                `id_roja45_product_payment_type` int(10) unsigned,
                `position` int(5),
                `payment_due` tinyint(1),
                `payment_late` tinyint(1),
                `reminders_sent` int(5),
                `completed` tinyint(1),
                `requested` tinyint(1),
                `deleted` tinyint(1),
                `total` double(20,6),
                `total_with_tax` double(20,6),
                `note` varchar(1000),
                `date_requested` DATETIME NULL,
                `date_paid` DATETIME NULL,
                `date_due` DATETIME NULL,
                `date_completed` DATETIME NULL,
                `date_add` DATETIME NULL,
                `date_upd` DATETIME NULL,
                `date_del` DATETIME NULL,
                PRIMARY KEY (`id_roja45_product_rental_payment`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item` (
                  `id_roja45_product_rental_payment_item` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_roja45_product_rental_payment` INT(10) UNSIGNED NOT NULL,
                  `id_product` INT(10) UNSIGNED NOT NULL,
                  `id_product_attribute` INT(10) UNSIGNED NOT NULL,
                  `total_paid` DOUBLE(20,6),
                  PRIMARY KEY (`id_roja45_product_rental_payment_item`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus` (
                `id_roja45_product_rental_status` int(10) unsigned NOT NULL auto_increment,
                `color`       varchar(255) NOT NULL,
                `code`        varchar(255) NOT NULL,
                `send_email` tinyint(1) NOT NULL DEFAULT \'0\',
                `notify_admin` tinyint(1) NOT NULL DEFAULT \'0\',
                `record_history` tinyint(1) NOT NULL DEFAULT \'0\',
                `unremovable` tinyint(1) NOT NULL DEFAULT \'0\',
                `block_calendar` tinyint(1) NOT NULL DEFAULT \'0\',
                `customer_account` tinyint(1) NOT NULL DEFAULT \'0\',
                `answer_template` varchar(255) NOT NULL,
                PRIMARY KEY (`id_roja45_product_rental_status`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus_lang` (
                `id_roja45_product_rental_status` int(10) unsigned NOT NULL auto_increment,
                `id_lang` varchar(255) NOT NULL,
                `status` varchar(255) NOT NULL,
                PRIMARY KEY (`id_roja45_product_rental_status`,`id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalprocess` (
                `id_roja45_product_rental_process` int(10) unsigned NOT NULL auto_increment,
                `id_roja45_product_rental` int(10) unsigned NOT NULL,
                `id_roja45_product_rental_status` int(10) unsigned NOT NULL,
                `position` int(10),
                PRIMARY KEY (`id_roja45_product_rental_process`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalnote` (
                `id_roja45_product_rentalnote` int(10) unsigned NOT NULL auto_increment,
                `id_roja45_product_rental` int(10) unsigned NOT NULL,
                `note` varchar(1024) NOT NULL,
                PRIMARY KEY (`id_roja45_product_rentalnote`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalmessage` (
                `id_roja45_product_rentalmessage` int(10) unsigned NOT NULL auto_increment,
                `id_roja45_product_rental` int(10) unsigned NOT NULL,
                `id_customer_thread` int(10) NOT NULL,
                PRIMARY KEY (`id_roja45_product_rentalmessage`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_period` (
              `id_roja45_product_period` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `is_recurring` TINYINT(1),
              `start_date` DATE,
              `end_date` DATE,
              PRIMARY KEY (`id_roja45_product_period`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_period_lang` (
              `id_roja45_product_period` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `name` VARCHAR(255),
              PRIMARY KEY (`id_roja45_product_period`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_periodrate` (
              `id_roja45_product_periodrate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_roja45_product` INT(10) UNSIGNED NOT NULL,
              `id_parent` INT(10) UNSIGNED NOT NULL,
              `id_roja45_product_period` INT(10) UNSIGNED NOT NULL,
              `start_date` DATE,
              `end_date` DATE,
              `id_rate` INT(10) UNSIGNED,
              `rate` DOUBLE(20,6),
              PRIMARY KEY (`id_roja45_product_periodrate`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_periodrate_lang` (
              `id_roja45_product_periodrate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `name` VARCHAR(255),
              PRIMARY KEY (`id_roja45_product_periodrate`,`id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_chargetype` (
                `id_roja45_product_rental_extra_chargetype` int(10) unsigned NOT NULL auto_increment,
                `code` INT(10) UNSIGNED NOT NULL,
                PRIMARY KEY (`id_roja45_product_rental_extra_chargetype`)
                ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
            $return &= (bool) Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_chargetype_lang` (
                `id_roja45_product_rental_extra_chargetype` int(10) unsigned NOT NULL auto_increment,
                `id_lang` int(10) unsigned NOT NULL,
                `name` varchar(255) NOT NULL,
                `description` text NOT NULL,
                PRIMARY KEY (`id_roja45_product_rental_extra_chargetype`, `id_lang`)
                ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
            $return &= (bool) Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_extra` (
                    `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `id_roja45_productrental_extra_type` INT(10) UNSIGNED NOT NULL,
                    `default_selected` TINYINT(1),
                    `enabled` TINYINT(1),
                    `required` TINYINT(1),
                    `deselect_warning` TINYINT(1),
                    `image` VARCHAR(255),
                    `rate` DOUBLE(20,6),
                    PRIMARY KEY (`id_roja45_product_extra`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_extra_lang` (
                    `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `id_lang` INT(10) UNSIGNED NOT NULL,
                    `name` VARCHAR(255) NOT NULL,
                    `description` TEXT NOT NULL,
                    `deselect_warning_text` TEXT NOT NULL,
                    PRIMARY KEY (`id_roja45_product_extra`,`id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_model_extra` (
                    `id_roja45_product_extralink` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                    `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL,
                    `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
                    `rate` DOUBLE(20,6),
                    `enabled` TINYINT(1),
                    PRIMARY KEY (`id_roja45_product_extralink`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistory` (
                `id_roja45_productrental_rentalhistory` int(10) unsigned NOT NULL auto_increment,
                `id_roja45_property_cart` int(10) unsigned NOT NULL,
                `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL,
                `id_roja45_productrental_rentalstatus` int(10) unsigned NOT NULL,
                `date_add` datetime,
                `date_upd` datetime,
                `detail` varchar(1024),
                PRIMARY KEY (`id_roja45_productrental_rentalhistory`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype` (
                `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_roja45_productrental_rentalhistory_type`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype_lang` (
                `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL auto_increment,
                `id_lang` int(10) unsigned NOT NULL,
                `name` varchar(255),
                PRIMARY KEY (`id_roja45_productrental_rentalhistory_type`, `id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_workingday` (
              `id_roja45_product_rental_workingday` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
              `day` VARCHAR(255),
              `opening_time` TIME,
              `closing_time` TIME,
              `is_working_day` tinyint(1),
              `allow_rentals` tinyint(1),
              PRIMARY KEY (`id_roja45_product_rental_workingday`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_workingday_lang` (
                  `id_roja45_product_rental_workingday` INT(10) UNSIGNED NOT NULL,
                  `id_lang` int(10) unsigned NOT NULL,
                  `name` VARCHAR(255),
                  PRIMARY KEY (`id_roja45_product_rental_workingday`, `id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discount` (
              `id_roja45_product_discount` int(10) unsigned NOT NULL auto_increment,
              `name` varchar(255) NOT NULL,
              `reduction_type` varchar(255),
              `start_date` datetime,
              `end_date` datetime,
              `enabled` tinyint(1),
              `date_add` datetime,
              `date_upd` datetime,
              PRIMARY KEY (`id_roja45_product_discount`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountconditiongroup` (
              `id_roja45_product_discountconditiongroup` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_discount` int(10) unsigned NOT NULL,
              PRIMARY KEY (`id_roja45_product_discountconditiongroup`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountcondition` (
              `id_roja45_product_discountcondition` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_discountconditiongroup` int(10) unsigned NOT NULL,
              `type` varchar(255) NOT NULL,
              `value` varchar(255),
              PRIMARY KEY (`id_roja45_product_discountcondition`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile` (
              `id_roja45_product_discountprofile` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_discount` int(10) unsigned NOT NULL,
              `position` varchar(255) NOT NULL,
              `period_start` INT(10),
              `period_end` INT(10),
              `days` varchar(255) NOT NULL,
              `value` varchar(255),
              PRIMARY KEY (`id_roja45_product_discountprofile`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_productdiscount` (
              `id_roja45_product_productdiscount` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product` int(10) unsigned NOT NULL,
              `id_roja45_product_discount` int(10) unsigned NOT NULL,
              PRIMARY KEY (`id_roja45_product_productdiscount`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype` (
                  `id_roja45_product_payment_type` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `enabled` TINYINT(1),
                  `include` TINYINT(1),
                  PRIMARY KEY (`id_roja45_product_payment_type`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype_lang` (
                  `id_roja45_product_payment_type` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_lang` INT(10) UNSIGNED NOT NULL,
                  `name` VARCHAR(255),
                  PRIMARY KEY (`id_roja45_product_payment_type`, `id_lang`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_damagedeposit` (
                  `id_roja45_product_damagedeposit` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                  `id_deposit_type` INT(10) UNSIGNED NOT NULL,
                  `id_deposit_method` INT(10) UNSIGNED NOT NULL,
                  `id_deposit_source_value` INT(10) UNSIGNED NOT NULL,
                  `name` VARCHAR(255),
                  `deposit_amount` DOUBLE(20,6),
                  `with_tax` TINYINT(1),
                  `enabled` TINYINT(1),
                  PRIMARY KEY (`id_roja45_product_damagedeposit`)
                ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_type` (
                `id_roja45_productrental_extra_type` int(10) unsigned NOT NULL auto_increment,
                `code` varchar(255),
                `id` int(10) unsigned NOT NULL,
                PRIMARY KEY (`id_roja45_productrental_extra_type`)
                ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
            $return &= (bool) Db::getInstance()->execute($sql);

            $sql = '
                CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_type_lang` (
                `id_roja45_productrental_extra_type` int(10) unsigned NOT NULL auto_increment,
                `id_lang` int(10) unsigned NOT NULL,
                `name` varchar(255) NOT NULL,
                `description` text NOT NULL,
                PRIMARY KEY (`id_roja45_productrental_extra_type`, `id_lang`)
                ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
            $return &= (bool) Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher` (
              `id_roja45_product_voucher` int(10) unsigned NOT NULL auto_increment,
              `id_customer` INT(10) UNSIGNED NOT NULL,
              `code` VARCHAR(255),
              `quantity` INT(10),
              `quantity_per_user` INT(10),
              `reduction_percent` DOUBLE(20,6),
              `reduction_amount` DOUBLE(20,6),
              `reduction_extras` TINYINT(1),
              `free_extras` TINYINT(1),
              `enabled` tinyint(1),
              `date_from` datetime,
              `date_to` datetime,
              `date_add` datetime,
              `date_upd` datetime,
              PRIMARY KEY (`id_roja45_product_voucher`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher_lang` (
              `id_roja45_product_voucher` int(10) unsigned NOT NULL auto_increment,
              `id_lang` INT(10) UNSIGNED NOT NULL,
              `name` varchar(255) NOT NULL,
              PRIMARY KEY (`id_roja45_product_voucher`, `id_lang`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher_extra` (
              `id_roja45_product_voucher` int(10) unsigned NOT NULL,
              `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL,
              PRIMARY KEY (`id_roja45_product_voucher`, `id_roja45_product_extra`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_pricerule` (
              `id_roja45_product_pricerule` int(10) unsigned NOT NULL auto_increment,
              `name` varchar(255) NOT NULL,
              `enabled` tinyint(1),
              `date_add` datetime,
              `date_upd` datetime,
              PRIMARY KEY (`id_roja45_product_pricerule`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleconditiongroup` (
              `id_roja45_product_priceruleconditiongroup` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
              PRIMARY KEY (`id_roja45_product_priceruleconditiongroup`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_pricerulecondition` (
              `id_roja45_product_pricerulecondition` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_priceruleconditiongroup` int(10) unsigned NOT NULL,
              `type` varchar(255) NOT NULL,
              `value` varchar(255),
              PRIMARY KEY (`id_roja45_product_pricerulecondition`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofile` (
              `id_roja45_product_priceruleprofile` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
              `position` varchar(255) NOT NULL,
              PRIMARY KEY (`id_roja45_product_priceruleprofile`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofileday` (
              `id_roja45_product_priceruleprofile` int(10) unsigned NOT NULL,
              `day` int(10) NOT NULL,
              `value` int(10) NOT NULL,
              PRIMARY KEY (`id_roja45_product_priceruleprofile`, `day`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);

            $sql = '
            CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_productpricerule` (
              `id_roja45_product_productpricerule` int(10) unsigned NOT NULL auto_increment,
              `id_roja45_product` int(10) unsigned NOT NULL,
              `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
              PRIMARY KEY (`id_roja45_product_productpricerule`)
            ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
            $return &= (bool)Db::getInstance()->execute($sql);
            return $return;
        } catch (Exception $e) {
            return false;
        }
    }

    private function setGlobalVars()
    {
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_RESERVATION_TYPE_INSTANT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_RESERVATION_TYPE_INSTANT', ProductRentalModel::INSTANT_BOOK);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SENDEMAIL')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SENDEMAIL', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_DELETETABLES')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_DELETETABLES', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_USEJS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_USEJS', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_INSTALLDATA')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_INSTALLDATA', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SENDONSTATUS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SENDONSTATUS', Configuration::get('PS_OS_PAYMENT'));
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_HASLOCATION')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_HASLOCATION', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_HASADDRESS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_HASADDRESS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_HASCONTACT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_HASCONTACT', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_CREATEMODELS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_CREATEMODELS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_AUTOCONFIRM')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_AUTOCONFIRM', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT', 100);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_COLLECTIONTIME')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME', '12:00');
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_RETURNTIME')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_RETURNTIME', '12:00');
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLESALES')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLESALES', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ALWAYSUSECART')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ALWAYSUSECART', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_USEPERIODPRICING')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_USEPERIODPRICING', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY')) {
            Configuration::updateGlobalValue('PS_HOME_CATEGORY', 2);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLESEARCH')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLESEARCH', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER', 2);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS', 2);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_REMINDERAFTER')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_REMINDERAFTER', 2);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER', 5);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRESELECTRATE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRESELECTRATE', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY', 1);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS')) {
            Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS', 0);
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR')) {
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR', 'article.product-miniature');
            } else {
                Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR', 'li.ajax_block_product');
            }
        }
        if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR')) {
            if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
                Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR', '#add-to-cart-or-refresh');
            } else {
                Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR', '#buy_block');
            }
        }
        if ($contacts = Contact::getContacts($this->context->language->id)) {
            if (!Configuration::hasKey('ROJA45_PRODUCTRENTAL_CS_ACCOUNT')) {
                Configuration::updateGlobalValue('ROJA45_PRODUCTRENTAL_CS_ACCOUNT', $contacts[0]['id_contact']);
            }
        }
        return true;
    }

    private function populateDefaultData()
    {
        $return = true;
        $def_states = array(
            array(
                'code' => ProductRentalRentalStatus::$RCVD,
                'color' => '#87c5de',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 0,
                'answer_template' => null
            ),
            array(
                'code' => ProductRentalRentalStatus::$CHKT,
                'color' => '#e4c493',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 0,
                'available_customer' => 0,
                'answer_template' => null
            ),
            array(
                'code' => ProductRentalRentalStatus::$CCNF,
                'color' => '#dde776',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'rental_request_received'
            ),
            array(
                'code' => ProductRentalRentalStatus::$PRES,
                'color' => '#619cea',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 0,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'rental_reserved'
            ),
            array(
                'code' => ProductRentalRentalStatus::$CONF,
                'color' => '#67c1a5',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'rental_confirmed'
            ),
            array(
                'code' => ProductRentalRentalStatus::$DPST,
                'color' => '#46bc2d',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'deposit_received'
            ),
            array(
                'code' => ProductRentalRentalStatus::$PAYM,
                'color' => '#f9fa27',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 0,
                'available_customer' => 1,
                'answer_template' => 'request_customer_payment'
            ),
            array(
                'code' => ProductRentalRentalStatus::$PAYU,
                'color' => '#fdb465',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => null
            ),
            array(
                'code' => ProductRentalRentalStatus::$PAYC,
                'color' => '#7bee92',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_payment_received'
            ),
            array(
                'code' => ProductRentalRentalStatus::$PAYR,
                'color' => '#ff644c',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_payment_reminder'
            ),
            array(
                'code' => ProductRentalRentalStatus::$PAYO,
                'color' => '#ff644c',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_payment_overdue'
            ),
            array(
                'code' => ProductRentalRentalStatus::$RETN,
                'color' => '#46bc2d',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_rental_returned'
            ),
            array(
                'code' => ProductRentalRentalStatus::$DLTD,
                'color' => '#92a4ae',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 0,
                'answer_template' => null
            ),
            array(
                'code' => ProductRentalRentalStatus::$CCLD,
                'color' => '#92a4ae',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_rental_cancelled'
            ),
            array(
                'code' => ProductRentalRentalStatus::$COMP,
                'color' => '#92a4ae',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_rental_complete'
            ),
            array(
                'code' => ProductRentalRentalStatus::$REVW,
                'color' => '#972ffe',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'customer_review_request'
            ),
            array(
                'code' => ProductRentalRentalStatus::$OTHR,
                'color' => '#e0e0e0',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 1,
                'record_history' => 0,
                'available_customer' => 0,
                'answer_template' => null
            ),
            array(
                'code' => ProductRentalRentalStatus::$ABND,
                'color' => '#FF8C00',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 1,
                'block_calendar' => 0,
                'record_history' => 0,
                'available_customer' => 0,
                'answer_template' => 'rental_abandoned'
            ),
            array(
                'code' => ProductRentalRentalStatus::$INCP,
                'color' => '#FF8C00',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 0,
                'available_customer' => 0,
                'answer_template' => 'rental_incomplete'
            ),
            array(
                'code' => ProductRentalRentalStatus::$OVER,
                'color' => '#fb8071',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'rental_overdue'
            ),
            array(
                'code' => ProductRentalRentalStatus::$ADMN,
                'color' => '#e0e0e0',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 0,
                'record_history' => 1,
                'available_customer' => 0,
                'answer_template' => ''
            ),
            array(
                'code' => ProductRentalRentalStatus::$RDUE,
                'color' => '#cc88df',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 0,
                'block_calendar' => 1,
                'record_history' => 0,
                'available_customer' => 1,
                'answer_template' => 'rental_return_due'
            ),
            array(
                'code' => ProductRentalRentalStatus::$SHIP,
                'color' => '#f9fa27',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 0,
                'available_customer' => 1,
                'answer_template' => ''
            ),
            array(
                'code' => ProductRentalRentalStatus::$CLCT,
                'color' => '#f9fa27',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 0,
                'available_customer' => 1,
                'answer_template' => 'rental_collection_due'
            ),
            array(
                'code' => ProductRentalRentalStatus::$OPEN,
                'color' => '#7bee92',
                'unremovable' => 1,
                'send_email' => 0,
                'notify_admin' => 0,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => ''
            ),
            array(
                'code' => ProductRentalRentalStatus::$CCLR,
                'color' => '#f75553',
                'unremovable' => 1,
                'send_email' => 1,
                'notify_admin' => 1,
                'block_calendar' => 1,
                'record_history' => 1,
                'available_customer' => 1,
                'answer_template' => 'cancellation_requested'
            )
        );

        foreach ($def_states as $state) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus',
                array(
                    'color' => pSQL($state['color']),
                    'code' => pSQL($state['code']),
                    'unremovable' => (int)$state['unremovable'],
                    'send_email' => (int)$state['send_email'],
                    'notify_admin' => (int)$state['notify_admin'],
                    'block_calendar' => (int)$state['block_calendar'],
                    'record_history' => (int)$state['record_history'],
                    'customer_account' => (int)$state['available_customer'],
                    'answer_template' => pSQL($state['answer_template']),
                )
            );
            $id_status = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_rentalstatus_lang',
                    array(
                        'id_roja45_product_rental_status' => (int)$id_status,
                        'id_lang' => (int)$language['id_lang'],
                        'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $state['code'],
                            $language
                        )),
                    )
                );
            }
        }

        $workingdays = array(
            array(
                'day' => 1,
                'name' => 'SUNDAY',
            ),
            array(
                'day' => 2,
                'name' => 'MONDAY',
            ),
            array(
                'day' => 3,
                'name' => 'TUESDAY',
            ),
            array(
                'day' => 4,
                'name' => 'WEDNESDAY',
            ),
            array(
                'day' => 5,
                'name' => 'THURSDAY',
            ),
            array(
                'day' => 6,
                'name' => 'FRIDAY',
            ),
            array(
                'day' => 7,
                'name' => 'SATURDAY',
            )
        );

        foreach ($workingdays as $workingday) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_workingday',
                array(
                    'id_roja45_product_rental_workingday' => $workingday['day'],
                    'day' => $workingday['name'],
                    'opening_time' => '09:00:00',
                    'closing_time' => '17:00:00',
                    'is_working_day' => 1,
                    'allow_rentals' => 1,
                )
            );
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_workingday_lang',
                    array(
                        'id_roja45_product_rental_workingday' => (int)$workingday['day'],
                        'id_lang' => (int)$language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $workingday['name'],
                            $language
                        ))
                    )
                );
            }
        }

        $extra_types = array(
            array(
                'code' => 'PER_PERIOD',
            ),
            array(
                'code' => 'PER_RENTAL',
            ),
            array(
                'code' => 'PER_RENTAL_ITEM',
            ),
            array(
                'code' => 'PER_RENTAL_ITEM_PER_PERIOD',
            ),
        );
        foreach ($extra_types as $extra_type) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_extra_type',
                array(
                    'code' => (int) $extra_type['code'],
                )
            );
            $id = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_extra_type_lang',
                    array(
                        'id_roja45_productrental_extra_type' => (int)$id,
                        'id_lang' => (int)$language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $extra_type['code'].'ExtraTypeName',
                            $language
                        )),
                        'description' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $extra_type['code'].'ExtraTypeDesc',
                            $language
                        )),
                    )
                );
            }
        }

        $rate_durations = array(
            array(
                'code' => 'HOURLY',
                'type' => ProductRentalRateDuration::HOURLY,
                'duration' => 1,
                'active' => 0,
            ),
            array(
                'code' => 'DAILY',
                'type' => ProductRentalRateDuration::DAILY,
                'duration' => 1,
                'active' => 1,
            ),
            array(
                'code' => 'WEEKLY',
                'type' => ProductRentalRateDuration::WEEKLY,
                'duration' => 7,
                'active' => 0,
            ),
            array(
                'code' => 'MONTHLY',
                'type' => ProductRentalRateDuration::MONTHLY,
                'duration' => 1,
                'active' => 0,
            ),
        );
        foreach ($rate_durations as $rate_duration) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rateduration',
                array(
                    'type' => (int) $rate_duration['type'],
                    'duration' => (int) $rate_duration['duration'],
                    'active' => (int) $rate_duration['active'],
                )
            );
            $id = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_rateduration_lang',
                    array(
                        'id_roja45_product_rateduration' => (int)$id,
                        'id_lang' => (int)$language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $rate_duration['code'].'DurationName',
                            $language
                        )),
                    )
                );
            }
        }

        $def_rate_types = array(
            array(
                'name' => 'StandardDailyRateName',
                'desc' => 'StandardDailyRateDesc',
                'id_roja45_product_rateduration' => ProductRentalRateDuration::getRateDurationId(
                    ProductRentalRateDuration::DAILY
                )
            )
        );

        foreach ($def_rate_types as $def_rate_type) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_ratetype',
                array(
                    'id_roja45_product_rateduration' => pSQL($def_rate_type['id_roja45_product_rateduration'])
                )
            );
            $id_rate_type = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_ratetype_lang',
                    array(
                        'id_roja45_product_ratetype' => (int) $id_rate_type,
                        'id_lang' => (int) $language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $def_rate_type['name'],
                            $language
                        )),
                        'description' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            $def_rate_type['desc'],
                            $language
                        )),
                    )
                );
            }
        }

        $reservation_profile = new ProductRentalPaymentProfile();
        $reservation_profile->id_group = 0;
        $reservation_profile->number_payments = 0;
        $reservation_profile->days_until_reservation = 0;
        $reservation_profile->deposit_type = ProductRentalPaymentProfile::PERCENTAGE;
        $reservation_profile->type = ProductRentalPaymentProfile::FULL;
        $reservation_profile->position = 1;
        $reservation_profile->deposit_amount = 100;
        $reservation_profile->enabled = 1;
        foreach (Language::getLanguages(true) as $lang) {
            $reservation_profile->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                $this,
                'PaymentProfileFullName',
                $lang
            );
            $reservation_profile->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                $this,
                'PaymentProfileFullDesc',
                $lang
            );
        }

        $return &= $reservation_profile->save();

        $reservation_profile = new ProductRentalPaymentProfile();
        $reservation_profile->id_group = 0;
        $reservation_profile->number_payments = 0;
        $reservation_profile->days_until_reservation = 30;
        $reservation_profile->deposit_type = ProductRentalPaymentProfile::PERCENTAGE;
        $reservation_profile->type = ProductRentalPaymentProfile::DEPOSIT_FINAL;
        $reservation_profile->position = 0;
        $reservation_profile->deposit_amount = 50;
        $reservation_profile->enabled = 1;
        foreach (Language::getLanguages(true) as $lang) {
            $reservation_profile->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'PaymentProfileDepositName', $lang);
            $reservation_profile->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'PaymentProfileDepositDesc', $lang);
        }
        $return &= $reservation_profile->save();

        $reservation_profile = new ProductRentalPaymentProfile();
        $reservation_profile->id_group = 0;
        $reservation_profile->number_payments = 0;
        $reservation_profile->days_until_reservation = 0;
        $reservation_profile->deposit_type = ProductRentalPaymentProfile::PERCENTAGE;
        $reservation_profile->type = ProductRentalPaymentProfile::COD_FINAL;
        $reservation_profile->position = 0;
        $reservation_profile->deposit_amount = 50;
        $reservation_profile->enabled = 1;
        foreach (Language::getLanguages(true) as $lang) {
            $reservation_profile->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'PaymentProfileCODName', $lang);
            $reservation_profile->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'PaymentProfileCODDesc', $lang);
        }
        $return &= $reservation_profile->save();

        Configuration::updateValue('ROJA45_PRODUCTRENTAL_COD_PAYMENT', $reservation_profile->id);
        $rate_classes = array(
            array(
                'name' => 'DailyRate',
            ),
            array(
                'name' => 'WeeklyRate',
            ),
            array(
                'name' => 'MonthlyRate',
            ),
            array(
                'name' => 'CustomRate',
            )
        );

        foreach ($rate_classes as $rate_class) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rateclass',
                array(
                    'enabled' => 1
                )
            );
            $id_roja45_product_rateclass = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_rateclass_lang',
                    array(
                        'id_roja45_product_rateclass' => (int)$id_roja45_product_rateclass,
                        'id_lang' => (int)$language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($this, $rate_class['name'].'Name', $language)),
                        'description' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($this, $rate_class['name'].'Desc', $language)),
                    )
                );
            }
        }

        $service_charge = new ProductRentalExtra(Configuration::get('ROJA45_PRODUCTRENTAL_SERVICECHARGE_ID'));
        if (!Validate::isLoadedObject($service_charge)) {
            $service_charge->rate = 0;
            $service_charge->id_roja45_productrental_extra_type = ProductRentalExtraType::PER_PERIOD;
            $service_charge->default_selected = 0;
            $service_charge->deselect_warning = 0;
            $service_charge->enabled = 0;
            $service_charge->required = 0;
            foreach (Language::getLanguages(true) as $language) {
                $service_charge->name[$language['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'ServiceChargeTitle', $language);
                $service_charge->description[$language['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'ServiceChargeDecriptionRequired', $language);
            }
            $return &= $service_charge->save();
            Configuration::updateValue('ROJA45_PRODUCTRENTAL_SERVICECHARGE_ID', $service_charge->id);
        }

        $payment_types = array(
            array(
                'code' => 'Deposit',
                'include' => 1,
            ),
            array(
                'code' => 'Balance',
                'include' => 1,
            ),
            array(
                'code' => 'Other',
                'include' => 0,
            ),
        );
        foreach ($payment_types as $payment_type) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_paymenttype',
                array(
                    'enabled' => 1,
                    'include' => (int) $payment_type['include']
                )
            );
            $id = Db::getInstance()->Insert_ID();
            foreach (Language::getLanguages(true) as $language) {
                $return &= Db::getInstance()->insert(
                    'roja45_productrental_paymenttype_lang',
                    array(
                        'id_roja45_product_payment_type' => (int)$id,
                        'id_lang' => (int)$language['id_lang'],
                        'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                            $this,
                            'PaymentType'.$payment_type['code'],
                            $language
                        )),
                    )
                );
            }
        }

        $subject = $this->l('Rental Request Received');
        $subject = $this->l('Rental Prereserved');
        $subject = $this->l('Rental Confirmation');
        $subject = $this->l('Deposit Received');
        $subject = $this->l('Rental Return Overdue');
        $subject = $this->l('Rental Collection Soon');
        $subject = $this->l('Rental Cancellation Request Received');
        $subject = $this->l('Rental Return Due');
        $subject = $this->l('Please review your rental experience');
        $subject = $this->l('Rental Return Confirmation');
        $subject = $this->l('Rental Cancelled');
        $subject = $this->l('Rental Payment Due');
        $subject = $this->l('Rental Payment Reminder');
        $subject = $this->l('Rental Payment Overdue');
        $subject = $this->l('Rental Payment Confirmation');
        return $return;
    }

    private function installTabs()
    {
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            return $this->installTabs17();
        } else {
            return $this->installTabs16();
        }
    }

    private function installTabs16()
    {
        $id_tab = Tab::getIdFromClassName('AdminParent' . $this->tabClassName);
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminParent' . $this->tabClassName;
            $tab->id_parent = 0;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();

            $tab->updatePosition(0, 3);

            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = $this->tabClassName;
            $tab->id_parent = Tab::getIdFromClassName('AdminParent' . $this->tabClassName);
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }

        $id_parent = Tab::getIdFromClassName('AdminParent' . $this->tabClassName);

        $id_tab = Tab::getIdFromClassName('RentalDamageDeposits');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalDamageDeposits';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }
        $id_tab = Tab::getIdFromClassName('RentalRateTypes');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalRateTypes';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }
        $id_tab = Tab::getIdFromClassName('RentalPaymentProfiles');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalPaymentProfiles';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }
        $id_tab = Tab::getIdFromClassName('RentalExtras');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalExtras';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('RentalDiscounts');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalDiscounts';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('RentalVouchers');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalVouchers';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('RentalPriceRules');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalPriceRules';
            $tab->id_parent = $id_parent;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('AdminParentAdminProductRentals');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminParentAdminProductRentals';
            $tab->id_parent = 0;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminParentAdminProductRentals',
                    $lang
                );
            }
            $tab->add();

            $tab->updatePosition(0, 4);

            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminProductRentals';
            $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminProductRentals',
                    $lang
                );
            }
            $tab->add();

            $id_tab = Tab::getIdFromClassName('AdminRentalCalendar');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminRentalCalendar';
                $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
                $tab->module = $this->name;
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'AdminRentalCalendar',
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('AdminRentalStatus');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminRentalStatus';
                $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
                $tab->module = $this->name;
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'AdminRentalStatus',
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('AdminWorkingDays');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminWorkingDays';
                $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
                $tab->module = $this->name;
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'AdminWorkingDays',
                        $lang
                    );
                }
                $tab->add();
            }
        }

        return true;
    }

    private function installTabs17()
    {
        $id_tab = Tab::getIdFromClassName('AdminRentals');
        if (!$id_tab) {
            /**
             * Rent parent menu
             */
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminRentals';
            $tab->id_parent = 0;
            $tab->module = $this->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminParentAdminProductRental17',
                    $lang
                );
            }
            $tab->add();
            $tab->updatePosition(0, 3);

            /**
             * Catalog menu
             */
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminParentAdminProductRental';
            $tab->id_parent = Tab::getIdFromClassName('AdminRentals');
            $tab->module = $this->name;
            $tab->name = array();
            $tab->icon = 'store';
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminProductRental17',
                    $lang
                );
            }
            $tab->add();

            $id_catalog_menu = Tab::getIdFromClassName('AdminParentAdminProductRental');

            /**
             * Products submenu
             */
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminProductRental';
            $tab->id_parent = $id_catalog_menu;
            $tab->module = $this->name;
            $tab->icon = 'store';
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminProductRental17',
                    $lang
                );
            }
            $tab->add();

            $id_tab = Tab::getIdFromClassName('RentalDamageDeposits');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalDamageDeposits';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->name = array();
                $tab->icon = 'av_timer';
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, $tab->class_name, $lang);
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('RentalRateTypes');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalRateTypes';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'list';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        $tab->class_name,
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('RentalPaymentProfiles');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalPaymentProfiles';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'payment';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        $tab->class_name,
                        $lang
                    );
                }
                $tab->add();
            }
            $id_tab = Tab::getIdFromClassName('RentalExtras');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalExtras';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'add_circle';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'RentalExtras17',
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('RentalDiscounts');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalDiscounts';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'local_atm';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'RentalDiscounts17',
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('RentalPriceRules');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalPriceRules';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'playlist_add_check';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'RentalPriceRules17',
                        $lang
                    );
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('RentalVouchers');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'RentalVouchers';
                $tab->id_parent = $id_catalog_menu;
                $tab->module = $this->name;
                $tab->icon = 'local_atm';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'RentalVouchers17',
                        $lang
                    );
                }
                $tab->add();
            }

            /**
             * Rentals menu
             */
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminParentAdminProductRentals';
            $tab->id_parent = Tab::getIdFromClassName('AdminRentals');
            $tab->module = $this->name;
            $tab->icon = 'collections_bookmark';
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminParentAdminProductRentals',
                    $lang
                );
            }
            $tab->add();

            $id_rentals_menu = Tab::getIdFromClassName('AdminParentAdminProductRentals');

            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminProductRentals';
            $tab->id_parent = $id_rentals_menu;
            $tab->module = $this->name;
            $tab->icon = 'collections_bookmark';
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $this,
                    'AdminProductRentals',
                    $lang
                );
            }
            $tab->add();

            $id_tab = Tab::getIdFromClassName('AdminRentalStatus');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminRentalStatus';
                $tab->id_parent = $id_rentals_menu;
                $tab->module = $this->name;
                $tab->icon = 'warning';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'AdminRentalStatus17', $lang);
                }
                $tab->add();
            }

            $id_tab = Tab::getIdFromClassName('AdminWorkingDays');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminWorkingDays';
                $tab->id_parent = $id_rentals_menu;
                $tab->module = $this->name;
                $tab->icon = 'today';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'AdminWorkingDays', $lang);
                }
                $tab->add();
            }

            /**
             * Calendar menu
             */
            $id_tab = Tab::getIdFromClassName('AdminParentAdminRentalCalendar');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminParentAdminRentalCalendar';
                $tab->id_parent = Tab::getIdFromClassName('AdminRentals');
                $tab->module = $this->name;
                $tab->icon = 'date_range';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $this,
                        'AdminRentalCalendar',
                        $lang
                    );
                }
                $tab->add();
            }
            $id_calendar_menu = Tab::getIdFromClassName('AdminParentAdminRentalCalendar');

            $id_tab = Tab::getIdFromClassName('AdminRentalCalendar');
            if (!$id_tab) {
                $tab = new Tab();
                $tab->active = 1;
                $tab->class_name = 'AdminRentalCalendar';
                $tab->id_parent = $id_calendar_menu;
                $tab->module = $this->name;
                $tab->icon = 'date_range';
                $tab->name = array();
                foreach (Language::getLanguages(true) as $lang) {
                    $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($this, 'AdminRentalCalendar', $lang);
                }
                $tab->add();
            }
        }
        return true;
    }

    private function uninstallDb()
    {
        $return = true;
        try {
            $delete_data = (int) Configuration::get('ROJA45_PRODUCTRENTAL_DELETETABLES');
            if ($delete_data) {
                $return = Db::getInstance()->execute('DROP TABLE IF EXISTS
                    `' . _DB_PREFIX_ . 'roja45_productrental_details`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_details_shop`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rental`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalprocess`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_period`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_period_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_model`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_model_image`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_model_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rate`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rate_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rategroup`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rateclass`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rateclass_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_ratetype`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_ratetype_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rateduration`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rateduration_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_periodrate`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_periodrate_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_productunavailable`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistory`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalmessage`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalnote`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_workingday`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_workingday_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra_chargetype`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra_chargetype_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_model_extra`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_discount`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_discountconditiongroup`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_discountcondition`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_productdiscount`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_daterate`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_damagedeposit`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra_type`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_extra_type_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_voucher`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_voucher_lang`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_voucher_extra`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_pricerule`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_priceruleconditiongroup`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_pricerulecondition`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofile`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofileday`,
                    `' . _DB_PREFIX_ . 'roja45_productrental_productpricerule`
                ');
            }
            return $return;
        } catch (Exception $e) {
            return false;
        }
    }

    private function uninstallTabs()
    {
        $id_tab = Tab::getIdFromClassName('RentalPricePeriods');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('RentalRateTypes');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('RentalPaymentProfiles');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('RentalDamageDeposits');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('RentalExtras');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('RentalDiscounts');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('RentalVouchers');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('RentalPriceRules');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('AdminRentalStatus');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }

        $id_tab = Tab::getIdFromClassName('AdminRentalGraph');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminProductRentals');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminWorkingDays');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminProductRentals');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminRentalCalendar');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminParentAdminProductRental');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminParentAdminProductRentals');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminParentAdminRentalCalendar');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        $id_tab = Tab::getIdFromClassName('AdminRentals');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->delete();
        }
        return true;
    }

    private function deleteDefaultData()
    {
        $return = true;

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus_lang`; ';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile_lang`; ';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_extra_chargetype"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_extra_chargetype`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_extra_chargetype_lang`; ';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_paymenttype"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype_lang`;';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_rateclass"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rateclass`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rateclass_lang`;';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_ratetype"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_ratetype`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_ratetype_lang`;';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_rateduration"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rateduration`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_rateduration_lang`;';
            $return &= (bool)Db::getInstance()->execute($sql);
        }

        $result = Db::getInstance()->executeS(
            'SHOW TABLES LIKE "' . _DB_PREFIX_ . 'roja45_productrental_workingday"'
        );
        if (count($result)) {
            $sql = 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_workingday`; ';
            $sql .= 'TRUNCATE `' . _DB_PREFIX_ . 'roja45_productrental_workingday_lang`;';
            $return &= (bool)Db::getInstance()->execute($sql);
        }
        return $return;
    }

    private function removeGlobalVars()
    {
        $delete_data = (int)Configuration::get('ROJA45_PRODUCTRENTAL_DELETETABLES');
        if ($delete_data) {
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_RESERVATION_TYPE_INSTANT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SENDEMAIL');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLED');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_CS_ACCOUNT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DELETETABLES');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_USEJS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_INSTALLDATA');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DATAINSTALLED');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_VERSION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SENDONSTATUS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_HASADDRESS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_HASLOCATION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_HASCONTACT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_CREATEMODELS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_AUTOCONFIRM');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SERVICECHARGE_ID');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_NONCONFIRMEDBLOCKS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_RETURNTIME');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_COLLECTIONTIME');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLESALES');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ALWAYSUSECART');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_USEPERIODPRICING');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLESEARCH');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_REMINDAFTER');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_REMINDERAFTER');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRESELECTRATE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_COD_PAYMENT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_MARKUNAVAILABLE');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SHOWNONORDERS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_INSTANTRESERVATION');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX');
            if ($id_product = Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT')) {
                $product = new Product($id_product);
                $product->delete();
            }
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR');
            Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR');
        }
        return true;
    }

    protected function renderModuleForm()
    {
        $admin_link = $this->context->link->getAdminLink(
            'AdminModules',
            true
        ).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
        $token = Tools::getAdminTokenLite('AdminModules');

        $tax_groups = array();
        foreach (TaxRulesGroup::getTaxRulesGroups(true) as $tax_group) {
            $tax_groups[$tax_group['id_tax_rules_group']] = $tax_group['name'];
        }
        $tpl = $this->context->smarty->createTemplate($this->getTemplatePath('configuration.tpl'));
        $tpl->assign(
            array(
                'languages' => $this->context->controller->getLanguages(),
                'link' => $this->context->link,
                'contacts' => Contact::getContacts($this->context->language->id),
                'defaultFormLanguage' => (int)Configuration::get('PS_LANG_DEFAULT'),
                'statuses' => OrderState::getOrderStates($this->context->language->id),
                'tax_groups' => $tax_groups,
                'categories' => Category::getAllCategoriesName(2, $this->context->language->id, false),
                'admin_link' => $admin_link,
                'token' => $token,
                'id_module' => $this->id,
                'fields_value' => $this->getModuleConfigFieldsValues(),
                'roja45productrental_cron' =>
                    _PS_BASE_URL_.
                    _MODULE_DIR_.
                    'roja45productrental/roja45productrental-cron.php?token='.
                    Tools::substr(Tools::encrypt('roja45productrental/cron'), 0, 10),
            )
        );
        $html = $tpl->fetch();
        $html .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/prestui/ps-tags.tpl');
        return $html;
    }

    private function getModuleConfigFieldsValues()
    {
        return array(
            'ROJA45_PRODUCTRENTAL_ENABLED_PRODUCTS' => ProductRentalDetails::getEnabledProducts(
                $this->context->shop->id
            ),
            'ROJA45_PRODUCTRENTAL_DELETETABLES' => Configuration::get('ROJA45_PRODUCTRENTAL_DELETETABLES'),
            'ROJA45_PRODUCTRENTAL_SENDEMAIL' => Configuration::get('ROJA45_PRODUCTRENTAL_SENDEMAIL'),
            'ROJA45_PRODUCTRENTAL_CS_ACCOUNT' => Configuration::get('ROJA45_PRODUCTRENTAL_CS_ACCOUNT'),
            'ROJA45_PRODUCTRENTAL_INSTALLDATA' => Configuration::get('ROJA45_PRODUCTRENTAL_INSTALLDATA'),
            'ROJA45_PRODUCTRENTAL_INSTALLTEMPLATES' => Configuration::get('ROJA45_PRODUCTRENTAL_INSTALLTEMPLATES'),
            'ROJA45_PRODUCTRENTAL_USEJS' => Configuration::get('ROJA45_PRODUCTRENTAL_USEJS'),
            'ROJA45_PRODUCTRENTAL_VERSION' => Configuration::get('ROJA45_PRODUCTRENTAL_VERSION'),
            'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION' => Configuration::get('ROJA45_PRODUCTRENTAL_MINIMUM_DURATION'),
            'ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION' => Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION'),
            'ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_ALLOWSAMEDAYRENTALS'
            ),
            'ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE' => Configuration::get('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE'),
            'ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT' => Configuration::get('ROJA45_PRODUCTRENTAL_OVERRIDE_PAYMENT'),
            'ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF' => Configuration::get('ROJA45_PRODUCTRENTAL_OVERRIDE_ORDERCONF'),
            'ROJA45_PRODUCTRENTAL_SENDONSTATUS' => Configuration::get('ROJA45_PRODUCTRENTAL_SENDONSTATUS'),
            'ROJA45_PRODUCTRENTAL_HASLOCATION' => Configuration::get('ROJA45_PRODUCTRENTAL_HASLOCATION'),
            'ROJA45_PRODUCTRENTAL_HASADDRESS' => Configuration::get('ROJA45_PRODUCTRENTAL_HASADDRESS'),
            'ROJA45_PRODUCTRENTAL_HASCONTACT' => Configuration::get('ROJA45_PRODUCTRENTAL_HASCONTACT'),
            'ROJA45_PRODUCTRENTAL_CREATEMODELS' => Configuration::get('ROJA45_PRODUCTRENTAL_CREATEMODELS'),
            'ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE' => Configuration::get('ROJA45_PRODUCTRENTAL_PERMANENTLYDELETE'),
            'ROJA45_PRODUCTRENTAL_AUTOCONFIRM' => Configuration::get('ROJA45_PRODUCTRENTAL_AUTOCONFIRM'),
            'ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_UPDATEORDERONCONFIRM'
            ),
            'ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY'
            ),
            'ROJA45_PRODUCTRENTAL_LASTITEMSWARNING' => Configuration::get('ROJA45_PRODUCTRENTAL_LASTITEMSWARNING'),
            'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT'
            ),
            'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX' => Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX'),
            'ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD' => Configuration::get('ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD'),
            'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE'
            ),
            'ROJA45_PRODUCTRENTAL_RETURNTIME' => Configuration::get('ROJA45_PRODUCTRENTAL_RETURNTIME'),
            'ROJA45_PRODUCTRENTAL_COLLECTIONTIME' => Configuration::get('ROJA45_PRODUCTRENTAL_COLLECTIONTIME'),
            'ROJA45_PRODUCTRENTAL_ENABLESALES' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLESALES'),
            'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
            ),
            'ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLELIVEPRICE'),
            'ROJA45_PRODUCTRENTAL_ALWAYSUSECART' => Configuration::get('ROJA45_PRODUCTRENTAL_ALWAYSUSECART'),
            'ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS' => Configuration::get(
                'ROJA45_PRODUCTRENTAL_ENABLEOTHERRENTALPAYMENTS'
            ),
            'ROJA45_PRODUCTRENTAL_DISPLAY_LABEL' => Configuration::get('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL'),
            'ROJA45_PRODUCTRENTAL_USEPERIODPRICING' => Configuration::get('ROJA45_PRODUCTRENTAL_USEPERIODPRICING'),
            'ROJA45_PRODUCTRENTAL_SEARCHCATEGORY' => Configuration::get('ROJA45_PRODUCTRENTAL_SEARCHCATEGORY'),
            'ROJA45_PRODUCTRENTAL_ENABLESEARCH' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLESEARCH'),
            'ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS' => Configuration::get('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS'),
            'ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL' => Configuration::get('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL'),
            'ROJA45_PRODUCTRENTAL_ABANDONEDAFTER' => Configuration::get('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER'),
            'ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE' => Configuration::get('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE'),
            'ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER' => Configuration::get('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER'),
            'ROJA45_PRODUCTRENTAL_REMINDERAFTER' => Configuration::get('ROJA45_PRODUCTRENTAL_REMINDERAFTER'),
            'ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS' => Configuration::get('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS'),
            'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD'),
            'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD'),
            'ROJA45_PRODUCTRENTAL_PRESELECTRATE' => Configuration::get('ROJA45_PRODUCTRENTAL_PRESELECTRATE'),
            'ROJA45_PRODUCTRENTAL_PREPARATIONDAYS' => Configuration::get('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS'),
            'ROJA45_PRODUCTRENTAL_RECONDITIONDAYS' => Configuration::get('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS'),
            'ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT'),
            'ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX' => Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITUSESYSTEMTAX'),
            'ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS' => Configuration::get('ROJA45_PRODUCTRENTAL_AUTOENABLENEWPRODUCTS'),
            'ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS'),
            'ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION' => Configuration::get('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION'),
            'ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER' => Configuration::get('ROJA45_PRODUCTRENTAL_RENTALRETURNREMINDER'),
            'ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE'),
            'ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEMANUALCOLLECTIONPROCESS'),
            'ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS' => Configuration::get('ROJA45_PRODUCTRENTAL_SINGLEITEMRENTALS'),
            'ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT' => Configuration::get('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT'),
            'ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY' => Configuration::get('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY'),
            'ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE' => Configuration::get('ROJA45_PRODUCTRENTAL_RESULTTOAVAILABLE'),
            'ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE' => Configuration::get('ROJA45_PRODUCTRENTAL_SHOWWHENSINGLE'),
            'ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS' => Configuration::get('ROJA45_PRODUCTRENTAL_SURPRESSCOREEMAILS'),
            'ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY' => Configuration::get('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY'),
            'ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS' => Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEDELIVERYCOLLECTIONADDRESS'),
            'ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR' => Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTLISTITEMSELECTOR'),
            'ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR' => Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTPAGEADDTOCARTFORMSELECTOR'),
        );
    }

    private function getRates($id_product)
    {
        $id_roja45_product = ProductRentalDetails::isRentable($id_product);
        $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);
        $rates = array();
        foreach ($models as $model) {
            $all_rates = ProductRentalRate::getRates(
                $id_roja45_product,
                $model['id_roja45_product_model'],
                (int)$this->context->language->id
            );

            $rate_details = array();
            $periods = array();
            foreach ($all_rates as $rate) {
                $rate_type = new ProductRentalRateType($rate['id_type'], (int)$this->context->language->id);
                $rate_details[$rate['id_roja45_product_rate']]['details'] = $rate_type;
                $rate_details[$rate['id_roja45_product_rate']]['standard'][] = $rate;
                $periods[0]['name'] = $this->l('Low Season');
                $periods[0]['desc'] = '';

                $all_periods = ProductRentalPeriodRate::getPeriodRates(
                    $id_roja45_product,
                    $model['id_roja45_product_model'],
                    $rate['id_roja45_product_ratetype'],
                    (int)$this->context->language->id
                );

                foreach ($all_periods as $key => $period) {
                    $periods[$key + 1]['name'] = $period['name'];
                    $periods[$key + 1]['desc'] = $period['start_date'] . ' - ' . $period['end_date'];
                    $rate_details[$rate['id_roja45_product_rate']]['periods'][] = $period;
                }
            }
            $rates[$model['id_roja45_product_model']]['name'] = $model['name'];
            $rates[$model['id_roja45_product_model']]['rates'] = $rate_details;
            $rates[$model['id_roja45_product_model']]['details'] = $model;
            $rates[$model['id_roja45_product_model']]['periods'] = $periods;
        }

        return $rates;
    }

    private function renderProductForm($id_product)
    {
        $id_roja45_product = ProductRentalDetails::isRentable($id_product);
        $rentalproduct = null;
        $enabled = false;
        if ($id_roja45_product > 0) {
            $rentalproduct = new ProductRentalDetails($id_roja45_product);
            $enabled = (bool) $rentalproduct->enabled;
        }
        $tpl = $this->context->smarty->createTemplate($this->getTemplatePath('displayAdminProductExtra.tpl'));
        $tpl->assign(
            array(
                'id_roja45_product' => (int) $id_roja45_product,
                'enabled' => $enabled,
            )
        );
        return $tpl->fetch();
    }

    private function loadProductDetails($id_roja45_product)
    {
        $fields_values = array();

        $rentalproduct = new ProductRentalDetails($id_roja45_product);
        $fields_values['ROJA45_PRODUCTRENTAL_PRODUCT_ID'] = $rentalproduct->id_product;
        $fields_values['ROJA45_PRODUCTRENTAL_ADDRESS'] = $rentalproduct->address;
        $fields_values['ROJA45_PRODUCTRENTAL_ADDRESS_2'] = $rentalproduct->address_2;
        $fields_values['ROJA45_PRODUCTRENTAL_CITY'] = $rentalproduct->city;
        $fields_values['ROJA45_PRODUCTRENTAL_TYPE'] = $rentalproduct->type;

        if ($rentalproduct->country == 0) {
            $fields_values['ROJA45_PRODUCTRENTAL_COUNTRY'] = (int)$this->context->country->id;
        } else {
            $fields_values['ROJA45_PRODUCTRENTAL_COUNTRY'] = $rentalproduct->country;
        }

        if ($rentalproduct->state == 0) {
            $fields_values['ROJA45_PRODUCTRENTAL_STATE'] = 0;
        } else {
            $fields_values['ROJA45_PRODUCTRENTAL_STATE'] = $rentalproduct->state;
        }

        $fields_values['ROJA45_PRODUCTRENTAL_RESERVATIONSENABLED'] = $rentalproduct->enabled;
        $fields_values['ROJA45_PRODUCTRENTAL_ZIP'] = $rentalproduct->postal_code;
        $fields_values['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_1'] = $rentalproduct->telephone_1;
        $fields_values['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_2'] = $rentalproduct->telephone_2;
        $fields_values['ROJA45_PRODUCTRENTAL_URL'] = $rentalproduct->url;
        $fields_values['ROJA45_PRODUCTRENTAL_LAT'] = $rentalproduct->lat;
        $fields_values['ROJA45_PRODUCTRENTAL_LON'] = $rentalproduct->lon;
        $fields_values['ROJA45_PRODUCTRENTAL_EMAIL'] = $rentalproduct->email;

        return $fields_values;
    }

    private function getProductPageVariables($product)
    {
        if (is_object($product)) {
            $productObj = $product;
            $product = array();
            $product['id'] = $productObj->id;
            $product['minimal_quantity'] = $productObj->minimal_quantity;
            if (isset($productObj->id_attribute)) {
                $product['id_product_attribute'] = $productObj->id_attribute;
            } else {
                $product['id_product_attribute'] = 0;
            }
        }

        $id_roja45_product = ProductRentalDetails::isRentable($product['id']);
        $rentalproduct = new ProductRentalDetails(
            $id_roja45_product,
            (int)$this->context->language->id,
            (int)$this->context->shop->id
        );
        $controller_url = $this->context->link->getModuleLink(
            'roja45productrental',
            'ProductRentalFront',
            array()
        );
        $get_availability_url = $this->context->link->getModuleLink(
            'roja45productrental',
            'ProductRentalFront',
            array(
                'get_availability' => 1
            )
        );
        $token = Tools::getToken();

        $rentals = ProductRentalRental::getAvailability(
            $rentalproduct->id_roja45_product
        );
        $rate_periods = array(
            1 => array(
                'id_rate_period' => 1,
                'period' => 'DAY',
                'name' => 'Daily Rates',
            )
        );

        if (Configuration::get('ROJA45_PRODUCTRENTAL_USEPRODUCTCOMBINATIONQTY')) {
            $id_roja45_product_model = ProductRentalModel::getModelForAttributeId(
                $rentalproduct->id_roja45_product,
                $product['id_product_attribute']
            );
            $total_available = ProductRentalDetails::getStockOnHand(
                $rentalproduct->id_roja45_product,
                $id_roja45_product_model
            );
        } else {
            $total_available = ProductRentalDetails::getStockOnHand(
                $rentalproduct->id_roja45_product
            );
        }

        $this->smarty->assign(array(
            'link' => $this->context->link,
            'controller_url' => $controller_url . '?token=' . $token,
            'get_availability_url' => $get_availability_url,
            'roja45_productrental_dateformat' => RojaFortyFiveProductRentalCore::convertDateFormat(
                $this->context->language->date_format_lite
            ),
            'roja45_productrental_timeformat' => 'hh:mm',
            'ROJA45_PRODUCTRENTAL_ID' => $rentalproduct->id_roja45_product,
            'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION' => (int) $rentalproduct->minimum_duration,
            'ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION' => (int) $rentalproduct->maximum_duration,
            'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT' => (int) Configuration::get(
                'ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT'
            ),
            'ROJA45_PRODUCTRENTAL_ID_PRODUCT' => Tools::getValue('id_product'),
            'ROJA45_PRODUCTRENTAL_MINIMUM_ORDER_QUANTITY' => 1,
            'roja45_rentals' => Tools::jsonEncode($rentals),
            'roja45productrental_rateperiods' => Tools::jsonEncode($rate_periods),
            'default_id' => '1',
            'roja45productrental_start_day' => (int) Configuration::get('ROJA45_PRODUCTRENTAL_WEEKSTARTDAY')-1,
            'product' => $product,
            'id_product_attribute' =>
                (Tools::getValue('id_product_attribute')) ?
                    Tools::getValue('id_product_attribute') :
                    0,
            'quantity_available' => $total_available
        ));

        $customer_requirements = RojaFortyFiveProductRentalCore::getCustomerRequirements('ROJA45_PRODUCTRENTAL_');
        if (count($customer_requirements)) {
            if (!empty($customer_requirements['ROJA45_PRODUCTRENTAL_RATE_DURATION'])) {
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => $customer_requirements['ROJA45_PRODUCTRENTAL_RATE_DURATION']
                ));
            } else {
                // TODO - This needs to come from product model, select first rate duration that has rates
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_RATE_DURATION' => ProductRentalRateDuration::DAILY
                ));
            }
            if (isset($customer_requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE'])) {
                $collection_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $customer_requirements['ROJA45_PRODUCTRENTAL_COLLECTION_DATE']
                );
                if ($collection_date) {
                    $this->smarty->assign(array(
                        'ROJA45_PRODUCTRENTAL_COLLECTION_DATE' => $collection_date->format(
                            $this->context->language->date_format_lite
                        )
                    ));
                }
            }
            if (isset($customer_requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE'])) {
                $return_date = DateTime::createFromFormat(
                    'Y-m-d',
                    $customer_requirements['ROJA45_PRODUCTRENTAL_RETURN_DATE']
                );
                if ($return_date) {
                    $this->smarty->assign(array(
                        'ROJA45_PRODUCTRENTAL_RETURN_DATE' => $return_date->format(
                            $this->context->language->date_format_lite
                        )
                    ));
                }
            }
            if (isset($customer_requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME'])) {
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => $customer_requirements['ROJA45_PRODUCTRENTAL_COLLECTION_TIME']
                ));
            } else {
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => $rentalproduct->collection_time
                ));
            }
            if (isset($customer_requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME'])) {
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_RETURN_TIME' => $customer_requirements['ROJA45_PRODUCTRENTAL_RETURN_TIME']
                ));
            } else {
                $this->smarty->assign(array(
                    'ROJA45_PRODUCTRENTAL_RETURN_TIME' => $rentalproduct->return_time
                ));
            }
        } else {
            $this->smarty->assign(array(
                'ROJA45_PRODUCTRENTAL_COLLECTION_TIME' => $rentalproduct->collection_time
            ));
            $this->smarty->assign(array(
                'ROJA45_PRODUCTRENTAL_RETURN_TIME' => $rentalproduct->return_time
            ));
            // TODO - This needs to come from product model, select first rate duration that has rates
            $this->smarty->assign(array(
                'ROJA45_PRODUCTRENTAL_RATE_DURATION' => ProductRentalRateDuration::DAILY
            ));
        }

        $models = ProductRentalModel::getModels($id_roja45_product, (int)$this->context->language->id);
        $details = array();
        $rates_available = false;
        $initial_rate = 0;
        foreach ($models as $key => $model) {
            // TODO - Enable/disable models
            if ((int) $model['enabled']) {
                $details[$key]['model'] = $model;
                $rates = ProductRentalRate::getRates(
                    $id_roja45_product,
                    $model['id_roja45_product_model'],
                    (int)$this->context->language->id,
                    Customer::getGroupsStatic($this->context->customer->id)
                );
                foreach ($rates as $rate) {
                    if (!$initial_rate) {
                        $initial_rate = $rate['rate'];
                    } else {
                        if ((float)$rate['rate'] < (float)$initial_rate) {
                            $initial_rate = $rate['rate'];
                        }
                    }
                }
                $details[$key]['rates'] = $rates;
                if (count($rates) > 0) {
                    $rates_available = true;
                }
            }
        }

        $this->smarty->assign(array(
            'currency' => $this->context->currency,
            'rental_product' => $rentalproduct,
            'initial_rate' => $initial_rate,
            'rate_periods' => $rate_periods,
            'rates_available' => $rates_available,
            'tax_enabled' => 0
        ));

        $tax_enabled = Configuration::get('PS_TAX');
        $usetax = true;
        if (Tax::excludeTaxeOption()) {
            $usetax = false;
        }
        $tax_calculator = null;
        if ($tax_enabled && $usetax) {
            $tax_manager = Roja45ProductRental::getTaxManager((int)$rentalproduct->id_product, $this->context);
            $tax_calculator = $tax_manager->getTaxCalculator();
            $this->smarty->assign(
                array(
                    'tax_calculator' => $tax_calculator,
                    'tax_enabled' => 1
                )
            );
        }
    }

    private function getEmailTemplate($template_name, $id_lang, &$template_html, &$template_txt)
    {
        $theme_path = _PS_THEME_DIR_;
        $module_path = _PS_MODULE_DIR_;

        // Get the path of theme by id_shop if exist
        if (is_numeric($this->context->shop->id) && $this->context->shop->id) {
            $shop = new Shop((int)$this->context->shop->id);
            $theme_name = $shop->getTheme();

            if (_THEME_NAME_ != $theme_name) {
                $theme_path = _PS_ROOT_DIR_ . '/themes/' . $theme_name . '/';
            }
        }

        $iso = Language::getIsoById($id_lang);
        if (!$iso) {
            Tools::dieOrLog(Tools::displayError('Error - No ISO code for email'), true);
            return false;
        }

        if (file_exists($theme_path . 'modules/' . $this->name . '/mails/' . $iso . '/' . $template_name . '.txt') ||
            file_exists($theme_path . 'modules/' . $this->name . '/mails/' . $iso . '/' . $template_name . '.html')) {
            $template_path = $theme_path . 'modules/' . $this->name . '/mails/' .$iso . '/';
        } elseif (file_exists($module_path . $this->name . '/mails/' . $iso . '/' . $template_name . '.txt') ||
            file_exists($module_path . $this->name . '/mails/' . $iso . '/' . $template_name . '.html')) {
            $template_path = $module_path . $this->name . '/mails/' .$iso . '/';
        } elseif (file_exists($theme_path . 'modules/' . $this->name . '/mails/' . $iso . '/' . $template_name . '.txt') ||
            file_exists($theme_path . 'modules/' . $this->name . '/mails/en/' . $template_name . '.html')) {
            $template_path = $theme_path . 'modules/' . $this->name . '/mails/en/';
        } elseif (file_exists($module_path . $this->name . '/mails/en/' . $template_name . '.txt')
            || file_exists($module_path . $this->name . '/mails/en/' . $template_name . '.html')) {
            $template_path = $module_path . $this->name . '/mails/en/';
        }

        $template_html = Tools::file_get_contents($template_path . $template_name . '.html');
        $template_txt = strip_tags(html_entity_decode(Tools::file_get_contents($template_path . $template_name . '.txt'), null, 'utf-8'));
    }

    public function saveCustomerRequirements($requirements)
    {
        foreach ($requirements as $key => $requirement) {
            $this->context->cookie->__set($key, $requirement);
        }
    }

    public function getCustomerRequirements()
    {
        return $this->context->cookie->getFamily('ROJA45_PRODUCTRENTAL_');
    }

    public function clearCustomerRequirements($requirements)
    {
        foreach ($requirements as $requirement) {
            $this->context->cookie->__unset($requirement);
        }
    }

    public function clearAllCustomerRequirements()
    {
        $this->context->cookie->unsetFamily('ROJA45_PRODUCTRENTAL_');
    }

    public static function getTemplateLangId($template_name, $id_lang)
    {
        $iso_code = Language::getIsoById($id_lang);
        if (file_exists(_PS_THEME_DIR_.'modules/roja45productrental/mails'.DIRECTORY_SEPARATOR.$iso_code.DIRECTORY_SEPARATOR.$template_name . '.html') ||
            file_exists(_PS_THEME_DIR_.'modules/roja45productrental/mails'.DIRECTORY_SEPARATOR.$iso_code.DIRECTORY_SEPARATOR.$template_name . '.txt') ||
            file_exists(_PS_MODULE_DIR_.'roja45productrental/mails'.DIRECTORY_SEPARATOR.$iso_code.DIRECTORY_SEPARATOR.$template_name . '.html') ||
            file_exists(_PS_MODULE_DIR_.'roja45productrental/mails'.DIRECTORY_SEPARATOR.$iso_code.DIRECTORY_SEPARATOR.$template_name . '.txt')
        ) {
            return $id_lang;
        } elseif (file_exists(_PS_THEME_DIR_.'modules/roja45productrental/mails'.DIRECTORY_SEPARATOR.'en'.DIRECTORY_SEPARATOR.$template_name . '.html') ||
            file_exists(_PS_THEME_DIR_.'modules/roja45productrental/mails'.DIRECTORY_SEPARATOR.'en'.DIRECTORY_SEPARATOR.$template_name . '.txt') ||
            file_exists(_PS_MODULE_DIR_.'roja45productrental/mails'.DIRECTORY_SEPARATOR.'en'.DIRECTORY_SEPARATOR.$template_name . '.html') ||
            file_exists(_PS_MODULE_DIR_.'roja45productrental/mails'.DIRECTORY_SEPARATOR.'en'.DIRECTORY_SEPARATOR.$template_name . '.txt')
        ) {
            return Language::getIdByIso('en');
        } else {
            return Configuration::get('PS_LANG_DEFAULT');
        }
    }

    /**
     * @param $rental ProductRentalRental
     * @return string template
     */
    public function getRentalSummary($rental)
    {
        $data = $rental->getSummary();
        $this->smarty->assign($data);
        if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
            $delete_link = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'deleteProduct' => '1',
                )
            );
        } else {
            $delete_link = $this->context->link->getModuleLink(
                'roja45productrental',
                'ProductRentalFront',
                array(
                    'ajax' => 1,
                    'action' => 'deleteProduct',
                )
            );
        }
        $display_tax = !(Group::getPriceDisplayMethod(Group::getCurrent()->id));
        $this->smarty->assign(
            array(
                'id_roja45_product_rental' => $rental->id_roja45_product_rental,
                'display_tax' => $display_tax,
                'delete_product_link' => $delete_link,
                'link' => Context::getContext()->link,
                'cartImage' => ImageType::getFormatedName('cart'),
                'mediumImage' => ImageType::getFormatedName('medium'),
                'cartSize' => Image::getSize(ImageType::getFormatedName('cart')),
                'mediumSize' => Image::getSize(ImageType::getFormatedName('medium')),
            )
        );
    }

    public static function getTaxManager($id_product, $context = null)
    {
        if ($context === null) {
            $context = Context::getContext();
        }
        $address = new Address();
        $address->id_country = (int)$context->country->id;
        $address->id_state = 0;
        $address->postcode = 0;

        $tax_manager = TaxManagerFactory::getManager($address, Product::getIdTaxRulesGroupByIdProduct((int)$id_product, $context));
        return $tax_manager;
    }
}
