<?php
/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_1_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_1_0($module)
{
    $return = true;

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistory` (
        `id_roja45_productrental_rentalhistory` int(10) unsigned NOT NULL auto_increment,
        `id_roja45_property_cart` int(10) unsigned NOT NULL,
        `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL,
        `id_roja45_productrental_rentalstatus` int(10) unsigned NOT NULL,
        `date_add` datetime,
        `date_upd` datetime,
        `detail` varchar(1024),
        PRIMARY KEY (`id_roja45_productrental_rentalhistory`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype` (
        `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL,
        PRIMARY KEY (`id_roja45_productrental_rentalhistory_type`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalhistorytype_lang` (
        `id_roja45_productrental_rentalhistory_type` int(10) unsigned NOT NULL,
        `id_lang` int(10) unsigned NOT NULL,
        `name` varchar(255),
        PRIMARY KEY (`id_roja45_productrental_rentalhistory_type`, `id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalnote` (
        `id_roja45_product_rentalnote` int(10) unsigned NOT NULL auto_increment,
        `id_roja45_product_rental` int(10) unsigned NOT NULL,
        `note` varchar(1024) NOT NULL,
        PRIMARY KEY (`id_roja45_product_rentalnote`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalmessage` (
        `id_roja45_product_rentalmessage` int(10) unsigned NOT NULL auto_increment,
        `id_roja45_product_rental` int(10) unsigned NOT NULL,
        `id_customer_thread` int(10) NOT NULL,
        PRIMARY KEY (`id_roja45_product_rentalmessage`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_workingday` (
          `id_roja45_product_rental_workingday` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `day` VARCHAR(255),
          `is_working_day` tinyint(1),
          PRIMARY KEY (`id_roja45_product_rental_workingday`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_workingday_lang` (
          `id_roja45_product_rental_workingday` INT(10) UNSIGNED NOT NULL,
          `id_lang` int(10) unsigned NOT NULL,
          `name` VARCHAR(255),
          PRIMARY KEY (`id_roja45_product_rental_workingday`, `id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `'._DB_PREFIX_.'roja45_productrental_details`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'collection_time') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details`
        ADD COLUMN `collection_time` varchar(10) AFTER `lon`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details`
        ADD COLUMN `return_time` varchar(10) AFTER `collection_time`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details`
        ADD COLUMN `minimum_duration` int(10) AFTER `return_time`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details`
        ADD COLUMN `maximum_duration` varchar(10) AFTER `minimum_duration`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET `id_paymentprofile` = 1;';
    $return &= Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `'._DB_PREFIX_.'roja45_productrental_rental`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_roja45_product_paymentprofile') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental`
        ADD COLUMN `id_roja45_product_paymentprofile` varchar(10) AFTER `id_roja45_product_rental_status`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $id_tab = Tab::getIdFromClassName('ProductRentals');
    if ($id_tab) {
        $tab = new Tab($id_tab);
        $tab->delete();
    }

    $id_tab = Tab::getIdFromClassName('AdminParent' . $module->tabClassName);
    if ($id_tab) {
        $tab = new Tab($id_tab);
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminParent' . $module->tabClassName, $lang);
        }
        $tab->save();
    }

    $id_tab = Tab::getIdFromClassName('AdminParentAdminProductRentals');
    if (!$id_tab) {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'AdminParentAdminProductRentals';
        $tab->id_parent = 0;
        $tab->module = $module->name;
        $tab->name = array();
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminParentAdminProductRentals', $lang);
        }
        $tab->add();

        $tab->updatePosition(0, 4);

        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'AdminProductRentals';
        $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
        $tab->module = $module->name;

        $tab->name = array();
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminProductRentals', $lang);
        }
        $tab->add();

        $id_tab = Tab::getIdFromClassName('AdminRentalCalendar');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminRentalCalendar';
            $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
            $tab->module = $module->name;

            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminRentalCalendar', $lang);
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('AdminRentalStatus');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminRentalStatus';
            $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
            $tab->module = $module->name;

            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminRentalStatus', $lang);
            }
            $tab->add();
        }

        $id_tab = Tab::getIdFromClassName('AdminWorkingDays');
        if (!$id_tab) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'AdminWorkingDays';
            $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRentals');
            $tab->module = $module->name;

            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'AdminWorkingDays', $lang);
            }
            $tab->add();
        }
    }

    $id_tab = Tab::getIdFromClassName('AdminRentalGraph');
    if ($id_tab) {
        $tab = new Tab($id_tab);
        $tab->delete();
    }

    $id_status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$CONF);
    $status = new ProductRentalRentalStatus($id_status);
    $status->answer_template = 'rental_confirmed';
    $status->save();

    $def_states = array(
        array(
            'code' => ProductRentalRentalStatus::$ABND,
            'color' => '#FF0000',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 1,
            'block_calendar' => 0,
            'answer_template' => 'rental_abandoned'
        ),
        array(
            'code' => ProductRentalRentalStatus::$INCP,
            'color' => '#d4d4d4',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 0,
            'block_calendar' => 0,
            'answer_template' => 'rental_incomplete'
        ),
        array(
            'code' => ProductRentalRentalStatus::$OVER,
            'color' => '#FF0000',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 0,
            'block_calendar' => 0,
            'answer_template' => 'rental_overdue'
        )
    );

    foreach ($def_states as $state) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rentalstatus',
            array(
                'color' => pSQL($state['color']),
                'code' => pSQL($state['code']),
                'unremovable' => (int)$state['unremovable'],
                'send_email' => (int)$state['send_email'],
                'notify_admin' => (int)$state['notify_admin'],
                'block_calendar' => (int)$state['block_calendar'],
                'answer_template' => pSQL($state['answer_template']),
            )
        );
        $id_status = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus_lang',
                array(
                    'id_roja45_product_rental_status' => (int)$id_status,
                    'id_lang' => (int)$language['id_lang'],
                    'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $state['code'], $language)),
                )
            );
        }
    }

    $working_days = array(
        array(
            'id' => 1,
            'day' => ProductRentalWorkingDay::SUNDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 2,
            'day' => ProductRentalWorkingDay::MONDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 3,
            'day' => ProductRentalWorkingDay::TUESDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 4,
            'day' => ProductRentalWorkingDay::WEDNESDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 5,
            'day' => ProductRentalWorkingDay::THURSDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 6,
            'day' => ProductRentalWorkingDay::FRIDAY,
            'is_working_day' => 1
        ),
        array(
            'id' => 7,
            'day' => ProductRentalWorkingDay::SATURDAY,
            'is_working_day' => 1
        )
    );

    foreach ($working_days as $working_day) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_workingday',
            array(
                'id_roja45_product_rental_workingday' => (int) $working_day['id'],
                'day' => pSQL($working_day['day']),
                'is_working_day' => (int) $working_day['is_working_day'],
            )
        );
        $id = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_workingday_lang',
                array(
                    'id_roja45_product_rental_workingday' => (int)$id,
                    'id_lang' => (int)$language['id_lang'],
                    'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $working_day['day'], $language)),
                )
            );
        }
    }

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET minimum_duration = 1 WHERE minimum_duration IS NULL';
    $return &= Db::getInstance()->execute($sql);

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET maximum_duration = 0';
    $return &= Db::getInstance()->execute($sql);

    $return &= Configuration::updateValue('ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION', 0);
    $return &= Configuration::updateValue('ROJA45_PRODUCTRENTAL_DELETETABLES', 0);

    $return &= $module->unregisterHook('displayAdminOrder');

    return $return;
}
