<?php
/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_1_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_1_3($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `'._DB_PREFIX_.'roja45_productrental_rental`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'uid') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental`
        ADD COLUMN `uid` VARCHAR(255) AFTER `modified`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental`
        ADD COLUMN `date_add` DATETIME AFTER `uid`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental`
        ADD COLUMN `date_upd` datetime AFTER `date_add`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rental` SET date_add = received;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rental` SET date_upd = last_update';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental` DROP `received`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental` DROP `last_update`;';
        $return &= Db::getInstance()->execute($sql);

        $rentals = Db::getInstance()->executeS('SELECT id_roja45_product_rental FROM `'._DB_PREFIX_.'roja45_productrental_rental`');
        foreach ($rentals as $rental) {
            $rental = new ProductRentalRental($rental['id_roja45_product_rental']);
            $date = DateTime::createFromFormat('Y-m-d H:i:s', $rental->date_add);
            $mysql_date_string = $date->format('YmdHis');
            $rental->uid = $mysql_date_string . '-' . uniqid() . '@' . $_SERVER['SERVER_NAME'];
            $rental->save();
        }
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `'._DB_PREFIX_.'roja45_productrental_rentalproduct`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_paymentprofile') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct`
        ADD COLUMN `id_paymentprofile` INT(10);';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct';
        $results = Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $rental_product = new ProductRentalRentalProduct($row['id_roja45_product_rental_product']);
            $sql = '
                SELECT id_paymentprofile
                FROM ' . _DB_PREFIX_ . 'roja45_productrental_details
                WHERE id_roja45_product='.(int)$row['id_roja45_product'];
            $id_paymentprofile = Db::getInstance()->getValue($sql);
            if (!$id_paymentprofile) {
                $id_paymentprofile = 2;
                $paymentprofile = new ProductRentalPaymentProfile(
                    $id_paymentprofile,
                    (int) Context::getContext()->language->id
                );
                if (!Validate::isLoadedObject($paymentprofile)) {
                    $id_paymentprofile = 1;
                }
            }
            $rental_product->id_paymentprofile = $id_paymentprofile;
            $rental_product->save();
        }
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental` DROP `id_roja45_product_paymentprofile`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `'._DB_PREFIX_.'roja45_productrental_rentalrate`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'day') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
        ADD COLUMN `value` DOUBLE(20,6) AFTER `qty`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
        ADD COLUMN `day` DATE AFTER `value`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
            ADD COLUMN `entry` INT(10) AFTER `day`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
        ADD COLUMN `date_add` DATETIME AFTER `qty`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
        ADD COLUMN `date_upd` datetime AFTER `date_add`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'SELECT * FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalrate ORDER BY `id_roja45_product_rental_rate` ASC';
        $results = Db::getInstance()->executeS($sql);
        foreach ($results as $row) {
            $original_rate = new ProductRentalRentalModelRate($row['id_roja45_product_rental_rate']);
            $rate = new ProductRentalRate($row['id_roja45_product_rate']);
            $rental_model = new ProductRentalRentalModel($row['id_roja45_product_rental_model']);
            $rental_product = new ProductRentalRentalProduct($rental_model->id_roja45_product_rental_product);
            $rental = new ProductRentalRental($rental_product->id_roja45_product_rental);

            if (Validate::isLoadedObject($rental_model)) {
                $date_range = new DatePeriod(
                    DateTime::createFromFormat('Y-m-d', $rental_model->start_date),
                    new DateInterval('P1D'),
                    DateTime::createFromFormat('Y-m-d', $rental_model->end_date)
                );
                $dates = iterator_to_array($date_range);
                for ($i = 0; $i < count($dates); $i++) {
                    $sql = '
                        SELECT qty 
                        FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalrate 
                        WHERE id_roja45_product_rental_rate = '.$row['id_roja45_product_rental_rate'];
                    $qty = Db::getInstance()->getValue($sql);
                    if ($qty) {
                        for ($j = 1; $j <= $qty; $j++) {
                            $date = $dates[$i]->format('Y-m-d');
                            $rate_value = $rate->rate;

                            $ratetypeObj = new ProductRentalRateType($row['id_roja45_product_rate']);
                            if ($special_rate = ProductRentalPeriodRate::getPricePeriodForDate(
                                $rental->id_roja45_product,
                                $row['id_roja45_product_rental_model'],
                                $ratetypeObj->id_roja45_product_ratetype,
                                Context::getContext()->language->id,
                                $date
                            )) {
                                $rate_value= $special_rate[0]['rate_value'];
                            }

                            $rental_rate = new ProductRentalRentalModelRate();
                            $rental_rate->id_roja45_product_rental_model = $original_rate->id_roja45_product_rental_model;
                            $rental_rate->id_roja45_product_rate = $original_rate->id_roja45_product_rate;
                            $rental_rate->entry = $j;
                            $rental_rate->value = $rate_value;
                            $rental_rate->day = $date;
                            $return &= $rental_rate->save();
                        }
                    }
                }
            }
            $return &= $original_rate->delete();
        }

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` DROP `total`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` DROP `qty`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` DROP `total_wt`;';
        $return &= Db::getInstance()->execute($sql);
    }

    Configuration::updateValue('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE', 1);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_DELETETABLES', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_SHOWCALENDARAVAILABILITY', 1);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_UPDATEPRODUCTPRICE', 1);
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
