<?php
/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_1_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_2_0($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_details`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'instant_rental') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details`
        ADD COLUMN `instant_rental` TINYINT(1) AFTER `return_time`;';
        $return &= Db::getInstance()->execute($sql);

        $rental_products = Db::getInstance()->executeS(
            'SELECT id_roja45_product FROM `' . _DB_PREFIX_ .
            'roja45_productrental_details`'
        );
        foreach ($rental_products as $rental_product) {
            $rental_product = new ProductRentalDetails($rental_product['id_roja45_product']);
            $rental_product->instant_rental = 1;
            $rental_product->collection_time = '12:00';
            $rental_product->return_time = '12:00';
            $rental_product->save();
        }

        $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET `instant_rental` ="1"';
        $return &= Db::getInstance()->execute($sql);
    }

    Db::getInstance()->execute(
        'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` 
        CHANGE `entry` `entry` INT(10) NULL DEFAULT NULL;'
    );

    // TODO - Update existing rental rate entries to combine back to 1 per qty
    $rental_rate_models = Db::getInstance()->executeS(
        'SELECT DISTINCT id_roja45_product_rental_model
        FROM `'._DB_PREFIX_.'roja45_productrental_rentalrate`'
    );
    foreach ($rental_rate_models as $rental_rate_model) {
        $rental_rates = Db::getInstance()->executeS(
            'SELECT * 
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
            WHERE id_roja45_product_rental_model=' . (int) $rental_rate_model['id_roja45_product_rental_model']
        );

        $rental_rate_dates = Db::getInstance()->executeS(
            'SELECT DISTINCT day
            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
            WHERE id_roja45_product_rental_model=' . (int) $rental_rate_model['id_roja45_product_rental_model']
        );
        $num_days = count($rental_rate_dates);
        $rows = count($rental_rates);
        $qty = $rows/$num_days;

        $entries = array();
        foreach ($rental_rate_dates as $rental_rate_date) {
            $rental_rate = Db::getInstance()->executeS(
                'SELECT *
                FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
                WHERE id_roja45_product_rental_model=' . (int) $rental_rate_model['id_roja45_product_rental_model'] . '
                AND day = "'.pSQL($rental_rate_date['day']).'"'
            );
            $new_rate = new ProductRentalRentalModelRate();
            $new_rate->id_roja45_product_rental_model = $rental_rate_model['id_roja45_product_rental_model'];
            $new_rate->id_roja45_product_rate = $rental_rate[0]['id_roja45_product_rate'];
            $new_rate->date_add = $rental_rate[0]['date_add'];
            $new_rate->date_upd = $rental_rate[0]['date_upd'];
            $new_rate->value = $rental_rate[0]['value'];
            $new_rate->day = $rental_rate_date['day'];
            $new_rate->entry = $qty;
            $entries[] = $new_rate;
        }
        Db::getInstance()->execute(
            'DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
            WHERE id_roja45_product_rental_model=' . (int) $rental_rate_model['id_roja45_product_rental_model']
        );
        foreach ($entries as $entry) {
            $entry->add();
        }
    }
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME', '12:00');
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_RETURNTIME', '12:00');
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLESALES', 1);
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
