<?php
/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_1_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_3_1($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_details_shop` (
          `id_roja45_product` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_shop` INT(10) UNSIGNED NOT NULL,
          `enabled` TINYINT(1),
          PRIMARY KEY (`id_roja45_product`, `id_shop`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discount` (
          `id_roja45_product_discount` int(10) unsigned NOT NULL auto_increment,
          `name` varchar(255) NOT NULL,
          `reduction_type` varchar(255),
          `start_date` datetime,
          `end_date` datetime,
          `enabled` tinyint(1),
          `date_add` datetime,
          `date_upd` datetime,
          PRIMARY KEY (`id_roja45_product_discount`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountconditiongroup` (
          `id_roja45_product_discountconditiongroup` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_discount` int(10) unsigned NOT NULL,
          PRIMARY KEY (`id_roja45_product_discountconditiongroup`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountcondition` (
          `id_roja45_product_discountcondition` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_discountconditiongroup` int(10) unsigned NOT NULL,
          `type` varchar(255) NOT NULL,
          `value` varchar(255),
          PRIMARY KEY (`id_roja45_product_discountcondition`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile` (
          `id_roja45_product_discountprofile` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_discount` int(10) unsigned NOT NULL,
          `position` int(10) NOT NULL,
          `days` int(10) NOT NULL,
          `value` int(10) NOT NULL,
          PRIMARY KEY (`id_roja45_product_discountprofile`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_productdiscount` (
          `id_roja45_product_productdiscount` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product` int(10) unsigned NOT NULL,
          `id_roja45_product_discount` int(10) unsigned NOT NULL,
          PRIMARY KEY (`id_roja45_product_productdiscount`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_workingday`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'opening_time') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_workingday`
        ADD COLUMN `opening_time` TIME NOT NULL DEFAULT \'09:00:00\' AFTER `day`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_workingday`
        ADD COLUMN `closing_time` TIME NOT NULL DEFAULT \'17:00:00\' AFTER `opening_time`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'collection_time') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
        ADD COLUMN `collection_time` TIME AFTER `start_date`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
        ADD COLUMN `return_time` TIME AFTER `end_date`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
        ADD COLUMN `total_wt` DOUBLE(20,6);';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
        ADD COLUMN `date_add` DATETIME;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
        ADD COLUMN `date_upd` DATETIME;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_details`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_shop_default') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details` CHANGE `id_shop` `id_shop_default` INT(10) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
    }

    Configuration::updateValue('ROJA45_PRODUCTRENTAL_COLLECTIONTIME', '12:00');
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_RETURNTIME', '12:00');

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET collection_time = "12:00";';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_details` SET return_time = "12:00";';
    $return &= Db::getInstance()->execute($sql);

    $sql = 'SELECT id_roja45_product, id_shop_default, enabled FROM ' . _DB_PREFIX_ . 'roja45_productrental_details';
    $rows = Db::getInstance()->executeS($sql);
    foreach ($rows as $row) {
        $sql = 'SELECT id_roja45_product FROM `' . _DB_PREFIX_ . 'roja45_productrental_details_shop` WHERE id_roja45_product='. $row['id_roja45_product'];
        if (!Db::getInstance()->getValue($sql)) {
            $sql = '
            INSERT INTO `' . _DB_PREFIX_ . 'roja45_productrental_details_shop`
            VALUES (' . $row['id_roja45_product'] . ',' . $row['id_shop_default'] . ',' . $row['enabled'].');';
            $return &= Db::getInstance()->execute($sql);
        }
    }
    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` SET collection_time = "12:00:00";';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` SET return_time = "12:00:00";';
    $return &= Db::getInstance()->execute($sql);
    if (!Tab::getIdFromClassName('RentalDiscounts')) {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'RentalDiscounts';
        $tab->id_parent = Tab::getIdFromClassName('AdminParent' . $module->tabClassName);
        $tab->module = $module->name;

        $tab->name = array();
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'RentalDiscounts', $lang);
        }
        $return &= $tab->add();
    }
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
