<?php
/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_1_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_1_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_3_2($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_daterate` (
          `id_roja45_product_daterate` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_roja45_product` INT(10) UNSIGNED NOT NULL,
          `id_roja45_product_model` INT(10) UNSIGNED NOT NULL,
          `id_roja45_product_rate` INT(10) UNSIGNED NOT NULL,
          `date` DATE,
          `rate` DOUBLE(20,6),
          PRIMARY KEY (`id_roja45_product_daterate`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype` (
          `id_roja45_product_payment_type` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `enabled` TINYINT(1),
          `include` TINYINT(1),
          PRIMARY KEY (`id_roja45_product_payment_type`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_paymenttype_lang` (
          `id_roja45_product_payment_type` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_lang` INT(10) UNSIGNED NOT NULL,
          `name` VARCHAR(255),
          PRIMARY KEY (`id_roja45_product_payment_type`, `id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item` (
          `id_roja45_product_rental_payment_item` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_roja45_product_rental_payment` INT(10) UNSIGNED NOT NULL,
          `id_product` INT(10) UNSIGNED NOT NULL,
          `id_product_attribute` INT(10) UNSIGNED NOT NULL,
          `total_paid` DOUBLE(20,6),
          PRIMARY KEY (`id_roja45_product_rental_payment_item`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);


    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'date_add') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `date_requested` DATETIME AFTER `due_date`;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `id_roja45_product_payment_type` INT(10) AFTER `id_currency`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `requested` TINYINT(1) NOT NULL DEFAULT 0 AFTER `completed`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `payment_late` TINYINT(1) NOT NULL DEFAULT 0 AFTER `payment_due`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `deleted` TINYINT(1) NOT NULL DEFAULT 0 AFTER `payment_due`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `reminders_sent` INT(10) AFTER `payment_late`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `note` VARCHAR(1000) AFTER `total`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `date_completed` DATETIME AFTER `total_with_tax`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `date_add` DATETIME AFTER `date_completed`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `date_upd` DATETIME AFTER `date_add`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment`
        ADD COLUMN `date_del` DATETIME AFTER `date_upd`;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` CHANGE `paid_date` `date_paid` DATETIME NULL DEFAULT NULL;';
        $return &= Db::getInstance()->execute($sql);

        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment` CHANGE `due_date` `date_due` DATETIME NULL DEFAULT NULL;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'record_history') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`
        ADD COLUMN `record_history` TINYINT(1) AFTER `notify_admin`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'tax') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`
        ADD COLUMN `tax` DOUBLE(20,6);';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'tax') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`
        ADD COLUMN `tax` DOUBLE(20,6);';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`
        ADD COLUMN `date_add` DATETIME;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`
        ADD COLUMN `date_upd` DATETIME;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'customer_account') {
            $add_tables = false;
        }
    }

    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalstatus`
        ADD COLUMN `customer_account` TINYINT(1);';
        $return &= Db::getInstance()->execute($sql);
    }

    $tax_enabled = Configuration::get('PS_TAX');
    $usetax = true;
    if (Tax::excludeTaxeOption()) {
        $usetax = false;
    }

    $sql = 'SELECT id_roja45_product_rental FROM ' . _DB_PREFIX_ . 'roja45_productrental_rental';
    $rows = Db::getInstance()->executeS($sql);
    foreach ($rows as $row) {
        $rental = new ProductRentalRental($row['id_roja45_product_rental']);
        $address_id = Address::getFirstCustomerAddressId($rental->id_customer);
        if (!Address::addressExists($address_id)) {
            $address_id = null;
        }
        $address = new Address($address_id);

        foreach ($rental->getProducts() as $product) {
            $product_tax_calculator = null;
            if ($tax_enabled && $usetax) {
                $id_tax_rules_group = Product::getIdTaxRulesGroupByIdProduct(
                    (int)$product['id_product'],
                    Context::getContext()
                );
                $product_tax_calculator = TaxManagerFactory::getManager(
                    $address,
                    $id_tax_rules_group
                )->getTaxCalculator();

                $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                foreach ($models as $model) {
                    $sql = '
                        SELECT DISTINCT id_roja45_product_rate
                        FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
                        WHERE rr.id_roja45_product_rental_model=' . (int)$model['id_roja45_product_rental_model'];
                    foreach (Db::getInstance()->executeS($sql) as $rate_id) {
                        $sql = '
                            SELECT *
                            FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` rr
                            WHERE rr.id_roja45_product_rental_model=' . (int)$model['id_roja45_product_rental_model'] . '
                            AND rr.id_roja45_product_rate = ' . $rate_id['id_roja45_product_rate'] . '
                            ORDER BY rr.period';
                        $days = Db::getInstance()->executeS($sql);
                        foreach ($days as $day) {
                            $model_rate = new ProductRentalRentalModelRate($day['id_roja45_product_rental_rate']);
                            $model_rate->tax = ($product_tax_calculator->addTaxes($model_rate->value))-$model_rate->value;
                            $model_rate->save();
                        }
                    }

                    $sql = '
                        SELECT DISTINCT id_roja45_product_rental_extra
                        FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra` rr
                        WHERE rr.id_roja45_product_rental_model=' . (int)$model['id_roja45_product_rental_model'];
                    foreach (Db::getInstance()->executeS($sql) as $extra_id) {
                        $model_extra = new ProductRentalRentalModelExtra($extra_id['id_roja45_product_rental_extra']);
                        $model_extra->tax = ($product_tax_calculator->addTaxes($model_extra->rate))-$model_extra->rate;
                        $model_extra->save();
                    }
                }
            }
        }

        $payments = ProductRentalRentalPayment::getList($rental->id);
        foreach ($payments as $payment) {
            $paymentObj = new ProductRentalRentalPayment($payment['id_roja45_product_rental_payment']);
            $paymentObj->requested = 1;
            $paymentObj->id_roja45_product_payment_type = ProductRentalPaymentType::DEPOSIT;
            $paymentObj->date_requested = $payment['date_paid'];
            $return &= $paymentObj->save();

            $sql = 'DELETE FROM ' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment_item WHERE id_roja45_product_rental_payment = ' . $payment['id_roja45_product_rental_payment'];
            Db::getInstance()->execute($sql);
            $rental_object = Tools::jsonDecode($rental->toJSON(Context::getContext()->language->id));
            $rental_object = ProductRentalRental::validateRental($rental_object);
            foreach ($rental_object->products as $rental_product) {
                foreach ($rental_product->models as $model) {
                    $product_rental_payment_item = new ProductRentalRentalPaymentItem();
                    $product_rental_payment_item->id_roja45_product_rental_payment = $payment['id_roja45_product_rental_payment'];
                    $product_rental_payment_item->id_product = $rental_product->id_product;
                    $product_rental_payment_item->id_product_attribute = $model->id_product_attribute;
                    $product_rental_payment_item->total_paid = $model->total_to_pay_model;
                    $return &= $product_rental_payment_item->add();
                }
            }
        }
    }

    $payment_types = array(
        array(
            'code' => 'Deposit',
            'include' => 1,
        ),
        array(
            'code' => 'Balance',
            'include' => 1,
        ),
        array(
            'code' => 'Other',
            'include' => 0,
        ),
    );
    foreach ($payment_types as $payment_type) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_paymenttype',
            array(
                'enabled' => 1,
                'include' => (int) $payment_type['include']
            )
        );
        $id = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_paymenttype_lang',
                array(
                    'id_roja45_product_payment_type' => (int)$id,
                    'id_lang' => (int)$language['id_lang'],
                    'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'PaymentType'.$payment_type['code'], $language)),
                )
            );
        }
    }

    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$RCVD);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 0;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$CHKT);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 0;
    $status->available_customer = 0;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$CCNF);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$PRES);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$CONF);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$DPST);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$PAYM);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 0;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$PAYU);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$PAYC);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$RETN);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$DLTD);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 0;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$CCLD);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$COMP);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$REVW);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();
    $status = ProductRentalRentalStatus::getStatusByType(ProductRentalRentalStatus::$OVER);
    $status = new ProductRentalRentalStatus($status);
    $status->record_history = 1;
    $status->available_customer = 1;
    $return &= $status->save();

    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
        $id_tab = Tab::getIdFromClassName($module->tabClassName);
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'store';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('RentalPricePeriods');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'av_timer';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('RentalRateTypes');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'list';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('RentalPaymentProfiles');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'payment';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('RentalExtras');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'add_circle';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('RentalDiscounts');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'local_atm';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('AdminProductRentals');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'collections_bookmark';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('AdminRentalCalendar');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'date_range';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('AdminRentalStatus');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'warning';
            $return &= $tab->save();
        }

        $id_tab = Tab::getIdFromClassName('AdminWorkingDays');
        if ($id_tab) {
            $tab = new Tab($id_tab);
            $tab->icon = 'today';
            $return &= $tab->save();
        }

        $return &= $module->registerHook('actionObjectProductInCartDeleteAfter');
    }

    $return &= Configuration::updateValue('ROJA45_PRODUCTRENTAL_ALWAYSUSECART', 0);
    $return &= Configuration::updateValue('ROJA45_PRODUCTRENTAL_USEPERIODPRICING', 0);
    $return &= Configuration::updateValue('ROJA45_PRODUCTRENTAL_DISPLAY_LABEL', 1);
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
