<?php
/**
 * upgrade_module_1_4_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_4_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_4_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_4_0($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;
    $context = Context::getContext();
    $return &= (bool)Db::getInstance()->execute('DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rategroup`');
    $return &= (bool)Db::getInstance()->execute('DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass`');
    $return &= (bool)Db::getInstance()->execute('DROP TABLE IF EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass_lang`');

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rategroup` (
          `id_roja45_product_rategroup` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_roja45_product_rate` INT(10),
          `id_group` INT(10),
          PRIMARY KEY (`id_roja45_product_rategroup`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass` (
          `id_roja45_product_rateclass` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `enabled` TINYINT(1),
          PRIMARY KEY (`id_roja45_product_rateclass`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateclass_lang` (
          `id_roja45_product_rateclass` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_lang` INT(10) UNSIGNED NOT NULL,
          `name` VARCHAR(255),
          `description` VARCHAR(1024),
          PRIMARY KEY (`id_roja45_product_rateclass`,`id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rateclass`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'enabled') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rateclass` 
            ADD `enabled` TINYINT(1)';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'payment_request_days') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_paymentprofile` 
            ADD `payment_request_days` INT(10) NOT NULL DEFAULT \'7\' AFTER `days_until_reservation`';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rental`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'cod') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rental` 
            ADD `cod` TINYINT(1) NOT NULL AFTER `modified`';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_model`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'reference') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_model` 
            ADD `reference` VARCHAR(255) NOT NULL AFTER `name`';
        $return &= Db::getInstance()->execute($sql);
    }

    $select = Db::getInstance()->getValue('SELECT id_meta FROM `' . _DB_PREFIX_ . 'meta` WHERE page ="module-roja45productrental-ProductRentalFront"');
    if (!$select) {
        Db::getInstance()->execute(
            'INSERT INTO `' . _DB_PREFIX_ . 'meta` (`id_meta`, `page`, `configurable`) 
            VALUES (NULL, "module-roja45productrental-ProductRentalFront", 1)'
        );
        $id_meta = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'meta_lang',
                array(
                    'id_meta' => (int) $id_meta,
                    'id_shop' => (int) $context->shop->id,
                    'id_lang' => (int) $language['id_lang'],
                    'title' => pSQL(''),
                    'description' => pSQL(''),
                    'keywords' => pSQL(''),
                    'url_rewrite' => pSQL('')
                )
            );
        }

        Db::getInstance()->execute(
            'INSERT INTO `' . _DB_PREFIX_ . 'meta` (`id_meta`, `page`, `configurable`)
            VALUES (NULL, "module-roja45productrental-ProductRentalSearch", 1)'
        );
        $id_meta = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'meta_lang',
                array(
                    'id_meta' => (int) $id_meta,
                    'id_shop' => (int) $context->shop->id,
                    'id_lang' => (int) $language['id_lang'],
                    'title' => pSQL(''),
                    'description' => pSQL(''),
                    'keywords' => pSQL(''),
                    'url_rewrite' => pSQL('')
                )
            );
        }
        Db::getInstance()->execute(
            'INSERT INTO `' . _DB_PREFIX_ . 'meta` (`id_meta`, `page`, `configurable`)
            VALUES (NULL, "module-roja45productrental-ProductRentalFacetedSearch", 1)'
        );
        $id_meta = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'meta_lang',
                array(
                    'id_meta' => (int) $id_meta,
                    'id_shop' => (int) $context->shop->id,
                    'id_lang' => (int) $language['id_lang'],
                    'title' => pSQL(''),
                    'description' => pSQL(''),
                    'keywords' => pSQL(''),
                    'url_rewrite' => pSQL('')
                )
            );
        }
    }

    $rate_classes = array(
        array(
            'name' => 'DailyRate',
        ),
        array(
            'name' => 'WeeklyRate',
        ),
        array(
            'name' => 'MonthlyRate',
        ),
        array(
            'name' => 'CustomRate',
        )
    );

    $languages = Language::getLanguages();
    foreach ($rate_classes as $rate_class) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rateclass',
            array(
                'enabled' => 1
            )
        );
        $id_roja45_product_rateclass = Db::getInstance()->Insert_ID();
        foreach ($languages as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rateclass_lang',
                array(
                    'id_roja45_product_rateclass' => (int) $id_roja45_product_rateclass,
                    'id_lang' => (int) $language['id_lang'],
                    'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $rate_class['name'].'Name', $language)),
                    'description' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $rate_class['name'].'Desc', $language)),
                )
            );
        }
    }


    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_rate', 'r');
    $rates = Db::getInstance()->executeS($sql);
    $groups = Group::getGroups($context->language->id);
    foreach ($rates as $rate) {
        $data = array();
        foreach ($groups as $group) {
            $data[] = array(
                'id_roja45_product_rate' => $rate['id_roja45_product_rate'],
                'id_group' => $group['id_group']
            );
        }
        Db::getInstance()->insert('roja45_productrental_rategroup', $data);
    }

    $reservation_profile = new ProductRentalPaymentProfile();
    $reservation_profile->id_group = 0;
    $reservation_profile->number_payments = 0;
    $reservation_profile->days_until_reservation = 0;
    $reservation_profile->deposit_type = ProductRentalPaymentProfile::PERCENTAGE;
    $reservation_profile->type = ProductRentalPaymentProfile::COD_FINAL;
    $reservation_profile->position = 0;
    $reservation_profile->deposit_amount = 50;
    $reservation_profile->enabled = 1;
    foreach (Language::getLanguages(true) as $lang) {
        $reservation_profile->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'PaymentProfileCODName', $lang);
        $reservation_profile->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'PaymentProfileCODDesc', $lang);
    }
    $return &= $reservation_profile->save();

    $def_states = array(
        array(
            'code' => ProductRentalRentalStatus::$PAYR,
            'color' => '#ff644c',
            'unremovable' => 1,
            'send_email' => 1,
            'notify_admin' => 1,
            'block_calendar' => 1,
            'record_history' => 1,
            'available_customer' => 1,
            'answer_template' => 'remind_customer_payment'
        ),
        array(
            'code' => ProductRentalRentalStatus::$PAYO,
            'color' => '#ff644c',
            'unremovable' => 1,
            'send_email' => 1,
            'notify_admin' => 1,
            'block_calendar' => 1,
            'record_history' => 1,
            'available_customer' => 1,
            'answer_template' => 'customer_payment_overdue'
        ),
    );

    foreach ($def_states as $state) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rentalstatus',
            array(
                'color' => pSQL($state['color']),
                'code' => pSQL($state['code']),
                'unremovable' => (int)$state['unremovable'],
                'send_email' => (int)$state['send_email'],
                'notify_admin' => (int)$state['notify_admin'],
                'block_calendar' => (int)$state['block_calendar'],
                'record_history' => (int)$state['record_history'],
                'customer_account' => (int)$state['available_customer'],
                'answer_template' => pSQL($state['answer_template']),
            )
        );
        $id_status = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus_lang',
                array(
                    'id_roja45_product_rental_status' => (int)$id_status,
                    'id_lang' => (int)$language['id_lang'],
                    'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $state['code'], $language)),
                )
            );
        }
    }

    Configuration::updateValue('ROJA45_PRODUCTRENTAL_COD_PAYMENT', $reservation_profile->id);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER', 5);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_REMINDERAFTER', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD', 0);

    $module->registerHook('actionRoja45ProductRentalPostProcessBefore');
    $module->registerHook('actionRoja45ProductRentalPostProcessAfter');
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
