<?php
/**
 * upgrade_module_1_4_1.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_4_1
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_4_1.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_4_1($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_model`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'is_linked') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_model` 
            ADD `is_linked` TINYINT(1)';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'damage_deposit') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` 
            ADD `damage_deposit` DOUBLE(20,6) AFTER `total_wt`';
        $return &= Db::getInstance()->execute($sql);
    }

    $def_states = array(
        array(
            'code' => ProductRentalRentalStatus::$ADMN,
            'color' => '#ff644c',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 0,
            'block_calendar' => 0,
            'record_history' => 1,
            'available_customer' => 0,
            'answer_template' => ''
        ),
    );

    foreach ($def_states as $state) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rentalstatus',
            array(
                'color' => pSQL($state['color']),
                'code' => pSQL($state['code']),
                'unremovable' => (int)$state['unremovable'],
                'send_email' => (int)$state['send_email'],
                'notify_admin' => (int)$state['notify_admin'],
                'block_calendar' => (int)$state['block_calendar'],
                'record_history' => (int)$state['record_history'],
                'customer_account' => (int)$state['available_customer'],
                'answer_template' => pSQL($state['answer_template']),
            )
        );
        $id_status = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus_lang',
                array(
                    'id_roja45_product_rental_status' => (int)$id_status,
                    'id_lang' => (int)$language['id_lang'],
                    'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $state['code'], $language)),
                )
            );
        }
    }


    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_model', 'prm');
    $models =  Db::getInstance()->executeS($sql);
    foreach ($models as $model) {
        $model = new ProductRentalModel($model['id_roja45_product_model']);
        $model->is_linked = 1;
        $model->save();
    }

    if ((int) Configuration::get('ROJA45_PRODUCTRENTAL_ENABLEPRODUCTDEPOSIT')) {
        $id_damage_deposit_product = (int) Configuration::get('ROJA45_PRODUCTRENTAL_IDPRODUCTDEPOSIT');
        $damage_percntage = (int)Configuration::get('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT') / 100;

        // TODO - Update all rental model entries with damage deposit
        $rentals = ProductRentalRental::getAllOpenRentals();
        foreach ($rentals as $rental) {
            $rental = new ProductRentalRental($rental['id_roja45_product_rental']);
            $sql = 'select id_order 
                    from ' . _DB_PREFIX_ . 'roja45_productrental_rentalpayment
                    where id_roja45_product_rental = ' . (int) $rental->id_roja45_product_rental . '
                    order by id_roja45_product_rental_payment asc';
            $id_order = Db::getInstance()->getValue($sql);
            if (count($id_order)) {
                $sql = '
                    select product_id 
                    from ' . _DB_PREFIX_ . 'order_detail
                    where id_order = ' . (int) $id_order;
                $order_lines = Db::getInstance()->executeS($sql);
                $damage_deposit_paid = false;
                foreach ($order_lines as $order_line) {
                    if ($order_line['product_id'] == $id_damage_deposit_product) {
                        $damage_deposit_paid = true;
                        // TODO - we have the total damage deposit paid here.
                    }
                }

                $total_damage_deposit = 0.0;
                $products = $rental->getProducts();
                foreach ($products as $product) {
                    if ($damage_deposit_paid) {
                        $models = ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']);
                        foreach ($models as $model) {
                            $model = new ProductRentalRentalModel($model['id_roja45_product_rental_model']);
                            $model->damage_deposit = $model->total * ($damage_percntage/100);
                            $model->save();
                            $total_damage_deposit += $model->damage_deposit;
                        }
                    }
                }
                // todo check calculated damage deposit is the same as the paid amount.
            }
        }
    }
    //
    // foreach model
    // check that the order associated had a damage deposit paid.
    // if yes, calculate damage deposit and save.
    $reservation_profile = new ProductRentalPaymentProfile();
    $reservation_profile->id_group = 0;
    $reservation_profile->number_payments = 0;
    $reservation_profile->days_until_reservation = 0;
    $reservation_profile->deposit_type = ProductRentalPaymentProfile::PERCENTAGE;
    $reservation_profile->type = ProductRentalPaymentProfile::COD_FINAL;
    $reservation_profile->position = 0;
    $reservation_profile->deposit_amount = 50;
    $reservation_profile->enabled = 1;
    foreach (Language::getLanguages(true) as $lang) {
        $reservation_profile->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'PaymentProfileCODName', $lang);
        $reservation_profile->description[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, 'PaymentProfileCODDesc', $lang);
    }
    $reservation_profile->save();

    Configuration::updateValue('ROJA45_PRODUCTRENTAL_COD_PAYMENT', $reservation_profile->id);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_REQUESTPAYMENTS', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ABANDONEDRENTAL', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ABANDONEDAFTER', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_DELETEINCOMPLETE', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_MAXIMUMREMINDERS', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_FIRSTREMINDERAFTER', 5);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_REMINDERAFTER', 2);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLECUSTOMERSELECTCOD', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_PREPARATIONDAYS', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_RECONDITIONDAYS', 0);
    Configuration::updateValue('ROJA45PRODUCTRENTAL_AUTOENABLENEWPRODUCTS', 0);

    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
        $sql = 'UPDATE `' . _DB_PREFIX_ . 'tab` SET icon = "store" WHERE class_name="AdminParentAdminProductRental";';
        $return &= Db::getInstance()->execute($sql);
    }

    $module->registerHook('actionRoja45ProductRentalPostProcessBefore');
    $module->registerHook('actionRoja45ProductRentalPostProcessAfter');
    $module->registerHook('actionProductSave');
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
