<?php
/**
 * upgrade_module_1_5_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_0
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_0.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_0($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateduration` (
          `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `type` INT(10) UNSIGNED NOT NULL,
          `active` TINYINT(1) UNSIGNED NOT NULL,
          `duration` INT(10) NOT NULL,
          PRIMARY KEY (`id_roja45_product_rateduration`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_rateduration_lang` (
          `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_lang` INT(10) UNSIGNED NOT NULL,
          `name` VARCHAR(255),
          PRIMARY KEY (`id_roja45_product_rateduration`,`id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_damagedeposit` (
          `id_roja45_product_damagedeposit` INT(10) UNSIGNED NOT NULL AUTO_INCREMENT,
          `id_deposit_type` INT(10) UNSIGNED NOT NULL,
          `id_deposit_method` INT(10) UNSIGNED NOT NULL,
          `id_deposit_source_value` INT(10) UNSIGNED NOT NULL,
          `name` VARCHAR(255),
          `deposit_amount` DOUBLE(20,6),
          `with_tax` TINYINT(1),
          `enabled` TINYINT(1),
          PRIMARY KEY (`id_roja45_product_damagedeposit`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_type` (
        `id_roja45_productrental_extra_type` int(10) unsigned NOT NULL auto_increment,
        `code` varchar(255),
        `id` int(10) unsigned NOT NULL,
        PRIMARY KEY (`id_roja45_productrental_extra_type`)
        ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
    $return &= (bool) Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'roja45_productrental_extra_type_lang` (
        `id_roja45_productrental_extra_type` int(10) unsigned NOT NULL auto_increment,
        `id_lang` int(10) unsigned NOT NULL,
        `name` varchar(255) NOT NULL,
        `description` text NOT NULL,
        PRIMARY KEY (`id_roja45_productrental_extra_type`, `id_lang`)
        ) ENGINE=`'._MYSQL_ENGINE_.'` DEFAULT CHARSET=UTF8;';
    $return &= (bool) Db::getInstance()->execute($sql);

    $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rateduration`;';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_rateduration_lang`;';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rateduration` AUTO_INCREMENT = 1;';
    $return &= Db::getInstance()->execute($sql);

    $rate_durations = array(
        array(
            'code' => 'HOURLY',
            'type' => ProductRentalRateDuration::HOURLY,
            'duration' => 1,
            'active' => 0,
        ),
        array(
            'code' => 'DAILY',
            'type' => ProductRentalRateDuration::DAILY,
            'duration' => 1,
            'active' => 1,
        ),
        array(
            'code' => 'WEEKLY',
            'type' => ProductRentalRateDuration::WEEKLY,
            'duration' => 7,
            'active' => 0,
        ),
        array(
            'code' => 'MONTHLY',
            'type' => ProductRentalRateDuration::MONTHLY,
            'duration' => 1,
            'active' => 0,
        ),
    );
    foreach ($rate_durations as $rate_duration) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rateduration',
            array(
                'type' => (int) $rate_duration['type'],
                'duration' => (int) $rate_duration['duration'],
                'active' => (int) $rate_duration['active'],
            )
        );
        $id = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rateduration_lang',
                array(
                    'id_roja45_product_rateduration' => (int)$id,
                    'id_lang' => (int)$language['id_lang'],
                    'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation($module, $rate_duration['code'].'DurationName', $language)),
                )
            );
        }
    }

    $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_extra_type`;';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'roja45_productrental_extra_type_lang`;';
    $return &= Db::getInstance()->execute($sql);
    $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_extra_type` AUTO_INCREMENT = 1;';
    $return &= Db::getInstance()->execute($sql);
    $extra_types = array(
        array(
            'code' => 'PER_PERIOD',
        ),
        array(
            'code' => 'PER_RENTAL',
        ),
        array(
            'code' => 'PER_RENTAL_ITEM',
        ),
        array(
            'code' => 'PER_RENTAL_ITEM_PER_PERIOD',
        ),
    );
    foreach ($extra_types as $extra_type) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_extra_type',
            array(
                'code' => (int) $extra_type['code'],
            )
        );
        $id = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_extra_type_lang',
                array(
                    'id_roja45_productrental_extra_type' => (int)$id,
                    'id_lang' => (int)$language['id_lang'],
                    'name' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $module,
                        $extra_type['code'].'ExtraTypeName',
                        $language
                    )),
                    'description' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $module,
                        $extra_type['code'].'ExtraTypeDesc',
                        $language
                    )),
                )
            );
        }
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_extra`');
    $add_tables = false;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'charge_type') {
            $add_tables = true;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_extra` CHANGE `charge_type` `id_roja45_productrental_extra_type` INT(10) UNSIGNED NOT NULL;';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_extra` ADD `image` VARCHAR(255);';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_extra` ADD `deselect_warning` TINYINT(1);';
        $return &= Db::getInstance()->execute($sql);
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_extra_lang` ADD `deselect_warning_text` TEXT NOT NULL AFTER `description`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`');
    $add_tables = false;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'day') {
            $add_tables = true;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` CHANGE `day` `period` DATETIME NULL DEFAULT NULL;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'discount') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` 
            ADD `discount` DOUBLE(20,6) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` 
            ADD `total` DOUBLE(20,6) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` SET `discount` = 0.0;';
    $return &= Db::getInstance()->execute($sql);

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalrate` SET `total` = value;';
    $return &= Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'period_start') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile` 
            ADD `period_start` INT(10) AFTER `position`';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_discountprofile` 
            ADD `period_end` INT(10) AFTER `period_start`';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_discountprofile', 'dp');
    $sql->orderBy('dp.days');
    $results =  Db::getInstance()->executeS($sql);
    $previous_profile = null;
    foreach ($results as $row) {
        $discount_profile = new ProductRentalDiscountProfile($row['id_roja45_product_discountprofile']);
        if ($previous_profile) {
            $discount_profile->period_start = $previous_profile->days+1;
            $discount_profile->period_end = $previous_profile->days;
        } else {
            $discount_profile->period_start = 0;
            $discount_profile->period_end = $discount_profile->days;
        }
        $previous_profile = clone $discount_profile;
        $return &= $discount_profile->save();
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_roja45_product_rateduration') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` 
            ADD `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
            ADD `return_due` TINYINT(1) NOT NULL DEFAULT \'0\' AFTER `damage_deposit`;';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
            ADD `overdue` TINYINT(1) NOT NULL DEFAULT \'0\' AFTER `return_due`;';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
            ADD `out_for_rent` TINYINT(1) NOT NULL DEFAULT \'0\' AFTER `return_due`;';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`
            ADD `date_rtn` DATETIME NULL DEFAULT NULL AFTER `returned`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_ratetype`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_roja45_product_rateduration') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_ratetype` 
            ADD `id_roja45_product_rateduration` INT(10) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_details`');
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'id_roja45_product_damagedeposit') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details` 
            ADD `id_roja45_product_damagedeposit` INT(10) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details` 
            ADD `id_roja45_product_overdueaction` INT(10) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
        $sql =
            'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_details` 
            ADD `overdue_fine` DOUBLE(20,6) UNSIGNED NOT NULL';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS(
        'SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`'
    );
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'damage_deposit_inc') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` ADD `damage_deposit_inc` DOUBLE(20,6)';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` SET `id_roja45_product_rateduration` = 2;';
    $return &= Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_ratetype`');
    $drop_tables = false;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'type') {
            $drop_tables = true;
        }
    }
    if ($drop_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_ratetype` DROP `type`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS('SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_model`');
    $drop_tables = false;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'rate_type') {
            $drop_tables = true;
        }
    }
    if ($drop_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_model` DROP `rate_type`;';
        $return &= Db::getInstance()->execute($sql);
    }

    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_ratetype', 'rt');
    $results =  Db::getInstance()->executeS($sql);
    foreach ($results as $row) {
        $rate_type = new ProductRentalRateType($row['id_roja45_product_ratetype']);
        $rate_type->id_roja45_product_rateduration = 2;
        $return &= $rate_type->save();
    }
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_USEPERIODPRICING', 0);
    Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITAMOUNT');
    Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITTAX');
    Configuration::deleteByName('ROJA45_PRODUCTRENTAL_FIXEDPRODUCTDEPOSITMETHOD');
    Configuration::deleteByName('ROJA45_PRODUCTRENTAL_PRODUCTDEPOSITSOURCE');
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLEMANUALRETURNPROCESS', 0);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION', 1);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLEOVERDUEFINE', 0);

    $id_tab = Tab::getIdFromClassName('RentalPricePeriods');
    $tab = new Tab($id_tab);
    $tab->active=0;
    $tab->save();

    $id_tab = Tab::getIdFromClassName('RentalDamageDeposits');
    if (!$id_tab) {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'RentalDamageDeposits';
        $tab->id_parent = Tab::getIdFromClassName('AdminParentAdminProductRental');
        $tab->module = $module->name;
        $tab->name = array();
        $tab->icon = 'av_timer';
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation($module, $tab->class_name, $lang);
        }
        $tab->add();
    }

    $def_states = array(
        array(
            'code' => ProductRentalRentalStatus::$RDUE,
            'color' => '#cc88df',
            'unremovable' => 1,
            'send_email' => 1,
            'notify_admin' => 0,
            'block_calendar' => 1,
            'record_history' => 0,
            'available_customer' => 1,
            'answer_template' => 'rental_return_due'
        ),
        array(
            'code' => ProductRentalRentalStatus::$SHIP,
            'color' => '#f9fa27',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 1,
            'block_calendar' => 1,
            'record_history' => 0,
            'available_customer' => 1,
            'answer_template' => ''
        ),
        array(
            'code' => ProductRentalRentalStatus::$CLCT,
            'color' => '#f9fa27',
            'unremovable' => 1,
            'send_email' => 1,
            'notify_admin' => 1,
            'block_calendar' => 1,
            'record_history' => 0,
            'available_customer' => 1,
            'answer_template' => 'rental_collection_due'
        ),
        array(
            'code' => ProductRentalRentalStatus::$OPEN,
            'color' => '#7bee92',
            'unremovable' => 1,
            'send_email' => 0,
            'notify_admin' => 0,
            'block_calendar' => 1,
            'record_history' => 1,
            'available_customer' => 1,
            'answer_template' => ''
        )
    );

    foreach ($def_states as $state) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rentalstatus',
            array(
                'color' => pSQL($state['color']),
                'code' => pSQL($state['code']),
                'unremovable' => (int)$state['unremovable'],
                'send_email' => (int)$state['send_email'],
                'notify_admin' => (int)$state['notify_admin'],
                'block_calendar' => (int)$state['block_calendar'],
                'record_history' => (int)$state['record_history'],
                'customer_account' => (int)$state['available_customer'],
                'answer_template' => pSQL($state['answer_template']),
            )
        );
        $id_status = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus_lang',
                array(
                    'id_roja45_product_rental_status' => (int)$id_status,
                    'id_lang' => (int)$language['id_lang'],
                    'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $module,
                        $state['code'],
                        $language
                    )),
                )
            );
        }
    }

    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_rental', 'r');
    $rentals = Db::getInstance()->executeS($sql);

    foreach ($rentals as $rental) {
        $rentalObj = new ProductRentalRental($rental['id_roja45_product_rental']);
        foreach ($rentalObj->getProducts() as $product) {
            foreach (ProductRentalRentalModel::getModels($product['id_roja45_product_rental_product']) as $model) {
                $time_until_return = (strtotime($model['end_date'] . ' ' . $model['return_time']) - strtotime(date("Y-m-d" . '00:00:00')));
                if ($time_until_return <= 0) {
                    $model = new ProductRentalRentalModel($model['id_roja45_product_rental_model']);
                    $model->overdue = 1;
                    $model->save();
                }
            }
        }
    }

    $sql = new DbQuery();
    $sql->select('*');
    $sql->from('roja45_productrental_details', 'r');
    $rental_products = Db::getInstance()->executeS($sql);
    foreach ($rental_products as $rental_product) {
        $rentalObj = new ProductRentalDetails($rental_product['id_roja45_product']);
        $rentalObj->id_roja45_product_overdueaction = 1;
        $rentalObj->save();
    }

    Configuration::updateValue('ROJA45_PRODUCTRENTAL_ENABLESEARCH', 1);
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
