<?php
/**
 * upgrade_module_1_5_1.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_1
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_1.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_1($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;
    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher` (
          `id_roja45_product_voucher` int(10) unsigned NOT NULL auto_increment,
          `id_customer` INT(10) UNSIGNED NOT NULL,
          `code` VARCHAR(255),
          `quantity` INT(10),
          `quantity_per_user` INT(10),
          `reduction_percent` DOUBLE(20,6),
          `reduction_amount` DOUBLE(20,6),
          `reduction_extras` TINYINT(1),
          `free_extras` TINYINT(1),
          `enabled` tinyint(1),
          `date_from` datetime,
          `date_to` datetime,
          `date_add` datetime,
          `date_upd` datetime,
          PRIMARY KEY (`id_roja45_product_voucher`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher_lang` (
          `id_roja45_product_voucher` int(10) unsigned NOT NULL,
          `id_lang` INT(10) UNSIGNED NOT NULL,
          `name` varchar(255) NOT NULL,
          PRIMARY KEY (`id_roja45_product_voucher`, `id_lang`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_voucher_extra` (
          `id_roja45_product_voucher` int(10) unsigned NOT NULL,
          `id_roja45_product_extra` INT(10) UNSIGNED NOT NULL,
          PRIMARY KEY (`id_roja45_product_voucher`, `id_roja45_product_extra`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS(
        'SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct`'
    );
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'vouchers') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalproduct` ADD `vouchers` VARCHAR(255)';
        $return &= Db::getInstance()->execute($sql);
    }

    $list_fields = Db::getInstance()->executeS(
        'SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra`'
    );
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'discount') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalextra` ADD `discount` DOUBLE(20,6)';
        $return &= Db::getInstance()->execute($sql);
    }

    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
        $id_catalog_menu = Tab::getIdFromClassName('AdminParentAdminProductRental');
        if (!Tab::getIdFromClassName('RentalVouchers')) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalVouchers';
            $tab->id_parent = $id_catalog_menu;
            $tab->module = $module->name;
            $tab->icon = 'local_atm';
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $module,
                    'RentalVouchers17',
                    $lang
                );
            }
            $tab->add();
        }
    } else {
        $id_parent = Tab::getIdFromClassName('AdminParent' . $module->tabClassName);
        if (!Tab::getIdFromClassName('RentalVouchers')) {
            $tab = new Tab();
            $tab->active = 1;
            $tab->class_name = 'RentalVouchers';
            $tab->id_parent = $id_parent;
            $tab->module = $module->name;
            $tab->name = array();
            foreach (Language::getLanguages(true) as $lang) {
                $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                    $module,
                    $tab->class_name,
                    $lang
                );
            }
            $tab->add();
        }
    }
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_REQUIRECUSTOMERACCOUNT', 1);
    Configuration::updateValue('ROJA45_PRODUCTRENTAL_SHOWCARTSUMMARY', 0);
    Configuration::updateValue('PS_HOME_CATEGORY', 2);
    $module->registerHook('displayProductAdditionalInfo');
    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
