<?php
/**
 * upgrade_module_1_5_7.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_7
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_7.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_7($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_pricerule` (
          `id_roja45_product_pricerule` int(10) unsigned NOT NULL auto_increment,
          `name` varchar(255) NOT NULL,
          `enabled` tinyint(1),
          `date_add` datetime,
          `date_upd` datetime,
          PRIMARY KEY (`id_roja45_product_pricerule`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleconditiongroup` (
          `id_roja45_product_priceruleconditiongroup` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
          PRIMARY KEY (`id_roja45_product_priceruleconditiongroup`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_pricerulecondition` (
          `id_roja45_product_pricerulecondition` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_priceruleconditiongroup` int(10) unsigned NOT NULL,
          `type` varchar(255) NOT NULL,
          `value` varchar(255),
          PRIMARY KEY (`id_roja45_product_pricerulecondition`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofile` (
          `id_roja45_product_priceruleprofile` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
          `position` varchar(255) NOT NULL,
          PRIMARY KEY (`id_roja45_product_priceruleprofile`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_priceruleprofileday` (
          `id_roja45_product_priceruleprofile` int(10) unsigned NOT NULL,
          `day` int(10) NOT NULL,
          `value` int(10) NOT NULL,
          PRIMARY KEY (`id_roja45_product_priceruleprofile`, `day`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $sql = '
        CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'roja45_productrental_productpricerule` (
          `id_roja45_product_productpricerule` int(10) unsigned NOT NULL auto_increment,
          `id_roja45_product` int(10) unsigned NOT NULL,
          `id_roja45_product_pricerule` int(10) unsigned NOT NULL,
          PRIMARY KEY (`id_roja45_product_productpricerule`)
        ) ENGINE=`' . _MYSQL_ENGINE_ . '` DEFAULT CHARSET=UTF8;';
    $return &= (bool)Db::getInstance()->execute($sql);

    $list_fields = Db::getInstance()->executeS(
        'SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_workingday`'
    );
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'allow_rentals') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_workingday` ADD `allow_rentals` TINYINT(1)';
        $return &= Db::getInstance()->execute($sql);
    }

    foreach (ProductRentalWorkingDay::getDays() as $working_day) {
        $working_day = new ProductRentalWorkingDay($working_day['id_roja45_product_rental_workingday']);
        $working_day->allow_rentals = $working_day->is_working_day;
        $working_day->save();
    }

    $id_catalog_menu = Tab::getIdFromClassName('AdminParentAdminProductRental');
    $id_tab = Tab::getIdFromClassName('RentalPriceRules');
    if (!$id_tab) {
        $tab = new Tab();
        $tab->active = 1;
        $tab->class_name = 'RentalPriceRules';
        $tab->id_parent = $id_catalog_menu;
        $tab->module = $module->name;
        $tab->icon = 'playlist_add_check';
        $tab->name = array();
        foreach (Language::getLanguages(true) as $lang) {
            $tab->name[$lang['id_lang']] = RojaFortyFiveProductRentalCore::getLocalTranslation(
                $module,
                'RentalPriceRules17',
                $lang
            );
        }
        $tab->add();
    }

    Tools::error_log('Finished Upgrading: '.$module->name.' : '. __FUNCTION__);
    return $return;
}
