<?php
/**
 * upgrade_module_1_5_9.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  upgrade_module_1_5_9
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

/**
 * upgrade_module_1_5_9.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 * @category  Function
 *
 * 2016 ROJA45.COM - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_5_9($module)
{
    Tools::error_log('Upgrading: '.$module->name.' : '. __FUNCTION__);
    $return = true;

    $list_fields = Db::getInstance()->executeS(
        'SHOW FIELDS FROM `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel`'
    );
    $add_tables = true;
    foreach ($list_fields as $field) {
        if ($field['Field'] == 'damage_deposit_inc') {
            $add_tables = false;
        }
    }
    if ($add_tables) {
        $sql = 'ALTER TABLE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` ADD `damage_deposit_inc` DOUBLE(20,6)';
        $return &= Db::getInstance()->execute($sql);
    }
    $sql = 'UPDATE `' . _DB_PREFIX_ . 'roja45_productrental_rentalmodel` SET `damage_deposit_inc` = `damage_deposit`';
    $return &= Db::getInstance()->execute($sql);

    $def_states = array(
        array(
            'code' => ProductRentalRentalStatus::$CCLR,
            'color' => '#f75553',
            'unremovable' => 1,
            'send_email' => 1,
            'notify_admin' => 1,
            'block_calendar' => 1,
            'record_history' => 1,
            'available_customer' => 1,
            'answer_template' => 'cancellation_requested'
        )
    );

    foreach ($def_states as $state) {
        $return &= Db::getInstance()->insert(
            'roja45_productrental_rentalstatus',
            array(
                'color' => pSQL($state['color']),
                'code' => pSQL($state['code']),
                'unremovable' => (int)$state['unremovable'],
                'send_email' => (int)$state['send_email'],
                'notify_admin' => (int)$state['notify_admin'],
                'block_calendar' => (int)$state['block_calendar'],
                'record_history' => (int)$state['record_history'],
                'customer_account' => (int)$state['available_customer'],
                'answer_template' => pSQL($state['answer_template']),
            )
        );
        $id_status = Db::getInstance()->Insert_ID();
        foreach (Language::getLanguages(true) as $language) {
            $return &= Db::getInstance()->insert(
                'roja45_productrental_rentalstatus_lang',
                array(
                    'id_roja45_product_rental_status' => (int)$id_status,
                    'id_lang' => (int)$language['id_lang'],
                    'status' => pSQL(RojaFortyFiveProductRentalCore::getLocalTranslation(
                        $module,
                        $state['code'],
                        $language
                    )),
                )
            );
        }
    }

    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
        $module->unregisterHook('displayProductButtons');
        $module->registerHook('displayProductAdditionalInfo');
    }
    if (version_compare(_PS_VERSION_, '1.7', '>=') == true) {
        $module->registerHook('actionEmailSendBefore');
    }

    return $return;
}
