/**
 * roja45productrental.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

var roja45productrental = (function (my) {
    my.rental_convertButton = function (button) {
        var id = null;
        if (button.data('id-product')) {
            id = button.data('id-product');
        } else {
            id = $('#product_page_product_id').val();
        }

        if (typeof roja45_rentable_products[id] != 'undefined') {
            button.removeClass('ajax_add_to_cart_button').addClass('ajax_rent_now_button');
            button.attr('href', button.parent().find('.button.lnk_view').attr('href'));
            button.html('<span>'+roja45_button_text+'</span>');
        }
    };

    my.toggleWaitDialog = function () {
        if (typeof toggleRoja45GlobalWaitDialog === "function") {
            toggleRoja45GlobalWaitDialog();
        } else {
            if ($('#immersive-modal-dialog').is(':visible')) {
                $('#immersive-modal-dialog').fadeOut();
            } else {
                $('#immersive-modal-dialog').fadeIn();
            }
        }
    };

    my.checkDateAvailable = function(dateToCheck) {
        var day = (dateToCheck.getDay()+1);

        if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
            $returnclass = "unavailable non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = false;
            return [$return, $returnclass, $returntooltip];
        } else if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
            $returnclass = "available non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = true;
            return [$return, $returnclass, $returntooltip];
        } else {
            return [true, 'available', roja45_productrental_calendar_tooltip_num_available];
        }
    };

    return my;
}(roja45productrental || {}));

$(document).ready(function () {
    Date.prototype.addDays = function (days) {
        var dat = new Date(this.valueOf());
        dat.setDate(dat.getDate() + days);
        return dat;
    };

    prestashop.on(
        'updateProductList',
        function (event) {
            $(roja45_productrental_selector_productlistitem + ' .roja45productrental.product.enabled').each(function (index, element) {
                if (roja45_productrental_showrentallabel) {
                    var ele = $(this).closest('article');
                    ele.find('ul.product-flags').append('<li class="product-flag rental">' + roja45productrental_rental_link_text + '</li>');
                }
            });
        }
    );

    $(window).on('show.bs.modal', function(ele) {
        var ele = $('div.quickview .roja45productrental_block');
        ele.closest('div.quickview').find('.product-add-to-cart').hide();
        var block = ele.closest('div.quickview').find('#roja45productrental_block_17');
        ele.closest('div.quickview').find('#add-to-cart-or-refresh').append(block);
        ele.closest('div.quickview').find('#add-to-cart-or-refresh').attr('action', roja45_rental_controller);
        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker({
            dateFormat: roja45_productrental_dateformat,
        });
        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker({
            dateFormat: roja45_productrental_dateformat,
        });
        if (roja45_productrental_enabletimeselect) {
            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker({
                timeFormat: roja45_productrental_timeformat,
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: roja45_productrental_timestep,
            });
            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker({
                timeFormat: roja45_productrental_timeformat,
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: roja45_productrental_timestep,
            });
        }
        $('#rental_quantity_wanted').TouchSpin({
            verticalbuttons: true,
            verticalupclass: 'material-icons touchspin-up',
            verticaldownclass: 'material-icons touchspin-down',
            buttondown_class: 'btn btn-touchspin js-touchspin',
            buttonup_class: 'btn btn-touchspin js-touchspin',
            min: 1,
            max: $(this).attr('max'),
        });
        $('#roja45productrental_loading_dialog').fadeOut();
    });

    $(window).on('shown.bs.modal', function(ele) {
        var here = '';
    });

    $(window).on('loaded.bs.modal', function(ele) {
        var here = '';
    });

    $(roja45_productrental_selector_productlistitem + ' .roja45productrental.product.enabled').each(function (index, element) {
        if (roja45_productrental_showrentallabel) {
            var ele = $(this).closest('article');
            ele.find('ul.product-flags').append('<li class="product-flag rental">' + roja45productrental_rental_link_text + '</li>');
        }
    });

    $('li .product-container .roja45productrental.product.enabled').each(function (index, element) {
        var id_product = parseInt($(this).attr('data-id-product'));
        var button = $(this).closest('.product-container').find('.button.ajax_add_to_cart_button');
        if (id_product  && roja45_productrental_showrentallabel) {
            var url = button.closest('.ajax_block_product').find('.product_img_link').attr('href');
            button.closest('.ajax_block_product').find('.product-image-container').append('<a class="rental-box rental-box-bottom-right" href="' + url + '"><span class="rental-label">' + roja45productrental_rental_link_text + '</span></a>');
        }
    });

    $('#add_to_cart button').each(function (index, element) {
        $(document).off('click', '#add_to_cart button');
        roja45productrental.rental_convertButton($(this));
    });
    $('.ajax_add_to_cart_button').each(function (index, element) {
        roja45productrental.rental_convertButton($(this));
    });

    if ($('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').length > 0) {
        var minDate = new Date();
        minDate = minDate.addDays(parseInt(roja45_productrental_preparationdays));
        $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker({
            minDate: minDate,
            changeMonth: true,
            changeYear: true,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 1,
            showButtonPanel: true,
            onClose: function (selectedDate, obj) {
                var selectedDate = $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                var day = (selectedDate.getDay()+1);
                $('.roja45productrental-search-bar-messages.collection').slideUp('fast', function() {
                    if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
                        if ($('.roja45productrental-search-bar-messages.collection').is(":hidden")) {
                            $('.roja45productrental-search-bar-messages.collection').slideDown();
                        }
                    }
                });

                var returnDate = $(this).datepicker('getDate', roja45_productrental_minimumduration + 'd');
                if (typeof returnDate !== "undefined" && returnDate) {
                    returnDate.setDate(returnDate.getDate() + parseInt(roja45_productrental_minimumduration));
                    $(this).closest('form').find($('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]')).datepicker('setDate', returnDate);
                }
                $(this).closest('form').find($('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]')).datepicker('option', "minDate", returnDate);
                $(this).closest('form').find($('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]')).datepicker("show");
            },
            beforeShowDay: function (selectedDate) {
                return roja45productrental.checkDateAvailable(
                    selectedDate
                );
            }
        });
    }

    if ($('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').length > 0) {
        var minDate = new Date();
        minDate = minDate.addDays(parseInt(roja45_productrental_preparationdays));

        $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker({
            minDate: minDate,
            changeMonth: true,
            changeYear: true,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 1,
            showButtonPanel: true,
            onSelect: function(selectedDate, obj) {
                var selectedDate = $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('getDate');
                var day = (selectedDate.getDay()+1);
                $('.roja45productrental-search-bar-messages.return').slideUp('fast', function() {
                    if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
                        if ($('.roja45productrental-search-bar-messages.return').is(":hidden")) {
                            $('.roja45productrental-search-bar-messages.return').slideDown();
                        }
                    }
                });
            },
            beforeShowDay: function (selectedDate) {
                return roja45productrental.checkDateAvailable(
                    selectedDate
                );
            }
        });

        if (roja45_productrental_enabletimeselect) {
            $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker({
                timeFormat: roja45_productrental_timeformat,
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: roja45_productrental_timestep
            });
            $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker({
                timeFormat: roja45_productrental_timeformat,
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: roja45_productrental_timestep,
            });
            var collectionDate = $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
            if (collectionDate != 'undefined' && collectionDate) {
                var day = collectionDate.getDay()+1;
                var opening_time = roja45_working_days[day]['opening_time'];
                var closing_time = roja45_working_days[day]['closing_time'];
                var res = collectionDate.toISOString().slice(0, 10);
                opening_time = new Date(Date.parse(res + 'T' + opening_time));
                closing_time = new Date(Date.parse(res + 'T' + closing_time));
                $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));

                $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                $('#roja45productrental_search_form input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
            }
        }
    }

    $('.btn-number-spinner').each(function(index, value) {
        var min_value = parseInt($(this).closest('.table-row').attr('data-field-min-value'));
        var current_value = parseInt($(this).closest('.table-row').attr('data-field-current-value'));
        if (current_value > min_value) {
            $(this).removeClass('disabled');
            $(this).removeAttr('disabled');
        }
    });

    $(document).on('click', '.spinner-container .increment .btn.btn-number-spinner', function (e) {
        e.preventDefault();
        var fieldName = $(this).closest('.table-row').attr('data-field-name');
        var current = parseInt($(this).closest('form').find('input[name=' + fieldName + ']').val());
        var maxValue = parseInt($(this).closest('.table-row').attr('data-field-max-value'));
        if (!isNaN(current)) {
            current = current+1;
            if (maxValue>-1) {
                if (current < maxValue) {
                    $(this).closest('form').find('input[name=' + fieldName + ']').val(current);
                    $(this).closest('.table-row').find('.table-cell.value span').html(current);
                }
            } else {
                $(this).closest('form').find('input[name=' + fieldName + ']').val(current);
                $(this).closest('.table-row').find('.table-cell.value span').html(current);
            }
            $(this).closest('.table-row').find('.decrement .btn.btn-number-spinner').removeClass('disabled');
            $(this).closest('.table-row').find('.decrement .btn.btn-number-spinner').removeAttr('disabled');
        }
    });

    $(document).on('click', '.spinner-container .decrement .btn.btn-number-spinner', function (e) {
        e.preventDefault();
        var fieldName = $(this).closest('.table-row').attr('data-field-name');
        var current = parseInt($(this).closest('form').find('input[name=' + fieldName + ']').val());
        var min_value = parseInt($(this).closest('.table-row').attr('data-field-min-value'));
        if (!isNaN(current)) {
            current = current-1;
            if (current>min_value) {
                $(this).closest('form').find('input[name=' + fieldName + ']').val(current);
                $(this).closest('.table-row').find('.table-cell.value span').html(current);
            }

            if (current==min_value) {
                $(this).closest('form').find('input[name=' + fieldName + ']').val(current);
                $(this).closest('.table-row').find('.table-cell.value span').html(current);
                $(this).closest('.table-row').find('.decrement .btn.btn-number-spinner').addClass('disabled');
                $(this).closest('.table-row').find('.decrement .btn.btn-number-spinner').attr('disabled');
            }
        }
    });

    $(document).click(function (e) {
        if ($('.dropdown dd ul').is(':visible')) {
            $('.dropdown dd ul').slideUp();
            $('.dropdown').removeClass('active');
        }
    });

    $('#ROJA45_PRODUCTRENTAL_QTY').TouchSpin({
        verticalbuttons: true,
        verticalupclass: 'material-icons touchspin-up',
        verticaldownclass: 'material-icons touchspin-down',
        buttondown_class: 'btn btn-touchspin js-touchspin',
        buttonup_class: 'btn btn-touchspin js-touchspin',
        min: 1,
        max: $('#ROJA45_PRODUCTRENTAL_QTY').attr('max'),
    });

    $('.remove-from-cart[data-id-product='+roja45_productrental_idproductdeposit+']').hide();
    $('input[data-product-id='+roja45_productrental_idproductdeposit+']').closest('.input-group').hide();

    if ($('#order-confirmation .page-order-confirmation').length) {
        $('#order-confirmation .page-order-confirmation').hide();
    }

    $('#roja45_productrental_addresses #use_same_address').on('click', function(e) {
        if($(this).prop('checked') == true){
            $('#collection_address').hide();
        } else {
            $('#collection_address').show();
        }
    });

    $('#roja45_productrental_addresses button[name=save-addresses]').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        button.removeClass('saving saved error-saving');
        $.ajax({
            url: $(this).closest('form').attr('action'),
            type: 'post',
            dataType: 'json',
            data: $(this).closest('form').serialize(),
            beforeSend: function () {
                $('#rental_address_overlay').show();
                button.addClass('saving disabled');
            },
            success: function (data) {
                if (data.result) {
                    button.removeClass('saving');
                    button.addClass('saved');
                    $('#roja45_productrental_addresses input[name=id_delivery_address]').val(data.id_delivery_address);
                    $('#roja45_productrental_addresses input[name=id_collection_address]').val(data.id_collection_address);
                    $('#addresses_saved').show();
                } else {
                    button.addClass('error-saving');
                }
            },
            error: function (data) {
                button.addClass('error-saving');
            },
            complete: function (data) {
                $('#rental_address_overlay').hide();
                button.removeClass('disabled');
            }
        });
    });

    $('.btn-update-address').on('click', function(e) {
        e.preventDefault();
        var button = $(this);
        button.removeClass('saving saved error-saving');
        $.ajax({
            url: $(this).closest('form').attr('action'),
            type: 'post',
            dataType: 'json',
            data: $(this).closest('form').serialize(),
            beforeSend: function () {
                $('#rental_address_overlay').show();
                button.addClass('saving disabled');
            },
            success: function (data) {
                if (data.result) {
                    button.removeClass('saving');
                    button.addClass('saved');
                    $('#roja45_productrental_addresses input[name=id_delivery_address]').val(data.id_delivery_address);
                    $('#roja45_productrental_addresses input[name=id_collection_address]').val(data.id_collection_address);
                    $('#addresses_saved').show();
                } else {
                    button.addClass('error-saving');
                }
            },
            error: function (data) {
                button.addClass('error-saving');
            },
            complete: function (data) {
                $('#rental_address_overlay').hide();
                button.removeClass('disabled');
            }
        });
    });
});
