/**
 * roja45productrental_products.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */


$(document).ready(function () {
    calendar_object = null;
    prestashop.on(
        'updateProduct',
        function (event) {
            $('#roja45productrental_loading_dialog').show();
        }
    );

    prestashop.on(
        'updatedProduct',
        function (event) {
            $('#roja45productrental_loading_dialog').hide();
            var id_product_attribute = 0;
            if (typeof event != 'undefined') {
                id_product_attribute = event.id_product_attribute;
                $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val(id_product_attribute);
            }

            var product = JSON.parse($('#product-details').attr('data-product'));
            if (parseInt(roja45_productrental_usecombintionqty)>0) {
                $('input[name=ROJA45_PRODUCTRENTAL_QTY_AVAILABLE]').val(product.quantity);
            }

            roja45productrentals.initFields();
            //if (parseInt(roja45_productrental_showlivetotal)) {
                roja45productrentals.getLiveTotal();
            //}
        }
    );

    if (typeof roja45_id_product_deposit != 'undefined' && roja45_id_product_deposit) {
        $.each($('#cart_block .products dt'), function (index, value) {
            var id = $(this).attr('data-id');
            var res = id.split('_');
            var id_product = res[3];
            if (id_product==roja45_id_product_deposit) {
                $(this).find('.remove_link').remove();
            }
        });
    }

    roja45_block_remaining = false;
    if (roja45_productrental_usejs) {
        $('body').addClass('roja45-rental-product');

        if ($('#roja45productrental_block_17').closest(roja45_productrental_selector_productpageaddtocartform).length == 0) {
            $('#roja45productrental_block_17').appendTo(roja45_productrental_selector_productpageaddtocartform);
        }
    }

    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var id = $(e.target).attr('href');
        if (id == '#extra-0') {
            e.preventDefault();
            var start_date = $('.rental-content-calendar-container').attr('data-start-date');
            var number_days = $('.rental-content-calendar-container').attr('data-days');
            var page = $('input[name=page]').val();
            roja45productrentals.loadCalendar(start_date, 0);
        }
    });

    $('.rate-heading').tooltip();

    $('a.rates-link').on('click', function (e) {
        e.preventDefault();
        var target = $(this).attr('href');
        $('body').scrollTo(target, {duration: 'slow', offsetTop: '100', easing: 'swing'});
    });

    roja45productrentals.initFields();

    $('#roja45productrental_loading_dialog').fadeOut();

    $(document).on('click', '.btn-prev', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        roja45productrentals.loadCalendar(start_date, -1);
    });

    $(document).on('click', '.btn-today', function(e) {
        e.preventDefault();
        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth()+1;
        var yyyy = today.getFullYear();
        roja45productrentals.loadCalendar(yyyy+'-'+mm+'-'+dd, 0);
    });

    $(document).on('click', '.btn-next', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        roja45productrentals.loadCalendar(start_date, 1);
    });
});

var roja45productrentals = (function (my) {
    my.initFields = function() {
        $('.btn-availability').on('click', function(e) {
            e.preventDefault();
            $('#roja45productrental_message_block').slideUp();
            if (roja45productrentals.validateProductPageFields(e)) {
                $(this).closest('form').attr('action', controller + '&getAvailability=1');
                $(this).closest('form').submit();
            }
        });

        $('#rental_quantity_wanted').on('change', function(e) {
            e.preventDefault();
            $('#roja45productrental_message_block').slideUp();
            //if (parseInt(roja45_productrental_showlivetotal)) {
                roja45productrentals.getLiveTotal();
            //}
        });

        var minimum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val());
        var maximum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION]').val());
        var controller = $('input[name=ROJA45_PRODUCTRENTAL_CONTROLLER_URL]').val();

        if ($('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').length > 0) {
            var minDate = new Date();
            minDate = minDate.addDays(parseInt(roja45_productrental_preparationdays));
            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker({
                minDate: minDate,
                changeMonth: false,
                changeYear: false,
                dateFormat: roja45_productrental_dateformat,
                numberOfMonths: 2,
                showButtonPanel: false,
                firstDay: parseInt(roja45productrental_start_day),
                onClose: function (selectedDate, obj) {
                    var period = roja45_productrental_rateperiods[$('input[name=ROJA45_PRODUCTRENTAL_RATEPERIOD]').val()];
                    if (period['period']=='DAY') {
                        // TODO set collection time min/max based on day
                        var collectionDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                        if (typeof collectionDate !== "undefined" && collectionDate) {
                            var collection_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
                            var departureDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                            departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                            var day = departureDate.getDay()+1;

                            $('.roja45productrental-form-messages.collection').slideUp('fast', function() {
                                var collectionDay = collectionDate.getDay()+1;
                                if (roja45_working_days[collectionDay]['working_day']=='0' && roja45_working_days[collectionDay]['allow_rentals']=='1') {
                                    if ($('.roja45productrental-form-messages.collection').is(":hidden")) {
                                        $('.roja45productrental-form-messages.collection').slideDown();
                                    }
                                }
                            });

                            var opening_time = roja45_working_days[day]['opening_time'];
                            var closing_time = roja45_working_days[day]['closing_time'];

                            var checkdate = $.datepicker.formatDate('yy-mm-dd', collectionDate);
                            var id_combination = $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
                            if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                                opening_time = roja45_rentals[id_combination]['dates'][checkdate]['time'];
                            }

                            var res = departureDate.toISOString().slice(0,10);
                            opening_time = new Date(Date.parse(res + 'T' + opening_time));
                            closing_time = new Date(Date.parse(res + 'T' + closing_time));
                            // $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                            // $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                            // $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val(collection_time);

                            departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                            var day = (departureDate.getDay()+1);

                            if (roja45_working_days[day]['working_day']=='0') {
                                var not_found = true;
                                var days_to_add = 1;
                                while (not_found) {
                                    if (day==7) {
                                        day = 1;
                                    } else {
                                        day++;
                                    }
                                    if (roja45_working_days[day]['working_day']=='1') {
                                        not_found = false;
                                        departureDate.setDate(departureDate.getDate()+parseInt(days_to_add));
                                    } else {
                                        days_to_add++;
                                    }
                                }
                            }

                            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                            //if (parseInt(roja45_productrental_showlivetotal)) {
                                roja45productrentals.getLiveTotal();
                            //}
                            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker("show");
                        }
                    } else if(period['period']=='WEEK') {
                        // TODO - define whether daya to day, arbitary, restrict to 7 day blocks, etc
                    } else if (period['period']=='MONTH') {

                    } else if (period['period']=='CUSTOM') {
                        var departureDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate', minimum_duration+'d');
                        if (typeof departureDate !== "undefined" && departureDate) {
                            departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                        }
                    }
                    if (roja45_productrental_enabletimeselect) {
                    } else {
                        if (departureDate != null && maximum_duration==0) {
                        }
                    }
                },
                beforeShow: function () {
                    roja45_block_remaining = false;
                },
                beforeShowDay: function (d) {
                    return roja45productrentals.checkDateAvailable(
                        d,
                        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate'),
                        true,
                        minimum_duration,
                        maximum_duration
                    );
                }
            });
            if (roja45_productrental_enabletimeselect) {
                $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker({
                    timeFormat: roja45_productrental_timeformat,
                    controlType: 'select',
                    oneLine: true,
                    stepHour: 1,
                    stepMinute: roja45_productrental_timestep,
                    showButtonPanel: false,
                    onSelect: function (obj) {
                        //if (parseInt(roja45_productrental_showlivetotal)) {
                            roja45productrentals.getLiveTotal();
                        //}
                        $(this).datepicker('hide');
                    }
                });
                var collectionDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                if (collectionDate != 'undefined' && collectionDate) {
                    var collection_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
                    var day = collectionDate.getDay()+1;
                    var opening_time = roja45_working_days[day]['opening_time'];
                    var closing_time = roja45_working_days[day]['closing_time'];
                    var res = collectionDate.toISOString().slice(0, 10);
                    opening_time = new Date(Date.parse(res + 'T' + opening_time));
                    closing_time = new Date(Date.parse(res + 'T' + closing_time));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val(roja45_productrental_collectionafter);
                }
            }

            $('.roja45productrental_block .cal-arrival .input-group-addon').on('click', function(e) {
                $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker("show");
            });
            $('.roja45productrental_block .cal-departure .input-group-addon').on('click', function(e) {
                $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker("show");
            });
        }

        if ($('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').length > 0) {
            $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker({
                changeMonth: false,
                changeYear: false,
                dateFormat: roja45_productrental_dateformat,
                numberOfMonths: 2,
                showButtonPanel: false,
                firstDay: parseInt(roja45productrental_start_day),
                onSelect: function (selectedDate, obj) {
                    var departureDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('getDate');
                    if (typeof departureDate !== "undefined" && departureDate) {
                        var return_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();
                        var day = departureDate.getDay()+1;
                        $('.roja45productrental-form-messages.return').slideUp('fast', function () {
                            if (roja45_working_days[day]['working_day'] == '0' && roja45_working_days[day]['allow_rentals'] == '1') {
                                if ($('.roja45productrental-form-messages.return').is(":hidden")) {
                                    $('.roja45productrental-form-messages.return').slideDown();
                                }
                            }
                        });

                        var opening_time = roja45_working_days[day]['opening_time'];
                        var closing_time = roja45_working_days[day]['closing_time'];

                        var checkdate = $.datepicker.formatDate('yy-mm-dd', departureDate);
                        var id_combination = $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
                        if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                            closing_time = roja45_rentals[id_combination]['dates'][checkdate]['time'];
                        }

                        var departureDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                        var res = departureDate.toISOString().slice(0, 10);
                        opening_time = new Date(Date.parse(res + 'T' + opening_time));
                        closing_time = new Date(Date.parse(res + 'T' + closing_time));

                        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val(return_time);
                    }
                    //if (parseInt(roja45_productrental_showlivetotal)) {
                        roja45productrentals.getLiveTotal();
                    //}
                },
                beforeShow: function () {
                    var dt = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker( 'getDate' );
                    roja45_block_remaining = false;
                    return { minDate: dt };
                },
                beforeShowDay: function (d) {
                    return roja45productrentals.checkDateAvailable(
                        d,
                        $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate'),
                        false,
                        minimum_duration,
                        maximum_duration
                    );
                }
            });

            if (typeof roja45_productrental_enabletimeselect != 'undefined' || roja45_productrental_enabletimeselect) {
                $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker({
                    timeFormat: roja45_productrental_timeformat,
                    controlType: 'select',
                    oneLine: true,
                    stepHour: 1,
                    stepMinute: roja45_productrental_timestep,
                    showButtonPanel: false,
                    onSelect: function (obj) {
                        //if (parseInt(roja45_productrental_showlivetotal)) {
                            roja45productrentals.getLiveTotal();
                        //}
                        $(this).datepicker('hide');
                    }
                });

                var departureDate = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('getDate');
                if (departureDate != 'undefined' && departureDate) {
                    var return_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();
                    var day = departureDate.getDay()+1;
                    var opening_time = roja45_working_days[day]['opening_time'];
                    var closing_time = roja45_working_days[day]['closing_time'];
                    var res = departureDate.toISOString().slice(0, 10);
                    opening_time = new Date(Date.parse(res + 'T' + opening_time));
                    closing_time = new Date(Date.parse(res + 'T' + closing_time));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                    $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val(roja45_productrental_returnbefore);
                }
            }
        }

        $('#rental_quantity_wanted').TouchSpin({
            verticalbuttons: true,
            verticalupclass: 'material-icons touchspin-up',
            verticaldownclass: 'material-icons touchspin-down',
            buttondown_class: 'btn btn-touchspin js-touchspin',
            buttonup_class: 'btn btn-touchspin js-touchspin',
            min: 1,
            max: 1000000
        });

        //if (parseInt(roja45_productrental_showlivetotal)) {
            roja45productrentals.getLiveTotal();
        //}
    };

    my.getLiveTotal = function() {
        var id_product = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT]').val();
        var id_product_attribute = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
        var id_roja45_product_rateduration = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RATE_DURATION]').val();
        var qty = $('#roja45productrental_block_17 input[name=qty]').val();
        var collection_date = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').val();
        var collection_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
        var return_date = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').val();
        var return_time = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();

        var rental_details = {
            id_roja45_product_rateduration : id_roja45_product_rateduration,
            products : [{
                id_product: id_product,
                id_product_attribute: id_product_attribute,
                qty: qty,
                collection_date: collection_date,
                collection_time: collection_time,
                return_date: return_date,
                return_time: return_time,
            }]
        };
        var valid = true;

        if (valid) {
            $('#roja45productrental_liveprice .live_price_display').remove();
            $.ajax({
                url: roja45_rental_controller,
                type: 'get',
                dataType: 'json',
                data: {
                    'action' : 'getLivePrice',
                    'ajax' : 1,
                    'rental_details' : JSON.stringify(rental_details)
                },
                beforeSend: function () {

                    // if ($('#roja45productrental_liveprice:visible').length) {
                    //     $('#roja45productrental_liveprice .live_price_display').fadeOut('fast', function(e) {
                    //         $('#roja45productrental_liveprice .waiting').fadeIn();
                    //         $('#roja45productrental_liveprice .live_price_display').remove();
                    //     });
                    // } else {
                    //     $('#roja45productrental_liveprice').slideUp('fast', function(e) {
                    //         $('#roja45productrental_liveprice .live_price_display').remove();
                    //     });
                    // }
                },
                success: function (data) {
                    console.log(data.result);
                    if (data.result) {
                        $('#roja45productrental_liveprice .live_price_display').remove();
                        $('#roja45productrental_liveprice').append(data.view);
                        if ($('#roja45productrental_liveprice:visible').length) {
                            $('#roja45productrental_liveprice .waiting').fadeOut('fast', function(e) {
                                $('#roja45productrental_liveprice .live_price_display').fadeIn();
                            });
                        } else {
                            $('#roja45productrental_liveprice .live_price_display').show();
                            $('#roja45productrental_liveprice').fadeIn('fast');
                        }
                    } else if (data.errors) {
                        $('#roja45productrental_liveprice').fadeOut('fast', function(e) {
                            $('#roja45productrental_liveprice .live_price_display').remove();
                            $('#roja45productrental_liveprice .waiting').hide();

                            $('#roja45productrental_liveprice_errors').fadeIn('fast');
                        });
                    } else {
                        $('#roja45productrental_liveprice').fadeOut('fast', function(e) {
                            $('#roja45productrental_liveprice .live_price_display').remove();
                            $('#roja45productrental_liveprice .waiting').hide();
                        });
                    }
                },
                error: function (data) {
                    console.log('here');
                },
                complete: function (data) {
                    //roja45propertymanager.togglePricesWaitDialog();
                }
            });
        }
    };

    my.validateProductPageFields = function(e) {
        var validationErrors = [];
        var arrival_date = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').val();

        if (arrival_date.length == 0) {
            validationErrors.push(roja45_productrental_collection_date_error);
        }

        var departure_date = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').val();
        if (departure_date.length == 0) {
            validationErrors.push(roja45_productrental_return_date_error);
        }

        if (parseInt($('input[name=ROJA45_PRODUCTRENTAL_QTY_AVAILABLE]').val())<parseInt($('#rental_quantity_wanted').val())) {
            validationErrors.push(roja45_productrental_insufficent_qty);
        }

        // get days
        if (validationErrors.length > 0) {
            e.preventDefault();
            roja45productrentals.displayErrors(validationErrors);
            return false;
        }
        $('.roja45productrental_block').addClass('loading');
        $('.roja45productrental_block .btn-availability').addClass('disabled');

        return true;
    };

    my.checkDateAvailable = function(dateToCheck, arrivalDate, arrival, minimum_duration, maximum_duration) {
        if (!arrival) {
            var collection_date = $('#roja45productrental_block_17 input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
            if (collection_date) {
                if (minimum_duration) {
                    var minimum_date = roja45productrentals.addDays(collection_date, minimum_duration-1);
                    if (!roja45productrentals.dateCompare(minimum_date, dateToCheck)) {
                        $returnclass = "unavailable minimum-duration";
                        $returntooltip = roja45_productrental_calendar_tooltip_minduration;
                        $return = false;
                        return [$return, $returnclass, $returntooltip];
                    }
                }
                if (maximum_duration) {
                    var maximum_date = roja45productrentals.addDays(collection_date, maximum_duration);
                    if (roja45productrentals.dateCompare(maximum_date, dateToCheck)) {
                        $returnclass = "unavailable maximum-duration";
                        $returntooltip = roja45_productrental_calendar_tooltip_maxduration;
                        $return = false;
                        return [$return, $returnclass, $returntooltip];
                    }
                }
            }
        }

        var $return = true;
        var $returnclass = "available";
        if (parseInt(roja45_productrental_usecombintionqty)>0) {
            var id_combination = $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
        } else {
            var id_combination = 'all';
        }

        var $returntooltip = roja45_rentals[id_combination]['total_available'] + ' ' + roja45_productrental_calendar_tooltip_num_available;
        var day = (dateToCheck.getDay()+1);

        if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
            $returnclass = "unavailable non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = false;
            //return [$return, $returnclass, $returntooltip];
        } else if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
            $returnclass = "non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = true;
            //return [$return, $returnclass, $returntooltip];
        }

        if (roja45_productrental_calendaravailability==1) {
            if (!arrival && (roja45productrentals.dateCompare(dateToCheck, arrivalDate))) {
                $returnclass = "unavailable before-arrival";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }

            if (roja45_block_remaining) {
                $returnclass = "unavailable no-consecutive";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }
            var checkdate = $.datepicker.formatDate('yy-mm-dd', dateToCheck);
            var available = parseInt(roja45_rentals[id_combination]['total_available']);

            if (available==0) {
                $returnclass = "unavailable no-consecutive";
                $returntooltip = available + ' ' + roja45_productrental_calendar_tooltip_num_available;;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }
            if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                if (typeof roja45_rentals[id_combination]['dates'][checkdate]['unavailable'] != 'undefined' && roja45_rentals[id_combination]['dates'][checkdate]['unavailable']==1) {
                    $returnclass = "unavailable";
                    $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                    $return = false;
                    return [$return, $returnclass, $returntooltip];
                }

                var rentals = roja45_rentals[id_combination]['dates'][checkdate];
                var diff = available - rentals['count'];
                var type = rentals['type'];

                if (type==1) {
                    // Reservable as end date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "unavailable";
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_checkout_only;
                            $return = true;
                            $returnclass = "available-departure";
                            roja45_block_remaining = true;
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==2) {
                    // Reserved
                    if (diff <= 0) {
                        $return = false;
                        $returnclass = "unavailable";
                        $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass =  "available has-reservations ";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available ";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==3) {
                    // Reservable as start date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "available-arrival";
                            $returntooltip = roja45_productrental_calendar_tooltip_checkin_only + ' ' +roja45_rentals[id_combination]['dates'][checkdate]['time'];
                            $return = true;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                            $returnclass = "unavailable";
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1 && !arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff == 1 && arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else {
                        if (arrival) {
                            $returnclass = "available";
                            $returntooltip = roja45_productrental_calendar_tooltip_last;
                            $return = true;
                        }
                    }
                }
            }
        }

        return [$return, $returnclass, $returntooltip];
    };

    my.initialiseCalendar = function() {
        var container = $('.rental-content-calendar-container').width();
        var days = $('.rental-content-calendar-container').attr('data-days');
        var cell_width = container/days;

        $('.rental-content-calendar-container-columns').width(container);
        $('.rental-content-calendar-container-navigation').width(container);
        $('.rental-content-calendar-container-dates').width(container);
        $('.rental-content-calendar-container-reservations').width(container);
        $('.rental-content-calendar-container-column').width(cell_width);

        //var calendar_container_off = $('.rental-content-calendar-container').offset();
        //$('.rental-content-calendar-container-dates').offset({ top: calendar_container_off.top, left: calendar_container_off.left });

        var period_start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var period_end_date = $('.rental-content-calendar-container').attr('data-end-date');

        var container = $('.rental-content-calendar-container').width();
        var days = $('.rental-content-calendar-container').attr('data-days');
        var cell_width = container / days;

        var dates = $('.rental-content-calendar-container-days .rental-content-calendar-container-column');
        var firstDate = moment($(dates[0]).attr('data-date'));
        var lastDate = moment($(dates[dates.length - 1]).attr('data-date'));

        var start = firstDate.month() + (firstDate.year() * 12);
        var end = lastDate.month() + (lastDate.year() * 12);

        for (var i = start; i <= end; i++) {
            var count = 0;
            var date, dateMonth, last;

            for (var j = 0; j < dates.length; j++) {
                date = moment($(dates[j]).attr('data-date'));
                dateMonth = date.month() + (date.year() * 12);

                if (dateMonth === i) {
                    count++;
                    last = moment($(dates[j]).attr('data-date'));
                }
            }

            var width = cell_width * count;
            var date_formatted = last.format('MMMM YYYY');
            $('.rental-content-calendar-container-header').append($('<div class="rental-content-calendar-container-header-item" style="width: ' + width + 'px;">' + date_formatted + '</div>'));
        }

        $('.rental-content-product-cell-row.rental-content-product-model').each(function () {
            var id_roja45_product = $(this).attr('data-id-roja45-product');
            var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');

            var rentals = $('.rental-content-rental-container[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
            if (rentals.length) {
                var position = $(this).offset();
                var ranges = [];
                var lines = 1;
                var height = $(this).outerHeight();
                rentals.each(function (index) {
                    var start_date = $(this).attr('data-start-date');
                    var t = start_date.split(/[-]/);
                    var start_date = new Date(t[0], t[1] - 1, t[2]);
                    var end_date = $(this).attr('data-end-date');
                    var t = end_date.split(/[-]/);
                    var end_date = new Date(t[0], t[1] - 1, t[2]);
                    var line = 0;
                    $.each(ranges, function(index, value) {
                        if (roja45productrentals.dateRangeOverlaps(start_date, end_date, value.start, value.end)) {
                            line++;
                            lines++;
                        }
                    });
                    ranges.push({
                        start: start_date,
                        end: end_date
                    });
                    var orig_offset = $(this).offset();
                    var number_of_days = roja45productrentals.dateDiffInDays(start_date, end_date);
                    var entry_height = $(this).outerHeight();
                    var diff = height - entry_height;
                    var top = position.top + (line * entry_height) + ((line + 1) * (diff / 2));
                    var diff = roja45productrentals.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-start-date')));
                    var leftOffset = (diff * cell_width) + (cell_width / 2);

                    $(this).offset({top: top, left: orig_offset.left + leftOffset});
                    $(this).width(number_of_days * cell_width);
                    $(this).css({opacity: 1});
                });

                $(this).outerHeight(height * lines);
                $('.rental-content-calendar-cell.day[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']').outerHeight(height * lines);
            }
        });

        var unavailables = $('.rental-content-unavailable-container');
        if (unavailables.length) {
            unavailables.each(function (index) {
                var height = $(this).outerHeight();
                var id_roja45_product = $(this).attr('data-id-roja45-product');
                var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');
                var start_date = $(this).attr('data-start-date');
                var end_date = $(this).attr('data-end-date');
                var t = start_date.split(/[-]/);
                var start_date = new Date(t[0], t[1] - 1, t[2]);
                var t = end_date.split(/[-]/);
                var end_date = new Date(t[0], t[1] - 1, t[2]);
                var number_of_days = roja45productrentals.dateDiffInDays(start_date, end_date);

                var row = $('.rental-content-calendar-cell[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
                var position = row.offset();

                var entry_height = $(this).outerHeight();
                var diff = height - entry_height;
                var top = position.top + (diff / 2) + 5;
                var orig_offset = $(this).offset();
                // difference between reservation start date and period start date
                var diff = roja45productrentals.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-start-date')));
                var leftOffset = (diff * cell_width) + (cell_width / 2);

                $(this).offset({top: top, left: orig_offset.left + leftOffset});
                // count reservations currently in the blck
                $(this).width(number_of_days * cell_width);
                $(this).css({opacity: 1});
            });
        }
    }

    my.dateDiffInDays = function(a, b) {
        var _MS_PER_DAY = 1000 * 60 * 60 * 24;
        var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
        var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

        return Math.floor((utc2 - utc1) / _MS_PER_DAY);
    }

    my.dateRangeOverlaps = function (a_start, a_end, b_start, b_end) {
        if (a_start <= b_start && b_start <= a_end) return true; // b starts in a
        if (a_start <= b_end   && b_end   <= a_end) return true; // b ends in a
        if (b_start <  a_start && a_end   <  b_end) return true; // a in b
        return false;
    }

    my.loadCalendar = function(start_date, offset) {
        $.ajax({
            url: roja45_rental_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'loadProductPageCalendar',
                'id_roja45_product' : $('input[name=ROJA45_PRODUCTRENTAL_ID]').val(),
                'ajax' : 1,
                'start_date' : start_date,
                'offset' : offset,
            },
            beforeSend: function () {
                $('#roja45_productrental_extracontent_calendar .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    $('#roja45_productrental_extracontent_calendar .content').empty().append(data.view);
                    roja45productrentals.initialiseCalendar();
                } else {
                }
            },
            error: function (data) {
            },
            complete: function (data) {
                $('#roja45_productrental_extracontent_calendar .rental-content-loading-overlay').hide();
            }
        });
    }

    my.addDays = function(date, days) {
        var updated_date = new Date(date.getTime());
        updated_date.setDate(updated_date.getDate() + days);
        return updated_date;
    },

    my.dateCompare = function (date1, date2) {
        return new Date(date2) > new Date(date1);
    };

    my.displayWarning = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    my.displayErrors = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    return my;
}(roja45productrentals || {}));
