/**
 * roja45productrental_order.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    $('input[name^=ROJA45_PRODUCTRENTAL_RENTALSENABLED_]').off('change').on('change', function (e) {
        var url = $(this).closest('.list-group-item').attr('data-controller');
        var id_roja45_product = $(this).closest('.list-group-item').attr('data-id-roja45-product');
        var href = url + '&action=updateEnabledStatus&ajax=1&id_roja45_product='+id_roja45_product+'&status='+$(this).val();
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (data) {
                roja45global.displaySuccessMsg(data.response);
            },
            complete: function () {
               roja45global.toggleModal();
            },
        });
    });

    roja45productrental.initialise();

    hideOtherLanguage(id_lang_default);

    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        if ($(this).attr('data-id') == 'roja45productrental_models_tab') {
           //roja45productrental.getModels();
        }
    });

});

var roja45productrental = {
    initialise : function ()
    {
        $('#roja45productrental_details_form').validate({});
        $('#roja45productrental_models_form').validate({});
        $('#roja45productrental_calendar_form').validate({});

        /**
         * Property Details
         */
        $('#ROJA45_PRODUCTRENTAL_COUNTRY').off('change').on('change', function (e) {
            var href = $('#roja45productrental_details_form').attr('action') + '&action=getStates&ajax=1&id_country=' + $('#ROJA45_PRODUCTRENTAL_COUNTRY').val();
            $.ajax({
                type: 'GET',
                url: href,
                cache: false,
                dataType: 'json',
                beforeSend : function() {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result) {
                        $('#ROJA45_PRODUCTRENTAL_STATE').empty();
                        $('#ROJA45_PRODUCTRENTAL_STATE').append('<option value="0" selected="selected">&nbsp;-&nbsp;</option>');
                        $.each(data.states, function (key, value) {
                            $('#ROJA45_PRODUCTRENTAL_STATE').append('<option value="' + value.id_state + '">' + value.name + '</option>');
                        });
                        $('#ROJA45_PRODUCTRENTAL_STATE').prop('disabled', false);
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function () {
                    roja45global.toggleModal();
                }
            });
        });

        $("#addRate").attr("disabled", "disabled");
        $(".updateProductModel, .updateCloseProductModel").attr("disabled", "disabled");

        $(document).on('click', '.submitDetails', function (e) {
            e.preventDefault();
            roja45productrental.submitDetails();
        });
        $(document).on('click', '.addModel', function (e) {
            e.preventDefault();
            roja45productrental.addModel();
        });
        $(document).on('click', '.editModel', function (e) {
            e.preventDefault();
            var id_roja45_product_model = $(this).closest('.rate-row').attr('data-id');
            roja45productrental.editModel(id_roja45_product_model);
        });
        $(document).on('click', '.duplicateModel', function (e) {
            e.preventDefault();
            roja45productrental.duplicateModel($(this));
        });
        $(document).on('click', '.deleteModel', function (e) {
            e.preventDefault();
            roja45productrental.deleteModel($(this));
        });
        $(document).on('click', '.updateSubmitProductRentalModelExtras', function (e) {
            e.preventDefault();
            roja45productrental.submitProductRentalModelExtras($(this))
        });
        $(document).on('click', 'ps-panel-footer-link[name=saveRate] a', function (e) {
            e.preventDefault();
            roja45productrental.submitProductModelRate($(this));
        });

        $(document).on('click', '.editRate', function (e) {
            e.preventDefault();
            roja45productrental.editProductModelRate($(this));
        });
        $(document).on('click', '.deleteRate', function (e) {
            e.preventDefault();
            roja45productrental.deleteProductModelRate($(this));
        });
        $(document).on('click', 'ps-panel-footer-link[name=addPeriodRate] a', function (e) {
            e.preventDefault();
            roja45productrental.submitProductPeriodRate($(this));
        });
        $(document).on('click', '.deletePeriodRate', function (e) {
            e.preventDefault();
            roja45productrental.deleteProductPeriodRate($(this));
        });

        $(document).on('change', 'select[name=ROJA45_PRODUCTRENTAL_PERIOD_ID]', function (e) {
            e.preventDefault();
            roja45productrental.updatePeriod($(this));
        }).trigger('change');

        $('input[name=ROJA45_PRODUCTRENTAL_COLLECTIONTIME]').timepicker(
            $.timepicker.regional[iso_user]
        );
        $('input[name=ROJA45_PRODUCTRENTAL_RETURNTIME]').timepicker(
            $.timepicker.regional[iso_user]
        );

    },

    initEditor : function() {
        tinySetup({
            editor_selector: "autoload_rte",
            setup: function (ed) {
                /*
                ed.on('init', function (ed) {
                    if (typeof ProductMultishop.load_tinymce[ed.target.id] != 'undefined') {
                        if (typeof ProductMultishop.load_tinymce[ed.target.id])
                            tinyMCE.get(ed.target.id).hide();
                        else
                            tinyMCE.get(ed.target.id).show();
                    }
                });
                */
                ed.on('keydown', function (ed, e) {
                    tinyMCE.triggerSave();
                    textarea = $('#' + tinymce.activeEditor.id);
                    var max = textarea.parent('div').find('span.counter').attr('data-max');
                    if (max != 'none') {
                        count = tinyMCE.activeEditor.getBody().textContent.length;
                        rest = max - count;
                        if (rest < 0)
                            textarea.parent('div').find('span.counter').html('<span style="color:red;">Maximum ' + max + ' characters : ' + rest + '</span>');
                        else
                            textarea.parent('div').find('span.counter').html(' ');
                    }
                });
            }
        });
    },

    submitDetails : function () {
        var href = $('#roja45productrental_details_form').attr('action') + '&action=submitProductDetails&ajax=1';
        tinyMCE.triggerSave();
        var data = $('#roja45productrental_details_form').serialize();

        $.ajax({
            url: href,
            type: 'post',
            dataType: 'json',
            data: data,
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (json) {
                if (json.result == 'success') {
                    roja45global.displaySuccessMsg(json.response);
                } else if (json.result == 'redirect') {
                    roja45global.displayErrorMsg(json.message);
                    window.location = json.route;
                } else if (json.result == 'error') {
                    $.each(json.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function (data) {
                roja45global.toggleModal();
            }
        });
    },

    addModel : function () {
        var href = $('#roja45productrental_models_form').attr('action') + '&action=addProductModel&ajax=1&id_roja45_product=' + $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result && (data.result == 'success')) {
                    roja45productrental.loadProductModelList(data.view);
                    roja45productrental.loadProductModelList(data.view);
                    roja45productrental.editModel(data.id_roja45_product_model);
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });

        $("#addRate").attr("disabled", false);
        $(".updateProductModel, .updateCloseProductModel").attr("disabled", false);
    },

    getModels : function (id_roja45_product)
    {
        var id_roja45_product = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var href = $('#roja45productrental_models_form').attr('action') + '&action=getModels&ajax=1&id_roja45_product=' + id_roja45_product;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result && (data.result == 'success')) {
                    $('#models_list').empty();
                    $('#models_list').append(data.html);
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                roja45global.displayErrorMsg(data.statusText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    editModel : function (id_roja45_product_model)
    {
        var id_roja45_product = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var id_product = $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val();
        var href = $('#roja45productrental_models_form').attr('action') + '&action=retrieveModel&ajax=1&id_roja45_product=' + id_roja45_product + '&id_roja45_product_model=' + id_roja45_product_model + '&id_product=' + id_product;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result && (data.result == 'success')) {
                    $('#roja45productrental_model_container').empty();
                    $('#roja45productrental_model_container').append(data.html);
                    riot.mount('#roja45productrental_model_container', '*');
                    roja45productrental.initEditor();
                    roja45productrental.initialiseModelEventHandlers();
                    hideOtherLanguage(data.id_lang);
                    $('a[href="#roja45productrental_model_tab"]').trigger('click');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                roja45global.displayErrorMsg(data.statusText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    updateProductModel : function (ele, close)
    {
        tinyMCE.triggerSave();
        var description = [];
        $.each(languages, function (index, lang) {
            var row = {};
            var id = lang['id_lang'];
            var value = $('#ROJA45_PRODUCTRENTAL_DESCRIPTION_' + id).val();
            row[id] = value;
            description.push(row);
        });

        $.ajax({
            url: $(ele).attr('href'),
            type: 'post',
            dataType: 'json',
            data: {
                'ROJA45_PRODUCTRENTAL_ID': $('input[name=ROJA45_PRODUCTRENTAL_ID]').val(),
                'ROJA45_PRODUCTRENTAL_PRODUCT_ID': $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                'ROJA45_PRODUCTRENTAL_MODEL_ID': $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val(),
                'ROJA45_PRODUCTRENTAL_PAYMENTPROFILE': $('input[name=ROJA45_PRODUCTRENTAL_PAYMENTPROFILE]').val(),
                'ROJA45_PRODUCTRENTAL_QTY_AVAILABLE': $('input[name=ROJA45_PRODUCTRENTAL_QTY_AVAILABLE]').val(),
                'ROJA45_PRODUCTRENTAL_MINIMUM_DURATION': $('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val(),
                'ROJA45_PRODUCTRENTAL_RATETYPE': $('input[name=ROJA45_PRODUCTRENTAL_RATETYPE]').val(),
                'ROJA45_PRODUCTRENTAL_NAME': $('input[name=ROJA45_PRODUCTRENTAL_NAME]').val(),
                'ROJA45_PRODUCTRENTAL_MODELENABLED': $('input[name=ROJA45_PRODUCTRENTAL_MODELENABLED]:checked').val(),
                'ROJA45_PRODUCTRENTAL_MODEL_REFERENCE': $('input[name=ROJA45_PRODUCTRENTAL_MODEL_REFERENCE]').val(),
                'ROJA45_PRODUCTRENTAL_PAYMENTPROFILE': $('#ROJA45_PRODUCTRENTAL_PAYMENTPROFILE').val(),
                'ROJA45_PRODUCTRENTAL_PAYMENT_PROFILE_ENABLED': $('#ROJA45_PRODUCTRENTAL_PAYMENT_PROFILE_ENABLED').is(':checked'),
                'ROJA45_PRODUCTRENTAL_DESCRIPTION': description,
                'action': 'updateProductModel',
                'ajax': '1',
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    if (close) {
                        roja45global.displaySuccessMsg(data.response);
                        window.location = data.redirect;
                    }
                } else {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                }
            },
            error: function (data) {
                $.each(data.errors, function (index, value) {
                    roja45global.displayErrorMsg(value);
                });
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    initialiseModelEventHandlers : function() {
        $('#addRate').attr('disabled', false);

        $('.updateProductModel, .updateCloseProductModel').attr('disabled', false);

        $('.roja45-field-enable').off('change').on('change', function () {
            var enabled = +$(this).is(':checked');
            if (enabled) {
                $('.roja45-field-enable-group').removeAttr('disabled')
            } else {
                $('.roja45-field-enable-group').attr('disabled', 'disabled');
            }
        }).trigger('change');

        $('#ROJA45_PRODUCTRENTAL_RATETYPE').off('change').on('change', function () {
            var id_roja45_product = $(this).closest('#roja45productrental_model_form').find('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
            var id_roja45_product_model = $(this).closest('#roja45productrental_model_form').find('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();
            var data = {};
            data.ROJA45_PRODUCTRENTAL_ID = id_roja45_product;
            data.ROJA45_PRODUCTRENTAL_MODEL_ID = id_roja45_product_model;
            data.ROJA45_PRODUCTRENTAL_RATETYPE = $(this).val();
            var href = $('#roja45productrental_model_form').attr('action') + '&action=getRateTypesForModel&ajax=1';

            $.ajax({
                type: 'GET',
                url: href,
                cache: false,
                dataType: 'json',
                data: data,
                beforeSend : function() {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result && (data.result == 'success')) {
                        roja45productrental.loadProductModelRates(data.rates);
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function () {
                    roja45global.toggleModal();
                }
            });
        });

        $('#ROJA45_PRODUCTRENTAL_MODEL_SERVICE_CHARGE_TYPE').off('change').on('change', function () {
            if ($(this).val()>0) {
                $('#ROJA45_PRODUCTRENTALMODEL_SERVICE_CHARGE').removeAttr('disabled');
            } else {
                $('#ROJA45_PRODUCTRENTAL_MODEL_SERVICE_CHARGE').attr('disabled', 'disabled');
            }
        }).trigger('change');

        // riotjs
        $('ps-panel-footer-link[name=cancelUpdateProductRentalModel] a').off('click').on('click', function (e) {
            e.preventDefault();
            $('a[href="#roja45productrental_models_tab"]').trigger('click');
            $('#roja45productrental_model_container').empty();
        });

        $('ps-panel-footer-link[name=updateProductRentalModel] a').off('click').on('click', function (e) {
            e.preventDefault();
            roja45productrental.updateProductModel($(this), false);
        });

        $('ps-panel-footer-link[name=updateCloseProductRentalModel] a').off('click').on('click', function (e) {
            e.preventDefault();
            roja45productrental.updateProductModel($(this), true);
        });

        $('#roja45productrental_priceperiod_block').show();
        $('#modelImagesList').selectable();

        $('#selectImages').off('click').on('click', function (e) {
            e.preventDefault();
            $('#selectImagesModal').modal();

            var id_roja45_product = $(this).closest('#roja45productrental_model_form').find('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
            var id_model = $(this).closest('#roja45productrental_model_form').find('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();

            $('#selectImagesModal .modal-body').attr('data-id', id_roja45_product);
            $('#selectImagesModal .modal-body').attr('data-id-model', id_model);

            $('#selectedImages').off('click').on('click', function (e) {
                e.preventDefault();
                var selected = [];
                $('#selectImagesModal li.ui-selected').each(function (index, value) {
                    $(this).removeClass('ui-selected');
                    selected.push($(this).attr('data-id-image'));
                });

                if (selected.length) {
                    var data = {};
                    data.images = selected;
                    data.ROJA45_PRODUCTRENTAL_PRODUCT_ID = $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val();
                    var href = $('#roja45productrental_model_form').attr('action') + '&action=addModelImages&ajax=1&id_roja45_product=' + $('#selectImagesModal .modal-body').attr('data-id') + '&id_roja45_product_model=' + $('#selectImagesModal .modal-body').attr('data-id-model');
                    $.ajax({
                        type: 'GET',
                        url: href,
                        cache: false,
                        dataType: 'json',
                        data: data,
                        beforeSend : function() {
                            roja45global.toggleModal();
                        },
                        success: function (data) {
                            if (data.result && (data.result == 'success')) {
                                roja45productrental.loadProductModelImages(data.view);
                            } else if (data.result == 'error') {
                                $.each(data.errors, function (index, value) {
                                    roja45global.displayErrorMsg(value);
                                });
                            } else {
                                roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                            }
                        },
                        error: function (data) {
                            jAlert(data.responseText + '[' + data.responseText + ']');
                        },
                        complete: function () {
                            roja45global.toggleModal();
                            $('#selectImagesModal').modal('toggle');
                        }
                    });
                }
            });
        });
    },

    /*
    submitProductPeriodRate : function ()
    {
        var validationErrors = [];
        if (validationErrors.length == 0) {
            var data = {};

            data.ROJA45_PRODUCTRENTAL_ID = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
            data.ROJA45_PRODUCTRENTAL_MODEL_ID = $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();
            data.ROJA45_PRODUCTRENTAL_PERIOD_ID = $('select[name=ROJA45_PRODUCTRENTAL_PERIOD_ID]').val();
            data.ROJA45_PRODUCTRENTAL_RATE_ID = $('select[name=ROJA45_PRODUCTRENTAL_RATE_ID]').val();
            data.ROJA45_PRODUCTRENTAL_PERIOD_RATE = $('input[name=ROJA45_PRODUCTRENTAL_PERIOD_RATE]').val();

            var href = $('#roja45productrental_model_form').attr('action') + '&action=submitProductPeriodRates&ajax=1';
            $.ajax({
                url: href,
                type: 'post',
                dataType: 'json',
                data: data,
                beforeSend: function () {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result == 'success') {
                        roja45global.displaySuccessMsg(data.response);
                        roja45productrental.loadProductModelPeriods(data.html);
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function (data) {
                    roja45global.toggleModal();
                }
            });
        } else {
            $.each(validationErrors, function (index, value) {
                roja45global.displayErrorMsg(value);
            });
        }
    },

    updateProductPeriodRate : function (event)
    {
        var ele = event.currentTarget;

        var old_value = $(ele).closest('.period-row').attr('data-value');
        var value = $(ele).val();

        if (value != old_value) {
            var href = $('#').attr('action') + '&action=submitProductPeriodRates&ajax=1';
            var id = $(ele).closest('.period-row').attr('data-id');
            var id_type = $(ele).closest('.period-row').attr('data-id-type');
            var id_period = $(ele).closest('.period-row').attr('data-id-period');
            var data = {};
            data.ROJA45_PRODUCTRENTAL_ID = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
            data.ROJA45_PRODUCTRENTAL_MODEL_ID = $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();
            data.ROJA45_PRODUCTRENTAL_PRODUCT_ID = $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val();
            data.ROJA45_PRODUCTRENTAL_PERIOD_START_DATE = $(ele).closest('.period-row').attr('data-start-date');
            data.ROJA45_PRODUCTRENTAL_PERIOD_END_DATE = $(ele).closest('.period-row').attr('data-end-date');
            data.ROJA45_PRODUCTRENTAL_RATE_ID = id_type;
            data.ROJA45_PRODUCTRENTAL_PERIOD_ID = id_period;
            data.ROJA45_PRODUCTRENTAL_PERIOD_RATE_ID = id;
            data.ROJA45_PRODUCTRENTAL_PERIOD_RATE = value;

            $.ajax({
                url: href,
                type: 'post',
                dataType: 'json',
                data: data,
                beforeSend: function () {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result == 'success') {
                        roja45global.displaySuccessMsg(data.response);
                        roja45productrental.loadProductModelPeriods(data.html);
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function (data) {
                    roja45global.toggleModal();
                }
            });
        }
    },

    deleteProductPeriodRate : function (ele)
    {
        var id_pricePeriod = ele.closest('.period-row').attr('data-id');
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.deleteProductPeriodRateConfirmed(id_pricePeriod);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    deleteProductPeriodRateConfirmed : function (id_priceperiod) {
        var href = $('#roja45productrental_model_form').attr('action');
        var id_roja45_product = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var id_roja45_product_model = $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();
        $.ajax({
            url: href,
            type: 'get',
            data : {
                'action' : 'deletePeriodRate',
                'ajax' : 1,
                'id_roja45_product' : id_roja45_product,
                'id_roja45_product_model' : id_roja45_product_model,
                'id_price_period' : id_priceperiod
            },
            dataType: 'json',
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result == 'success') {
                    roja45global.displaySuccessMsg(data.response);
                    roja45productrental.loadProductModelPeriods(data.html);
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function (data) {
                roja45global.toggleModal();
            }
        });
    },
    */
    loadProductModelPeriods : function(periods_view)
    {
        $('#productrental_model_preiod_rates').fadeOut('fast', function () {
            $(this).empty();
            $(this).append(periods_view);
            $(this).fadeIn();
        });
    },

    editProductModelRate : function(ele) {
        var id_roja45_product_rate = ele.closest('tr').attr('data-id');
        var id_roja45_product_rate_type = ele.closest('tr').attr('data-id-type');
        var rate = ele.closest('tr').attr('data-rate');
        var groups = ele.closest('tr').attr('data-group-ids');
        groups = groups.split(',');
        $('input[name="ROJA45_PRODUCTRENTAL_RATEGROUP[]"]').each(function() {
            if ($.inArray($(this).val(), groups) !== -1) {
                $(this).attr('checked', 'checked');
            }
        });
        $('input[name=ROJA45_PRODUCTRENTAL_RATE_ID]').val(id_roja45_product_rate);
        $('select[name=ROJA45_PRODUCTRENTAL_RATE_TYPE]').val(id_roja45_product_rate_type);
        $('input[name=ROJA45_PRODUCTRENTAL_RATE]').val(rate);
    },

    deleteProductModelRate : function (ele) {
        var id_roja45_product_rate = ele.closest('.rate-row').attr('data-id');
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.deleteProductModelRateConfirmed(id_roja45_product_rate);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    deleteProductModelRateConfirmed : function (id) {
        var href = $('#roja45productrental_model_form').attr('action');
        $.ajax({
            url: href,
            type: 'post',
            dataType: 'json',
            data: {
                'action' : 'deleteProductModelRate',
                'ajax' : 1,
                'ROJA45_PRODUCTRENTAL_ID' : $('input[name=ROJA45_PRODUCTRENTAL_ID]').val(),
                'ROJA45_PRODUCTRENTAL_MODEL_ID' : $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val(),
                'ROJA45_PRODUCTRENTAL_RATE_ID' : id,
                'ROJA45_PRODUCTRENTAL_PRODUCT_ID' : $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                'ROJA45_PRODUCTRENTAL_RATE' : $('input[name=ROJA45_PRODUCTRENTAL_RATE]').val(),
                'ROJA45_PRODUCTRENTAL_RATE_TYPE' : $('select[name=ROJA45_PRODUCTRENTAL_RATE_TYPE]').val(),
            },
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result == 'success') {
                    roja45global.displaySuccessMsg(data.response);
                    //$('select[name=ROJA45_PRODUCTRENTAL_RATE_TYPE] option[value=' + data.id_rate + ']').remove();
                    $('select[name=ROJA45_PRODUCTRENTAL_RATE_ID] option[value=' + data.id_rate + ']').remove();

                    roja45productrental.loadProductModelRates(data.rates);
                    roja45productrental.loadProductModelPeriods(data.periods_view);
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function (data) {
                roja45global.toggleModal();
            }
        });
    },

    duplicateModel : function (ele)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.duplicateModelConfirmed(ele);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    duplicateModelConfirmed : function (ele)
    {
        var id_roja45_product = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var id_roja45_product_model = ele.closest('.rate-row').attr('data-id');
        var href = $('#roja45productrental_models_form').attr('action') + '&action=duplicateProductModel&ajax=1&id_roja45_product=' + id_roja45_product + '&id_roja45_product_model=' + id_roja45_product_model;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result && (data.result == 'success')) {
                    roja45productrental.loadProductModelList(data.view);
                    $('#roja45productrental_models_form')[0].reset();
                    $('#roja45productrental_models_form').fadeOut();
                    $('#productrental_priceperiod_tab').fadeOut();
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    deleteModel : function (ele)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.deleteModelConfirmed(ele);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    deleteModelConfirmed : function (ele)
    {
        var id_roja45_product = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var id_roja45_product_model = ele.closest('.rate-row').attr('data-id');
        var href = $('#roja45productrental_models_form').attr('action') + '&action=deleteProductModel&ajax=1&id_roja45_product=' + id_roja45_product + '&id_roja45_product_model=' + id_roja45_product_model;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result && (data.result == 'success')) {
                    roja45productrental.loadProductModelList(data.view);
                    $('#roja45productrental_models_form')[0].reset();
                    $('#roja45productrental_models_form').fadeOut();
                    $('#productrental_priceperiod_tab').fadeOut();
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    submitProductModelRate : function ()
    {
        var rate = parseFloat($('input[name=ROJA45_PRODUCTRENTAL_RATE]').val());
        var group_ids = $('input[name="ROJA45_PRODUCTRENTAL_RATEGROUP[]"');
        group_ids = group_ids.filter(":checked").map(function () {
            return this.value;
        }).get().join(',');
        if ($.isNumeric(rate)) {
            $.ajax({
                url: $('#roja45productrental_model_form').attr('action'),
                type: 'post',
                dataType: 'json',
                data: {
                    'action' : 'submitProductModelRate',
                    'ajax' : 1,
                    'ROJA45_PRODUCTRENTAL_ID' : $('input[name=ROJA45_PRODUCTRENTAL_ID]').val(),
                    'ROJA45_PRODUCTRENTAL_MODEL_ID' : $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val(),
                    'ROJA45_PRODUCTRENTAL_PRODUCT_ID' : $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                    'ROJA45_PRODUCTRENTAL_RATE_ID' : $('input[name=ROJA45_PRODUCTRENTAL_RATE_ID]').val(),
                    'ROJA45_PRODUCTRENTAL_RATE' : rate,
                    'ROJA45_PRODUCTRENTAL_RATE_TYPE' : $('select[name=ROJA45_PRODUCTRENTAL_RATE_TYPE]').val(),
                    'ROJA45_PRODUCTRENTAL_RATE_NAME' : $('#ROJA45_PRODUCTRENTAL_RATE_NAME option:selected').text(),
                    'ROJA45_PRODUCTRENTAL_RATE_GROUPS' : group_ids
                },
                beforeSend: function () {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result) {
                        roja45global.displaySuccessMsg(data.response);
                        $('select[name=ROJA45_PRODUCTRENTAL_RATE_ID]').append('<option value="' + data.rate.id_type + '">' + data.rate_name + '</option>');
                        $('input[name=ROJA45_PRODUCTRENTAL_RATE_ID]').val('');
                        $('input[name=ROJA45_PRODUCTRENTAL_RATE]').val('')
                        roja45productrental.loadProductModelRates(data.rates);
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function (data) {
                    roja45global.toggleModal();
                }
            });
        } else {
            roja45global.displayErrorMsg(roja45_productrental_rate_value_error);
        }
    },

    updateProductModelRate : function (event) {
        var ele = event.currentTarget;

        if (!$(ele).parent().hasClass('has-error')) {
            var old_value = $(ele).closest('.rate-row').attr('data-value');
            var value = $(ele).val();

            if (value != old_value) {
                var href = $('#roja45productrental_model_form').attr('action') + '&action=submitProductModelRate&ajax=1';
                var id = $(ele).closest('.rate-row').attr('data-id');
                var id_type = $(ele).closest('.rate-row').attr('data-id-type');
                var data = {};
                data.ROJA45_PRODUCTRENTAL_ID = $('input[name=ROJA45_PRODUCTRENTAL_ID]').val();
                data.ROJA45_PRODUCTRENTAL_MODEL_ID = $('input[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val();
                data.ROJA45_PRODUCTRENTAL_PRODUCT_ID = $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val();
                data.ROJA45_PRODUCTRENTAL_RATE_ID = id;
                data.ROJA45_PRODUCTRENTAL_RATE_TYPE = id_type;
                data.ROJA45_PRODUCTRENTAL_RATE = value

                $.ajax({
                    url: href,
                    type: 'post',
                    dataType: 'json',
                    data: data,
                    beforeSend: function () {
                        roja45global.toggleModal();
                    },
                    success: function (data) {
                        if (data.result == 'success') {
                            roja45global.displaySuccessMsg(data.response);
                            roja45productrental.loadProductModelRates(data.rates);
                        } else if (data.result == 'error') {
                            $.each(data.errors, function (index, value) {
                                roja45global.displayErrorMsg(value);
                            });
                        } else {
                            roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                        }
                    },
                    error: function (data) {
                        jAlert(data.responseText + '[' + data.responseText + ']');
                    },
                    complete: function (data) {
                        roja45global.toggleModal();
                    }
                });
            }
        }
    },

    loadProductModelList : function(view) {
        $('#models_list').fadeOut('fast', function () {
            $(this).empty();
            $(this).append(view);
            $(this).fadeIn();
        });
    },

    loadProductModelRates : function(rates) {
        $('#productrental_model_rates').fadeOut('fast', function () {
            $(this).empty();
            $(this).append(rates);
            $(this).fadeIn();
        });
    },

    loadProductModelImages : function(image_list) {
        $('#modelImageList').fadeOut('fast', function () {
            $(this).empty();
            $(this).append(image_list);

            // TODO - Assign event handlers
            $('.model_covered').off('click').on('click', function (e) {
                e.preventDefault();
                var id = $(this).parent().parent().parent().attr('data-id');
                $("#modelImageList .model_cover i").each(function (i) {
                    $(this).removeClass('icon-check-sign').addClass('icon-check-empty');
                });
                $(this).removeClass('icon-check-empty').addClass('icon-check-sign');
                // TODO - Update DB.
            });
            $(this).fadeIn();
        });
    },

    submitCalendarEntry : function (ele)
    {
        var start = $('#addEntryModal #event_start_date').val();
        var end = $('#addEntryModal #event_end_date').val();
        var title = ele.attr('data-title');
        var type = ele.attr('data-type');
        var href = ele.attr('href') + '&action=addRental&ajax=1&id_product=' + $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val() + '&id_roja45_product=' + $('input[name=ROJA45_PRODUCTRENTAL_ID]').val() + '&id_roja45_product_model=' + $('select[name=ROJA45_PRODUCTRENTAL_MODEL_ID]').val() + '&id_type=' + type + '&start_date=' + start + '&end_date=' + end + '&title=' + title;

        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    productrental_calendar.fullCalendar('renderEvent', {
                        title: data.title,
                        start: start,
                        end: end,
                        allDay: true,
                        borderColor: data.borderColor,
                        color: data.color,
                        summary: data.summary,
                        id: data.id,
                        id_roja45_product_rental: data.id_roja45_product_rental
                    }, true);
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
                $('#addEntryModal').modal('toggle');
            }
        });
    },

    cancelRental : function (href, id_roja45_product_rental)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.cancelRentalConfirmed(href, id_roja45_product_rental);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    cancelRentalConfirmed : function (href, id_roja45_product_rental)
    {
        var href = href + '&id_roja45_product_rental=' + id_roja45_product_rental;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#fullCalModal').modal('toggle');
                    $('#roja45productrental_calendar_block').fullCalendar('removeEvents');
                    $('#roja45productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    validate_number : function (s) {
        var val = $(s).val();
        var rgx = /^[0-9]*\.?[0-9]*$/;
        if (!val.match(rgx)) {
            $(s).parent().addClass('has-error');
            return false;
        } else {
            $(s).parent().removeClass('has-error');
            return true;
        }
    },

    submitProductRentalModelExtras : function (ele) {
        var href = ele.attr('href')+'&action=submitProductRentalModelExtras&ajax=1';
        $.ajax({
            url: href,
            type: 'post',
            dataType: 'json',
            data: $('#roja45productrental_model_form').serialize(),
            beforeSend: function () {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data) {
                    if (data.result == 'success') {
                        roja45global.displaySuccessMsg(data.response);
                        $('#roja45productrental_extras_block').fadeOut('fast', function() {
                            $('#roja45productrental_extras_block').empty();
                            $('#roja45productrental_extras_block').append(data.view);
                            $('#roja45productrental_extras_block').fadeIn();
                        });
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function (data) {
                roja45global.toggleModal();
            }
        });
    },

    updateProductRentalModelExtraRate : function() {
    },

    updateRental : function (href)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.updateRentalConfirmed(href);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    updateRentalConfirmed : function (href)
    {
        var href = href
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#fullCalModal').modal('toggle');
                    $('#roja45productrental_calendar_block').fullCalendar('removeEvents');
                    $('#roja45productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    requestPayment : function (href)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.requestPaymentConfirmed(href);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    requestPaymentConfirmed : function (href)
    {
        var href = href
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result=='success') {
                    $('#fullCalModal').modal('toggle');
                    $('#roja45productrental_calendar_block').fullCalendar('removeEvents');
                    $('#roja45productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText + '[' + data.responseText + ']');
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    updatePeriod : function() {
        var id_period = parseInt($('select[name=ROJA45_PRODUCTRENTAL_PERIOD_ID]').val());
        if (id_period > 0) {
            var href = $('#roja45productrental_model_form').attr('action') + '&action=getPeriodDetails&ajax=1&id_period=' + id_period;

            $.ajax({
                type: 'GET',
                url: href,
                cache: false,
                dataType: 'json',
                beforeSend : function() {
                    roja45global.toggleModal();
                },
                success: function (data) {
                    if (data.result && (data.result == 'success')) {
                    } else if (data.result == 'error') {
                        $.each(data.errors, function (index, value) {
                            roja45global.displayErrorMsg(value);
                        });
                    } else {
                        roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    }
                },
                error: function (data) {
                    jAlert(data.responseText + '[' + data.responseText + ']');
                },
                complete: function () {
                    roja45global.toggleModal();
                }
            });
        }
    }
}
