/**
 * roja45productrental_order.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    $(document).on('click', '.show-booking', function (e) {
        e.preventDefault();
        roja45productrental.getBookingSummary($(this));
    });
});

roja45productrental = {

    getBookingSummary: function(ele) {
        var reference = ele.closest('tr').attr('data-booking-reference');
        var href = ele.closest('table').attr('data-controller');

        $.ajax({
            url: href,
            type: 'get',
            dataType: 'json',
            data : {
                'action' : 'getBookingSummary',
                'booking_reference' : reference,
                'ajax' : 1,
            },
            beforeSend: function () {
                roja45productrental.toggleWaitDialog();
            },
            success: function (data) {
                $('#block_booking_summary').fadeOut('slow', function() {
                    $(this).empty();
                    $(this).append(data.summary);
                    $(this).fadeIn('slow', function() {
                        $.scrollTo(this, 1200);
                    });
                });

            },
            error: function (data) {
                console.log('No summary available.');
            },
            complete: function (data) {
                roja45productrental.toggleWaitDialog();
            }
        });
    },

    displayWarning : function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    },

    displayErrors : function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-error">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    },

    toggleWaitDialog: function () {
        if (typeof toggleRoja45GlobalWaitDialog === "function") {
            toggleRoja45GlobalWaitDialog();
        } else {
            $('#immersive-modal-dialog').fadeIn();
        }
    }
}