/**
 * roja45productrental_order.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    var cart_items = $('.cart_item');
    $.each(cart_items, function (index, value) {
        var id = $(this).attr('id');
        var res = id.split('_');
        var id_product = res[1];
        if (typeof roja45_rentable_products[id_product] != 'undefined') {
            $('[id^=' + id + '] .price-percent-reduction').hide();
            $('[id^=' + id + '] .old-price').hide();

            var qty = $('input[name^=quantity_' + id_product + '_]').val();
            if (typeof qty === 'undefined') {
                qty = '1';
            }
            $('[id^=' + id + '] .cart_quantity').empty();
            $('[id^=' + id + '] .cart_quantity').append('<p>' + qty + '</p>');
        } else if (roja45_id_product_deposit>0 && id_product==roja45_id_product_deposit) {
            $('[id^=' + id + '] .cart_quantity').empty();
            $('[id^=' + id + '] .cart_delete a').remove();
            $('#' + id + ' .cart_unit .price-percent-reduction').remove();
            $('#' + id + ' .cart_unit .old-price').remove();
            $('#' + id + ' a').attr('href', '');
            if ($('.shopping_cart [data-id^=cart_block_product_'+id_product+']')) {
                $('.shopping_cart [data-id^=cart_block_product_'+id_product+'] .remove_link').remove();
            }
        }
    });

    $('#cart_summary .cart_total_delivery').hide();

    $('.delete_cart_model').off('click').on('click', function(e) {
        e.preventDefault();
        var data = {
            'ROJA45_PRODUCTRENTAL_ID_CART': $(this).closest('tr').attr('data-id-roja45-product-cart'),
            'ROJA45_PRODUCTRENTAL_ID_MODEL': $(this).closest('tr').attr('data-id-roja45-product-model'),
            'ROJA45_PRODUCTRENTAL_ID_PRODUCT': $(this).closest('tr').attr('data-id-product'),
            'ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE': $(this).closest('tr').attr('data-id-product-attribute')
        };

        data = $.param(data);

        toggleWaitDialog();
        var url = roja45_rental_controller + '&action=submitDeleteCartModel&ajax=1';
        $.ajax({
            url: url,
            type: 'post',
            dataType: 'json',
            data: data,
            beforeSend: function () {
            },
            success: function (json) {
                if (json) {
                    if (json.result == 'success') {
                        window.location=json.redirect;
                    } else if (json.result == 'error') {
                        displayErrors(json.errors);
                    } else {
                        displayErrors([roja45_unexpected_error]);
                    }
                } else {
                    displayErrors([roja45_unexpected_error]);
                }
            },
            error: function (data) {
                displayErrors([roja45_unexpected_error]);
            },
            complete: function (data) {
                toggleWaitDialog();
            }
        });
    });
});

function toggleWaitDialog() {
    if (typeof toggleRoja45GlobalWaitDialog === "function") {
        toggleRoja45GlobalWaitDialog();
    }
}

function displayErrors(errors) {

}
