/**
 * roja45moduleadmin.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function() {
    $('input[name=is_recurring]').on('change', function(e) {
        e.preventDefault();
        roja45productrental.init();
    }).trigger('change');

    $('#roja45_productrental_period_form_submit_btn').on('click', function(e) {
        var checked = $('input[name=is_recurring]:checked').val();
        if (checked==1) {
            var from_date = $.datepicker.parseDate('yy-mm-dd', '1004-' + $('input[name=start_date]').val());
            $('input[name=start_date]').val($.datepicker.formatDate('yy-mm-dd',from_date));
            var to_date = $.datepicker.parseDate('yy-mm-dd', '1004-' + $('input[name=end_date]').val());
            // check year, if greater, use 1005
            if (from_date > to_date) {
                var to_date = $.datepicker.parseDate('yy-mm-dd', '1005-' + $('input[name=end_date]').val());
            }
            $('input[name=end_date]').val($.datepicker.formatDate('yy-mm-dd',to_date));
        }
    });
});

roja45productrental = {
    init : function() {
        var checked = $('input[name=is_recurring]:checked').val();
        if (checked==1) {
            try {
                var date = $.datepicker.parseDate('yy-mm-dd', $('input[name=start_date]').val() );
                $('input[name=start_date]').val($.datepicker.formatDate("mm-dd",date));
                var date = $.datepicker.parseDate('yy-mm-dd', $('input[name=end_date]').val() );
                $('input[name=end_date]').val($.datepicker.formatDate("mm-dd", date));
            } catch(e) {
            }

            if ($('.roja45_datepicker').hasClass('ui-datepicker-enabled')) {
                $('.roja45_datepicker').datepicker('destroy');
                $('.roja45_datepicker').removeClass('ui-datepicker-enabled');
            }

            $('.roja45_datepicker').datepicker({
                changeYear: false,
                dateFormat: 'mm-dd',
                beforeShow: function (input, inst) {
                    inst.dpDiv.addClass('no-year-date-picker');
                },
                onClose: function(dateText, inst){
                    inst.dpDiv.removeClass('no-year-date-picker');
                }
            });
            $('.roja45_datepicker').addClass('ui-datepicker-enabled');
        } else {
            try {
                var date = $.datepicker.parseDate('mm-dd', $('input[name=start_date]').val() );
                $('input[name=start_date]').val($.datepicker.formatDate('yy-mm-dd',date));
                var date = $.datepicker.parseDate('mm-dd', $('input[name=end_date]').val() );
                $('input[name=end_date]').val($.datepicker.formatDate('yy-mm-dd', date));
            } catch(e) {
            }

            if ($('.roja45_datepicker').hasClass('ui-datepicker-enabled')) {
                $('.roja45_datepicker').datepicker('destroy');
                $('.roja45_datepicker').removeClass('ui-datepicker-enabled');
            }
            $(".roja45_datepicker").datepicker({
                prevText: '',
                nextText: '',
                dateFormat: 'yy-mm-dd'
            });
            $('.roja45_datepicker').addClass('ui-datepicker-enabled');
        }
    }
};