/**
 * roja45productrental_products.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    
    Date.prototype.addDays = function (days) {
        var dat = new Date(this.valueOf());
        dat.setDate(dat.getDate() + days);
        return dat;
    }

    if (typeof roja45_id_product_deposit != 'undefined' && roja45_id_product_deposit) {
        $.each($('#cart_block .products dt'), function (index, value) {
            var id = $(this).attr('data-id');
            var res = id.split('_');
            var id_product = res[3];
            if (id_product==roja45_id_product_deposit) {
                $(this).find('.remove_link').remove();
            }
        });
    }

    roja45_block_remaining = false;
    if (roja45_productrental_usejs) {
        $('#add_to_cart').remove();
        $('#roja45productrental_block').insertBefore('.box-cart-bottom');
        $('#roja45productrental_block').show();
        $('body').addClass('roja45-rental-product');
    }

    var minimum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val());
    var maximum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION]').val());
    var id_product_attribute = $('#idCombination').val();
    var controller = $('input[name=ROJA45_PRODUCTRENTAL_CONTROLLER_URL]').val();
    $('#buy_block').attr('action', controller);

    if ($('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').length > 0) {
        var minDate = new Date();
        minDate = minDate.addDays(parseInt(roja45_productrental_preparationdays));
        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker({
            minDate: minDate,
            changeMonth: false,
            changeYear: false,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 2,
            showButtonPanel: true,
            firstDay: parseInt(roja45productrental_start_day),
            onClose: function (selectedDate, obj) {
                var period = roja45_productrental_rateperiods[$('input[name=ROJA45_PRODUCTRENTAL_RATEPERIOD]').val()];
                if (period['period']=='DAY') {
                    var collectionDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate', minimum_duration+'d');
                    if (typeof collectionDate !== "undefined" && collectionDate) {
                        var collection_time = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
                        var departureDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                        departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                        var day = departureDate.getDay()+1;

                        var opening_time = roja45_working_days[day]['opening_time'];
                        var closing_time = roja45_working_days[day]['closing_time'];

                        var checkdate = $.datepicker.formatDate('yy-mm-dd', collectionDate);
                        //var id_combination = $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
                        var id_combination = $('#idCombination').val();
                        if (!id_combination) {
                            id_combination = 0;
                        }
                        if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                            opening_time = roja45_rentals[id_combination]['dates'][checkdate]['time'];
                        }

                        var res = departureDate.toISOString().slice(0,10);
                        opening_time = new Date(Date.parse(res + 'T' + opening_time));
                        closing_time = new Date(Date.parse(res + 'T' + closing_time));
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val(collection_time);

                        //departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                        //var day = (departureDate.getDay()+1);
                        if (roja45_working_days[day]=='0') {
                            var not_found = true;
                            var days_to_add = 1;
                            while (not_found) {
                                if (day==7) {
                                    day = 1;
                                } else {
                                    day++;
                                }
                                if (roja45_working_days[day]=='1') {
                                    not_found = false;
                                    departureDate.setDate(departureDate.getDate()+parseInt(days_to_add));
                                } else {
                                    days_to_add++;
                                }
                            }
                        }

                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                        if (parseInt(roja45_productrental_showlivetotal)) {
                            roja45productrentals.getLiveTotal();
                        }
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker("show");
                    }
                } else if(period['period']=='WEEK') {
                    // TODO - define whether daya to day, arbitary, restrict to 7 day blocks, etc
                } else if (period['period']=='MONTH') {

                } else if (period['period']=='CUSTOM') {
                    var departureDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate', minimum_duration+'d');
                    if (typeof departureDate !== "undefined" && departureDate) {
                        departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                    }
                }
            },
            beforeShow: function() {
                $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', new Date());
                roja45_block_remaining = false;
            },
            beforeShowDay: function (d) {
                return roja45productrentals.checkDateAvailable(
                    d,
                    $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate'),
                    true,
                    minimum_duration,
                    maximum_duration
                );
            }
        });

        $('.roja45productrental_block .cal-arrival .input-group-addon').on('click', function(e) {
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('show');
        });
        $('.roja45productrental_block .cal-departure .input-group-addon').on('click', function(e) {
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('show');
        });
    }

    if (typeof roja45_productrental_enabletimeselect != 'undefined' || roja45_productrental_enabletimeselect) {
        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker({
            ampm: false,
            pickSeconds: false,
            timeFormat: roja45_productrental_timeformat,
            timeSuffix: '',
            step: '15',
            onSelect: function (obj) {
                if (parseInt(roja45_productrental_showlivetotal)) {
                    roja45productrentals.getLiveTotal();
                }
            }
        });
        var collectionDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
        if (collectionDate != 'undefined' && collectionDate && collectionDate.length > 0) {
            var collection_time = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
            var day = collectionDate.getDay()+1;
            var opening_time = roja45_working_days[day]['opening_time'];
            var closing_time = roja45_working_days[day]['closing_time'];
            var res = collectionDate.toISOString().slice(0, 10);
            opening_time = new Date(Date.parse(res + 'T' + opening_time));
            closing_time = new Date(Date.parse(res + 'T' + closing_time));
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val(collection_time);
        }
    }

    if ($('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').length > 0) {
        $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker({
            changeMonth: false,
            changeYear: false,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 2,
            showButtonPanel: true,
            firstDay: parseInt(roja45productrental_start_day),
            onSelect: function (selected, evnt) {
                var departureDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('getDate');
                if (typeof departureDate !== "undefined" && departureDate) {
                    var day = departureDate.getDay()+1;
                    var opening_time = roja45_working_days[day]['opening_time'];
                    var closing_time = roja45_working_days[day]['closing_time'];

                    var checkdate = $.datepicker.formatDate('yy-mm-dd', departureDate);
                    //var id_combination = $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val();
                    var id_combination = $('#idCombination').val();
                    if (!id_combination) {
                        id_combination = 0;
                    }
                    if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                        closing_time = roja45_rentals[id_combination]['dates'][checkdate]['time'];
                    }

                    var departureDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                    var res = departureDate.toISOString().slice(0, 10);
                    opening_time = new Date(Date.parse(res + 'T' + opening_time));
                    closing_time = new Date(Date.parse(res + 'T' + closing_time));
                    $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                    $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                }
                if (parseInt(roja45_productrental_showlivetotal)) {
                    roja45productrentals.getLiveTotal();
                }
            },
            beforeShow: function() {
                roja45_block_remaining = false;
            },
            beforeShowDay: function (d) {
                return roja45productrentals.checkDateAvailable(
                    d,
                    $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate'),
                    false,
                    minimum_duration,
                    maximum_duration
                );
            }
        });

        if (typeof roja45_productrental_enabletimeselect != 'undefined' || roja45_productrental_enabletimeselect) {
            $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker({
                ampm: false,
                pickSeconds: false,
                timeFormat: roja45_productrental_timeformat,
                timeSuffix: '',
                step: '15',
                onSelect: function (obj) {
                    if (parseInt(roja45_productrental_showlivetotal)) {
                        roja45productrentals.getLiveTotal();
                    }
                }
            });
            var departureDate = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('getDate');
            if (departureDate != 'undefined' && departureDate && departureDate.length > 0) {
                var return_time = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();
                var day = departureDate.getDay()+1;
                var opening_time = roja45_working_days[day]['opening_time'];
                var closing_time = roja45_working_days[day]['closing_time'];
                var res = departureDate.toISOString().slice(0, 10);
                opening_time = new Date(Date.parse(res + 'T' + opening_time));
                closing_time = new Date(Date.parse(res + 'T' + closing_time));
                $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val(return_time);
            }
        }
    }

    // hide unused page elements.
    if (roja45_productrental_usejs) {
        roja45productrentals.prepareProductPage();
    }

    $(document).on('click', '.number-spinner .num-selector-up', function (e) {
        e.preventDefault();
        var fieldName = $(this).attr('data-field-name');
        var currentVal = parseInt($('input[name=' + fieldName + ']').val());
        var maxValue = parseInt($(this).attr('data-maximum'));
        if (!isNaN(currentVal)) {
            currentVal = currentVal+1;
            if (maxValue>-1) {
                if (currentVal < maxValue) {
                    $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
                    roja45productrentals.formDirty();
                }
            } else {
                $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
                roja45productrentals.formDirty();
            }
        }
    });

    $(document).on('click', '.number-spinner .num-selector-down', function (e) {
        e.preventDefault();
        var fieldName = $(this).attr('data-field-name');
        var currentVal = parseInt($('input[name=' + fieldName + ']').val());
        var minValue = parseInt($(this).attr('data-minimum'));
        if (!isNaN(currentVal) && currentVal > minValue) {
            currentVal = currentVal-1;
            $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
        } else {
            $('input[name=' + fieldName + ']').val(minValue);
            roja45productrentals.formDirty();
        }
    });

    $(document).on('click', '.select-field .dropdown dt a', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var ele = $(this).closest('.dropdown').find('dd ul');
        if ($(this).closest('.dropdown').hasClass('active')) {
            ele.slideUp();
            $(this).closest('.dropdown').removeClass('active');
        } else {
            $(this).closest('.dropdown').addClass('active');
            ele.slideDown();
        }
    });

    $(document).click(function (e) {
        if ($('.dropdown dd ul').is(':visible')) {
            $('.dropdown dd ul').slideUp();
            $('.dropdown').removeClass('active');
        }
    });

    $(document).on('click', '.select-field .dropdown dd ul li a', function (e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        var value = $(this).attr('data-value');
        $(this).closest('.dropdown').find('dt a span').html(value);
        $(this).closest('.dropdown').find('dt a').attr('data-id', id);
        $(this).closest('.dropdown').find('dt a').attr('data-value', value);
        $(this).closest('.dropdown').find('input').val(id);
        $(this).closest('.dropdown').find('dt a').attr('data-value', value);
        $(this).closest('.dropdown').find('dd ul').slideUp();
        $(this).closest('.dropdown').removeClass('active');
    });

    $('.rate-heading').tooltip();

    $("a.rates-link").on('click', function (e) {
        e.preventDefault();
        var target = $(this).attr('href');
        $('body').scrollTo(target, {duration: 'slow', offsetTop: '100', easing: 'swing'});
    });

    $('.btn-availability').on('click', function(e) {
        $('#roja45productrental_message_block').slideUp();
        roja45productrentals.validateProductPageFields(e);
    });

    $(document).on('change', '#quantity_wanted', function (e) {
        if (parseInt(roja45_productrental_showlivetotal)) {
            roja45productrentals.getLiveTotal();
        }
    });

    if (parseInt(roja45_productrental_showlivetotal)) {
        roja45productrentals.getLiveTotal();
    }
});

var roja45productrentals = (function (my) {
    my.prepareProductPage = function() {
        $('#buy_block #add_to_cart').hide();
        $('#add_to_cart_product_page_button').insertAfter($('#roja45productrental_price'));

        $('.box-cart-bottom .roja45productrental_notes').show();
        $('.box-cart-bottom .roja45productrental_getprice').show();
    };

    my.getLiveTotal = function() {
        var id_product = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT]').val();
        var id_roja45_product_rateduration = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RATE_DURATION]').val();
        var id_product_attribute = $('#idCombination').val();
        var qty = $('#quantity_wanted').val();
        var collection_date = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').val();
        var collection_time = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
        var return_date = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').val();
        var return_time = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();

        var rental_details = {
            products : [{
                id_product: id_product,
                id_product_attribute: id_product_attribute,
                qty: qty,
                collection_date: collection_date,
                collection_time: collection_time,
                return_date: return_date,
                return_time: return_time,
            }],
            id_roja45_product_rateduration : id_roja45_product_rateduration
        };
        var valid = true;

        if (valid) {
            $.ajax({
                url: roja45_rental_controller,
                type: 'get',
                dataType: 'json',
                data: {
                    'action' : 'getLivePrice',
                    'ajax' : 1,
                    'rental_details' : JSON.stringify(rental_details)
                },
                beforeSend: function () {
                },
                success: function (data) {
                    if (data.result) {
                        $('#roja45productrental_liveprice .live_price_display').remove();
                        $('#roja45productrental_liveprice').append(data.view);
                        if ($('#roja45productrental_liveprice:visible').length) {
                            $('#roja45productrental_liveprice .waiting').fadeOut('fast', function(e) {
                                $('#roja45productrental_liveprice .live_price_display').fadeIn();
                            });
                        } else {
                            $('#roja45productrental_liveprice .live_price_display').show();
                            $('#roja45productrental_liveprice').fadeIn('fast');
                        }
                    } else if (data.errors) {
                        $('#roja45productrental_liveprice').fadeOut('fast', function(e) {
                            $('#roja45productrental_liveprice .live_price_display').remove();
                            $('#roja45productrental_liveprice .waiting').hide();

                            $('#roja45productrental_liveprice_errors').fadeIn('fast');
                        });
                    } else {
                        $('#roja45productrental_liveprice').fadeOut('fast', function(e) {
                            $('#roja45productrental_liveprice .live_price_display').remove();
                            $('#roja45productrental_liveprice .waiting').hide();
                        });
                    }
                },
                error: function (data) {
                    console.log('here');
                },
                complete: function (data) {
                    //roja45propertymanager.togglePricesWaitDialog();
                }
            });
        }
    };

    my.validateProductPageFields = function(e) {
        var validationErrors = [];
        var arrival_date = $('#ROJA45_PRODUCTRENTAL_COLLECTION_DATE').val();

        if (arrival_date.length == 0) {
            validationErrors.push(roja45_arrival_date_error);
        }

        var departure_date = $('#ROJA45_PRODUCTRENTAL_RETURN_DATE').val();
        if (departure_date.length == 0) {
            validationErrors.push(roja45_departure_date_error);
        }
        if (validationErrors.length > 0) {
            e.preventDefault();
            roja45productrentals.displayErrors(validationErrors);
            return false;
        }
        $('.roja45productrental_block').addClass('loading');
        $('.roja45productrental_block .btn-availability').addClass('disabled');

        $('input[name=ROJA45_PRODUCTRENTAL_ID_PRODUCT_ATTRIBUTE]').val($('#idCombination').val());
    };

    my.checkDateAvailable = function(dateToCheck, arrivalDate, arrival, minimum_duration, maximum_duration) {
        if (!arrival) {
            var collection_date = $('#roja45productrental_block input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
            if (collection_date) {
                if (minimum_duration) {
                    var minimum_date = roja45productrentals.addDays(collection_date, minimum_duration-1);
                    if (!roja45productrentals.dateCompare(minimum_date, dateToCheck)) {
                        $returnclass = "unavailable minimum-duration";
                        $returntooltip = roja45_productrental_calendar_tooltip_minduration;
                        $return = false;
                        return [$return, $returnclass, $returntooltip];
                    }
                }
                if (maximum_duration) {
                    var maximum_date = roja45productrentals.addDays(collection_date, maximum_duration);
                    if (roja45productrentals.dateCompare(maximum_date, dateToCheck)) {
                        $returnclass = "unavailable maximum-duration";
                        $returntooltip = roja45_productrental_calendar_tooltip_maxduration;
                        $return = false;
                        return [$return, $returnclass, $returntooltip];
                    }
                }
            }
        }
        
        var $return = true;
        var $returnclass = "available";
        
        var idCombination = $('#idCombination').val();
        if (!idCombination) {
            idCombination = $('#product_customization_id').val();
            if (!idCombination) {
                idCombination = 0;
            }
        }

        var $returntooltip = roja45_rentals[idCombination]['total_available'] + ' ' + roja45_productrental_calendar_tooltip_num_available;
        var day = (dateToCheck.getDay()+1);

        if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
            $returnclass = "unavailable non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = false;
        } else if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
            $returnclass = "non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = true;
        }

        if (roja45_productrental_calendaravailability==1) {
            if (!arrival && (roja45productrentals.dateCompare(dateToCheck, arrivalDate))) {
                $returnclass = "unavailable before-arrival";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }

            if (roja45_block_remaining) {
                $returnclass = "unavailable no-consecutive";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }
            var checkdate = $.datepicker.formatDate('yy-mm-dd', dateToCheck);
            if (idCombination>0 && typeof roja45_rentals[0] != 'undefined' && typeof roja45_rentals[0]['dates'] != 'undefined' && typeof roja45_rentals[0]['dates'][checkdate] != 'undefined') {
                $returnclass = "unavailable";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }

            if (typeof roja45_rentals[idCombination]['dates'] === 'object' && typeof roja45_rentals[idCombination]['dates'][checkdate] != 'undefined') {
                if (typeof roja45_rentals[idCombination]['dates'][checkdate]['unavailable'] != 'undefined' && roja45_rentals[idCombination]['dates'][checkdate]['unavailable']==1) {
                    $returnclass = "unavailable";
                    $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                    $return = false;
                    return [$return, $returnclass, $returntooltip];
                }

                var rentals = roja45_rentals[idCombination]['dates'][checkdate];
                var available = roja45_rentals[idCombination]['total_available'];
                var diff = available - rentals['count'];
                var type = rentals['type'];

                if (type==1) {
                    // Reservable as end date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "unavailable";
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_checkout_only;
                            $return = false;
                            $returnclass = "available-departure";
                            roja45_block_remaining = true;
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==2) {
                    // Reserved
                    if (diff <= 0) {
                        $return = false;
                        $returnclass = "unavailable";
                        $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==3) {
                    // Reservable as start date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "available-arrival";
                            $returntooltip = roja45_productrental_calendar_tooltip_checkin_only;
                            $return = true;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                            $returnclass = "unavailable";
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1 && !arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff == 1 && arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else {
                        if (arrival) {
                            $returnclass = "available";
                            $returntooltip = roja45_productrental_calendar_tooltip_last;
                            $return = true;
                        }
                    }
                }
            }
        }
        return [$return, $returnclass, $returntooltip];
    };

    my.addDays = function(date, days) {
        var updated_date = new Date(date.getTime());
        updated_date.setDate(updated_date.getDate() + days);
        return updated_date;
    },

    my.dateCompare = function (date1, date2) {
        return new Date(date2) > new Date(date1);
    };

    my.displayWarning = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    my.displayErrors = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    return my;
}(roja45productrentals || {}));
