/**
 * roja45productrental_order.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

var roja45productrentals = (function (my) {
    var invalidfields = 0;
    var validateRequestPool = Array();
    var validateRequest = null;
    var abortedRequestPool = Array();

    my.validateFields = function(e) {
        var validationErrors = [];
        var arrival_date = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').val();

        if (arrival_date.length == 0) {
            validationErrors.push(roja45_arrival_date_error);
        }

        var departure_date = $('#ROJA45_PRODUCTRENTAL_RETURN_DATE').val();
        if (departure_date.length == 0) {
            validationErrors.push(roja45_departure_date_error);
        }
        // get days
        if (validationErrors.length > 0) {
            e.preventDefault();
            roja45productrentals.displayErrors(validationErrors);
            return false;
        }
    };

    my.getRentalDetails = function() {
        var ROJA45_PRODUCTRENTAL_ID = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_ID]').val();
        var ROJA45_PRODUCTRENTAL_COLLECTION_DATE = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').val();
        var ROJA45_PRODUCTRENTAL_COLLECTION_TIME = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').val();
        var ROJA45_PRODUCTRENTAL_RETURN_DATE = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').val();
        var ROJA45_PRODUCTRENTAL_RETURN_TIME = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').val();

        var rental_details = {
            active_product : true,
            id_roja45_product : ROJA45_PRODUCTRENTAL_ID,
            collection_date : ROJA45_PRODUCTRENTAL_COLLECTION_DATE,
            collection_time : ROJA45_PRODUCTRENTAL_COLLECTION_TIME + ':00',
            return_date : ROJA45_PRODUCTRENTAL_RETURN_DATE,
            return_time : ROJA45_PRODUCTRENTAL_RETURN_TIME + ':00',
            vouchers : [],
            models : []
        };

        $('#enter_voucher_code ul.voucher-name li').each( function(index, element) {
            var voucher = {
                'code' : $(this).attr('data-code')
            }
            rental_details.vouchers.push(voucher);
        });

        $('#available_models_container .ajax-block-product-rental-model.has-quantity').each(function(index, element) {
            var selected_rate = false;
            if ($(this).find('.rate-selector.selected').length) {
                selected_rate = $(this).find('.rate-selector.selected');
            } else {
                selected_rate = $(this).find('.btn-productrental-selectrate.selected');
            }

            if (selected_rate != 'undefined' && selected_rate.length) {
                request_valid=true;
                var id_roja45_product_model = selected_rate.closest('.ajax-block-product-rental-model').attr('data-id-roja45-product-model');
                var id_product_attribute = selected_rate.closest('.ajax-block-product-rental-model').attr('data-id-product-attribute');
                if (!id_product_attribute) {
                    id_product_attribute = 0;
                }
                var id_roja45_product_rate = $(selected_rate).closest('.rate-selector').attr('data-id-roja45-product-rate');

                var model = null;
                var found = false;
                for(var i = 0; i < rental_details['models'].length; i++) {
                    if (rental_details['models'][i].id_roja45_product_model == id_roja45_product_model) {
                        found = true;
                        model = rental_details['models'][i];
                        var rates = request['rates'];
                        break;
                    }
                }

                if (!found) {
                    model = {
                        'id_roja45_product_rental_model' : id_roja45_product_model,
                        'id_product_attribute' : id_product_attribute,
                        'id_roja45_product_rateduration' : $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RATE_DURATION]').val(),
                        'collection_date' : ROJA45_PRODUCTRENTAL_COLLECTION_DATE,
                        'collection_time' : ROJA45_PRODUCTRENTAL_COLLECTION_TIME + ':00',
                        'return_date' : ROJA45_PRODUCTRENTAL_RETURN_DATE,
                        'return_time' : ROJA45_PRODUCTRENTAL_RETURN_TIME + ':00',
                        rates : [],
                        extras : []
                    }
                }

                // TODO - Build periods array
                var periods = [];
                $('#rate-info-'+id_roja45_product_model).find('.product-rental-rate-list-container[data-id-roja45-product-rate='+ id_roja45_product_rate +'] .rental-periods-content-column-container').each(function(index, element) {
                    var period = {
                        'period' : $(this).attr('data-period'),
                        'rule_modifier' : $(this).attr('data-rule-modifier'),
                    }
                    periods.push(period);
                });

                var rate = {
                    'id_roja45_product_rate': id_roja45_product_rate,
                    'qty': parseInt($(this).find('input[name=selected_qty]').val()),
                    'periods': periods,
                };
                model.rates.push(rate);

                $('#roja45productrental_available_extras .ajax-block-product-rental-extra[data-id-roja45-product-model='+id_roja45_product_model+']').find('.roja45productrental-addon').each(function() {
                    if ($(this).find('.checkbox:checked').length || $(this).find('.roja45productrental-addon-checkbox .selected').length) {
                        var id_roja45_product_extra = $(this).attr('data-id-roja45-product-extra');
                        var extra = {
                            'id_roja45_product_extra' : id_roja45_product_extra,
                            'id_roja45_product_model' : id_roja45_product_model
                        };
                        model.extras.push(extra);
                    }
                });

                $(this).closest('.ajax-block-product-rental-model').find('.roja45productrental-addon').each(function() {
                    if ($(this).find('.checkbox:checked').length || $(this).find('.checkbox[data-checked=checked]').length) {
                        var id_roja45_product_extra = $(this).attr('data-id-roja45-product-extra');
                        var extra = {
                            'id_roja45_product_extra' : id_roja45_product_extra,
                            'id_roja45_product_model' : id_roja45_product_model
                        };
                        model.extras.push(extra);
                    }
                });

                rental_details.models.push(model);
            }
        });

        return  {
            products : [rental_details]
        };
    };

    my.validateRental = function() {
        var rental_details = roja45productrentals.getRentalDetails();
        if (rental_details) {
            var url = $('#roja45productrental_reserve_form').attr('action');
            if(validateRequest && validateRequest.readyState != 4){
                validateRequest.abort();
            }
            validateRequest = $.ajax({
                url: url,
                type: 'post',
                dataType: 'json',
                data: {
                    'action' : 'validateRental',
                    'ajax' : 1,
                    'current_product_id' : $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_ID]').val(),
                    'rental_details' : JSON.stringify(rental_details)
                },
                beforeSend: function (jqXHR) {
                    roja45productrentals.showPricesWaitDialog();
                },
                success: function (data, status, jqXHR) {
                    if (data.result) {
                        $('#rental_totals .rental-totals-container').empty();
                        $('ul.voucher-name').show();
                        $('#rental_totals .rental-totals-container').prepend(data.rental_details_html);
                        $('#rental_messages').empty().append(data.rental_messages_html);
                        if ($('#rental_messages .center-block-content-message').length == 0) {
                            $('#rental_messages').slideUp();
                        } else {
                            $('#rental_messages').slideDown();
                        }
                        if ((data.current_product.vouchers.length > 0)) {
                            $.each(data.current_product.vouchers, function(index, value) {
                                $.each(value.extras, function(index, value) {
                                    $.each($('#roja45productrental_available_extras .roja45productrental-addon[data-id-roja45-product-extra='+value+']'), function(index, value) {
                                        $(this).find('.price').hide();
                                        $(this).find('.price.free-voucher').show();
                                    });
                                });
                            });
                        } else {
                            $('#roja45productrental_available_extras p.price.free-voucher').hide();
                            $('#roja45productrental_available_extras p.price.standard').show();
                        }
                        if (data.rental_valid) {
                            $('.btn-productrental-selectextras').removeClass('disabled');
                            $('.btn-productrental-selectextras').removeAttr('disabled');
                            $('.btn-productrental-reserve').removeClass('disabled');
                            $('.btn-productrental-reserve').removeAttr('disabled');
                        } else {
                            $('.btn-productrental-selectextras').addClass('disabled');
                            $('.btn-productrental-selectextras').attr('disabled', 'disabled');
                            $('.btn-productrental-reserve').addClass('disabled');
                            $('.btn-productrental-reserve').attr('disabled', 'disabled');
                        }
                    } else {
                        // show errors
                    }
                },
                error: function (data) {
                    console.log('No summary available.');
                },
                complete: function (data) {
                    roja45productrentals.hidePricesWaitDialog();
                }
            });
        } else {
            $('.btn-productrental-reserve').addClass('disabled');
            $('.btn-productrental-reserve').attr('disabled', 'disabled');
        }
    };

    my.validate = function() {
        roja45productrentals.invalidfields = 0;
        $('#roja45productrental_reserve_form .is_required').each( function( index, value) {
            var invalid = false;

            if ($(this).val().length == 0 ) {
                invalid = true;
            } else if ( $(this).attr('data-validate') != 'none' ) {
                if ($(this).attr('name') == 'postcode' && typeof(countriesNeedZipCode[$('#id_country option:selected').val()]) != 'undefined')
                    var result = window['validate_'+$(this).attr('data-validate')]($(this).val(), countriesNeedZipCode[$('#id_country option:selected').val()]);
                else
                    var result = window['validate_'+$(this).attr('data-validate')]($(this).val())
                if (result) {
                    invalid = false;
                } else {
                    invalid = true;
                }
            }

            if (invalid) {
                $(this).closest('.form-group').addClass('form-error').removeClass('form-ok');
                roja45productrentals.invalidfields++;
            } else {
                $(this).closest('.form-group').removeClass('form-error').addClass('form-ok');
            }
        });
    };

    my.addToCart = function (url, e) {
        try {
            var validationErrors = [];
            var arrival_date = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').val();

            if (arrival_date.length == 0) {
                validationErrors.push(roja45_arrival_date_error);
            }

            var departure_date = $('#ROJA45_PRODUCTRENTAL_RETURN_DATE').val();
            if (departure_date.length == 0) {
                validationErrors.push(roja45_departure_date_error);
            }
            // get days
            if (validationErrors.length > 0) {
                e.preventDefault();
                roja45productrentals.displayErrors(validationErrors);
                return false;
            }

            $('input[name=ROJA45_PRODUCTRENTAL_REQUEST]').val(JSON.stringify(roja45productrental_selection));
            roja45productrentals.toggleWaitDialog();

        } catch (Exception) {
            e.preventDefault();
        }
    };

    my.submitRental = function() {
        var rental_details = roja45productrentals.getRentalDetails();
        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_REQUEST]').val(JSON.stringify(rental_details));
        $('#roja45productrental_reserve_form').attr('action', roja45_productrental_controller+'&submitRental=1');
        roja45productrentals.toggleWaitDialog();
    };

    my.deleteRentalEntry = function(ele) {
        var href = ele.attr('href');
        $.ajax({
            url: href,
            type: 'get',
            dataType: 'json',
            beforeSend: function () {
                roja45productrentals.togglePricesWaitDialog();
            },
            success: function (data) {
                if (data.result) {
                    if (data.redirect) {
                        window.location = data.redirect;
                    } else {
                        $(ele).closest('#roja45productrental_summary').fadeOut('fast', function() {
                            $('#roja45_productrental_booking_details').remove();
                            $(data.html).insertBefore('#roja45productrental_customerconfirmation_form');
                            $(this).fadeIn();
                        });
                    }
                } else {
                    roja45productrentals.displayErrors(data.errors);
                }
            },
            error: function (data) {
                console.log('No summary available.');
            },
            complete: function (data) {
                roja45productrentals.togglePricesWaitDialog();
            }
        });
    };

    my.checkDateAvailable = function(dateToCheck) {
        var day = (dateToCheck.getDay()+1);
        if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
            $returnclass = "unavailable non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = false;
            return [$return, $returnclass, $returntooltip];
        } else if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
            $returnclass = "available non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = true;
            return [$return, $returnclass, $returntooltip];
        } else {
            return [true, 'available', roja45_productrental_calendar_tooltip_num_available];
        }
    };
    /*
    my.checkDateAvailable = function(dateToCheck, arrivalDate, arrival, id_combination, minimum_duration, maximum_duration) {
        if (!arrival) {
            var maximum_date = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
            if (maximum_date) {
                maximum_date = maximum_date.setDate(maximum_date.getDate() + parseInt(maximum_duration));
                if (maximum_duration && (roja45productrentals.dateCompare(maximum_date, d))) {
                    $returnclass = "unavailable maximum-duration";
                    $returntooltip = roja45_productrental_calendar_tooltip_maxduration;
                    $return = false;
                    return [$return, $returnclass, $returntooltip];
                }
            }
        }

        var $return = true;
        var $returnclass = "available";

        var $returntooltip = roja45_rentals[id_combination]['total_available'] + ' ' + roja45_productrental_calendar_tooltip_num_available;
        var day = (dateToCheck.getDay()+1);

        if (roja45_working_days[day]['working_day']=='0') {
            $returnclass = "unavailable non-working-day";
            $returntooltip = roja45_productrental_calendar_tooltip_closed;
            $return = false;
            return [$return, $returnclass, $returntooltip];
        }

        if (roja45_productrental_calendaravailability==1) {
            if (!arrival && (roja45productrentals.dateCompare(dateToCheck, arrivalDate))) {
                $returnclass = "unavailable before-arrival";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }

            if (roja45_block_remaining) {
                $returnclass = "unavailable no-consecutive";
                $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                $return = false;
                return [$return, $returnclass, $returntooltip];
            }
            var checkdate = $.datepicker.formatDate('yy-mm-dd', dateToCheck);
            if (typeof roja45_rentals[id_combination]['dates'] === 'object' && typeof roja45_rentals[id_combination]['dates'][checkdate] != 'undefined') {
                var rentals = roja45_rentals[id_combination]['dates'][checkdate];
                var available = roja45_rentals[id_combination]['total_available'];
                var diff = available - rentals['count'];
                var type = rentals['type'];

                if (type==1) {
                    // Reservable as end date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "unavailable";
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_checkout_only;
                            $return = true;
                            $returnclass = "available-departure";
                            //roja45_block_remaining = true;
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==2) {
                    // Reserved
                    if (diff <= 0) {
                        $return = false;
                        $returnclass = "unavailable";
                        $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    }
                } else if (type==3) {
                    // Reservable as start date
                    if (diff <= 0) {
                        if (arrival) {
                            $returnclass = "available-arrival";
                            $returntooltip = roja45_productrental_calendar_tooltip_checkin_only + ' ' +roja45_rentals[id_combination]['dates'][checkdate]['time'];
                            $return = true;
                        } else {
                            $returntooltip = roja45_productrental_calendar_tooltip_unavailable;
                            $return = false;
                            $returnclass = "unavailable";
                        }
                    } else if (diff == roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff > roja45_productrental_availability_warning && diff != available) {
                        $return = true;
                        $returnclass = "available-has-reservations";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff > roja45_productrental_availability_warning) {
                        $return = true;
                        $returnclass = "available";
                        $returntooltip = diff + ' ' + roja45_productrental_calendar_tooltip_num_available;
                    } else if (diff == 1 && !arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else if (diff == 1 && arrival) {
                        $return = true;
                        $returnclass = "available last-available";
                        $returntooltip = roja45_productrental_calendar_tooltip_last;
                    } else {
                        if (arrival) {
                            $returnclass = "available";
                            $returntooltip = roja45_productrental_calendar_tooltip_last;
                            $return = true;
                        }
                    }
                }
            }
        }
        return [$return, $returnclass, $returntooltip];

    };*/

    my.addVoucher = function(code) {
        if (code) {
            if ($('ul.voucher-name li[data-code='+code+']').length==0) {
                $('ul.voucher-name').append('<li class="voucher-summary-line" data-code="'+code+'"><span class="label">'+code+'<a href="#delete-voucher-code" class="delete-voucher"><i class="material-icons"></i></a></li>');
                $('input[name=voucher-input]').val();
                roja45productrentals.validateRental();
            }
        }
    }

    my.removeVoucher = function(code) {
        if (code) {
            $('ul.voucher-name li[data-code='+code+']').remove();
            if ($('ul.voucher-name li[data-code='+code+']').length==0) {
                $('ul.voucher-name').hide();
            }
            roja45productrentals.validateRental();
        }
    }

    my.showModelsTab = function () {
        window.location.hash = '';
        $('#roja45productrental_available_extras').fadeOut('fast', function() {
            $('#roja45productrental_available_models').fadeIn();
        });
    };

    my.showExtrasTab = function () {
        window.location.hash = '/extras';
        $('#roja45productrental_available_models').fadeOut('fast', function() {
            var rental_details = roja45productrentals.getRentalDetails();
            $('#roja45productrental_available_extras article').hide();
            for(var i = 0; i < rental_details['products'][0]['models'].length; i++) {
                var id_roja45_product_rental_model = rental_details['products'][0]['models'][i].id_roja45_product_rental_model;
                $('#roja45productrental_available_extras article[data-id-roja45-product-model='+id_roja45_product_rental_model+']').show();
            }

            $('.models.title').hide();
            $('.extras.title').show();

            $('#rental_summary').hide();
            $('.btn.btn-productrental-selectextras').hide();

            $('.btn.btn-productrental-reserve').show();
            $('#roja45productrental_available_extras').fadeIn();
        });
    };

    my.parseDate = function (str) {
        var mdy = str.split('/')
        return new Date(mdy[2], mdy[1] - 1, mdy[0]);
    };

    my.daydiff = function (first, second) {
        return Math.round((second - first) / (1000 * 60 * 60 * 24));
    },

    my.resetForm = function() {
        $('input[name=ROJA45_PRODUCTRENTAL_SPACES]').val('');
        $('input[name=selected_number_rooms]').each( function() {
            $(this).val('');
        });
        $('input[name=selected_number_value]').each( function() {
            $(this).val('');
        });
        $('.btn-productrental-reserve').addClass('disabled');
    };

    my.displayWarning = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    my.displayErrors = function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    };

    my.togglePricesWaitDialog = function () {
        if ($('#rental_totals_updating').is(':visible')) {
            $('#rental_totals_updating').fadeOut();
        } else {
            $('#rental_totals_updating').fadeIn();
        }
    };

    my.showPricesWaitDialog = function () {
        $('#rental_totals_updating').fadeIn();
    };

    my.hidePricesWaitDialog = function () {
        $('#rental_totals_updating').fadeOut();
    };
    return my;
}(roja45productrentals || {}));

$(document).ready(function () {
    Date.prototype.addDays = function(days) {
        var date = new Date(this.valueOf())
        date.setDate(date.getDate() + days);
        return date;
    }

    var minimum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val());
    var maximum_duration = parseInt($('input[name=ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION]').val());

    var last_hash;
    var hash = location.hash.replace(/^#/, '');
    $(window).on('hashchange', function(e) {
        last_hash = hash;
        hash = location.hash.replace(/^#/, '');
        if (hash.length==0) {
            $('#roja45productrental_available_extras').fadeOut('fast', function() {
                $('#rental_summary').show();
                $('.models.title').show();
                $('.extras.title').hide();
                $('.btn.btn-productrental-reserve').hide();
                $('.btn.btn-productrental-selectextras').show();
                $('#roja45productrental_available_models').fadeIn();
            })
        }
    });

    if(window.location.hash) {
        if (window.location.hash.substring(1) == '/extras') {
            roja45productrentals.showExtrasTab();
        }
    } else {

    }

    $(document).on('click', '.btn-back-to-models', function(e) {
        e.preventDefault();
        roja45productrentals.showModelsTab();
    });

    $(document).on('click', '.btn-add-voucher', function(e) {
        e.preventDefault();
        roja45productrentals.addVoucher($('input[name=voucher_code]').val());
    });

    $(document).on('click', 'a.delete-voucher', function(e) {
        e.preventDefault();
        var code = $(this).closest('.voucher-summary-line').attr('data-code');
        roja45productrentals.removeVoucher(code);
    });

    $('.btn-productrental-selectextras').on('click', function(e) {
        e.preventDefault();
        if (!$(this).hasClass('disabled')) {
            roja45productrentals.showExtrasTab();
        }
    });

    $('#roja45search_query_top').on('click', function (index, element) {
        $('#roja45productrental_searchbox ul.unorder_list_container').slideDown('fast', function () {
            $('#roja45productrental_searchbox')[0].reset();
            $(this).addClass('active');
        });
    });

    $(document).on('click', '.product-rental-rate .checker', function(e) {
        var input = $(this).find('input[name=product_rental_rate]');
        if (input.is(":checked")) {
            input.parent().removeClass('checked');
            input.attr('checked', false).change();
        } else {
            input.parent().addClass('checked');
            input.attr('checked', true).change();
        }
       // roja45productrentals.validateRental($(this));
    });

    $('input[name=product_rental_rate]').on('change', function(e) {
        $(this).closest('.rate-selector').toggleClass('selected');
        $(this).closest('.rate-selector').toggleClass('unselected');
        $(this).closest('.ajax-block-product-rental-model').toggleClass('has-quantity');
        roja45productrentals.validateRental($(this));
    });

    $('.roja45-rental-product-17 input[name=selected_qty]').each(function(index) {
        $(this).TouchSpin({
            max: $(this).attr('max'),
            verticalbuttons: true,
            verticalupclass: 'material-icons touchspin-up',
            verticaldownclass: 'material-icons touchspin-down',
            buttondown_class: 'btn btn-touchspin js-touchspin',
            buttonup_class: 'btn btn-touchspin js-touchspin',
        });
    });

    $('input[name=selected_qty]').on('change', function(e) {
        if ($(this).closest('.ajax-block-product-rental-model').hasClass('has-quantity')) {
            roja45productrentals.validateRental($(this));
        }
    });

    $('#roja45productrental_searchbox ul.unorder_list_container').on('mouseenter', function (index, element) {
        $(this).addClass('hovered');
    });

    $('#roja45productrental_searchbox ul.unorder_list_container').on('mouseleave', function (index, element) {
        $(this).removeClass('hovered');
    });

    if ($('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').length > 0) {
        var minDate = new Date();
        minDate = minDate.addDays(parseInt(roja45_productrental_preparationdays));

        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker({
            minDate: minDate,
            changeMonth: false,
            changeYear: false,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 2,
            showButtonPanel: true,
            onSelect: function (selectedDate, obj) {
                var period = roja45_productrental_rateperiods[$('input[name=ROJA45_PRODUCTRENTAL_RATEPERIOD]').val()];
                if (period['period']=='DAY') {
                    // TODO set collection time min/max based on day
                    var departureDate = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
                    if (typeof departureDate !== "undefined" && departureDate) {
                        var day = departureDate.getDay()+1;
                        $('.roja45productrental-form-messages.collection').slideUp('fast', function() {
                            var collectionDay = departureDate.getDay()+1;
                            if (roja45_working_days[collectionDay]['working_day']=='0' && roja45_working_days[collectionDay]['allow_rentals']=='1') {
                                if ($('.roja45productrental-form-messages.collection').is(":hidden")) {
                                    $('.roja45productrental-form-messages.collection').slideDown();
                                }
                            }
                        });

                        var opening_time = roja45_working_days[day]['opening_time'];
                        var closing_time = roja45_working_days[day]['closing_time'];
                        var res = departureDate.toISOString().slice(0,10);
                        opening_time = new Date(Date.parse(res + 'T' + opening_time));
                        closing_time = new Date(Date.parse(res + 'T' + closing_time));
                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));
                        departureDate.setDate(departureDate.getDate()+parseInt($('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val()));
                        var day = departureDate.getDay()+1;
                        if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
                            var not_found = true;
                            var days_to_add = 1;
                            while (not_found) {
                                if (day==7) {
                                    day = 1;
                                } else {
                                    day++;
                                }
                                if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='0') {
                                    days_to_add++;
                                } else {
                                    not_found = false;
                                    departureDate.setDate(departureDate.getDate()+parseInt(days_to_add));
                                }
                                /*if (roja45_working_days[day]['working_day']=='1') {
                                    not_found = false;
                                    departureDate.setDate(departureDate.getDate()+parseInt(days_to_add));
                                } else {
                                    days_to_add++;
                                }*/
                            }
                        }

                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                    }
                } else if(period['period']=='WEEK') {
                    // TODO - define whether daya to day, arbitary, restrict to 7 day blocks, etc
                } else if (period['period']=='MONTH') {

                } else if (period['period']=='CUSTOM') {
                    var departureDate = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate', minimum_duration+'d');
                    if (typeof departureDate !== "undefined" && departureDate) {
                        departureDate.setDate(departureDate.getDate()+parseInt(minimum_duration));
                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', departureDate);
                        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', departureDate);
                    }
                }
                if (roja45_productrental_enabletimeselect) {
                    //$('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').datepicker("show");
                } else {
                    if (departureDate != null && maximum_duration==0) {
                        //    $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker("show");
                    }
                }
            },
            beforeShow: function() {
                roja45_block_remaining = false;
            },
            beforeShowDay: function (selectedDate) {
                return roja45productrentals.checkDateAvailable(
                    selectedDate
                );
            }
        });
        if (roja45_productrental_enabletimeselect) {
            $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_TIME]').timepicker({
                timeFormat: roja45_productrental_timeformat,
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: roja45_productrental_timestep,
                showButtonPanel: false,
            });
        }

        $('.roja45productrental_block .cal-arrival .input-group-addon').on('click', function(e) {
            $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker("show");
        });
        $('.roja45productrental_block .cal-departure .input-group-addon').on('click', function(e) {
            $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker("show");
        });
    }

    if ($('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').length > 0) {
        var minDepartureDate = $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_COLLECTION_DATE]').datepicker('getDate');
        if (minDepartureDate) {
            minDepartureDate.setDate(minDepartureDate.getDate()+parseInt($('input[name=ROJA45_PRODUCTRENTAL_MINIMUM_DURATION]').val()));
            var day = minDepartureDate.getDay() + 1;
            if (roja45_working_days[day]['working_day'] == '0' && roja45_working_days[day]['allow_rentals'] == '0') {
                var not_found = true;
                var days_to_add = 1;
                while (not_found) {
                    if (day == 7) {
                        day = 1;
                    } else {
                        day++;
                    }
                    if (roja45_working_days[day]['working_day'] == '0' && roja45_working_days[day]['allow_rentals'] == '0') {
                        days_to_add++;
                    } else {
                        not_found = false;
                        minDepartureDate.setDate(minDepartureDate.getDate() + parseInt(days_to_add));
                    }
                }
            }
            $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('setDate', minDepartureDate);
            $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker('option', 'minDate', minDepartureDate);
        } else {
            minDepartureDate = new Date();
            minDepartureDate = minDepartureDate.addDays(parseInt(roja45_productrental_preparationdays));
        }

        $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').datepicker({
            minDate: minDepartureDate,
            changeMonth: false,
            changeYear: false,
            dateFormat: roja45_productrental_dateformat,
            numberOfMonths: 2,
            showButtonPanel: true,
            onSelect: function (selectedDate, obj) {
                var minDate = $(this).datepicker('getDate');
                var day = minDate.getDay()+1;
                $('.roja45productrental-form-messages.return').slideUp('fast', function() {
                    if (roja45_working_days[day]['working_day']=='0' && roja45_working_days[day]['allow_rentals']=='1') {
                        if ($('.roja45productrental-form-messages.return').is(":hidden")) {
                            $('.roja45productrental-form-messages.return').slideDown();
                        }
                    }
                });
                var opening_time = roja45_working_days[day]['opening_time'];
                var closing_time = roja45_working_days[day]['closing_time'];
                var res = minDate.toISOString().slice(0,10);
                opening_time = new Date(Date.parse(res + 'T' + opening_time));
                closing_time = new Date(Date.parse(res + 'T' + closing_time));
                // $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').timepicker('option', 'minDateTime', new Date(opening_time.getTime()));
                // $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_DATE]').timepicker('option', 'maxDateTime', new Date(closing_time.getTime()));

                minDate.setDate(minDate.getDate() + 1);  // TODO - Use min days  ONLY IF END DATE FIELD EXISTS (I.E. NOT USING NUM NIGHTS FIELD)
            },
            beforeShow: function () {
                roja45_block_remaining = false;
            },
            beforeShowDay: function (selectedDate) {
                return roja45productrentals.checkDateAvailable(
                    selectedDate
                );
            }
        });

        // if (typeof roja45_productrental_enabletimeselect != 'undefined' && roja45_productrental_enabletimeselect) {
        //     $('#roja45productrental_reserve_form input[name=ROJA45_PRODUCTRENTAL_RETURN_TIME]').timepicker({
        //         timeFormat: roja45_productrental_timeformat,
        //         controlType: 'select',
        //         oneLine: true,
        //         stepHour: 1,
        //         stepMinute: roja45_productrental_timestep,
        //         showButtonPanel: false,
        //     });
        // }
    }

    $('.change-search').on('click', function (e) {
        e.preventDefault();
        $('.search-query').slideUp('slow', function () {
            $('.search-query-table').hide()
            $('.new-search-query').show();
            $('.search-query').slideDown('slow');
        });
    });

    $('.btn-cancelnewsearch').on('click', function (e) {
        e.preventDefault();
        $('.search-query').slideUp('slow', function () {
            $('.search-query-table').show()
            $('.new-search-query').hide();
            $('.search-query').slideDown('slow');
        });
    });

    $(document).click(function (e) {
        if ($('#roja45productrental_searchbox ul.unorder_list_container').hasClass('active') && !$('#roja45productrental_searchbox ul.unorder_list_container').hasClass('hovered')) {
            $("#roja45productrental_searchbox ul.unorder_list_container").slideUp();
            $("#roja45productrental_searchbox ul.unorder_list_container").removeClass('active');
        }
    });

    $('.btn-productrental-reserve').on('click', function(e) {
        roja45productrentals.submitRental();
    });

    $(document).on('click', '.delete-rental-entry', function (e) {
        e.preventDefault();
        roja45productrentals.deleteRentalEntry($(this));
    });

    $(document).on('click', '.dropdown dt a', function (e) {
        e.preventDefault();
        e.stopPropagation();
        var ele = $(this).closest('.dropdown').find('dd ul');
        if ($(this).closest('.dropdown').hasClass('active')) {
            ele.slideUp();
            $(this).closest('.dropdown').removeClass('active');
        } else {
            $(this).closest('.dropdown').addClass('active');
            ele.slideDown();
        }
    });

    $(document).click(function (e) {
        if ($('.select-field .dropdown dd ul').is(':visible')) {
            $('.select-field .dropdown dd ul').slideUp();
            $('.select-field .dropdown').removeClass('active');
        }

        if ($('.dropdown dd ul').is(':visible')) {
            $('.dropdown dd ul').slideUp();
            $('.dropdown').removeClass('active');
        }

        if ($('.rate-nights-room-modal').is(':visible')) {
            $('.rate-nights-room-modal').fadeOut('fast');
        }
    });

    $('.show-daily-prices').on('click', function(e) {
        e.preventDefault();
        roja45productrentals.showDailyRate(e, $(this));
    });

    $(document).on('click', '.dropdown dd ul li a', function (e) {
        e.preventDefault();
        var id = $(this).attr('data-id');
        var value = $(this).attr('data-value');
        $(this).closest('.dropdown').find('dt a span').html(value);
        $(this).closest('.dropdown').find('dt a').attr('data-id', id);
        $(this).closest('.dropdown').find('dt a').attr('data-value', value);
        $(this).closest('.dropdown').find('input[name=selected_value]').val(value);
        $(this).closest('.dropdown').find('dd ul').slideUp();
        $(this).closest('.dropdown').removeClass('active');
        roja45productrentals.validateRental($(this));
    });

    $(document).on('click', '.number-spinner .num-selector-up', function (e) {
        e.preventDefault();
        var fieldName = $(this).attr('data-field-name');
        var currentVal = parseInt($('input[name=' + fieldName + ']').val());
        var maxValue = parseInt($(this).attr('data-maximum'));
        if (!isNaN(currentVal)) {
            currentVal = currentVal+1;
            if (maxValue>-1) {
                if (currentVal < maxValue) {
                    $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
                }
            } else {
                $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
            }
        }
    });

    $(document).on('click', '.number-spinner .num-selector-down', function (e) {
        e.preventDefault();
        var fieldName = $(this).attr('data-field-name');
        var currentVal = parseInt($('input[name=' + fieldName + ']').val());
        var minValue = parseInt($(this).attr('data-minimum'));
        if (!isNaN(currentVal) && currentVal > minValue) {
            currentVal = currentVal-1;
            $('input[name=' + fieldName + ']').val(currentVal).trigger('keyup');
        } else {
            $('input[name=' + fieldName + ']').val(minValue);
        }
    });

    $(document).on('change', '.roja45productrental-addon-checkbox .checkbox', function(e) {
        var deselect_warning = parseInt($(this).closest('.roja45productrental-addon').attr('data-deselect-warning'));
        if (deselect_warning && !this.checked) {
            var id_roja45_product_extra = $(this).closest('.roja45productrental-addon').attr('data-id-roja45-product-extra');
            $('#modal-deselect-warning-'+id_roja45_product_extra).modal();
        }
        roja45productrentals.validateRental($(this));
    });

    $('.btn-productrental-selectextra').on('click', function(e) {
        e.preventDefault();
        $(this).toggleClass('selected');
        $(this).toggleClass('unselected');

        if ($(this).hasClass('unselected')) {
            var deselect_warning = parseInt($(this).closest('.roja45productrental-addon').attr('data-deselect-warning'));
            if (deselect_warning && !this.checked) {
                var id_roja45_product_model = $(this).closest('article.ajax-block-product-rental-extra').attr('data-id-roja45-product-model');
                var id_roja45_product_extra = $(this).closest('.roja45productrental-addon').attr('data-id-roja45-product-extra');
                $('#modal-deselect-warning-'+id_roja45_product_model + '-' + id_roja45_product_extra).modal();
            }
        }
        roja45productrentals.validateRental($(this));
    });


    $('.btn-productrental-selectrate').on('click', function(e) {
        e.preventDefault();
        if (roja45_productrental_singleitemrentals) {
            $(this).toggleClass('selected');
            $(this).toggleClass('unselected');
        } else {
            $(this).closest('.rental-item').find('.btn-productrental-selectrate').not(this).removeClass('selected');
            $(this).closest('.rental-item').find('.btn-productrental-selectrate').not(this).addClass('unselected');
            $(this).toggleClass('selected');
            $(this).toggleClass('unselected');
        }

        if ($(this).closest('article').find('a.btn-productrental-selectrate.selected').length > 0) {
            $(this).closest('article').addClass('has-quantity');
        } else {
            $(this).closest('article').removeClass('has-quantity');
        }
        roja45productrentals.validateRental($(this));
    });

    $('.btn-search, .btn-update').on('click', function(e) {
        e.preventDefault();
        $('<input>').attr({
            type: 'hidden',
            name: 'getAvailability',
            value: 1
        }).appendTo('#roja45productrental_reserve_form');
        $('#roja45productrental_reserve_form').submit();
    });


    roja45productrental_selection = {};

    if ($('.roja45-rental-product-17 #ROJA45_PRODUCTRENTAL_REQUESTED_QTY').length) {
        $('.roja45-rental-product-17 #ROJA45_PRODUCTRENTAL_REQUESTED_QTY').TouchSpin({
            verticalbuttons: true,
            verticalupclass: 'material-icons touchspin-up',
            verticaldownclass: 'material-icons touchspin-down',
            buttondown_class: 'btn btn-touchspin js-touchspin',
            buttonup_class: 'btn btn-touchspin js-touchspin',
            min: 1,
            max: 1000000
        });
    }

    $('.btn.btn-productrental-selectextras, .btn.btn-productrental-reserve').removeClass('roja45-page-loading');

    if(!/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent) && $('.totals-scroll-anchor').length > 0) {
        var totals_height = $('.totals-scroll-content').outerHeight(true);
        $(window).scroll(function(e) {
            var scroller_anchor = $('.totals-scroll-anchor').offset().top;
            var scroller_anchor_width = $('.totals-scroll-anchor').width();

            var bottom = totals_height + 10;
            var footer = $('#footer').offset().top - $(window).scrollTop();

            var bottom_fixed = $(window).height()-footer;
            if (bottom >= footer) {
                $('.totals-scroll-content').addClass('roja45-scroll');
                $('.totals-scroll-content').removeClass('roja45-fixed-top');
                $('.totals-scroll-content').css({
                    'position': 'fixed',
                    'top': 'unset',
                    'bottom': ($(window).height()-footer) + 'px'
                });
                $('.totals-scroll-anchor').css('height', '50px');
            } else if ($(this).scrollTop() >= scroller_anchor && $('.totals-scroll-content').css('position') != 'fixed') {
                $('.totals-scroll-content').addClass('roja45-scroll');
                $('.totals-scroll-content').removeClass('roja45-fixed-top');
                $('.totals-scroll-content').css({
                    'width': scroller_anchor_width,
                    'position': 'fixed',
                    'top': '10px'
                });
                $('.totals-scroll-anchor').css('height', '50px');
            } else if ($(this).scrollTop() < scroller_anchor && $('.totals-scroll-content').css('position') != 'relative') {
                $('.totals-scroll-anchor').css('height', '0px');
                $('.totals-scroll-content').removeClass('roja45-scroll');
                $('.totals-scroll-content').addClass('roja45-fixed-top');
                // Change the CSS and put it back to its original position.
                $('.totals-scroll-content').css({
                    'position': 'relative',
                    'top': '0px'
                });
            }
        });
    }
});
