/**
 * roja45productrentaladmin_calendar.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    calendar_object = null;
    var controller = $('#productrental_calendar_form').attr('action');
    roja45productrental.initCalendar(controller);

    $(document).on('click', '#addExternal', function(e) {
        e.preventDefault();
        roja45productrental.submitCalendarEntry($(this));
    });
    $(document).on('click', '#blockDates', function(e) {
        e.preventDefault();
        roja45productrental.markUnavailable($(this));
    });
    $(document).on('click', '#closeEntry', function(e) {
        e.preventDefault();
        roja45productrental.closeControlPanel();
    });
    $(document).on('click', '#deleteEntry', function(e) {
        e.preventDefault();
        roja45productrental.submitDeleteUnavailable($(this).attr('href'), $(this).attr('data-id-roja45-product-unavailable'));
    });
});

roja45productrental = {
    initCalendar : function(controller) {
        if (calendar_object) {
            $('#productrental_calendar_block').fullCalendar( 'refetchEvents' );
        } else {
            calendar_object = $('#productrental_calendar_block').fullCalendar({
                timezone: false,
                editable: true,
                eventStartEditable: false,
                eventDurationEditable: false,
                nextDayThreshold: '00:01',
                timeFormat: 'hh:mm a',
                customButtons: {
                    refreshCalendar: {
                        text: roja45_productrental_refresh,
                        click: function () {
                            $('#productrental_calendar_block').fullCalendar('refetchEvents');
                        }
                    }
                },
                header: {
                    left: 'prev,next today',
                    center: 'title',
                    right: 'refreshCalendar'
                },
                eventSources: [
                    {
                        url: controller + '&action=getUnavailable&ajax=1',
                        type: 'POST',
                        data: function () {
                            return {
                                id_roja45_product: $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                            };
                        },
                        success: function(data) {
                            var events = [];
                        },
                        error: function(data) {
                            jAlert(data.responseText);
                        },
                    },
                    {
                        url: controller + '&action=getProductRentals&ajax=1',
                        type: 'POST',
                        data: function () {
                            return {
                                id_roja45_product: $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                            };
                        },
                        success: function(data) {
                            var events = [];
                        },
                        error: function(data) {
                            jAlert(data.responseText);
                        },
                    }
                ],
                /*
                events: {
                    url: href,
                    type: 'POST',
                    data: function () { // a function that returns an object
                        return {
                            id_roja45_product: $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                        };
                    }
                },
                */
                /*
                events: function(start, end, timezone, callback) {
                    $.ajax({
                        url: href,
                        dataType: 'json',
                        data: {
                            id_property: $('#propertymanager_property_form').find('#id_property').chosen().val(),
                        },
                        success: function(doc) {
                            var events = [];
                            $(doc).find('event').each(function() {
                                events.push({
                                    title: $(this).attr('title'),
                                    start: $(this).attr('start')
                                });
                            });
                            callback(events);
                            },
                        error: function (data) {
                            jAlert(data.responseText);
                        },
                        complete: function () {
                        }
                    });
                },

                dayRender: function(date, cell) {
                    var date_str = date.utc().format('YYYY-MM-DD');
                    if (typeof roja45_rates[date_str] !== "undefined") {
                        var html = '<div class="calendar_model_rates_block">';
                        html += '<ul class="calendar_model_rates"><table>';

                        $.each(roja45_rates[date_str], function(index, model) {
                            html += '<tr>';
                            html += '<table><thead>';
                            html += '<th colspan="3"><span>'+model.name+'</span></th>';
                            html += '</thead><tbody>';
                            $.each(model.rates, function(index, rate) {
                                html += '<tr>';
                                html += '<td colspan="2">'+rate.name+'</td><td colspan="1">'+rate.rate_formatted+'</td>';
                            });
                            html += '</tbody><table></tr>';
                        });

                        html += '</table></ul>';
                        html += '</div>';
                        $(cell).append(html);
                    }
                },
                */
                eventRender: function (event, element, view) {
                    if (event.allDay == true) {
                        event.allDay = true;
                    } else {
                        event.allDay = false;
                    }
                    element.find(".fc-title").empty().html('<p>' + event.title + '</p>');
                    element.find(".fc-content").append(event.description);
                },
                loading: function (isLoading, view) {
                    if (isLoading) {
                        roja45global.toggleModal();
                    } else {
                        roja45global.toggleModal();
                    }
                },
                selectable: true,
                selectHelper: true,
                select: function (start, end, allDay) {
                    if (start.isSame(moment(), 'day')  || start.isAfter(moment())) {
                        var end = moment(end).subtract(1, 'days');
                        if (start.utc().isSame(end.utc(), 'day')) {
                            var end = moment(end).add(1, 'days');
                        }
                        $.ajax({
                            type: 'GET',
                            url: controller,
                            cache: false,
                            dataType: 'json',
                            data: {
                                'action' : 'getCalendarProductModels',
                                'ajax' : 1,
                                'id_roja45_product' : $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                                'start_date' : start.utc().format('YYYY-MM-D'),
                                'end_date' : end.utc().format('YYYY-MM-D'),
                                'ajax' : 1,
                            },
                            beforeSend: function() {
                                roja45global.toggleModal();
                            },
                            success: function (data) {
                                if (data.result) {
                                    $('#productrental_calendar_control .calendar-entry-details-body').html(data.view);
                                    $('#productrental_calendar_control').fadeIn();
                                    $("input[name=event_start_date]").datepicker({
                                        changeMonth: true,
                                        changeYear: true,
                                        dateFormat: roja45_productrental_dateformat
                                    });
                                    $("input[name=event_end_date]").datepicker({
                                        changeMonth: true,
                                        changeYear: true,
                                        dateFormat: roja45_productrental_dateformat
                                    });
                                } else if (data.result == 'error') {
                                    $.each(data.errors, function (index, value) {
                                        roja45global.displayErrorMsg(value);
                                    });
                                } else {
                                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                                }
                            },
                            error: function (data) {
                                jAlert(data.responseText);
                            },
                            complete: function () {
                                roja45global.toggleModal();
                            }
                        });
                    } else {
                        calendar_object.fullCalendar('unselect');
                    }
                },
                eventClick: function (event, jsEvent, view) {
                    $('#eventUpdate').off('click').on('click', function (e) {
                        e.preventDefault();
                        var status = $('#fullCalModal select[name=reservation_status]').val();
                        var collection_date = $('#fullCalModal input[name=event_collection_date]').val();
                        var return_date = $('#fullCalModal input[name=event_return_date]').val();

                        var href = $(this).attr('href') + '&action=updateReservation&ajax=1&id_roja45_product=' + event.id_roja45_product + '&id_roja45_product_model=' + event.id_roja45_product_model + '&id_roja45_product_rental=' + event.id_roja45_product_rental + '&collection_date=' + collection_date + '&return_date=' + return_date + '&status=' + status;
                        roja45productrental.updateReservation(href);
                    });
                    $('#closeEntry').off('click').on('click', function (e) {
                        e.preventDefault();
                        roja45productrental.closeControlPanel();
                    });
                    $('#editEntry').off('click').on('click', function (e) {
                        e.preventDefault();
                        var href = $('#productrental_calendar_form').attr('action')+'&id_roja45_product_rental='+event.id_roja45_product_rental+'&viewroja45_productrental_rental';
                        window.open(href,'_blank');
                    });
                    $('#productrental_calendar_control .calendar-entry-details-body').html(event.summary);
                    $('#eventLink').attr('data-id-roja45-product-rental', event.id_roja45_product_rental);
                    $('.btn-requestpayment').off('click').on('click', function (e) {
                        e.preventDefault();
                        var href = $(this).attr('href');
                        roja45productrental.requestPayment(href);
                    });
                    $('#productrental_calendar_control').fadeIn();
                    $("#event_start_date").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat
                    });
                    $("#event_end_date").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat
                    });
                }
            });
        }
    },

    closeControlPanel : function() {
        $('#productrental_calendar_control').fadeOut('fast', function() {
            $('#productrental_calendar_control .calendar-entry-details-body').empty();
        });
    },

    submitCalendarEntry : function (ele)
    {
        var href = ele.attr('href') + '&action=addExternalReservation&ajax=1&id_roja45_product=' + $('input[name=ROJA45_PRODUCTRENTALS_PRODUCT_ID]').val() + '&id_roja45_product_model=' + $('select[name=ROJA45_PRODUCTRENTAL_PRODUCT_MODEL]').val();
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            data: $('#other_reservation_form').serialize(),
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    markUnavailable : function (ele)
    {
        $.ajax({
            type: 'GET',
            url: $('#productrental_calendar_form').attr('action'),
            cache: false,
            dataType: 'json',
            data: $('#block_dates_form').serialize(),
            data: {
                'action' : 'createUnavailable',
                'ajax' : 1,
                'id_roja45_product' : $('input[name=ROJA45_PRODUCTRENTAL_PRODUCT_ID]').val(),
                'event_start_date' : $('#block_dates_form input[name=event_start_date]').val(),
                'event_end_date' : $('#block_dates_form input[name=event_end_date]').val(),
                'event_note' : $('#block_dates_form input[name=event_note]').val(),
            },
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#productrental_calendar_block').fullCalendar('refetchEvents');
                    $('#productrental_calendar_control').fadeOut();
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    submitDeleteUnavailable : function (href, id_roja45_product_unavailable)
    {
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'deleteUnavailable',
                'ajax' : 1,
                'id_roja45_product_unavailable' : id_roja45_product_unavailable,
            },
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#productrental_calendar_block').fullCalendar('refetchEvents');
                    $('#productrental_calendar_control').fadeOut();
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    updateReservation : function (href)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.updateReservationConfirmed(href);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    updateReservationConfirmed : function (href)
    {
        var href = href;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#fullCalModal').modal('toggle');
                    $('#productrental_calendar_block').fullCalendar('removeEvents');
                    $('#productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    requestPayment : function (href)
    {
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_confirm,
            confirm: function () {
                roja45productrental.requestPaymentConfirmed(href);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    },

    requestPaymentConfirmed : function (href)
    {
        var href = href;
        $.ajax({
            type: 'GET',
            url: href,
            cache: false,
            dataType: 'json',
            beforeSend: function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    $('#fullCalModal').modal('toggle');
                    $('#productrental_calendar_block').fullCalendar('removeEvents');
                    $('#productrental_calendar_block').fullCalendar('refetchEvents');
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                roja45global.toggleModal();
            }
        });
    },

    displayWarning : function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    },

    displayErrors : function (errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-error">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    },

    toggleWaitDialog : function () {
        if (typeof toggleRoja45GlobalWaitDialog === "function") {
            toggleRoja45GlobalWaitDialog();
        } else {
            $('#immersive-modal-dialog').fadeIn();
        }
    }
};