/**
 * roja45propertymanager_order.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    var container = $('.rental-content .rental-content-calendar-container').width();
    var days = $('.rental-content .rental-content-calendar-container').attr('data-days');
    var cell_width = container/days;

    $('.rental-content .rental-content-calendar-container-columns').width(container);
    $('.rental-content .rental-content-calendar-container-navigation').width(container);
    $('.rental-content .rental-content-calendar-container-navigation').css({ top: '160px' });
    $('.rental-content .rental-content-products-navigation').css({top: '160px'});
    $('.rental-content .rental-content-calendar-container-dates').width(container);
    $('.rental-content .rental-content-calendar-container-reservations').width(container);
    $('.rental-content .rental-content-calendar-container-column').width(cell_width);

    var calendar_container_off = $('.rental-content-calendar-container').offset();
    $('.rental-content-calendar-container-dates').offset({ top: calendar_container_off.top, left: calendar_container_off.left });

    roja45productrentaladmin.initialisePage();
    $('.rental-content-calendar-container').css('opacity', '1');
    /*
    $('.reservation-content-reservation').on('click', function(e) {
       e.preventDefault();
    });
    */
    $('.btn-change-period').on('click', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $(this).attr('data-period');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(start_date, 0, number_days, page);
    });

    $('.btn-prev-page').on('click', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(start_date, -number_days, number_days, page);
    });
    $('.btn-prev-days').on('click', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(start_date, -5, number_days, page);
    });
    $('.btn-today').on('click', function(e) {
        e.preventDefault();
        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth()+1;
        var yyyy = today.getFullYear();
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(yyyy+'-'+mm+'-'+dd, -1, number_days, page);
    });
    $('.btn-next-days').on('click', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(start_date, 5, number_days, page);
    });
    $('.btn-next-page').on('click', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrentaladmin.loadCalendar(start_date, number_days, number_days, page);
    });
    $('#hiddenField').datepicker({
        onSelect: function (selected, evnt) {
            var date = $(this).datepicker( 'getDate' );
            var dd = date.getDate();
            var mm = date.getMonth()+1;
            var yyyy = date.getFullYear();
            var number_days = $('.rental-content-calendar-container').attr('data-days');
            var page = $('input[name=page]').val();
            roja45productrentaladmin.loadCalendar(yyyy+'-'+mm+'-'+dd, -1, number_days, page);
        },
    });

    var selected_model = null;
    $('.rental-content-calendar-container-columns').selectable({
        filter: '.day-selectable',
        distance: 30,
        selected: function(event, ui) {
        },
        selecting: function(event, ui) {
            if (!selected_model) {
                selected_model = $('.rental-content-calendar-container .ui-selecting').first().attr('data-id-roja45-product-model');
            }
            var current_model = $(ui.selecting).attr('data-id-roja45-product-model');
            if (selected_model == current_model) {
                $(ui.selecting).addClass('roja45-selecting');
            }
        },
        unselecting: function(event, ui) {
            $(ui.unselecting).removeClass('roja45-selecting');
        },
        start: function(event, ui) {
        },
        stop: function(event, ui) {
            selected_model = null;
            var first = $('.rental-content-calendar-container .ui-selected').first();
            var last = $('.rental-content-calendar-container .ui-selected').last();
            var id_roja45_product = first.attr('data-id-roja45-product');
            var id_roja45_product_model = first.attr('data-id-roja45-product-model');
            var start_date = first.attr('data-date');
            var end_date = last.attr('data-date');
            $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_ID]').val(id_roja45_product);
            $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID]').val(id_roja45_product_model);
            $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_START_DATE]').val(start_date);
            $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_END_DATE]').val(end_date);
            $('#rental_calendar_modal').modal('toggle');
        },
    });
    var timer;
    var delay = 250;
    $('.rental-content-calendar-cell.day-selectable').mouseover(function() {
        var ele = $(this);
        timer = setTimeout(function() {
            var pos = ele.position();
            var offset = ele.offset();
            var parent = ele.closest('.rental-content-calendar-container-columns').offset();
            ele.find('.rate-details').clone().appendTo('.rental-content-calendar-container-columns').css({'top': + pos.top+5, 'left': + (offset.left-parent.left)+ele.width()}).show();
        }, delay);
    });
    $('.rental-content-calendar-cell.day-selectable').mouseout(function() {
        var ele = $(this);
        //ele.find('.rate-details').hide();
        $('.rental-content-calendar-container-columns > .rate-details').remove();
        clearTimeout(timer);
    });
    /*
    $('.rental-content-calendar-cell.day-selectable').on('click', function(e) {
        e.preventDefault();
        $('#calendar_day_modal .modal-body').append($(this).find('.rate-details'));
        $('#calendar_day_modal .modal-body .rate-details').show();
        $('#calendar_day_modal').modal('toggle');
    });
    */
    $('#calendar_day_modal').on('hidden.bs.modal', function (event) {
        $('#calendar_day_modal .modal-body').empty();
    });

    $('#calendar_day_modal').on('show.bs.modal', function (event) {

    });

    $('.rental-calendar-entry-link').on('click', function(e) {
        e.preventDefault();
        var id_roja45_product_rental = $(this).attr('data-id-roja45-product-rental');
        $('#rental_entry_modal input[name=ROJA45_PRODUCT_RENTAL_ID]').val(id_roja45_product_rental);
        $('.roja45-selecting').removeClass('roja45-selecting');
        $('.ui-selected').removeClass('ui-selected');
        $('#rental_entry_modal').modal('toggle');
    });

    $('#rental_entry_modal').on('show.bs.modal', function (event) {
        $.ajax({
            url: roja45_rental_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'getCalendarRentalSummaryModal',
                'ajax' : 1,
                'id_roja45_product_rental' : $('#rental_entry_modal input[name=ROJA45_PRODUCT_RENTAL_ID]').val(),
            },
            beforeSend: function () {
                $('#rental_entry_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data && data.result) {
                    $('#rental_entry_modal .modal-body').append(data.view);
                }
                $('#rental_entry_modal .rental-content-loading-overlay').hide();
            },
            error: function (data) {
                $('#rental_entry_modal .rental-content-loading-overlay').hide();
            },
            complete: function (data) {
            }
        });
    })

    $('#rental_entry_modal').on('hidden.bs.modal', function (event) {
        $('#rental_entry_modal .modal-body').empty();
    })

    $('#rental_calendar_modal').on('show.bs.modal', function (event) {
        $.ajax({
            url: roja45_rental_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'getCalendarDatesModal',
                'ajax' : 1,
                'id_roja45_product' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_ID]').val(),
                'id_roja45_product_model' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID]').val(),
                'start_date' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_START_DATE]').val(),
                'end_date' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_END_DATE]').val(),
            },
            beforeSend: function () {
                $('#rental_calendar_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data && data.result) {
                    $('#rental_calendar_modal .modal-body').append(data.view);
                    $("input[name=event_start_date]").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat
                    });
                    $("input[name=event_end_date]").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat
                    });
                }
                $('#rental_calendar_modal .rental-content-loading-overlay').hide();
            },
            error: function (data) {
                $('#rental_calendar_modal .rental-content-loading-overlay').hide();
            },
            complete: function (data) {
            }
        });
    });

    $('#rental_calendar_modal').on('hidden.bs.modal', function (event) {
        $('.rental-content-calendar-cell').removeClass('roja45-selecting');
        $('.rental-content-calendar-cell').removeClass('ui-selected');
        $('#rental_calendar_modal .modal-body').empty();
    })

    $('.rental-calendar-unavailable-link').on('click', function(e) {
        e.preventDefault();
        var id_roja45_product_unavailable = $(this).attr('data-id-roja45-product-unavailable');
        $('#rental_unavailable_modal input[name=ROJA45_PRODUCT_RENTAL_ID_UNAVAILABLE]').val(id_roja45_product_unavailable);
        $('#rental_unavailable_modal').modal('toggle');
    });

    $('#rental_unavailable_modal').on('show.bs.modal', function (event) {
        $.ajax({
            url: roja45_rental_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'getUpdateBlockedDatesModal',
                'ajax' : 1,
                'id_roja45_product_unavailable' : $('#rental_unavailable_modal input[name=ROJA45_PRODUCT_RENTAL_ID_UNAVAILABLE]').val(),
            },
            beforeSend: function () {
                $('#rental_unavailable_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data && data.result) {
                    $('#rental_unavailable_modal .modal-body').append(data.view);
                    $("input[name=event_start_date]").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat,
                        minDate: data.start_date,
                    });
                    $("input[name=event_end_date]").datepicker({
                        changeMonth: true,
                        changeYear: true,
                        dateFormat: roja45_productrental_dateformat,
                        minDate: data.end_date,
                    });
                }
                $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
            },
            error: function (data) {
                $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
            },
            complete: function (data) {
            }
        });
    })

    $('#rental_unavailable_modal').on('hidden.bs.modal', function (event) {
        $('#rental_unavailable_modal .modal-body').empty();
    })

    $('.btn-select-date').on('click', function() {
        $('#hiddenField').datepicker('show');
    });

    $(document).on('click', '.roja45_productrental_modal a[data-toggle="tab"]', function (e) {
        var id = $(this).attr('data-id');
        $('.roja45_productrental_modal .tab-content .tab-pane').removeClass('active');
        $('#'+id).addClass('active');
    });

    $(document).on('click', '#updateRates', function (e) {
        e.preventDefault();
        roja45productrentaladmin.createCustomRates($(this), false);
    });

    $(document).on('click', '#updateRatesAndClose', function (e) {
        e.preventDefault();
        roja45productrentaladmin.createCustomRates($(this), true);
    });

    $(document).on('click', '#deleteRates', function (e) {
        e.preventDefault();
        roja45productrentaladmin.deleteCustomRates($(this));
    });

    $(document).on('click', '#updateDates', function(e) {
        e.preventDefault();
        roja45productrentaladmin.createUnavailable($(this));
    });

    $(document).on('click', '#updateBlockedDates', function(e) {
        e.preventDefault();
        roja45productrentaladmin.updateUnavailable($(this));
    });

    $(document).on('click', '#deleteBlockedDates', function(e) {
        e.preventDefault();
        roja45productrentaladmin.deleteUnavailable($(this));
    });

    $(document.body).on('click', '.btn-calendar-delete', function(e) {
        var ele = $(this);
        e.preventDefault();
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrentaladmin.deleteRental(ele);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.btn-calendar-cancel', function(e) {
        e.preventDefault();
        var ele = $(this);
        $.confirm({
            text: roja45_productrental_areyousure,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrentaladmin.cancelRental(ele);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });
});

var roja45productrentaladmin = (function (my) {
    my.dateRangeOverlaps = function (a_start, a_end, b_start, b_end) {
        if (a_start <= b_start && b_start <= a_end) return true; // b starts in a
        if (a_start <= b_end   && b_end   <= a_end) return true; // b ends in a
        if (b_start <  a_start && a_end   <  b_end) return true; // a in b
        return false;
    }

    my.dateDiffInDays = function(a, b) {
        var _MS_PER_DAY = 1000 * 60 * 60 * 24;
        var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
        var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

        return Math.floor((utc2 - utc1) / _MS_PER_DAY);
    }

    my.loadCalendar = function(start_date, offset, number_days, page) {
        $.ajax({
            url: roja45_calendar_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'loadCalendar',
                'ajax' : 1,
                'start_date' : start_date,
                'offset' : offset,
                'number_days' : number_days,
                'page' : page,
            },
            beforeSend: function () {
                $('.reservation-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    $('.reservation-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                $('.reservation-content-loading-overlay').hide();
            },
            complete: function (data) {
                //$('.reservation-content-loading-overlay').hide();
            }
        });
    }

    my.initialisePage = function() {
        var period_start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var period_end_date = $('.rental-content-calendar-container').attr('data-end-date');

        var container = $('.rental-content .rental-content-calendar-container').width();
        var days = $('.rental-content .rental-content-calendar-container').attr('data-days');
        var cell_width = container / days;

        var dates = $('.rental-content-calendar-container-days .rental-content-calendar-container-column');
        var firstDate = moment($(dates[0]).attr('data-date'));
        var lastDate = moment($(dates[dates.length - 1]).attr('data-date'));

        var start = firstDate.month() + (firstDate.year() * 12);
        var end = lastDate.month() + (lastDate.year() * 12);

        for (var i = start; i <= end; i++) {
            var count = 0;
            var date, dateMonth, last;

            for (var j = 0; j < dates.length; j++) {
                date = moment($(dates[j]).attr('data-date'));
                dateMonth = date.month() + (date.year() * 12);

                if (dateMonth === i) {
                    count++;
                    last = moment($(dates[j]).attr('data-date'));
                }
            }

            var width = cell_width * count;
            var date_formatted = last.format('MMMM YYYY');
            $('.rental-content-calendar-container-header').append($('<div class="rental-content-calendar-container-header-item" style="width: ' + width + 'px;">' + date_formatted + '</div>'));
        }

        $('.rental-content-product-cell-row.rental-content-product-model').each(function () {
            var id_roja45_product = $(this).attr('data-id-roja45-product');
            var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');

            var rentals = $('.rental-content-rental-container[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
            if (rentals.length) {
                var position = $(this).offset();
                var ranges = [];
                var lines = 1;
                var height = $(this).outerHeight();
                rentals.each(function (index) {
                    var collection_date = $(this).attr('data-collection-date');
                    var cd = collection_date.split(/[-]/);
                    var collection_date = new Date(cd[0], cd[1] - 1, cd[2]);
                    var collection_time = $(this).attr('data-collection-time');
                    var ct = collection_time.split(':'); // split it at the colons
                    var collection_time_mins = (+ct[0]) * 60 + (+ct[1]);

                    var return_date = $(this).attr('data-return-date');
                    var rd = return_date.split(/[-]/);
                    var return_date = new Date(rd[0], rd[1] - 1, rd[2]);
                    var return_time = $(this).attr('data-return-time');
                    var rt = return_time.split(':'); // split it at the colons
                    var return_time_mins = (+rt[0]) * 60 + (+rt[1]);

                    var line = 0;
                    $.each(ranges, function(index, value) {
                        if (roja45productrentaladmin.dateRangeOverlaps(collection_date, return_date, value.start, value.end)) {
                            line++;
                        }
                    });
                    lines = line+1;
                    ranges.push({
                        start: collection_date,
                        end: return_date
                    });
                    var orig_offset = $(this).offset();
                    var number_of_days = roja45productrentaladmin.dateDiffInDays(collection_date, return_date);
                    var entry_height = $(this).outerHeight();
                    var diff = height - entry_height;
                    var top = position.top + (line * entry_height) + ((line + 1) * (diff / 2));
                    var diff = roja45productrentaladmin.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-collection-date')));

                    var minuteLength = cell_width/1440;
                    var dayOffset = collection_time_mins*minuteLength;
                    //var leftOffset = (diff * cell_width) + (cell_width / 2);
                    var leftOffset = (diff * cell_width) + dayOffset;
                    var returnTimeOffset = (return_time_mins-collection_time_mins) * minuteLength;
                    var rentalWidth = (number_of_days * cell_width) + returnTimeOffset;
                    $(this).offset({top: top, left: orig_offset.left + leftOffset});
                    $(this).width(rentalWidth);
                    $(this).css({opacity: 1});

                    var preparation = parseInt($(this).attr('data-preparation'));
                    if (preparation > 0) {
                        var element = $('<div class="rental-content-rental-container" style="opacity: 0"><div class="rental-content-rental preparation"><span>'+roja45_productrental_preparation+'</span></div></div>');
                        $('.rental-content-calendar-container-rentals').append(element);
                        var elementWidth = preparation * cell_width;
                        element.width(elementWidth);
                        element.offset({top: top, left: orig_offset.left + leftOffset - elementWidth});
                        element.css({opacity: 1});
                    }
                    var recondition = parseInt($(this).attr('data-recondition'));
                    if (recondition > 0) {
                        var element = $('<div class="rental-content-rental-container" style="opacity: 0"><div class="rental-content-rental recondition"><span>'+roja45_productrental_recondition+'</span></div></div>');
                        $('.rental-content-calendar-container-rentals').append(element);
                        element.width(recondition * cell_width);
                        element.offset({top: top, left: orig_offset.left + leftOffset + rentalWidth});
                        element.css({opacity: 1});
                    }
                });

                $(this).outerHeight(height * lines);
                $('.rental-content-calendar-cell.day[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']').outerHeight(height * lines);
            }
        });

        var unavailables = $('.rental-content-unavailable-container');
        if (unavailables.length) {
            unavailables.each(function (index) {
                var height = $(this).outerHeight();
                var id_roja45_product = $(this).attr('data-id-roja45-product');
                var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');
                var start_date = $(this).attr('data-start-date');
                var end_date = $(this).attr('data-end-date');
                var t = start_date.split(/[-]/);
                var start_date = new Date(t[0], t[1] - 1, t[2]);
                var t = end_date.split(/[-]/);
                var end_date = new Date(t[0], t[1] - 1, t[2]);
                var number_of_days = roja45productrentaladmin.dateDiffInDays(start_date, end_date);

                var row = $('.rental-content-calendar-cell[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
                if (typeof row != 'undefined') {
                    var position = row.offset();
                    var entry_height = $(this).outerHeight();
                    var diff = height - entry_height;
                    var top = position.top + (diff / 2) + 5;
                    var orig_offset = $(this).offset();
                    // difference between reservation start date and period start date
                    var diff = roja45productrentaladmin.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-start-date')));
                    var leftOffset = (diff * cell_width) + (cell_width / 2);

                    $(this).offset({top: top, left: orig_offset.left + leftOffset});
                    // count reservations currently in the blck
                    $(this).width(number_of_days * cell_width);
                    $(this).css({opacity: 1});
                }
            });
        }
    }

    my.createHeaderElement = function (columns, text) {
        var width = columns * ctrl.columnWidth;
        var el = angular.element('<div class="rental-graphic-item">' + text + '</div>');
        el.css({'width': width + 'px'});
        return el;
    }

    my.createUnavailable = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('form').attr('action'),
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'createBlockedRentalDates',
                'ajax' : 1,
                'id_roja45_product' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_ID]').val(),
                'id_roja45_product_model' : $('#rental_calendar_modal input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID]').val(),
                'event_start_date' : $('#availability_form input[name=event_start_date]').val(),
                'event_end_date' : $('#availability_form input[name=event_end_date]').val(),
                'start_date' : $('.rental-content-calendar-container').attr('data-start-date'),
                'offset' : 1,
                'number_days' : $(this).attr('data-period'),
                'page' : $('input[name=page]').val(),
            },
            beforeSend: function() {
                $('#rental_calendar_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    $('#rental_calendar_modal .rental-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_calendar_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {
            }
        });
    }

    my.updateUnavailable = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('form').attr('action'),
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'updateUnavailable',
                'ajax' : 1,
                'id_roja45_product_unavailable' : $('#edit_block_dates_form input[name=id_roja45_product_unavailable]').val(),
                'event_start_date' : $('#edit_block_dates_form input[name=event_start_date]').val(),
                'event_end_date' : $('#edit_block_dates_form input[name=event_end_date]').val(),
                'start_date' : $('.rental-content-calendar-container').attr('data-start-date'),
                'offset' : 1,
                'number_days' : $(this).attr('data-period'),
                'page' : $('input[name=page]').val(),
            },
            beforeSend: function() {
                $('#rental_unavailable_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {
            }
        });
    }

    my.deleteUnavailable = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('form').attr('action'),
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'deleteUnavailable',
                'ajax' : 1,
                'id_roja45_product_unavailable' : $('#edit_block_dates_form input[name=id_roja45_product_unavailable]').val(),
                'start_date' : $('.rental-content-calendar-container').attr('data-start-date'),
                'offset' : 1,
                'number_days' : $(this).attr('data-period'),
                'page' : $('input[name=page]').val(),
            },
            beforeSend: function() {
                $('#rental_unavailable_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_unavailable_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {
            }
        });
    }

    my.createCustomRates = function (ele, redirect) {
        $.ajax({
            type: 'GET',
            url: ele.closest('form').attr('action')+'&action=createCustomRates&ajax=1&start_date='+$('.rental-content-calendar-container').attr('data-start-date')+'&offset=1&number_days='+$('.rental-content-calendar-container').attr('data-days')+'&page='+$('input[name=page]').val(),
            cache: false,
            dataType: 'json',
            data: $('#rates_form').serialize(),
            beforeSend: function() {
                $('#rental_calendar_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    if (redirect) {
                        window.location = data.redirect;
                    } else {
                        $('#rental_calendar_modal .rental-content-loading-overlay').hide();
                    }
                } else {
                    $('#rental_calendar_modal .rental-content-loading-overlay').hide();
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_calendar_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {

            }
        });
    }

    my.deleteCustomRates = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('form').attr('action')+'&action=deleteCustomRates&ajax=1',
            cache: false,
            dataType: 'json',
            data: $('#rates_form').serialize(),
            beforeSend: function() {
                $('#rental_calendar_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else if (data.result == 'error') {
                    $.each(data.errors, function (index, value) {
                        roja45global.displayErrorMsg(value);
                    });
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                }
            },
            error: function (data) {
                jAlert(data.responseText);
            },
            complete: function () {
                $('#rental_calendar_modal .rental-content-loading-overlay').hide();
            }
        });
    }

    my.deleteRental = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('#rental_entry_modal').find('#rental_entry_modal_summary_form').attr('action'),
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'calendarDeleteRental',
                'ajax' : 1,
                'id_roja45_product_rental' : ele.closest('#rental_entry_modal').find('input[name=ROJA45_PRODUCT_RENTAL_ID]').val(),
                'start_date' : $('.rental-content-calendar-container').attr('data-start-date'),
                'offset' : 1,
                'number_days' : $(this).attr('data-period'),
                'page' : $('input[name=page]').val(),
            },
            beforeSend: function() {
                $('#rental_entry_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    $('#rental_entry_modal .rental-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_entry_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {
            }
        });
    }

    my.cancelRental = function (ele) {
        $.ajax({
            type: 'GET',
            url: ele.closest('#rental_entry_modal').find('#rental_entry_modal_summary_form').attr('action'),
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'calendarCancelRental',
                'ajax' : 1,
                'id_roja45_product_rental' : ele.closest('#rental_entry_modal').find('input[name=ROJA45_PRODUCT_RENTAL_ID]').val(),
                'start_date' : $('.rental-content-calendar-container').attr('data-start-date'),
                'offset' : 1,
                'number_days' : $(this).attr('data-period'),
                'page' : $('input[name=page]').val(),
            },
            beforeSend: function() {
                $('#rental_entry_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(roja45_productrental_unknown_error);
                    $('#rental_entry_modal .rental-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                jAlert(data.responseText);
                $('#rental_entry_modal .rental-content-loading-overlay').hide();
            },
            complete: function () {
            }
        });
    }

    return my;
}(roja45productrentaladmin || {}));

