/**
 * roja45productrentaladmin_calendar.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

var roja45productrentals_pricerules = (function (my) {
    var invalidfields = 0;
    var current_id_condition_group = 0;
    var last_condition_group = 0;
    var conditions = new Array();
    var pricerules = new Array();

    my.toggle_condition_group = function(id_condition_group) {
        $('.condition_group').removeClass('alert-info');
        $('.condition_group > table').removeClass('alert-info');
        $('#condition_group_'+id_condition_group+' > table').addClass('alert-info');
        $('#condition_group_'+id_condition_group).addClass('alert-info');
        current_id_condition_group = id_condition_group;
    }

    my.get_current_condition_group = function() {
        return current_id_condition_group;
    }

    my.toggle_pricerule_block = function() {
        $('.pricerule_profile').removeClass('alert-info');
        $('.pricerule_profile > table').removeClass('alert-info');
        $('#pricerule_profile'+' > table').addClass('alert-info');
        $('#pricerule_profile').addClass('alert-info');
    }

    my.add_pricerule = function(id, profile) {
        if (!id) {
            id = 0;
        }

        var id_pricerule = id + '_' + profile;
        var pricerule = new Array();

        pricerule.id = id;
        pricerule.profile = profile;
        pricerule.to_delete = 0;
        pricerules[id_pricerule] = pricerule;
        return id_pricerule;
    }

    my.appendPriceRuleToProfile = function(html) {
        $('#pricerule_profile table tbody').append(html);
    }

    my.delete_pricerule = function(id_pricerule) {
        var pricerule = pricerules[id_pricerule];
        pricerule.to_delete = 1;
        $('#pricerule_profile table tr[data-id-row='+id_pricerule+']').remove();
        return false;
    }

    my.isInt = function(value) {
        return !isNaN(value) && (function(x) { return (x | 0) === x; })(parseFloat(value))
    }

    my.add_condition = function(type, value) {
        var id_condition = current_id_condition_group+'_'+type+'_'+value;
        if (typeof conditions[id_condition] != 'undefined') {
            return false;
        }
        var condition = new Array();
        condition.type = type;
        condition.value = value;
        condition.id_condition_group = current_id_condition_group;
        conditions[id_condition] = condition;
        return id_condition;
    }

    my.delete_condition = function(condition) {
        delete conditions[condition];

        to_delete = $('#'+condition).prev();
        if ($(to_delete).children().hasClass('btn_delete_condition')) {
            $(to_delete).remove();
        } else {
            $('#'+condition).next().remove();
        }

        $('#'+condition).remove();
        return false;
    }

    my.new_condition_group = function() {
        $('#conditions-panel').show();
        var html = '';

        if (last_condition_group > 0) {
            html += '<div class="row condition_separator text-center">OR</div><div class="clearfix">&nbsp;</div>';
        }

        last_condition_group++;
        html += '<div id="condition_group_'+last_condition_group+'" class="panel condition_group alert-info"><h3><i class="icon-tasks"></i>Condition group '+last_condition_group+'</h3>';
        html += '<table class="table alert-info"><thead><tr><th class="fixed-width-md"><span class="title_box">Type</span></th><th><span class="title_box">Value</span></th><th></th></tr></thead><tbody></tbody></table>';
        html += '</div>';
        $('#condition_group_list').append(html);
        roja45productrentals_pricerules.toggle_condition_group(last_condition_group);
    }

    my.new_pricerule_profile = function() {
        $('#pricerules-panel').show();

        if ($('#pricerule_profile').length>0) {
            return;
        }
        var html = '';

        html += '<div id="pricerule_profile" class="panel pricerule_profile alert-info"><h3><i class="icon-tasks"></i>Price Rule Profile</h3>';
        html += '<div class="alert alert-warning">Providing a value for any day, 0-100, will include that day in the profile.  Leave blank to exclude the day.</div>';
        html += '<table class="table alert-info"><thead><tr><th></th></tr></thead><tbody></tbody></table>';
        html += '</div>';
        $('#pricerule_list').append(html);
        roja45productrentals_pricerules.toggle_pricerule_block();
    }

    my.appendConditionToGroup = function(html) {
        if ($('#condition_group_'+current_id_condition_group+' table tbody tr').length > 0) {
            $('#condition_group_'+current_id_condition_group+' table tbody').append('<tr><td class="text-center btn_delete_condition" colspan="3"><b>AND</b></td></tr>');
        }
        $('#condition_group_'+current_id_condition_group+' table tbody').append(html);
    }

    my.getConditionGroupsFormInputs = function() {
        var html = '';
        for (i in conditions) {
            html += '<input type="hidden" name="condition_group_'+conditions[i].id_condition_group+'[]" value="'+conditions[i].type+'_'+conditions[i].value+'" />';
        }
        return html;
    }

    my.getPriceRuleFormInputs = function() {
        var html = '';
        for (i in pricerules) {
            html += '<input type="hidden" name="pricerules[]" value="'+pricerules[i].id+'_'+pricerules[i].to_delete+'_'+pricerules[i].profile+'"/>';
        }
        return html;
    }
    return my;
}(roja45productrentals_pricerules || {}));

$(document).ready(function () {
    $('#leave_bprice_on').click(function() {
        if (this.checked) {
            $('#price').attr('disabled', 'disabled');
        } else {
            $('#price').removeAttr('disabled');
        }
    });

    $('#roja45_productrental_pricerule_form').on('submit', function(e) {
        $('#conditions').append(roja45productrentals_pricerules.getConditionGroupsFormInputs());
        $('#pricerule').append(roja45productrentals_pricerules.getPriceRuleFormInputs());
    });

    $('#add_pricerule').click(function() {
        var days = new Array();
        var profile = '';
        var title = '';
        $('.price_rule_day_table input').each(function() {
            var day = $(this).attr('data-day');
            var value = $(this).val();
            if (value) {
                days.push($(this).attr('data-name'));
                profile = profile + day + '-' + value + '#';
                title = title + $(this).attr('data-name') + ' (' + value + '%), ';
            }
        });
        profile = profile.substring(0, profile.length-1);
        title = title.substring(0, title.length-1);
        if (days.length > 0) {
            var id_pricerule = roja45productrentals_pricerules.add_pricerule($('input[name=id_pricerule]').val(), profile);
            var html = '<tr data-id-row="'+id_pricerule+'" data-id="'+$('input[name=id_pricerule]').val()+'"><td>'+title+'</td><td><a href="#" onclick="roja45productrentals_pricerules.delete_pricerule(\''+id_pricerule+'\');" class="btn btn-default"><i class="icon-remove"></i></a></td></tr>';
            roja45productrentals_pricerules.appendPriceRuleToProfile(html);
        }

        $('input[name=id_pricerule]').val(0);
        $('.price_rule_day_table input').val('');
        return false;
    });

    $('#add_condition_category').click(function() {
        var id_condition = roja45productrentals_pricerules.add_condition('category', $('#id_category option:selected').val());
        if (!id_condition) {
            return false;
        }
        var html = '<tr id="'+id_condition+'"><td>Category</td><td>'+$('#id_category option:selected').html()+'</td><td><a href="#" onclick="roja45productrentals_pricerules.delete_condition(\''+id_condition+'\');" class="btn btn-default"><i class="icon-remove"></i></a></td></tr>';
        roja45productrentals_pricerules.appendConditionToGroup(html);
        return false;
    });

    $('#add_condition_roja45product').click(function() {
        var id_condition = roja45productrentals_pricerules.add_condition('roja45product', $('#id_roja45product option:selected').val());
        if (!id_condition) {
            return false;
        }

        var html = '<tr id="'+id_condition+'"><td>Rental Product</td><td>'+$('#id_roja45product option:selected').html()+'</td><td><a href="#" onclick="roja45productrentals_pricerules.delete_condition(\''+id_condition+'\');" class="btn btn-default"><i class="icon-remove"></i></a></td></tr>';
        roja45productrentals_pricerules.appendConditionToGroup(html);
        return false;
    });

    $('#add_condition_group').click(function() {
        roja45productrentals_pricerules.new_condition_group();
        return false;
    });

    $('#add_pricerule_profile').click(function() {
        roja45productrentals_pricerules.new_pricerule_profile();
        return false;
    });

    $('.condition_group').on('click', function() {
        var id = this.id.split('_');
        roja45productrentals_pricerules.toggle_condition_group(id[2]);
        return false;
    });
});
