/**
 * roja45productrentaladmin_calendar.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    calendar_object = null;
    note_box = $('#note-detail-div');
    note_box.dialog({
        autoOpen:false,
        title:"Title",
        show: "fade",
        hide: "fade"
    });

    $(document.body).on('click', '#submitRentalNote', function(e) {
        e.preventDefault();
        roja45productrental.submitAddNote();
    });

    $(document).on('click', 'ps-panel-footer-link[name=submitStatusUpdate] a', function (e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_setstatus,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitUpdateStatus(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.cancelRental', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_cancelrental,
            title: roja45_productrental_areyousure,
            confirm: function () {
                roja45productrental.cancelRental(target);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });
    $(document.body).on('click', '.btn-process-rental', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_processrental,
            title: roja45_productrental_areyousure,
            confirm: function () {
                roja45productrental.processRental(target);
            },
            cancel: function () {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $('.rental-note-link').each(function(key, value) {
        $(this).off('click').on('click', function(e) {
            e.preventDefault();
            var html = $(this).parent().find('.note-detail-div');
            note_box.html(html.html());
            note_box.dialog('option', 'title', html.data('received'));

            setTimeout( function()
            {
                note_box.dialog('open');
            }, 200);
        });
    });

    $('.delete-rental-note-link').each(function(key, value) {
        $(this).off('click').on('click', function(e) {
            e.preventDefault();
            $.ajax({
                type: 'POST',
                url: roja45_productrental_controller,
                cache: false,
                dataType: 'json',
                data : {
                    'ajax' : 1,
                    'token' : token,
                    'action' : 'deleteNote',
                    'id_roja45_product_rental' : $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val(),
                    'id_roja45_rental_note' : $(this).attr('data-id-roja45-rental-note'),
                },
                beforeSend : function() {
                    roja45global.toggleModal();
                },
                success : function(data)
                {
                    if (data.result) {
                        roja45global.displaySuccessMsg(data.response);
                        window.location = data.redirect;
                    } else if(!data.result) {
                        roja45global.displayErrorMsg(data.errors);
                    }
                },
                error: function(data) {
                    roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                },
                complete: function() {
                    roja45global.toggleModal();
                }
            });
        });
    });

    $(document.body).on('click', '.createPayment', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_requestpayment,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.createPayment(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.delete_payment_link', function(e) {
        e.preventDefault();
        var target = $(this);
        $.confirm({
            text: roja45_productrental_txt_deletepayment,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.deletePayment(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.request_payment_link', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_requestpayment,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.requestPayment(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.preReserveRental', function(e) {
        e.preventDefault();
        $.confirm({
            text: roja45_productrental_txt_prereserve,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.preReserveRental();
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.confirmRental', function(e) {
        e.preventDefault();
        $.confirm({
            text: roja45_productrental_txt_confirmrental,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.confirmRental();
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.deleteRental', function(e) {
        e.preventDefault();
        $.confirm({
            text: roja45_productrental_txt_deleterental,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.deleteRental();
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.create_order_link', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.getOrderDetails(target);
    });

    $(document.body).on('click', '#roja45_productrental_createorder', function(e) {
        e.preventDefault();
        roja45productrental.createOrder();
    });

    $("#create_payment_due_date").datepicker({
        changeMonth: true,
        changeYear: true,
        dateFormat: roja45_productrental_dateformat
    });

    $(document).on('click', '.roja45_productrental_request_dialog .cross, .roja45_productrental_request_dialog .continue, .roja45_productrental_request_dialog_overlay', function (e) {
        e.preventDefault();
        roja45productrental.closeDialog();
    });

    $('.select-full-amount').on('click', function(e) {
        e.preventDefault();
        $('input[name=amount_to_request]').val(roja45_total_outstanding);
    });

    $(document.body).on('click', '.btn-create-account', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.createCustomerAccount(target);
    });

    $(document.body).on('click', '.btn-find-account', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.retrieveCustomerAccount(target);
    });

    $(document.body).on('click', '.btn-add-rental', function(e) {
        e.preventDefault();
        $('#select_model_modal input[name=collection_date]').datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: 0,
            dateFormat: roja45_productrental_dateformat,
            onSelect: function (obj) {
                var collectionDate = $('#select_model_modal input[name=collection_date]').datepicker('getDate');
                collectionDate.setDate(collectionDate.getDate()+parseInt(1));
                $('#select_model_modal input[name=return_date]').datepicker('setDate', collectionDate);
                $('#select_model_modal input[name=return_date]').datepicker('option', 'minDate', collectionDate);            }
        });
        if (roja45_productrental_enabletimeselect) {
            $('#select_model_modal input[name=collection_time]').timepicker({
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: 15,
                onSelect: function (obj) {

                }
            });
        }
        $('#select_model_modal input[name=return_date]').datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: 0,
            dateFormat: roja45_productrental_dateformat
        });
        if (roja45_productrental_enabletimeselect) {
            $('#select_model_modal input[name=return_time]').timepicker({
                controlType: 'select',
                oneLine: true,
                stepHour: 1,
                stepMinute: 15,
                onSelect: function (obj) {

                }
            });
        }
        $('#select_model_modal .modal-dialog .page-four').hide();
        $('#select_model_modal .modal-dialog .page-three').remove();
        $('#select_model_modal .modal-dialog .page-two').remove();
        $('#select_model_modal .modal-dialog .page-one').show();
        $('#select_model_modal').modal();
    });

    $(document.body).on('click', '.payBalancePOS', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.getPayBalancePOSModal(target);
    });

    $(document.body).on('click', '.btn-approve-balance-payment', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.payBalancePOS(target);
    });


    $(document.body).on('click', '.btn-get-rental-products', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.submitGetRentalProducts(target);
    });

    $(document.body).on('click', '.btn-select-product', function(e) {
        e.preventDefault();
        var id_roja45_product = $(this).closest('tr').attr('data-id-roja45-product');
        roja45productrental.submitGetProductModels(
            id_roja45_product_rental,
            id_roja45_product,
            $('#select_model_modal .page-one input[name=collection_date]').val(),
            $('#select_model_modal .page-one input[name=return_date]').val(),
            $('#select_model_modal .page-one input[name=collection_time]').val(),
            $('#select_model_modal .page-one input[name=return_time]').val()
        );
    });

    $(document.body).on('click', '.btn-add-rental-model', function(e) {
        e.preventDefault();
        $('#select_model_modal input[name=collection_date]').datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: 0,
            dateFormat: roja45_productrental_dateformat
        });
        $('#select_model_modal input[name=return_date]').datepicker({
            changeMonth: true,
            changeYear: true,
            minDate: 0,
            dateFormat: roja45_productrental_dateformat
        });
        $('#select_model_modal input[name=id_roja45_product]').val($(this).closest('.rental-product-panel').attr('data-id-roja45-product'));
        $('#select_model_modal .modal-dialog .page-four').show();
        $('#select_model_modal .modal-dialog .page-two ').remove();
        $('#select_model_modal .modal-dialog .page-three').remove();
        $('#select_model_modal .modal-dialog .page-one').hide();
        $('#select_model_modal').modal();
    });

    $(document.body).on('click', '.btn-get-rental-models', function(e) {
        e.preventDefault();
        var target = $(e.target);
        var id_roja45_product = $('#select_model_modal input[name=id_roja45_product]').val();
        roja45productrental.submitGetProductModels(
            id_roja45_product_rental,
            id_roja45_product,
            $('#select_model_modal .page-four input[name=collection_date]').val(),
            $('#select_model_modal .page-four input[name=return_date]').val(),
            $('#select_model_modal .page-one input[name=collection_time]').val(),
            $('#select_model_modal .page-one input[name=return_time]').val()
        );
    });

    $(document.body).on('click', '.btn-add-rental-product-model', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.submitAddProductModel(target);
    });

    $(document.body).on('click', '.btn-add-rental-model-extra', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.getExtras(target);
    });

    $(document.body).on('click', '.btn-add-model-extra', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.addExtras(target);
    });

    $(document.body).on('click', '.btn-change-dates', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.changeDates(target);
    });
    $(document.body).on('click', '.btn-apply-new-dates', function(e) {
        e.preventDefault();
        var target = $(e.target);
        roja45productrental.applyNewDates(target);
    });

    $(document.body).on('click', '.btn-delete-rental-product', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_deleteproduct,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitDeleteProduct(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.btn-return-model', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_returnmodel,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitReturnModel(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.blockRentalDates', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_createrental,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitBlockRentalDates(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog"
        });
    });

    $(document.body).on('click', '.createRental', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_createrental,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitCreateRental(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog"
        });
    });

    $(document.body).on('click', '.btn-delete-rental-product-model', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_deleteproductmodel,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitDeleteProductModel(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.btn-delete-extra', function(e) {
        e.preventDefault();
        var target = $(e.target);
        $.confirm({
            text: roja45_productrental_txt_deleterentalextra,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.submitDeleteExtra(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.update-confirm-payment-link', function(e) {
        e.preventDefault();
        var target = $(e.target).closest('a');
        $.confirm({
            text: roja45_productrental_txt_confirmpayment,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.updateConfirmPaymentLink(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.update-payment-received-link', function(e) {
        e.preventDefault();
        var target = $(e.target).closest('a');
        $.confirm({
            text: roja45_productrental_txt_paymentreceived,
            title: roja45_productrental_areyousure,
            confirm: function() {
                roja45productrental.updatePaymentReceivedLink(target);
            },
            cancel: function() {
                // nothing to do
            },
            confirmButton: roja45_productrental_yes,
            cancelButton: roja45_productrental_no,
            post: true,
            confirmButtonClass: "btn-danger",
            cancelButtonClass: "btn-default",
            dialogClass: "bootstrap modal-dialog" // Bootstrap classes for large modal
        });
    });

    $(document.body).on('click', '.btn-change-period', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $(this).attr('data-period');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(start_date, 0, number_days, page);
    });

    $(document.body).on('click', '.btn-prev-page', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(start_date, -number_days, number_days, page);
    });

    $(document.body).on('click', '.btn-prev-days', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(start_date, -5, number_days, page);
    });

    $(document.body).on('click', '.btn-today', function(e) {
        e.preventDefault();
        var today = new Date();
        var dd = today.getDate();
        var mm = today.getMonth()+1;
        var yyyy = today.getFullYear();
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(yyyy+'-'+mm+'-'+dd, -1, number_days, page);
    });

    $(document.body).on('click', '.btn-next-days', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(start_date, 5, number_days, page);
    });

    $(document.body).on('click', '.btn-next-page', function(e) {
        e.preventDefault();
        var start_date = $('.rental-content-calendar-container').attr('data-start-date');
        var number_days = $('.rental-content-calendar-container').attr('data-days');
        var page = $('input[name=page]').val();
        roja45productrental.loadCalendar(start_date, number_days, number_days, page);
    });

    $(document.body).on('click', '.btn-preview-new-dates', function(e) {
        e.preventDefault();
        roja45productrental.validateDates();
    });
});

var roja45productrental = (function (my) {
    my.dateRangeOverlaps = function (a_start, a_end, b_start, b_end) {
        if (a_start <= b_start && b_start <= a_end) return true; // b starts in a
        if (a_start <= b_end   && b_end   <= a_end) return true; // b ends in a
        if (b_start <  a_start && a_end   <  b_end) return true; // a in b
        return false;
    }

    my.dateDiffInDays = function(a, b) {
        var _MS_PER_DAY = 1000 * 60 * 60 * 24;
        var utc1 = Date.UTC(a.getFullYear(), a.getMonth(), a.getDate());
        var utc2 = Date.UTC(b.getFullYear(), b.getMonth(), b.getDate());

        return Math.floor((utc2 - utc1) / _MS_PER_DAY);
    }

    my.loadCalendar = function(start_date, offset, number_days, page) {
        $.ajax({
            url: roja45_calendar_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'loadCalendar',
                'ajax' : 1,
                'start_date' : start_date,
                'offset' : offset,
                'number_days' : number_days,
                'page' : page,
            },
            beforeSend: function () {
                $('.reservation-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    $('.reservation-content-loading-overlay').hide();
                }
            },
            error: function (data) {
                $('.reservation-content-loading-overlay').hide();
            },
            complete: function (data) {
                //$('.reservation-content-loading-overlay').hide();
            }
        });
    }

    my.initialisePage = function() {
        var container = $('.rental-content .rental-content-calendar-container').width();
        if (container) {
            var days = $('.rental-content .rental-content-calendar-container').attr('data-days');
            var cell_width = container/days;

            $('.rental-content .rental-content-calendar-container-columns').width(container);
            $('.rental-content .rental-content-calendar-container-navigation').width(container);
            $('.rental-content .rental-content-calendar-container-navigation').css({top: '80px'});
            $('.rental-content .rental-content-products-navigation').css({top: '80px'});
            $('.rental-content .rental-content-calendar-container-dates').width(container);
            $('.rental-content .rental-content-calendar-container-reservations').width(container);
            $('.rental-content .rental-content-calendar-container-column').width(cell_width);

            var calendar_container_off = $('.rental-content-calendar-container').offset();
            $('.rental-content-calendar-container-dates').offset({ top: calendar_container_off.top, left: calendar_container_off.left });

            var period_start_date = $('.rental-content-calendar-container').attr('data-start-date');
            var period_end_date = $('.rental-content-calendar-container').attr('data-end-date');

            var container = $('.rental-content .rental-content-calendar-container').width();
            var days = $('.rental-content .rental-content-calendar-container').attr('data-days');
            var cell_width = container / days;

            var dates = $('.rental-content-calendar-container-days .rental-content-calendar-container-column');
            var firstDate = moment($(dates[0]).attr('data-date'));
            var lastDate = moment($(dates[dates.length - 1]).attr('data-date'));

            var start = firstDate.month() + (firstDate.year() * 12);
            var end = lastDate.month() + (lastDate.year() * 12);

            for (var i = start; i <= end; i++) {
                var count = 0;
                var date, dateMonth, last;

                for (var j = 0; j < dates.length; j++) {
                    date = moment($(dates[j]).attr('data-date'));
                    dateMonth = date.month() + (date.year() * 12);

                    if (dateMonth === i) {
                        count++;
                        last = moment($(dates[j]).attr('data-date'));
                    }
                }

                var width = cell_width * count;
                var date_formatted = last.format('MMMM YYYY');
                $('.rental-content-calendar-container-header').append($('<div class="rental-content-calendar-container-header-item" style="width: ' + width + 'px;">' + date_formatted + '</div>'));
            }

            $('.rental-content-product-cell-row.rental-content-product-model').each(function () {
                var id_roja45_product = $(this).attr('data-id-roja45-product');
                var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');

                var rentals = $('.rental-content-rental-container[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
                if (rentals.length) {
                    var position = $(this).offset();
                    var ranges = [];
                    var lines = 1;
                    var height = $(this).outerHeight();
                    rentals.each(function (index) {
                        var collection_date = $(this).attr('data-collection-date');
                        var cd = collection_date.split(/[-]/);
                        var collection_date = new Date(cd[0], cd[1] - 1, cd[2]);
                        var collection_time = $(this).attr('data-collection-time');
                        var ct = collection_time.split(':'); // split it at the colons
                        var collection_time_mins = (+ct[0]) * 60 + (+ct[1]);

                        var return_date = $(this).attr('data-return-date');
                        var rd = return_date.split(/[-]/);
                        var return_date = new Date(rd[0], rd[1] - 1, rd[2]);
                        var return_time = $(this).attr('data-return-time');
                        var rt = return_time.split(':'); // split it at the colons
                        var return_time_mins = (+rt[0]) * 60 + (+rt[1]);

                        var line = 0;
                        $.each(ranges, function(index, value) {
                            if (roja45productrental.dateRangeOverlaps(collection_date, return_date, value.start, value.end)) {
                                line++;
                            }
                        });
                        lines = line + 1;
                        ranges.push({
                            start: collection_date,
                            end: return_date
                        });
                        var orig_offset = $(this).offset();
                        var number_of_days = roja45productrental.dateDiffInDays(collection_date, return_date);
                        var entry_height = $(this).outerHeight();
                        var diff = height - entry_height;
                        var top = position.top + (line * entry_height) + ((line + 1) * (diff / 2));
                        var diff = roja45productrental.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-collection-date')));

                        var minuteLength = cell_width/1440;
                        var dayOffset = collection_time_mins*minuteLength;
                        //var leftOffset = (diff * cell_width) + (cell_width / 2);
                        var leftOffset = (diff * cell_width) + dayOffset;
                        var returnTimeOffset = (return_time_mins-collection_time_mins) * minuteLength;
                        var rentalWidth = (number_of_days * cell_width) + returnTimeOffset;
                        $(this).offset({top: top, left: orig_offset.left + leftOffset});
                        $(this).width(rentalWidth);
                        $(this).css({opacity: 1});

                        var preparation = parseInt($(this).attr('data-preparation'));
                        if (preparation > 0) {
                            var element = $('<div class="rental-content-rental-container" style="opacity: 0"><div class="rental-content-rental preparation"><span>'+roja45_productrental_preparation+'</span></div></div>');
                            $('.rental-content-calendar-container-rentals').append(element);
                            var elementWidth = preparation * cell_width;
                            element.width(elementWidth);
                            element.offset({top: top, left: orig_offset.left + leftOffset - elementWidth});
                            element.css({opacity: 1});
                        }
                        var recondition = parseInt($(this).attr('data-recondition'));
                        if (recondition > 0) {
                            var element = $('<div class="rental-content-rental-container" style="opacity: 0"><div class="rental-content-rental recondition"><span>'+roja45_productrental_recondition+'</span></div></div>');
                            $('.rental-content-calendar-container-rentals').append(element);
                            element.width(recondition * cell_width);
                            element.offset({top: top, left: orig_offset.left + leftOffset + rentalWidth});
                            element.css({opacity: 1});
                        }
                    });

                    $(this).outerHeight(height * lines);
                    $('.rental-content-calendar-cell.day[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']').outerHeight(height * lines);
                }
            });

            var unavailables = $('.rental-content-unavailable-container');
            if (unavailables.length) {
                unavailables.each(function (index) {
                    var height = $(this).outerHeight();
                    var id_roja45_product = $(this).attr('data-id-roja45-product');
                    var id_roja45_product_model = $(this).attr('data-id-roja45-product-model');
                    var start_date = $(this).attr('data-start-date');
                    var end_date = $(this).attr('data-end-date');
                    var t = start_date.split(/[-]/);
                    var start_date = new Date(t[0], t[1] - 1, t[2]);
                    var t = end_date.split(/[-]/);
                    var end_date = new Date(t[0], t[1] - 1, t[2]);
                    var number_of_days = roja45productrental.dateDiffInDays(start_date, end_date);

                    var row = $('.rental-content-calendar-cell[data-id-roja45-product=' + id_roja45_product + '][data-id-roja45-product-model=' + id_roja45_product_model + ']');
                    var position = row.offset();

                    var entry_height = $(this).outerHeight();
                    var diff = height - entry_height;
                    var top = position.top + (diff / 2) + 5;
                    var orig_offset = $(this).offset();
                    // difference between reservation start date and period start date
                    var diff = roja45productrental.dateDiffInDays(new Date(period_start_date), new Date($(this).attr('data-start-date')));
                    var leftOffset = (diff * cell_width) + (cell_width / 2);

                    $(this).offset({top: top, left: orig_offset.left + leftOffset});
                    // count reservations currently in the blck
                    $(this).width(number_of_days * cell_width);
                    $(this).css({opacity: 1});
                });
            }

            var selected_model = null;
            $('.rental-content-calendar-container-columns').selectable({
                filter: '.day-selectable',
                distance: 30,
                selected: function(event, ui) {
                },
                selecting: function(event, ui) {
                    if (!selected_model) {
                        selected_model = $('.rental-content-calendar-container .ui-selecting').first().attr('data-id-roja45-product-model');
                    }
                    var current_model = $(ui.selecting).attr('data-id-roja45-product-model');
                    if (selected_model == current_model) {
                        $(ui.selecting).addClass('roja45-selecting');
                    }
                },
                unselecting: function(event, ui) {
                    $(ui.unselecting).removeClass('roja45-selecting');
                },
                start: function(event, ui) {
                },
                stop: function(event, ui) {
                    selected_model = null;
                    var first = $('.rental-content-calendar-container .ui-selected').first();
                    var last = $('.rental-content-calendar-container .ui-selected').last();
                    var id_roja45_product = first.attr('data-id-roja45-product');
                    var id_roja45_product_model = first.attr('data-id-roja45-product-model');
                    var start_date = first.attr('data-date-formatted');
                    var end_date = last.attr('data-date-formatted');
                    $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_ID]').val(id_roja45_product);
                    $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_MODEL_ID]').val(id_roja45_product_model);
                    $('#productrental_calendar_controls input[name=collection_date]').val(start_date);
                    $('#productrental_calendar_controls input[name=return_date]').val(end_date);
                },
            });

            var timer;
            var delay = 250;
            $('.rental-content-calendar-cell.day-selectable').off('mouseover').mouseover(function() {
                var ele = $(this);
                timer = setTimeout(function() {
                    var pos = ele.position();
                    ele.find('.rate-details').css({'top': + pos.top+5, 'left': + pos.left+ele.width()}).show();
                }, delay);
            });
            $('.rental-content-calendar-cell.day-selectable').off('mouseover').mouseout(function() {
                var ele = $(this);
                ele.find('.rate-details').hide();
                clearTimeout(timer);
            });

            $('#productrental_calendar_controls input[name=collection_date]').datepicker({
                dateFormat: roja45_productrental_dateformat,
            });
            $('#productrental_calendar_controls input[name=return_date]').datepicker({
                dateFormat: roja45_productrental_dateformat,
            });
        }
    }

    my.submitAddNote = function(target) {
        if ($('#noteContent').val() <= 0)
        {
            roja45global.displayErrorMsg(roja45_productrental_error_no_note_content);
            return false;
        }
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'action' : 'addNote',
                'ajax' : 1,
                'token' : token,
                'id_roja45_product_rental' : $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val(),
                'note' : $('#noteContent').val()
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else if(!data.result) {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitUpdateStatus = function(target) {
        var id_status = $('select[name=updateStatus]').val();
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'setStatus',
                'token' : token,
                'id_roja45_product_rental' : $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val(),
                'id_status': id_status
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);

                    if (data.refresh) {
                        window.location = data.redirect;
                    }
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.createPayment = function(ele) {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        var request_amount = $('#amount_to_request').val();
        var errors = [];
        if (request_amount.length == 0 || request_amount==0) {
            $('#amount_to_request').parent().addClass('has-error');
            errors.push('Please provide an ammount to request.');
        }
        var due_date = $('#create_payment_due_date').val();
        if (due_date.length == 0) {
            $('#create_payment_due_date').parent().addClass('has-error');
            errors.push('Please provide a due date.');
        }
        var payment_type = $('#create_payment_paymenttype').val();
        var note = $('#create_payment_note').val();
        if (errors.length==0) {
            if (payment_type==3) {
                $.ajax({
                    type:"POST",
                    url : roja45_productrental_controller,
                    async: true,
                    dataType: "json",
                    data : {
                        ajax: "1",
                        action: "createOtherPayment",
                        id_roja45_product_rental: id_roja45_product_rental,
                        id_roja45_product_payment_type: payment_type,
                        note: note,
                        request_amount: request_amount,
                        due_date: due_date,
                    },
                    beforeSend : function() {
                        roja45global.toggleModal();
                    },
                    success : function(data) {
                        if (data.result) {
                            window.location = data.redirect;
                        } else {
                            roja45global.displayErrorMsg(data.errors);
                            roja45global.toggleModal();
                        }
                    },
                    error : function(data) {
                        roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                        roja45global.toggleModal();
                    },
                    complete: function() {
                    }
                });
            } else {
                $.ajax({
                    type:"POST",
                    url : roja45_productrental_controller,
                    async: true,
                    dataType: "json",
                    data : {
                        ajax: "1",
                        action: "createPayment",
                        id_roja45_product_rental: id_roja45_product_rental,
                        id_roja45_product_payment_type: payment_type,
                        note: note,
                        request_amount: request_amount,
                        due_date: due_date,
                    },
                    beforeSend : function() {
                        roja45global.toggleModal();
                    },
                    success : function(data) {
                        if (data.result) {
                            window.location = data.redirect;
                        } else {
                            roja45global.displayErrorMsg(data.errors);
                            roja45global.toggleModal();
                        }
                    },
                    error : function(data) {
                        roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                        roja45global.toggleModal();
                    },
                    complete: function() {
                    }
                });
            }
        } else {
            roja45global.displayErrorMsg(errors);
        }
    }

    my.deletePayment = function(ele) {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        var id_roja45_product_rental_payment = ele.closest('tr').attr('data-id-payment');
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: "1",
                action: "deletePayment",
                id_roja45_product_rental: id_roja45_product_rental,
                id_roja45_product_rental_payment: id_roja45_product_rental_payment,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.requestPayment = function(ele) {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        var id_roja45_product_rental_payment = ele.closest('tr').attr('data-id-payment');
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: "1",
                action: "requestPayment",
                id_roja45_product_rental: id_roja45_product_rental,
                id_roja45_product_rental_payment: id_roja45_product_rental_payment,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if (data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.preReserveRental = function() {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'preReserveRental',
                id_roja45_product_rental: id_roja45_product_rental,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function () {
                //roja45global.toggleModal();
            }
        });
    }

    my.confirmRental = function() {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'confirmRental',
                id_roja45_product_rental: id_roja45_product_rental,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function () {
                //roja45global.toggleModal();
            }
        });
    }

    my.processRental = function(ele) {
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'processRental',
                'ajax' : 1,
                'token' : token,
                'id_roja45_product_rental' : $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val(),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.message);
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                jAlert(roja45_productrental_error_errorunexpected+"\n\ntextStatus: '" + textStatus + "'\nerrorThrown: '" + errorThrown + "'\nresponseText:\n" + XMLHttpRequest.responseText);
                roja45global.toggleModal();
            },
            complete: function () {
            }
        });
    }

    my.cancelRental = function(ele) {
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data: {
                'action' : 'cancelRental',
                'ajax' : 1,
                'token' : token,
                'id_roja45_product_rental' : $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val(),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.message);
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                jAlert(roja45_productrental_error_errorunexpected+"\n\ntextStatus: '" + textStatus + "'\nerrorThrown: '" + errorThrown + "'\nresponseText:\n" + XMLHttpRequest.responseText);
                roja45global.toggleModal();
            },
            complete: function () {
            }
        });
    }

    my.deleteRental = function() {
        var id_roja45_product_rental = $('input[name=ROJA45_PRODUCTRENTAL_RENTAL_ID]').val();
        $.ajax({
            type: 'POST',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'deleteRental',
                id_roja45_product_rental: id_roja45_product_rental,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success: function (data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function () {
                //roja45global.toggleModal();
            }
        });
    }

    my.getOrderDetails = function(target) {
        var id_payment = target.closest('tr').attr('data-id-payment');
        var total = target.closest('tr').attr('data-payment-total');
        $('#roja45_productrental_createorder_dialog input[name=id_roja45_product_payment]').val(id_payment);
        $('#roja45_productrental_createorder_dialog input[name=payment_total]').val(total);
        $('#roja45_productrental_createorder_dialog input[name=payment_total_currency]').val(target.closest('tr').attr('data-payment-total-currency'));
        $('.roja45_productrental_request_dialog_overlay').addClass('roja45productrental-darken-background');
        $('#roja45_productrental_createorder_dialog .page-heading').html($('input[name=DIALOG_HEADING]').val());

        $('.roja45_productrental_request_dialog_overlay').css('width','100%');
        $('.roja45_productrental_request_dialog_overlay').css('height','100%');
        $('.roja45_productrental_request_dialog_overlay').show();
        $('#roja45_productrental_createorder_dialog').show();
        //$('#roja45_productrental_createorder_dialog').modal();
    }

    my.createOrder = function(ele) {
       // var id_roja45_product_rental = $('#roja45_productrental_createorder_form input[name=id_roja45_product_rental]').val();
        var id_roja45_product_payment = $('#roja45_productrental_createorder_dialog input[name=id_roja45_product_payment]').val();
        var amount_paid = $('#roja45_productrental_createorder_dialog input[name=payment_total]').val();
        var amount_paid_currency = $('#roja45_productrental_createorder_dialog input[name=payment_total_currency]').val();
        var id_currency = $('#roja45_productrental_createorder_dialog select[name=payment_currency]').val();
        var payment_method = $('#roja45_productrental_createorder_dialog select[name=payment_method]').val();
        var id_order_status = $('#roja45_productrental_createorder_dialog select[name=order_state]').val();
        $.ajax({
            type:'POST',
            url : roja45_productrental_controller,
            async: true,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'createOrder',
                id_roja45_product_rental: id_roja45_product_rental,
                id_roja45_product_payment: id_roja45_product_payment,
                amount_paid: amount_paid,
                amount_paid_currency: amount_paid_currency,
                id_currency: id_currency,
                payment_method: payment_method,
                id_order_status: id_order_status,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                    //roja45global.toggleModal();
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
                $('.roja45_productrental_request_dialog_overlay ').fadeOut();
                $('.roja45_productrental_createorder_dialog').fadeOut();
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.createCustomerAccount = function(ele) {
        var email = $('#create_contact_form input[name=email]').val();
        var firstname = $('#create_contact_form input[name=first_name]').val();
        var lastname = $('#create_contact_form input[name=last_name]').val();
        $.ajax({
            type:'POST',
            url : roja45_productrental_controller,
            async: true,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'createCustomerAccount',
                id_roja45_product_rental: id_roja45_product_rental,
                firstname: firstname,
                lastname: lastname,
                email: email,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
                $('.roja45_productrental_request_dialog_overlay ').fadeOut();
                $('.roja45_productrental_createorder_dialog').fadeOut();
                roja45global.toggleModal();
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {

            }
        });
    }

    my.retrieveCustomerAccount = function(ele) {
        var email = $('#create_contact_form input[name=email]').val();
        $.ajax({
            type:'POST',
            url : roja45_productrental_controller,
            async: true,
            dataType: 'json',
            data : {
                ajax: '1',
                action: 'retrieveCustomerAccount',
                id_roja45_product_rental: id_roja45_product_rental,
                email: email
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    $('.roja45_productrental_request_dialog_overlay ').fadeOut();
                    $('.roja45_productrental_createorder_dialog').fadeOut();
                    roja45global.toggleModal();
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {

            }
        });
    }

    my.submitGetRentalProducts = function(target) {
        var id_status = $('select[name=updateStatus]').val();
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'getRentalProducts',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'collection_date' : $('#select_model_modal input[name=collection_date]').val(),
                'collection_time' : $('#select_model_modal input[name=collection_time]').val(),
                'return_date' : $('#select_model_modal input[name=return_date]').val(),
                'return_time' : $('#select_model_modal input[name=return_time]').val(),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    $('#select_model_modal .modal-dialog .page-one').hide();
                    $('#select_model_modal .modal-dialog').append(data.view);
                    $('#select_model_modal').modal();
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.submitGetProductModels = function(
        id_roja45_product_rental,
        id_roja45_product,
        collection_date,
        return_date,
        collection_time,
        return_time
    ){
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'getRentalProductModels',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'id_roja45_product' : id_roja45_product,
                'collection_date' : collection_date,
                'return_date' : return_date,
                'collection_time' : collection_time,
                'return_time' : return_time
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    $('#select_model_modal .modal-dialog .page-two').remove();
                    $('#select_model_modal .modal-dialog .page-four').hide();
                    $('#select_model_modal .modal-dialog').append(data.view);
                    $('#select_model_modal').modal();
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.submitAddProductModel = function(target) {
        var ROJA45_PRODUCTRENTAL_ID = target.closest('#available_models_container').find('.ajax-block-product-rental-model').attr('data-id-roja45-product');
        var ROJA45_PRODUCTRENTAL_COLLECTION_DATE = target.closest('#available_models_container').find('input[name=collection_date]').val();
        var ROJA45_PRODUCTRENTAL_COLLECTION_TIME = target.closest('#available_models_container').find('input[name=collection_time]').val();
        var ROJA45_PRODUCTRENTAL_RETURN_DATE = target.closest('#available_models_container').find('input[name=return_date]').val();
        var ROJA45_PRODUCTRENTAL_RETURN_TIME = target.closest('#available_models_container').find('input[name=return_time]').val();

        var rental_details = {
            active_product : true,
            action : 'new',
            id_roja45_product : ROJA45_PRODUCTRENTAL_ID,
            collection_date : ROJA45_PRODUCTRENTAL_COLLECTION_DATE,
            return_date : ROJA45_PRODUCTRENTAL_RETURN_DATE,
            models : []
        };
        target.closest('div.ajax-block-product-rental-model').find('input[name="quantity"]').each(function() {
            var val = parseInt($(this).val());
            if (val > 0) {
                var model = {
                    action : 'new',
                    id_roja45_product_rental_model : $(this).closest('.ajax-block-product-rental-model').attr('data-id-roja45-product-model'),
                    id_product_attribute : $(this).closest('.ajax-block-product-rental-model').attr('data-id-product-attribute'),
                    id_roja45_product_rateduration : $(this).closest('.ajax-block-product-rental-model').find('select[name=rate_durations]').val(),
                    collection_date : ROJA45_PRODUCTRENTAL_COLLECTION_DATE,
                    collection_time : ROJA45_PRODUCTRENTAL_COLLECTION_TIME + ':00',
                    return_date : ROJA45_PRODUCTRENTAL_RETURN_DATE,
                    return_time : ROJA45_PRODUCTRENTAL_RETURN_TIME + ':00',
                    rates : [],
                    extras : []
                }

                var periods = [];
                target.closest('div.ajax-block-product-rental-model').find('.periods .period').each(function(index, element) {
                    var period = {
                        'period' : $(this).attr('data-period')
                    }
                    periods.push(period);
                });

                var id_roja45_product_rate = $(this).closest('tr').attr('data-id-roja45-product-rate');
                var rate = {
                    action : 'new',
                    id_roja45_product_rate : id_roja45_product_rate,
                    qty : val,
                    periods : periods
                };
                model.rates.push(rate);

                rental_details.models.push(model);

                var products =  {
                    products : [rental_details]
                };

                var productsJSON = JSON.stringify(products);

                $.ajax({
                    type: 'GET',
                    url: roja45_productrental_controller,
                    cache: false,
                    dataType: 'json',
                    data : {
                        'ajax': 1,
                        'action': 'addRentalProductModel',
                        'token' : token,
                        'id_roja45_product_rental' : id_roja45_product_rental,
                        'products' : productsJSON,
                    },
                    beforeSend : function() {
                        roja45global.toggleModal();
                    },
                    success : function(data)
                    {
                        if(data.result) {
                            window.location = data.redirect;
                        } else {
                            roja45global.displayErrorMsg(data.errors);
                            roja45global.toggleModal();
                        }
                    },
                    error: function(data) {
                        roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                        roja45global.toggleModal();
                    },
                    complete: function() {
                    }
                });
            }
        });
    }

    my.submitReturnModel = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'returnModel',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'id_roja45_product_rental_model' : target.closest('div.rental-model-panel').attr('data-id-roja45-product-rental-model'),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitDeleteProduct = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'deleteRentalProduct',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'id_roja45_product_rental_product' : target.closest('div.rental-product-panel').attr('data-id-roja45-product-rental-product'),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitDeleteProductModel = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'deleteRentalProductModel',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'id_roja45_product_rental_product' : target.closest('div.rental-product-panel').attr('data-id-roja45-product-rental-product'),
                'id_roja45_product_rental_model' : target.closest('div.rental-model-panel').attr('data-id-roja45-product-rental-model'),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitDeleteExtra = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'deleteExtra',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
                'id_roja45_product_rental_model' : target.closest('div.rental-model-panel').attr('data-id-roja45-product-rental-model'),
                'id_roja45_product_rental_extra' : target.closest('tr.extra-row').attr('data-id-product-rental-model-extra'),
                'id_roja45_product_extra' : target.closest('tr.extra-row').attr('data-id-product-extra'),
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.updateConfirmPaymentLink = function(ele) {
        var id_roja45_product_rental_payment = ele.closest('tr').attr('data-id-payment');
        var action = ele.attr('data-action');
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': action,
                'id_roja45_product_rental': id_roja45_product_rental,
                'id_roja45_product_rental_payment': id_roja45_product_rental_payment,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else {
                    jAlert(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {

            }
        });
    }

    my.updatePaymentReceivedLink = function(ele) {
        var id_roja45_product_rental_payment = ele.closest('tr').attr('data-id-payment');
        var action = ele.attr('data-action');
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': action,
                'id_roja45_product_rental': id_roja45_product_rental,
                'id_roja45_product_rental_payment': id_roja45_product_rental_payment,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if (data.result) {
                    roja45global.displaySuccessMsg(data.response);
                    window.location = data.redirect;
                } else {
                    jAlert(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {

            }
        });
    }

    my.getExtras = function(ele) {
        var id_roja45_product_rental_model = ele.closest('.rental-model-panel').attr('data-id-roja45-product-rental-model');
        var id_roja45_product_model = ele.closest('.rental-model-panel').attr('data-id-roja45-product-model');
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: '1',
                action: 'getExtras',
                id_roja45_product_rental : id_roja45_product_rental,
                id_roja45_product_rental_model : id_roja45_product_rental_model
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    $('#select_extras_modal .modal-body').empty().append(data.view);
                    $('#select_extras_modal').modal();
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.addExtras = function(ele) {
        var selected_extras = $('input[name="extra_modal_selected[]"]:checked');
        var extras = [];
        $.each(selected_extras, function( index, value ) {
            var extra = {};
            extra.id_roja45_product_rental_model = $(this).closest('tr').attr('data-id-roja45-product-rental-model');
            extra.id_roja45_product_extra = $(this).closest('tr').attr('data-id-roja45-extra');
            extra.id_roja45_product_extralink = $(this).closest('tr').attr('data-id-roja45-product-extra');
            extra.number_of_days = $(this).closest('tr').attr('data-days');
            extra.qty_per_day = $(this).closest('tr').find('input[name=qty_required]').val();
            extras.push(extra);
        });

        if (extras.length>0) {
            $.ajax({
                type:"POST",
                url : roja45_productrental_controller,
                async: true,
                dataType: "json",
                data : {
                    ajax: "1",
                    action: "addExtras",
                    id_roja45_product_rental: id_roja45_product_rental,
                    extras: extras,
                },
                beforeSend : function() {
                    roja45global.toggleModal();
                },
                success : function(data) {
                    if(data.result) {
                        window.location = data.redirect;
                    } else {
                        roja45global.displayErrorMsg(data.errors);
                        roja45global.toggleModal();
                    }
                },
                error : function(data) {
                    roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                    roja45global.toggleModal();
                },
                complete: function() {
                }
            });
        }
    }

    my.changeDates = function(ele) {
        var id_roja45_product = $(ele).closest('.rental-product-panel').attr('data-id-roja45-product');
        var id_roja45_rental_product = $(ele).closest('.rental-product-panel').attr('data-id-roja45-rental-product');
        var id_roja45_rental_model = $(ele).closest('.rental-model-panel').attr('data-id-roja45-product-rental-model');
        var id_roja45_product_model = $(ele).closest('.rental-model-panel').attr('data-id-roja45-product-model');
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: "1",
                action: "getChangeDatesModal",
                id_roja45_product_rental: id_roja45_product_rental,
                id_roja45_product: id_roja45_product,
                id_roja45_product_model: id_roja45_product_model,
                id_roja45_rental_product: id_roja45_rental_product,
                id_roja45_rental_model: id_roja45_rental_model,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    $('#change_dates_modal #productrental_calendar_container').empty().append(data.calendar);
                    $('#change_dates_modal #productrental_calendar_controls').empty().append(data.controls);
                    $('#change_dates_modal').modal();
                    roja45productrental.initialisePage();
                } else {
                    roja45global.displayErrorMsg(data.errors);

                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.validateDates = function() {
        var rental_details = {
            active_product : true,
            id_roja45_rental_product : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_ID]').val(),
            id_roja45_product : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_ID]').val(),
            collection_date : $('#productrental_calendar_controls input[name=collection_date]').val(),
            collection_time : $('#productrental_calendar_controls input[name=collection_time]').val(),
            return_date : $('#productrental_calendar_controls input[name=return_date]').val(),
            return_time : $('#productrental_calendar_controls input[name=return_time]').val(),
            vouchers : [],
            models : []
        };

        var model = {
            id_roja45_product_rental_model : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID]').val(),
            id_roja45_product_model : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_MODEL_ID]').val(),
            id_roja45_product_rateduration : $('#productrental_calendar_controls select[name=rate_durations]').val(),
            collection_date : $('#productrental_calendar_controls input[name=collection_date]').val(),
            collection_time : $('#productrental_calendar_controls input[name=collection_time]').val(),
            return_date : $('#productrental_calendar_controls input[name=return_date]').val(),
            return_time : $('#productrental_calendar_controls input[name=return_time]').val(),
            rates : [],
            extras : []
        };

        $('#productrental_calendar_controls input[name=quantity]').each(function(e) {
            if (parseInt($(this).val()) > 0) {
                var rate = {
                    'id_roja45_product_rate': $(this).closest('tr').attr('data-id-roja45-product-rate'),
                    'qty': parseInt($(this).val()),
                };
                model.rates.push(rate);
            }
        });
        rental_details.models.push(model);

        var rental = {
            products : [rental_details]
        }

        $.ajax({
            url: roja45_productrental_controller,
            type: 'get',
            dataType: 'json',
            data: {
                'action' : 'validateDates',
                'ajax' : 1,
                'rental_details' : JSON.stringify(rental)
            },
            beforeSend: function () {
                $('#change_dates_modal .rental-content-loading-overlay').show();
            },
            success: function (data) {
                if (data.result) {
                    $('#change_dates_modal #productrental_calendar_totals').empty().append(data.totals);
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
            },
            error: function (data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function (data) {
                $('#change_dates_modal .rental-content-loading-overlay').hide();
            }
        });
    }

    my.applyNewDates = function(ele) {
        var rental_details = {
            active_product : true,
            id_roja45_rental_product : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_ID]').val(),
            id_roja45_product : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_ID]').val(),
            collection_date : $('#productrental_calendar_controls input[name=collection_date]').val(),
            collection_time : $('#productrental_calendar_controls input[name=collection_time]').val(),
            return_date : $('#productrental_calendar_controls input[name=return_date]').val(),
            return_time : $('#productrental_calendar_controls input[name=return_time]').val(),
            vouchers : [],
            models : [],
            action: 'update'
        };

        var model = {
            id_roja45_product_rental_model : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID]').val(),
            id_roja45_product_model : $('#productrental_calendar_controls input[name=ROJA45_PRODUCT_MODEL_ID]').val(),
            id_roja45_product_rateduration : $('#productrental_calendar_controls select[name=rate_durations]').val(),
            collection_date : $('#productrental_calendar_controls input[name=collection_date]').val(),
            collection_time : $('#productrental_calendar_controls input[name=collection_time]').val(),
            return_date : $('#productrental_calendar_controls input[name=return_date]').val(),
            return_time : $('#productrental_calendar_controls input[name=return_time]').val(),
            rates : [],
            extras : [],
            action: 'update'
        };
        $('#productrental_calendar_controls input[name=quantity]').each(function(e) {
            if (parseInt($(this).val()) > 0) {
                var rate = {
                    'id_roja45_product_rate': $(this).closest('tr').attr('data-id-roja45-product-rate'),
                    'qty': parseInt($(this).val()),
                    action: 'update'
                };
                model.rates.push(rate);
            }
        });
        rental_details.models.push(model);

        var rental = {
            products : [rental_details]
        }
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: "1",
                action: "applyNewDates",
                id_roja45_product_rental: id_roja45_product_rental,
                rental_details : JSON.stringify(rental)
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitCreateRental = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'createRental',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.submitBlockRentalDates = function(target) {
        $.ajax({
            type: 'GET',
            url: roja45_productrental_controller,
            cache: false,
            dataType: 'json',
            data : {
                'ajax': 1,
                'action': 'blockRentalDates',
                'token' : token,
                'id_roja45_product_rental' : id_roja45_product_rental,
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data)
            {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error: function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {
            }
        });
    }

    my.deleteExtra = function(ele) {
        $(ele).closest('.extra-row').fadeOut('fast', function() {
            var status =  $(this).attr('data-status');
            if (status=='add') {
                $(this).remove();
            } else {
                $(this).attr('data-status', 'delete');
                $(this).addClass('deleted');
            }
        });
        $('.btn-save-reservation').removeClass('disabled');
    }

    my.getPayBalancePOSModal = function(ele) {
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: '1',
                action: 'getPayBalancePOSModal',
                id_roja45_product_rental : id_roja45_product_rental
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    $('#pay_balance_modal .modal-body').empty().append(data.view);
                    $('#pay_balance_modal').modal();
                } else {
                    roja45global.displayErrorMsg(data.errors);
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
            },
            complete: function() {
                roja45global.toggleModal();
            }
        });
    }

    my.payBalancePOS = function(ele) {
        $.ajax({
            type:"POST",
            url : roja45_productrental_controller,
            async: true,
            dataType: "json",
            data : {
                ajax: '1',
                action: 'payBalancePOS',
                id_roja45_product_rental : id_roja45_product_rental,
                total_to_pay : $('#pay_balance_modal input[name=total_to_pay]').val()
            },
            beforeSend : function() {
                roja45global.toggleModal();
            },
            success : function(data) {
                if(data.result) {
                    window.location = data.redirect;
                } else {
                    roja45global.displayErrorMsg(data.errors);
                    roja45global.toggleModal();
                }
            },
            error : function(data) {
                roja45global.displayErrorMsg(roja45_productrental_error_errorunexpected);
                roja45global.toggleModal();
            },
            complete: function() {

            }
        });
    }

    my.closeDialog = function() {
        $('.roja45_productrental_request_dialog_overlay ').hide();
        $('.roja45_productrental_request_dialog').fadeOut('fast');
        $('.roja45_productrental_request_dialog').off('click');
        $('.roja45_productrental_request_dialog').off('keypress');
    }

    my.displayWarning = function(errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-warning">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    }

    my.displayErrors = function(errors) {
        $('#roja45productrental_message_block').empty();
        $.each(errors, function (index, value) {
            $('#roja45productrental_message_block').append('<p class="product-rental-error">' + value + '</p>');
        });
        $('#roja45productrental_message_block').slideDown();
    }

    my.toggleWaitDialog = function() {
        if (typeof toggleRoja45GlobalWaitDialog === "function") {
            toggleRoja45GlobalWaitDialog();
        } else {
            $('#immersive-modal-dialog').fadeIn();
        }
    }

    return my;
}(roja45productrental || {}));