/**
 * roja45productrentaladmin_calendar.js.
 *
 * @author    Roja45
 * @copyright 2016 Roja45
 * @license   license.txt
 *
 * 2016 ROJA45 - All rights reserved.
 *
 * DISCLAIMER
 * Changing this file will render any support provided by us null and void.
 */

$(document).ready(function () {
    $('#customerFilter').autocomplete(
        $('#roja45_productrental_voucher_form').attr('action'),
        {
            minChars: 2,
            max: 50,
            width: 500,
            selectFirst: false,
            scroll: false,
            dataType: 'json',
            formatItem: function(data, i, max, value, term) {
                return value;
            },
            parse: function(data) {
                var mytab = new Array();
                for (var i = 0; i < data.length; i++)
                    mytab[mytab.length] = { data: data[i], value: data[i].cname + ' (' + data[i].email + ')' };
                return mytab;
            },
            extraParams: {
                customerFilter: 1,
                action: 'searchCustomer',
                ajax: 1
            }
        }
    ).result(function(event, data, formatted) {
        $('#id_customer').val(data.id_customer);
        $('#customerFilter').val(data.cname + ' (' + data.email + ')');
    });

    $('.datepicker').datetimepicker({
        beforeShow: function (input, inst) {
            setTimeout(function () {
                inst.dpDiv.css({
                    'z-index': 1031
                });
            }, 0);
        },
        prevText: '',
        nextText: '',
        dateFormat: 'yy-mm-dd',
        // Define a custom regional settings in order to use PrestaShop translation tools
        ampm: false,
        amNames: ['AM', 'A'],
        pmNames: ['PM', 'P'],
        timeFormat: 'hh:mm:ss tt',
        timeSuffix: '',
    });

    $('#free_extras_on').click(function() {
        roja45productrental_vouchers.toggleFreeExtras();
    });
    $('#free_extras_off').click(function() {
        roja45productrental_vouchers.toggleFreeExtras();
    });
    $('#extrasFilter').typeWatch({
        captureLength: 2,
        highlight: false,
        wait: 200,
        callback: function() {
            roja45productrental_vouchers.searchExtras();
        }
    });

    $(document).on('click', '.btn-add-extra-to-voucher', function(e) {
        var name = $('#select_free_extra option:selected').text();
        var id_roja45_product_extra = $('#select_free_extra').val();
        var add = true;
        $.each($('#extras_selected_table tr'), function() {
            if ($(this).attr('data-id-roja45-product-extra') == id_roja45_product_extra) {
                add = false;
            }
        });
        if (add) {
            $('#extras_selected_table').append('<tr data-id-roja45-product-extra="'+id_roja45_product_extra+'"><input type="hidden" name="selected_extras[]" value="'+id_roja45_product_extra+'"/><td>' + name + '</td><td class="text-right"><a class="btn btn-default btn-remove-extra-from-voucher" href="#" data-id-roja45-product-extra="'+id_roja45_product_extra+'"> <i class="icon-remove"></i></a></td></tr>');
            $('#extras_selected').show();
        } else {
            roja45global.displayErrorMsg('Already added');
        }
        //roja45productrental_vouchers.addExtraToVoucher($('#select_free_extra').val());
    });
    $(document).on('click', '.btn-remove-extra-from-voucher', function(e) {
        $(this).closest('tr').remove();
        //roja45productrental_vouchers.removeExtraFromVoucher($(this).attr('data-id-roja45-product-extra'));
    });
});

var roja45productrental_vouchers = (function (my) {
    my.displayVoucherTab = function (tab) {
        $('.voucher_tab').hide();
        $('.tab-row.active').removeClass('active');
        $('#voucher_link_' + tab).show();
        $('#voucher_' + tab).parent().addClass('active');
        $('#currentFormTab').val(tab);
    },

        my.toggleFreeExtras = function() {
            if ($('#free_extras_on').prop('checked')) {
                $('#free_extras_div').show(400);
            } else {
                $('#select_free_extra').val('0');
                $('#extrasFilter').val('');
                $('#free_extras_div').hide(200);
            }
        },

        my.searchExtras = function() {
            $.ajax({
                type: 'POST',
                headers: { "cache-control": "no-cache" },
                url: $('#roja45_productrental_voucher_form').attr('action'),
                async: true,
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'searchExtras',
                    query: $('#extrasFilter').val()
                },
                success : function(data)
                {
                    var extras_found = '';
                    if (data.result) {
                        $('#extras_err').hide();
                        $('#extras_found').show();
                        $.each(data.extras, function() {
                            extras_found += '<option value="' + this.id_roja45_product_extra + '">' + this.name + '</option>';
                        });
                        $('#extras_list #select_free_extra').html(extras_found);
                    } else {
                        roja45global.displayErrorMsg(data.response);
                        $('#extras_found').hide();
                    }
                }
            });
        },

        my.addExtraToVoucher = function(id_roja45_product_extra) {
            $.ajax({
                type: 'POST',
                headers: { "cache-control": "no-cache" },
                url: $('#roja45_productrental_voucher_form').attr('action'),
                async: true,
                dataType: 'json',
                data: {
                    ajax: 1,
                    action: 'addExtraToVoucher',
                    id_roja45_product_voucher: $('input[name=id_roja45_product_voucher]').val(),
                    id_roja45_product_extra: id_roja45_product_extra
                },
                success : function(data)
                {
                    var extras_selected = '';
                    if (data.result) {
                        $('#extras_selected').hide();
                        $('#extras_selected_table').empty();
                        $.each(data.extras, function() {
                            extras_selected += '<tr><td>' + this.name + '</td><td class="text-right"><a class="btn btn-default btn-remove-extra-from-voucher" href="#" data-id-roja45-product-extra="'+this.id_roja45_product_extra+'"> <i class="icon-remove"></i></a></td></tr>';
                        });
                        $('#extras_selected_table').append(extras_selected);
                        $('#extras_selected').show();
                    }
                }
            });
        }

    my.removeExtraFromVoucher = function(id_roja45_product_extra) {
        $.ajax({
            type: 'POST',
            headers: { "cache-control": "no-cache" },
            url: $('#roja45_productrental_voucher_form').attr('action'),
            async: true,
            dataType: 'json',
            data: {
                ajax: 1,
                action: 'removeExtraFromVoucher',
                id_roja45_product_voucher: $('input[name=id_roja45_product_voucher]').val(),
                id_roja45_product_extra: id_roja45_product_extra
            },
            success : function(data)
            {
                var extras_selected = '';
                if (data.result) {
                    $('#extras_selected').hide();
                    $('#extras_selected_table').empty();
                    if (data.extras.length>0) {
                        $.each(data.extras, function() {
                            extras_selected += '<tr><td>' + this.name + '</td><td class="text-right"><a class="btn btn-default btn-remove-extra-from-voucher" href="#" data-id-roja45-product-extra="'+this.id_roja45_product_extra+'"> <i class="icon-remove"></i></a></td></tr>';
                        });
                        $('#extras_selected_table').append(extras_selected);
                        $('#extras_selected').show();
                    }
                }
            }
        });
    }
    return my;
}(roja45productrental_vouchers || {}));