{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{if isset($unavailable) && $unavailable==1}
<div class="roja45_productrental_summary">
    <div class="col-lg-12">
        <div class="row">
            <div class="panel">
                <div class="panel">
                    <div class="panel-heading summary-heading">
                        <i class="icon-user"></i>
                        {l s='Dates Unavailable' mod='roja45productrental'}</span>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <p>{l s='From' mod='roja45productrental'}</p>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            <p>{dateFormat date=$start_date full=false}</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Until' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            <p>{dateFormat date=$end_date full=false}</p>
                        </div>
                    </div>
                    <div class="panel-footer">
                        <div class="row">
                            <button id="closeEntry" class="btn btn-default btn-lg pull-left">{l s='Close' mod='roja45productrental'}</button>
                            <a href="{$roja45_productrental_controller|escape:'html':'UTF-8'}"
                               id="deleteEntry"
                               data-id-roja45-product-unavailable="{$id_roja45_product_unavailable|escape:'html':'UTF-8'}"
                               class="btn btn-default btn-lg pull-right">{l s='Delete' mod='roja45productrental'}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{else}
<div class="roja45_productrental_summary">
    <div class="col-lg-12">
        <div class="row">
            <div class="panel">
                <div class="panel">
                    <div class="panel-heading summary-heading">
                        <i class="icon-user"></i>
                        {l s='Rental Summary' mod='roja45productrental'}</span><span class="badge">{$rental->reference|escape:"html":"UTF-8"}</span>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span >{l s='Current Status: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-title">
                            <input  id="reservation_status"
                                    name="reservation_status"
                                    type="text"
                                    class="form-control disabled"
                                    style="position: relative; z-index: 998;"
                                    disabled="disabled"
                                    value="{$status|escape:'htmlall':'UTF-8'}"/>
                        </div>
                    </div>
                </div>
                <div class="panel">
                    <div class="panel-heading summary-heading">
                        <i class="icon-user"></i>
                        {l s='Model' mod='roja45productrental'}</span><span class="badge">{$model_name|escape:'htmlall':'UTF-8'}</span>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Quantity: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            <input  id="event_end_date"
                                    name="event_end_date"
                                    type="text"
                                    class="form-control disabled"
                                    style="position: relative; z-index: 998;"
                                    disabled="disabled"
                                    value="{$model_qty|escape:'htmlall':'UTF-8'}"/>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Collection Date: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            <div class="input-group">
                                <input  id="event_start_date"
                                        name="event_start_date"
                                        type="text"
                                        class="form-control datepicker"
                                        style="position: relative; z-index: 998;"
                                        placeholder="{$roja45_productrental_dateformat|escape:'htmlall':'UTF-8'}"
                                        disabled="disabled"
                                        value="{$start_date|escape:'htmlall':'UTF-8'}"/>
                                <span class="input-group-addon">
                            <i class="icon-calendar"></i>
                        </span>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Return Date: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            <div class="input-group">
                                <input  id="event_end_date"
                                        name="event_end_date"
                                        type="text"
                                        class="form-control datepicker"
                                        style="position: relative; z-index: 998;"
                                        placeholder="{$roja45_productrental_dateformat|escape:'htmlall':'UTF-8'}"
                                        disabled="disabled"
                                        value="{$end_date|escape:'htmlall':'UTF-8'}"/>
                                <span class="input-group-addon">
                            <i class="icon-calendar"></i>
                        </span>
                            </div>
                        </div>
                    </div>
                {if isset($notes)}
                {foreach $notes as $note}
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Note: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">

                            <span>{$note.note|escape:'htmlall':'UTF-8'}</span>
                        </div>
                    </div>
                {/foreach}
                {/if}
                </div>
                <div class="panel">
                    <div class="panel-heading summary-heading">
                        <i class="icon-user"></i>
                        {l s='Customer Details' mod='roja45productrental'}</span>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Contact Name: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-title">
                            {if isset($customer_name)}
                                <span>{$customer_name|escape:'htmlall':'UTF-8'}</span>
                            {else}
                                <span>{l s='Not Provided' mod='roja45productrental'}</span>
                            {/if}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Contact Email: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            {if isset($email)}
                                <span><a href="mailto:{$email|escape:'htmlall':'UTF-8'}">{$email|escape:'htmlall':'UTF-8'}</a></span>
                            {else}
                                <span>{l s='Not Provided' mod='roja45productrental'}</span>
                            {/if}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Telephone: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            {if isset($address)}
                                <span><a href="tel:{$address->phone|escape:'htmlall':'UTF-8'}">{$address->phone|escape:'htmlall':'UTF-8'}</a></span>
                            {else}
                                <span>{l s='Not Provided' mod='roja45productrental'}</span>
                            {/if}
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-4 summary-title">
                            <span>{l s='Cell: ' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-6 summary-detail">
                            {if isset($address)}
                                <span><a href="tel:{$address->phone_mobile|escape:'htmlall':'UTF-8'}">{$address->phone_mobile|escape:'htmlall':'UTF-8'}</a></span>
                            {else}
                                <span>{l s='Not Provided' mod='roja45productrental'}</span>
                            {/if}
                        </div>
                    </div>
                </div>
                <div class="panel">
                    <div class="panel-heading summary-heading">
                        <i class="icon-user"></i>
                        {l s='Payment Details' mod='roja45productrental'}</span>
                    </div>
                    <div class="row" style="border-bottom: 1px solid;">
                        <div class="col-xs-2 summary-title">
                            <span>{l s='Total Paid (inc):' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-2 summary-detail">
                            <span><strong>{displayPrice price=$total_paid currency=$rental->id_currency}</strong></span>
                        </div>
                        <div class="col-xs-2 summary-title">
                            <span>{l s='Total Confirmed (inc):' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-2 summary-detail">
                            <span><strong>{displayPrice price=$total_paid_confirmed currency=$rental->id_currency}</strong></span>
                        </div>
                        <div class="col-xs-2 summary-title">
                            <span>{l s='Total Outstanding (inc):' mod='roja45productrental'}</span>
                        </div>
                        <div class="col-xs-2 summary-detail">
                            <span><strong>{displayPrice price=$total_outstanding_inc currency=$rental->id_currency}</strong></span>
                        </div>
                    </div>
                    {if isset($payments) && count($payments)}
                    <div class="row" style="border-bottom: 1px solid;">
                        {foreach $payments as $payment}
                            <div class="col-xs-6">
                                <div class="row">
                                    <div class="col-xs-5 summary-title">
                                        <span>{l s='Payment: ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-7 summary-detail">
                                        <span>{$payment.position+1|escape:'htmlall':'UTF-8'}</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-5 summary-title">
                                        <span>{l s='Amount (inc): ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-7 summary-detail">
                                        <span>{displayPrice price=$payment.total_with_tax currency=$payment.id_currency}</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-5 summary-title">
                                        <span>{l s='Paid On: ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-7 summary-detail">
                                        <span>{dateFormat date=$payment.date_paid full=1}</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-5 summary-title">
                                        <span>{l s='Confirmed: ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-7 summary-detail">
                                        {if $payment.completed==1}
                                            <span>{l s='YES' mod='roja45productrental'}</span>
                                        {else}
                                            <span>{l s='NO' mod='roja45productrental'}</span>
                                        {/if}
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    </div>
                    {/if}
                </div>
                <div class="panel-footer">
                    <div class="row">
                        <button id="closeEntry" class="btn btn-default btn-lg pull-left">{l s='Close' mod='roja45productrental'}</button>
                        <a id="editEntry"
                           href="{$roja45_productrental_controller|escape:'htmlall':'UTF-8'}&viewroja45_productrental_rental&id_roja45_product_rental={$id_roja45_product_rental|escape:'htmlall':'UTF-8'}"
                           target="_blank"
                           class="btn btn-default btn-lg pull-right">{l s='Edit' mod='roja45productrental'}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
{/if}