{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="roja45_productrental_modal">
    <div class="col-lg-12">
        <div class="row">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a id="rates_tab_link" href="#rates_tab" data-id="rates_tab" data-toggle="tab">{l s='Rates' mod='roja45productrental'}</a>
                </li>
                <li>
                    <a id="dates_tab_link" href="#dates_tab" data-id="dates_tab" data-toggle="tab">{l s='Availability' mod='roja45productrental'}</a>
                </li>
            </ul>
            <div class="tab-content panel">
                <div id="rates_tab" class="tab-pane active">
                    <div class="panel">
                        <form id="rates_form" action="{$controller_url}" method="post">
                            <input type="hidden" name="id_roja45_product" value="{$id_roja45_product|escape:'html':'UTF-8'}"/>
                            <div class="panel-heading summary-heading">
                                <i class="icon-calendar"></i>
                                {l s='Rates' mod='roja45productrental'}</span>
                            </div>
                            <div class="panel-body">
                                <div class="col-xs-12">
                                    <div class="row">
                                        <div class="panel">
                                            <div class="row">
                                                <div class="form-group">
                                                    <label class="control-label col-lg-3">{l s='Start Date' mod='roja45productrental'}</label>
                                                    <div class="col-lg-3 date-field">
                                                        <div class="input-group">
                                                            <input name="event_start_date"
                                                                   type="text"
                                                                   class="form-control datepicker event_start_date"
                                                                   style="position: relative; z-index: 998;"
                                                                   value="{$start_date|escape:'html':'UTF-8'}"
                                                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"/>
                                                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                                        </div>
                                                    </div>

                                                    <label class="control-label col-lg-3">{l s='End Date' mod='roja45productrental'}</label>
                                                    <div class="col-lg-3 date-field">
                                                        <div class="input-group">
                                                            <input name="event_end_date"
                                                                   type="text"
                                                                   class="form-control datepicker event_end_date"
                                                                   style="position: relative; z-index: 998;"
                                                                   value="{$end_date|escape:'html':'UTF-8'}"
                                                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"/>
                                                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group">
                                                    <label class="control-label col-lg-3">
                                                        <span class="label-tooltip" data-toggle="tooltip" data-html="true" title="{l s='Apply rates to the selected days' mod='roja45productrental'}">{l s='Apply rates to' mod='roja45productrental'}</span>
                                                    </label>
                                                    <div class="col-lg-8">
                                                        <table class="table">
                                                            <thead>
                                                            <tr>
                                                                <th>{l s='Day' mod='roja45productrental'}</th>
                                                                <th></th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            <tr>
                                                                <td>{l s='Sunday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="0" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Monday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="1" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Tuesday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="2" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Wednesday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="3" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Thursday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="4" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Friday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="5" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>{l s='Saturday' mod='roja45productrental'}</td>
                                                                <td>
                                                                    <input type="checkbox" name="apply_rates_to[]" value="6" class="" checked="checked"/>
                                                                </td>
                                                            </tr>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {foreach $models as $model}
                                            <div class="panel">
                                                <div class="panel-heading summary-heading">{$model.name|escape:'html':'UTF-8'}</div>
                                                <div class="row">
                                                    {foreach $model.rates as $rate}
                                                    <div class="form-group">
                                                        <div class="col-lg-12">
                                                            <div class="row">
                                                                <label class="control-label col-lg-4">{$rate.name|escape:'html':'UTF-8'}</label>
                                                                <div class="col-lg-4">
                                                                    <input name="model_base_rate"
                                                                           type="text"
                                                                           class="form-control"
                                                                           disabled="disabled"
                                                                           placeholder="{$rate.rate_formatted|escape:'html':'UTF-8'}"
                                                                           {if isset($rate.rate_formatted)}value="{$rate.rate_formatted|escape:'html':'UTF-8'}"{/if}/>
                                                                </div>
                                                                <div class="col-lg-4">
                                                                    <input name="model_rates[{$model.id_roja45_product_model|escape:'html':'UTF-8'}][{$rate.id_roja45_product_rate|escape:'html':'UTF-8'}]"
                                                                           type="text"
                                                                           class="form-control"
                                                                           placeholder="{$rate.rate|escape:'html':'UTF-8'}"
                                                                           {if isset($rate.rate)}value="{$rate.rate|escape:'html':'UTF-8'}"{/if}/>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {/foreach}
                                                </div>
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer">
                                <button id="deleteRates"
                                        class="btn btn-primary pull-left"
                                        type="submit"
                                        form="rates_form"
                                        name="action"
                                        value="submitDeleteCustomRate"
                                        href="{$roja45_productrental_controller|escape:'html':'UTF-8'}" class="">
                                    <span>{l s='Reset' mod='roja45productrental'}</span>
                                </button>
                                <button id="updateRatesAndClose"
                                        class="btn btn-primary pull-right"
                                        type="submit"
                                        form="rates_form"
                                        name="action"
                                        value="submitCreateCustomRates"
                                        href="{$roja45_productrental_controller|escape:'html':'UTF-8'}" class="">
                                    <span>{l s='Update & Close' mod='roja45productrental'}</span>
                                </button>
                                <button id="updateRates"
                                        class="btn btn-primary pull-right"
                                        type="submit"
                                        form="rates_form"
                                        name="action"
                                        value="submitCreateCustomRates"
                                        href="{$roja45_productrental_controller|escape:'html':'UTF-8'}" class="">
                                    <span>{l s='Update' mod='roja45productrental'}</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                <div id="dates_tab" class="tab-pane">
                    <div class="panel">
                        <form id="availability_form" action="{$controller_url}" method="post">
                            <input type="hidden" name="id_roja45_product" value="{$id_roja45_product|escape:'html':'UTF-8'}"/>
                            <div class="panel-heading summary-heading">
                                <i class="icon-calendar"></i>
                                {l s='Availability' mod='roja45productrental'}</span>
                            </div>
                            <div class="panel-body">
                                <div class="col-xs-12">
                                    <div class="row">
                                        <div class="panel">
                                            <div class="row">
                                                <div class="form-group">
                                                    <label class="control-label col-lg-3">{l s='Start Date' mod='roja45productrental'}</label>
                                                    <div class="col-lg-3 date-field">
                                                        <div class="input-group">
                                                            <input name="event_start_date"
                                                                   type="text"
                                                                   class="form-control datepicker event_start_date"
                                                                   style="position: relative; z-index: 998;"
                                                                   value="{$start_date|escape:'html':'UTF-8'}"
                                                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"/>
                                                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                                        </div>
                                                    </div>

                                                    <label class="control-label col-lg-3">{l s='End Date' mod='roja45productrental'}</label>
                                                    <div class="col-lg-3 date-field">
                                                        <div class="input-group">
                                                            <input name="event_end_date"
                                                                   type="text"
                                                                   class="form-control datepicker event_end_date"
                                                                   style="position: relative; z-index: 998;"
                                                                   value="{$end_date|escape:'html':'UTF-8'}"
                                                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"/>
                                                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        {foreach $models as $model}
                                            <div class="panel">
                                            <div class="panel-heading summary-heading">{$model.name|escape:'html':'UTF-8'}</div>
                                            </div>
                                        {/foreach}
                                    </div>
                                </div>
                            </div>
                            <div class="panel-footer">
                                <button id="updateDates"
                                        class="btn btn-primary"
                                        type="submit"
                                        form="rates_form"
                                        name="action"
                                        value="submitUpdateModelAvailability"
                                        href="{$roja45_productrental_controller|escape:'html':'UTF-8'}" class="">
                                    <span>{l s='Block Dates' mod='roja45productrental'}</span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
