{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="roja45_productrental_summary">
    <div class="col-lg-12">
        <div class="row">
            <form id="rental_entry_modal_summary_form" action="{$controller_url}" method="post">
                <div class="col-lg-12">
                    <div class="panel">
                        <div class="panel-heading summary-heading">
                            {l s='Rental' mod='roja45productrental'}</span><span class="badge"><a href="{$roja45_productrental_controller|escape:'htmlall':'UTF-8'}&viewroja45_productrental_rental&id_roja45_product_rental={$rental->id|escape:'htmlall':'UTF-8'}">#{$rental->reference|escape:"html":"UTF-8"}</a></span>
                        </div>
                        <div class="row">
                            <div class="col-xs-4 summary-title">
                                <span>{l s='Contact Name: ' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-6 summary-title">
                                {if isset($customer)}
                                    <span>{$customer->firstname|escape:'htmlall':'UTF-8'}&nbsp;{$customer->lastname|escape:'htmlall':'UTF-8'}</span>
                                {else}
                                    <span>{l s='Not Provided' mod='roja45productrental'}</span>
                                {/if}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-4 summary-title">
                                <span>{l s='Contact Email: ' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-6 summary-detail">
                                {if isset($customer)}
                                    <span><a href="mailto:{$customer->email|escape:'htmlall':'UTF-8'}">{$customer->email|escape:'htmlall':'UTF-8'}</a></span>
                                {else}
                                    <span>{l s='Not Provided' mod='roja45productrental'}</span>
                                {/if}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-4 summary-title">
                                <span>{l s='Telephone: ' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-6 summary-detail">
                                {if isset($address)}
                                    <span><a href="tel:{$address->phone|escape:'htmlall':'UTF-8'}">{$address->phone|escape:'htmlall':'UTF-8'}</a></span>
                                {else}
                                    <span>{l s='Not Provided' mod='roja45productrental'}</span>
                                {/if}
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-xs-4 summary-title">
                                <span>{l s='Cell: ' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-6 summary-detail">
                                {if isset($address)}
                                    <span><a href="tel:{$address->phone_mobile|escape:'htmlall':'UTF-8'}">{$address->phone_mobile|escape:'htmlall':'UTF-8'}</a></span>
                                {else}
                                    <span>{l s='Not Provided' mod='roja45productrental'}</span>
                                {/if}
                            </div>
                        </div>
                    </div>
                </div>
                {foreach $rental_products as $rental_product}
                {foreach $rental_product.models as $key=>$model}
                <div class="col-lg-6">
                    <div class="panel" {if $model.returned}<span class="badge">{elseif $model.overdue}style="box-shadow: 0px 0px 0px 5px {$overdue_status->color|escape:'htmlall':'UTF-8'};" {elseif $model.return_due}style="box-shadow: 0px 0px 0px 5px {$return_status->color|escape:'htmlall':'UTF-8'};"{/if}>
                        <div class="panel-heading">
                            {$model.qty|escape:'htmlall':'UTF-8'} x {$rental_product.product->name|escape:'htmlall':'UTF-8'}: {$model.model_name|escape:'htmlall':'UTF-8'}
                            {if $model.returned}<span class="badge">{l s='RETURNED' mod='roja45productrental'}</span>{elseif $model.overdue}<span class="badge" style="background: #{$overdue_status->color|escape:'htmlall':'UTF-8'};">{l s='OVERDUE' mod='roja45productrental'}</span>{elseif $model.return_due}<span class="badge" style="background: #{$return_status->color|escape:'htmlall':'UTF-8'};">{l s='RETURN DUE' mod='roja45productrental'}</span>{else}<span class="badge">{l s='ON RENT' mod='roja45productrental'}</span>{/if}</div>
                        <div class="panel-body">
                            <div class="col-xs-8">
                                <div class="row">
                                    <div class="col-xs-4 summary-title">
                                        <span>{l s='Collection: ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-6 summary-title">
                                        <span>{$model.collection_date|escape:'htmlall':'UTF-8'} - {$model.collection_time|escape:'htmlall':'UTF-8'}</span>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-4 summary-title">
                                        <span>{l s='Return: ' mod='roja45productrental'}</span>
                                    </div>
                                    <div class="col-xs-6 summary-title">
                                        <span>{$model.return_date|escape:'htmlall':'UTF-8'} - {$model.return_time|escape:'htmlall':'UTF-8'}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xs-4">
                            {if isset($model.extras)}
                                {foreach $model.extras as $extra}
                                    <div class="row">
                                        <div class="col-xs-6">
                                            <span>{$extra.qty|escape:'htmlall':'UTF-8'} x</span>
                                        </div>
                                        <div class="col-xs-6">
                                            <span>{$extra.name|escape:'htmlall':'UTF-8'}</span>
                                        </div>
                                    </div>
                                {/foreach}
                            {/if}
                            </div>
                        </div>
                    </div>
                </div>
                {/foreach}
                {/foreach}
                <div class="col-lg-12">
                    <div class="panel">
                        <div class="panel-heading summary-heading">
                            {l s='Payment Details' mod='roja45productrental'}</span>
                        </div>
                        <div class="row" style="border-bottom: 1px solid;">
                            <div class="col-xs-2 summary-title">
                                <span>{l s='Total Paid (inc):' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-2 summary-detail">
                                <span><strong>{displayPrice price=$total_paid currency=$rental->id_currency}</strong></span>
                            </div>
                            <div class="col-xs-2 summary-title">
                                <span>{l s='Total Confirmed (inc):' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-2 summary-detail">
                                <span><strong>{displayPrice price=$total_paid_confirmed currency=$rental->id_currency}</strong></span>
                            </div>
                            <div class="col-xs-2 summary-title">
                                <span>{l s='Total Outstanding (inc):' mod='roja45productrental'}</span>
                            </div>
                            <div class="col-xs-2 summary-detail">
                                <span><strong>{displayPrice price=$total_outstanding_inc currency=$rental->id_currency}</strong></span>
                            </div>
                        </div>
                        {if isset($payments) && count($payments)}
                            <div class="row" style="border-bottom: 1px solid;">
                                {foreach $payments as $payment}
                                    <div class="col-xs-6">
                                        <div class="row">
                                            <div class="col-xs-5 summary-title">
                                                <span>{l s='Payment: ' mod='roja45productrental'}</span>
                                            </div>
                                            <div class="col-xs-7 summary-detail">
                                                <span>{$payment.position+1|escape:'htmlall':'UTF-8'}</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-5 summary-title">
                                                <span>{l s='Amount (inc): ' mod='roja45productrental'}</span>
                                            </div>
                                            <div class="col-xs-7 summary-detail">
                                                <span>{displayPrice price=$payment.total_with_tax currency=$payment.id_currency}</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-5 summary-title">
                                                <span>{l s='Paid On: ' mod='roja45productrental'}</span>
                                            </div>
                                            <div class="col-xs-7 summary-detail">
                                                <span>{dateFormat date=$payment.date_paid full=1}</span>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-xs-5 summary-title">
                                                <span>{l s='Confirmed: ' mod='roja45productrental'}</span>
                                            </div>
                                            <div class="col-xs-7 summary-detail">
                                                {if $payment.completed==1}
                                                    <span>{l s='YES' mod='roja45productrental'}</span>
                                                {else}
                                                    <span>{l s='NO' mod='roja45productrental'}</span>
                                                {/if}
                                            </div>
                                        </div>
                                    </div>
                                {/foreach}
                            </div>
                        {/if}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>