{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="form-wrapper">
    <ps-tabs position="left">
        <ps-tab label="{l s='Product Details' mod='roja45productrental'}"
                id="roja45productrental_details_tab"
                active="true"">
            <form id="roja45productrental_details_form"
                  class="defaultForm form-horizontal"
                  action="{$admin_link|escape:'html':'UTF-8'}"
                  method="post"
                  enctype="multipart/form-data">

                <input type="hidden" name="ROJA45_PRODUCTRENTAL_PRODUCT_ID"
                       value="{$id_product|escape:'html':'UTF-8'}"/>
                <input type="hidden" name="ROJA45_PRODUCTRENTAL_ID"
                       value="{$id_roja45_product|escape:'html':'UTF-8'}"/>
                {if $enable_address==1}
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_ADDRESS"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_ADDRESS']|escape:"html":"UTF-8"}"
                                   label="{l s='Address' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_ADDRESS_2"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_ADDRESS_2']|escape:"html":"UTF-8"}"
                                   label="{l s='Address 2' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_CITY"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_CITY']|escape:"html":"UTF-8"}"
                                   label="{l s='City' mod='roja45productrental'}"></ps-input-text>
                    <ps-select label="{l s='Country' mod='roja45productrental'}"
                               name="ROJA45_PRODUCTRENTAL_COUNTRY"
                               chosen='true'>
                        {foreach $countries as $country}
                            <option value="{$country.id_country|escape:'html':'UTF-8'}"
                                    {if ($fields_value['ROJA45_PRODUCTRENTAL_COUNTRY']==$country.id_country)}selected="selected"{/if}>{$country.name|escape:'html':'UTF-8'}</option>
                        {/foreach}
                    </ps-select>
                    <ps-select label="{l s='State' mod='roja45productrental'}"
                               name="ROJA45_PRODUCTRENTAL_STATE"
                               hint="{l s='Select the product address state' mod='roja45productrental'}"
                               chosen='true'>
                        <option value="0"
                                {if ($fields_value['ROJA45_PRODUCTRENTAL_STATE']==0)}selected="selected"{/if}>
                            -
                        </option>
                        {if isset($states)}
                            {foreach $states as $state}
                                <option value="{$state.id_state|escape:'html':'UTF-8'}"
                                        {if ($fields_value['ROJA45_PRODUCTRENTAL_STATE']==$state.id_state)}selected="selected"{/if}>{$state.name|escape:'html':'UTF-8'}</option>
                            {/foreach}
                        {/if}
                    </ps-select>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_ZIP"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_ZIP']|escape:"html":"UTF-8"}"
                                   label="{l s='Zip/Postal Code' mod='roja45productrental'}"
                                   hint="{l s='Zip/Postal Code' mod='roja45productrental'}"></ps-input-text>
                {/if}
                {if $enable_contact==1}
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_1"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_1']|escape:"html":"UTF-8"}"
                                   label="{l s='Contact Telephone Number #1' mod='roja45productrental'}"
                                   hint="{l s='Set a product contact telephone number.' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_2"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_CONTACT_NUMBER_2']|escape:"html":"UTF-8"}"
                                   label="{l s='Contact Telephone Number #2' mod='roja45productrental'}"
                                   hint="{l s='Set a second product contact telephone number.' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_EMAIL"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_EMAIL']|escape:"html":"UTF-8"}"
                                   label="{l s='Email Address' mod='roja45productrental'}"
                                   hint="{l s='Set a product contact email address.' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_URL"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_URL']|escape:"html":"UTF-8"}"
                                   label="{l s='Website URL' mod='roja45productrental'}"
                                   hint="{l s='Set a product url if required.' mod='roja45productrental'}"></ps-input-text>
                {/if}
                {if $enable_location==1}
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_LAT"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_LAT']|escape:"html":"UTF-8"}"
                                   label="{l s='Product Location (Latitude)' mod='roja45productrental'}"
                                   hint="{l s='Set a latitude value for the product location if required.' mod='roja45productrental'}"></ps-input-text>
                    <ps-input-text name="ROJA45_PRODUCTRENTAL_LON"
                                   value="{$fields_value['ROJA45_PRODUCTRENTAL_LON']|escape:"html":"UTF-8"}"
                                   label="{l s='Product Location (Longitude)' mod='roja45productrental'}"
                                   hint="{l s='Set a longitude value for the product location if required.' mod='roja45productrental'}"></ps-input-text>
                {/if}
                <ps-select label="{l s='Payment Profile' mod='roja45productrental'}"
                           name="ROJA45_PRODUCTRENTAL_PAYMENTPROFILE_ID"
                           hint="{l s='Select the payment profile to use to calculate payments' mod='roja45productrental'}"
                           chosen='true'>
                    {foreach $payment_profiles as $payment_profile}
                        <option value="{$payment_profile.id_roja45_product_paymentprofile|escape:'html':'UTF-8'}"
                                {if ($fields_value['ROJA45_PRODUCTRENTAL_PAYMENTPROFILE_ID']==$payment_profile.id_roja45_product_paymentprofile)}selected="selected"{/if}>{$payment_profile.name|escape:'html':'UTF-8'}</option>
                    {/foreach}
                </ps-select>
                <ps-input-text name="ROJA45_PRODUCTRENTAL_COLLECTIONTIME"
                               id="ROJA45_PRODUCTRENTAL_COLLECTIONTIME"
                               label="{l s='Collection After' mod='roja45productrental'}"
                               hint="{l s='Rental collection only after this time' mod='roja45productrental'}"
                               value="{$fields_value['ROJA45_PRODUCTRENTAL_COLLECTIONTIME']|escape:'html':'UTF-8'}"
                               fixed-width="lg"></ps-input-text>
                <ps-input-text name="ROJA45_PRODUCTRENTAL_RETURNTIME"
                               id="ROJA45_PRODUCTRENTAL_RETURNTIME"
                               label="{l s='Return Before' mod='roja45productrental'}"
                               hint="{l s='Rental return must be before this time' mod='roja45productrental'}"
                               value="{$fields_value['ROJA45_PRODUCTRENTAL_RETURNTIME']|escape:'html':'UTF-8'}"
                               fixed-width="lg"></ps-input-text>
                <ps-select label="{l s='Minimum rental period' mod='roja45productrental'}"
                           name="ROJA45_PRODUCTRENTAL_MINIMUM_DURATION"
                           hint="{l s='Set the default minimum duration required for rentals.' mod='roja45productrental'}"
                           chosen='true'>
                    <option value="0" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==0)}selected="selected"{/if}>0</option>
                    <option value="1" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==1)}selected="selected"{/if}>1</option>
                    <option value="2" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==2)}selected="selected"{/if}>2</option>
                    <option value="3" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==3)}selected="selected"{/if}>3</option>
                    <option value="4" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==4)}selected="selected"{/if}>4</option>
                    <option value="5" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==5)}selected="selected"{/if}>5</option>
                    <option value="6" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==6)}selected="selected"{/if}>6</option>
                    <option value="7" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==7)}selected="selected"{/if}>7</option>
                    <option value="8" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==8)}selected="selected"{/if}>8</option>
                    <option value="9" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==9)}selected="selected"{/if}>9</option>
                    <option value="10" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==10)}selected="selected"{/if}>10</option>
                    <option value="11" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==11)}selected="selected"{/if}>11</option>
                    <option value="12" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==12)}selected="selected"{/if}>12</option>
                    <option value="13" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==13)}selected="selected"{/if}>13</option>
                    <option value="14" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==14)}selected="selected"{/if}>14</option>
                    <option value="15" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==15)}selected="selected"{/if}>15</option>
                    <option value="16" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==16)}selected="selected"{/if}>16</option>
                    <option value="17" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==17)}selected="selected"{/if}>17</option>
                    <option value="18" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==18)}selected="selected"{/if}>18</option>
                    <option value="19" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==19)}selected="selected"{/if}>19</option>
                    <option value="20" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==20)}selected="selected"{/if}>20</option>
                    <option value="21" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==21)}selected="selected"{/if}>21</option>
                    <option value="22" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==22)}selected="selected"{/if}>22</option>
                    <option value="23" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==23)}selected="selected"{/if}>23</option>
                    <option value="24" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==24)}selected="selected"{/if}>24</option>
                    <option value="25" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==25)}selected="selected"{/if}>25</option>
                    <option value="26" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==26)}selected="selected"{/if}>26</option>
                    <option value="27" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==27)}selected="selected"{/if}>27</option>
                    <option value="28" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==28)}selected="selected"{/if}>28</option>
                    <option value="29" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==29)}selected="selected"{/if}>29</option>
                    <option value="30" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==30)}selected="selected"{/if}>30</option>
                    <option value="31" {if ($fields_value['ROJA45_PRODUCTRENTAL_MINIMUM_DURATION']==31)}selected="selected"{/if}>31</option>
                </ps-select>
                <ps-select label="{l s='Maximum rental period' mod='roja45productrental'}"
                           name="ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION"
                           hint="{l s='Set the default maximum duration required for rentals.' mod='roja45productrental'}"
                           chosen='true'>
                    <option value="0" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==0)}selected="selected"{/if}>0</option>
                    <option value="1" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==1)}selected="selected"{/if}>1</option>
                    <option value="2" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==2)}selected="selected"{/if}>2</option>
                    <option value="3" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==3)}selected="selected"{/if}>3</option>
                    <option value="4" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==4)}selected="selected"{/if}>4</option>
                    <option value="5" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==5)}selected="selected"{/if}>5</option>
                    <option value="6" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==6)}selected="selected"{/if}>6</option>
                    <option value="7" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==7)}selected="selected"{/if}>7</option>
                    <option value="8" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==8)}selected="selected"{/if}>8</option>
                    <option value="9" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==9)}selected="selected"{/if}>9</option>
                    <option value="10" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==10)}selected="selected"{/if}>10</option>
                    <option value="11" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==11)}selected="selected"{/if}>11</option>
                    <option value="12" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==12)}selected="selected"{/if}>12</option>
                    <option value="13" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==13)}selected="selected"{/if}>13</option>
                    <option value="14" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==14)}selected="selected"{/if}>14</option>
                    <option value="15" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==15)}selected="selected"{/if}>15</option>
                    <option value="16" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==16)}selected="selected"{/if}>16</option>
                    <option value="17" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==17)}selected="selected"{/if}>17</option>
                    <option value="18" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==18)}selected="selected"{/if}>18</option>
                    <option value="19" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==19)}selected="selected"{/if}>19</option>
                    <option value="20" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==20)}selected="selected"{/if}>20</option>
                    <option value="21" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==21)}selected="selected"{/if}>21</option>
                    <option value="22" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==22)}selected="selected"{/if}>22</option>
                    <option value="23" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==23)}selected="selected"{/if}>23</option>
                    <option value="24" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==24)}selected="selected"{/if}>24</option>
                    <option value="25" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==25)}selected="selected"{/if}>25</option>
                    <option value="26" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==26)}selected="selected"{/if}>26</option>
                    <option value="27" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==27)}selected="selected"{/if}>27</option>
                    <option value="28" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==28)}selected="selected"{/if}>28</option>
                    <option value="29" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==29)}selected="selected"{/if}>29</option>
                    <option value="30" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==30)}selected="selected"{/if}>30</option>
                    <option value="31" {if ($fields_value['ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION']==31)}selected="selected"{/if}>31</option>
                </ps-select>
                {if ($damage_deposits && count($damage_deposits))}
                <ps-select label="{l s='Damage Deposit' mod='roja45productrental'}"
                           name="ROJA45_PRODUCTRENTAL_DAMAGEDEPOSIT"
                           hint="{l s='Select a damage deposit to apply during checkout' mod='roja45productrental'}"
                           chosen='true'>
                    <option value="0" {if ($fields_value['ROJA45_PRODUCTRENTAL_DAMAGEDEPOSIT'] == 0)}selected="selected"{/if}>{l s='Disabled' mod='roja45productrental'}</option>
                    {foreach $damage_deposits as $damage_deposit}
                    <option value="{$damage_deposit.id_roja45_product_damagedeposit|escape:'html':'UTF-8'}" {if ($fields_value['ROJA45_PRODUCTRENTAL_DAMAGEDEPOSIT'] == $damage_deposit.id_roja45_product_damagedeposit)}selected="selected"{/if}>{$damage_deposit.name|escape:'html':'UTF-8'}</option>
                    {/foreach}
                </ps-select>
                {/if}
                <ps-select label="{l s='Overdue Rental Action' mod='roja45productrental'}"
                           name="ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION"
                           hint="{l s='Select an action to take for an overdue rental.' mod='roja45productrental'}"
                           chosen='true'>
                    <option value="1" {if ($fields_value['ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION'] == 1)}selected="selected"{/if}>{l s='No Action' mod='roja45productrental'}</option>
                    <option value="2" {if ($fields_value['ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION'] == 2)}selected="selected"{/if}>{l s='Apply Last Rate' mod='roja45productrental'}</option>
                    <option value="3" {if ($fields_value['ROJA45_PRODUCTRENTAL_DEFAULTOVERDUERENTALACTION'] == 3)}selected="selected"{/if}>{l s='Apply Full Rate' mod='roja45productrental'}</option>
                </ps-select>
                <ps-input-text name="ROJA45_PRODUCTRENTAL_OVERDUEFINE"
                               id="ROJA45_PRODUCTRENTAL_OVERDUEFINE"
                               label="{l s='Overdue rental fine' mod='roja45productrental'}"
                               hint="{l s='Fine to be applied (applied daily)' mod='roja45productrental'}"
                               prefix="{$currency->sign|escape:'htmlall':'UTF-8'}"
                               value="{{toolsConvertPrice price=$fields_value['ROJA45_PRODUCTRENTAL_OVERDUEFINE']}|escape:'htmlall':'UTF-8'}"
                               fixed-width="lg"></ps-input-text>
                <ps-switch name="ROJA45_PRODUCTRENTAL_RESERVATIONSENABLED"
                           label="{l s='Enable Rentals' mod='roja45productrental'}"
                           hint="{l s='Enable online rental of this product?' mod='roja45productrental'}"
                           yes="{l s='Yes' mod='roja45productrental'}"
                           no="{l s='no' mod='roja45productrental'}"
                           active="{if ($fields_value['ROJA45_PRODUCTRENTAL_RESERVATIONSENABLED'] == "0")}false{else}true{/if}"></ps-switch>
                <ps-switch name="ROJA45_PRODUCTRENTAL_INSTANTRENTAL"
                           label="{l s='Instant Rentals' mod='roja45productrental'}"
                           hint="{l s='Rentals will be accepted automatically when made, set to No if you want to confirm each rental request.' mod='roja45productrental'}"
                           yes="{l s='Yes' mod='roja45productrental'}"
                           no="{l s='no' mod='roja45productrental'}"
                           active="{if ($fields_value['ROJA45_PRODUCTRENTAL_INSTANTRENTAL'] == "0")}false{else}true{/if}"></ps-switch>
                <div class="panel-footer">
                    <a href="{$admin_link|escape:'html':'UTF-8'}" id="submitDetails"
                       class="submitDetails btn btn-default btn btn-default pull-right">
                        <i class="process-icon-save"></i>{l s='Save Details' mod='roja45productrental'}</a>
                    <a href="{$product_link|escape:'html':'UTF-8'}" target="_blank" id="submitDetails"
                       class="btn btn-default btn btn-default pull-right">
                        <i class="process-icon-preview"></i>{l s='Preview' mod='roja45productrental'}</a>
                </div>
            </form>
        </ps-tab>

        <ps-tab label="{l s='Models' mod='roja45productrental'}"
                id="roja45productrental_models_tab"
                badge="{$productrental_models|count|escape:'html':'UTF-8'}">
            <form id="roja45productrental_models_form" class="defaultForm form-horizontal"
                  action="{$admin_link|escape:'htmlall':'UTF-8'}" method="post"
                  enctype="multipart/form-data" novalidate="">
                <input type="hidden" name="ROJA45_PRODUCTRENTAL_PRODUCT_ID"
                       value="{$id_product|escape:'html':'UTF-8'}"/>
                <input type="hidden" name="ROJA45_PRODUCTRENTAL_ID"
                       value="{$id_roja45_product|escape:'html':'UTF-8'}"/>
                <div class="form-group">
                    <div class="models-panel">
                        <button type="button"
                                class="btn btn-default btn-lg addModel">
                            <i class="icon-plus"></i> {l s='Add Rental Model' mod='roja45productrental'}</button>
                        <div id="models_list">
                            {include file='./productrental_models.tpl'}
                        </div>
                    </div>
                </div>
            </form>
        </ps-tab>

        <ps-tab label="{l s='Model' mod='roja45productrental'}"
                id="roja45productrental_model_tab">
            <form id="roja45productrental_model_form" class="defaultForm form-horizontal"
                  action="{$admin_link|escape:'htmlall':'UTF-8'}" method="post"
                  enctype="multipart/form-data" novalidate="">
                <div id="roja45productrental_model_container">

                </div>
            </form>
        </ps-tab>

        <ps-tab label="{l s='Messages' mod='roja45productrental'}"
                id="roja45productrental_messages_tab"
                badge="{$messages|count|escape:'html':'UTF-8'}">
            <ul>
                {foreach $messages as $message}
                    <li style="list-style: none;">
                        <div class="panel">
                            <h3 class="tab">{$message.subject|escape:'html':'UTF-8'}</h3>
                            <p>{$message.message|escape:'html':'UTF-8'}</p>
                            <div class="panel-footer">
                                <p>{$message.resolution|escape:'html':'UTF-8'}</p>
                            </div>
                        </div>
                    </li>
                {/foreach}
            </ul>
        </ps-tab>

    </ps-tabs>


    <script type="text/javascript">
        var roja45_productrental_priceperiods_startdate = "{l s='You must specify the period start date' mod='roja45productrental' js=1}";
        var roja45_productrental_priceperiods_enddate = "{l s='You must specify the period end date' mod='roja45productrental' js=1}";
        var roja45_productrental_unknown_error = "{l s='An unknown error has occurred, please try again and if the problem persists contact tyour support provider.' mod='roja45productrental' js=1}";
        var roja45_productrental_invalid_form = "{l s='You must complete all required fields' mod='roja45productrental' js=1}";
        var roja45_productrental_rate_value_error = "{l s='You must provide a price value for this rate type.' mod='roja45productrental' js=1}";
        var roja45_productrental_rate_exists_error = "{l s='You have already provided a price for this rate type.' mod='roja45productrental' js=1}";
        var roja45_productrental_refresh = "{l s='Refresh' mod='roja45productrental' js=1}";
        var roja45_productrental_confirm = "{l s='Confirm' mod='roja45productrental' js=1}";
        var roja45_productrental_yes = "{l s='Yes' mod='roja45productrental' js=1}";
        var roja45_productrental_no = "{l s='No' mod='roja45productrental' js=1}";
        var roja45_productrental_areyousure = "{l s='Are you sure?' mod='roja45productrental' js=1}";
        var roja45_productrental_dateformat = "{$roja45_productrental_dateformat|escape:'html':'UTF-8'}";
    </script>
</div>