{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{capture assign=priceDisplayPrecisionFormat}{'%.'|cat:$smarty.const._PS_PRICE_DISPLAY_PRECISION_|cat:'f'|escape:'htmlall':'UTF-8'}{/capture}
<div id="roja45productrental_extras_block" style="">
    <div class="panel">
        <div class="room_extras_container">
            <h3 class="tab">{l s='Model Extras' mod='roja45productrental'}</h3>

            <div class="form-group">
                <label class="control-label col-lg-2">
                    <span class="label-tooltip" data-toggle="tooltip" data-html="true" title=""
                          data-original-title="{l s='List of available extras' mod='roja45productrental'}">{l s='Extras' mod='roja45productrental'}</span>
                </label>
                <div class="col-lg-9">
                    <div class="panel">
                        <div id="rates_list">
                            <div class="table-responsive-row clearfix">
                                <table id="table-rates-list" class="table configuration">
                                    <thead>
                                    <tr class="nodrag nodrop">
                                        <th class="left"><span class="title_box">{l s='Extra' mod='roja45productrental'}</span></th>
                                        <th class="left"><span class="title_box">{l s='Required' mod='roja45productrental'}</span></th>
                                        <th class="left"><span class="title_box">{l s='Rate' mod='roja45productrental'}</span></th>
                                        <th class="left"><span class="title_box">{l s='Rate Type' mod='roja45productrental'}</span></th>
                                        <th class="right"><span class="title_box">{l s='Enabled' mod='roja45productrental'}</span></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    {if isset($available_addons) }
                                        {foreach $available_addons as $addon}
                                            <tr class="rate-row" data-id="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}" data-extra="{$addon@iteration|escape:'htmlall':'UTF-8'}">
                                                <input type="hidden"
                                                       name="ROJA45_PRODUCTRENTAL_ID_EXTRA[]"
                                                       value="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}">
                                                {if (array_key_exists($addon.id_roja45_product_extra, $selected))}
                                                    {assign var=op value=$addon.id_roja45_product_extra}
                                                    <input type="hidden"
                                                           name="ROJA45_PRODUCTRENTAL_ID_MODELEXTRA_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                           value="{$selected[$op].id_roja45_product_extralink|escape:'html':'UTF-8'}">
                                                {/if}
                                                <td data-value="{$addon.name|escape:'htmlall':'UTF-8'}">
                                                    <input type="hidden"
                                                           name="ROJA45_PRODUCTRENTAL_EXTRA_NAME_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                           value="{$addon.name|escape:'htmlall':'UTF-8'}">
                                                    {$addon.name|escape:'htmlall':'UTF-8'}
                                                </td>
                                                <td data-value="{$addon.required|escape:'htmlall':'UTF-8'}">
                                                    <input type="hidden"
                                                           name="ROJA45_PRODUCTRENTAL_EXTRA_REQUIRED_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                           value="{$addon.name|escape:'htmlall':'UTF-8'}">
                                                    {if ($addon.required==1)}
                                                        {l s='Yes' mod='roja45productrental'}
                                                    {else}
                                                        {l s='No' mod='roja45productrental'}
                                                    {/if}
                                                </td>
                                                {if (array_key_exists($addon.id_roja45_product_extra, $selected))}
                                                    <td data-id="rate"
                                                        data-value="{{toolsConvertPrice price=$selected[$op].rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}">
                                                        <div class="input-group">
                                                            <span class="input-group-addon">{$currency->sign|escape:"html":"UTF-8"}</span>
                                                            <input type="text"
                                                                   name="ROJA45_PRODUCTRENTAL_EXTRA_RATE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                                   value="{{toolsConvertPrice price=$selected[$op].rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}"
                                                                   class="form-control fixed-width-md"
                                                                   onkeyup='javascript: roja45productrental.validate_number(this);'
                                                                   onkeydown='javascript: if(event.keyCode == 13)roja45productrental.updateProductRentalModelExtraRate(event);'
                                                                   onblur="roja45productrental.updateProductRentalModelExtraRate(event);">
                                                        </div>
                                                    </td>
                                                {else}
                                                <td data-id="rate"
                                                    data-value="{{toolsConvertPrice price=$addon.rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}">
                                                    <div class="input-group">
                                                        <span class="input-group-addon">{$currency->sign|escape:'htmlall':'UTF-8'}</span>
                                                        <input type="text"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_RATE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               value="{{toolsConvertPrice price=$addon.rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}"
                                                               class="form-control fixed-width-md"
                                                               onkeyup='javascript: roja45productrental.validate_number(this);'
                                                               onkeydown='javascript: if(event.keyCode == 13)roja45productrental.updateProductRentalModelExtraRate(event);'
                                                               onblur="roja45productrental.updateProductRentalModelExtraRate(event);">
                                                    </div>
                                                </td>
                                                {/if}
                                                <td>
                                                    {if ($addon.id_roja45_productrental_extra_type==1)}
                                                        <input type="text"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_RATETYPE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               value="{l s='Per Period' mod='roja45productrental'}"
                                                               readonly/>
                                                    {elseif ($addon.id_roja45_productrental_extra_type==2)}
                                                        <input type="text"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_RATETYPE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               value="{l s='Per Rental' mod='roja45productrental'}"
                                                               readonly/>
                                                    {elseif ($addon.id_roja45_productrental_extra_type==3)}
                                                        <input type="text"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_RATETYPE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               value="{l s='Per Rental Item' mod='roja45productrental'}"
                                                               readonly/>
                                                    {elseif ($addon.id_roja45_productrental_extra_type==4)}
                                                        <input type="text"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_RATETYPE_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               value="{l s='Per Rental Item, Per Day' mod='roja45productrental'}"
                                                               readonly/>
                                                    {/if}
                                                </td>
                                                <td>
                                                    <span class="switch prestashop-switch">
                                                        <input type="radio"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               id="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}_on"
                                                               value="1"
                                                               {if (in_array($addon.id_roja45_product_extra, $selected_ids))}checked="checked"{/if}/>
                                                        <label for="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}_on"
                                                               class="radioCheck">{l s='Yes' mod='roja45productrental'}</label>
                                                        <input type="radio"
                                                               name="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               id="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}_off"
                                                               value="0"
                                                               {if (!in_array($addon.id_roja45_product_extra, $selected_ids))}checked="checked"{/if}/>
                                                        <label for="ROJA45_PRODUCTRENTAL_EXTRA_ENABLED_{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}_off"
                                                               class="radioCheck">{l s='No' mod='roja45productrental'}</label>
                                                        <a class="slide-button btn"></a>
                                                    </span>
                                                </td>
                                            </tr>
                                        {/foreach}
                                    {/if}
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="panel-footer">
            <a href="#" id="cancelUpdateProductRentalModel" class="cancelUpdateProductRentalModel btn btn-default btn btn-default pull-left"><i class="process-icon-cancel"></i>{l s='Cancel' mod='roja45productrental'}</a>
            <a href="{$admin_link|escape:'htmlall':'UTF-8'}" class="updateSubmitProductRentalModelExtras btn btn-default btn btn-default pull-right"><i class="process-icon-save"></i>{l s='Save Extras' mod='roja45productrental'}</a>
        </div>
    </div>
</div>