{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<input type="hidden" name="ROJA45_PRODUCTRENTAL_MODEL_ID" value="{$fields_value['ROJA45_PRODUCTRENTAL_MODEL_ID']|escape:'htmlall':'UTF-8'}"/>
<div id="roja45productrental_model_block">
    <ps-panel header="{l s='Details' mod='roja45productrental'}">
        <ps-switch name="ROJA45_PRODUCTRENTAL_MODELENABLED"
                   label="{l s='Enable Rental Model' mod='roja45productrental'}"
                   hint="{l s='Enable  rental of this model?' mod='roja45productrental'}"
                   yes="{l s='Yes' mod='roja45productrental'}"
                   no="{l s='no' mod='roja45productrental'}"
                   active="{if ($fields_value['ROJA45_PRODUCTRENTAL_MODELENABLED'] == "0")}false{else}true{/if}"></ps-switch>
        <ps-input-text name="ROJA45_PRODUCTRENTAL_NAME"
                       col-lg="10"
                       value="{$fields_value['ROJA45_PRODUCTRENTAL_NAME']|escape:'html':'UTF-8'}"
                       label="{l s='Model Name' mod='roja45productrental'}">
        </ps-input-text>
        <ps-input-text name="ROJA45_PRODUCTRENTAL_MODEL_REFERENCE"
                       col-lg="10"
                       value="{$fields_value['ROJA45_PRODUCTRENTAL_MODEL_REFERENCE']|escape:'html':'UTF-8'}"
                       label="{l s='Model Reference' mod='roja45productrental'}">
        </ps-input-text>
        <ps-textarea-lang name="ROJA45_PRODUCTRENTAL_DESCRIPTION"
                          label="{l s='Description' mod='roja45productrental'}"
                          hint="{l s='Give your customers a more detailed description of this model.' mod='roja45productrental'}"
                          col-lg="10"
                          rows="10"
                          cols="40"
                          active-lang="2"
                          rich-editor="true">
            {foreach $languages as $language}
                <div data-is="ps-textarea-lang-value"
                     iso-lang="{$language.iso_code|escape:"html":"UTF-8"}"
                     id-lang="{$language.id_lang|escape:"html":"UTF-8"}"
                     lang-name="{$language.name|escape:"html":"UTF-8"}">{if isset($fields_value['ROJA45_PRODUCTRENTAL_DESCRIPTION'][$language.id_lang])}{$fields_value['ROJA45_PRODUCTRENTAL_DESCRIPTION'][$language.id_lang]|escape:"html":"UTF-8"}{/if}</div>
            {/foreach}
        </ps-textarea-lang>

        {if (!$is_linked)}
        <ps-input-text name="ROJA45_PRODUCTRENTAL_QTY_AVAILABLE"
                       col-lg="10"
                       value="{$fields_value['ROJA45_PRODUCTRENTAL_QTY_AVAILABLE']|escape:'html':'UTF-8'}"
                       label="{l s='Available Quantity' mod='roja45productrental'}">
        </ps-input-text>
        {/if}
        <ps-panel-footer>
            <ps-panel-footer-link title="{l s='Cancel' mod='roja45productrental'}" icon="process-icon-cancel" href="{$admin_link|escape:'htmlall':'UTF-8'}" direction="left" name="cancelUpdateProductRentalModel"></ps-panel-footer-link>
            <ps-panel-footer-link title="{l s='Save & Stay' mod='roja45productrental'}" icon="process-icon-save" href="{$admin_link|escape:'htmlall':'UTF-8'}" direction="right" name="updateProductRentalModel"></ps-panel-footer-link>
            <ps-panel-footer-link title="{l s='Save' mod='roja45productrental'}" icon="process-icon-save" href="{$admin_link|escape:'htmlall':'UTF-8'}" direction="right" name="updateCloseProductRentalModel"></ps-panel-footer-link>
        </ps-panel-footer>
    </ps-panel>

    <ps-panel header="{l s='Default Rates' mod='roja45productrental'}">
        <div class="form-group">
            <div class="col-lg-9">
            <select name="ROJA45_PRODUCTRENTAL_RATE_DURATION" class="chosen ">
                {foreach $rate_durations as $rate_duration}
                    <option value="{$rate_duration.id_roja45_product_rateduration|escape:'htmlall':'UTF-8'}" {if $rate_duration.id_roja45_product_rateduration==2}selected="selected"{/if}>
                        {$rate_duration.name|escape:'htmlall':'UTF-8'}
                    </option>
                {/foreach}
            </select>
            </div>
        </div>
        <div id="productrental_model_rates">
            {include file='./productrental_rates.tpl'}
        </div>
    </ps-panel>

    <ps-panel header="{l s='Add Rate' mod='roja45productrental'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATE_ID">
        <ps-select label="{l s='Rate' mod='roja45productrental'}"
                   name="ROJA45_PRODUCTRENTAL_RATE_TYPE"
                   hint="{l s='Select the rate to add.' mod='roja45productrental'}"
                   chosen='true'>
            {foreach $rate_types as $rate_type}
                <option value="{$rate_type.id_roja45_product_ratetype|escape:'htmlall':'UTF-8'}" {if $rate_type.id_roja45_product_ratetype==1}selected="selected"{/if}>
                    {$rate_type.name|escape:'htmlall':'UTF-8'}
                </option>
            {/foreach}
        </ps-select>
        <div class="form-group">
            <label class="control-label col-lg-3">
                <span class="label-tooltip" data-toggle="tooltip" data-html="true" title="{l s='Select the customer group able to request quotations' mod='roja45productrental'}" data-original-title="{l s='Select the customer group able to request quotations' mod='roja45productrental'}">{l s='Customer Groups' mod='roja45productrental'}</span>
            </label>
            <div class="col-lg-8">
                <table class="table">
                    <thead>
                    <tr>
                        <th>{l s='Group' mod='roja45productrental'}</th>
                        <th>{l s='Enabled' mod='roja45productrental'}</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $customer_groups as $customer_group}
                        <tr>
                            <td>{$customer_group.name}</td>
                            <td>
                                <input type="checkbox" name="ROJA45_PRODUCTRENTAL_RATEGROUP[]" value="{$customer_group.id_group}" class="" checked="checked">
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            </div>
        </div>
        <ps-input-text name="ROJA45_PRODUCTRENTAL_RATE"
                       value="0.00"
                       label="{l s='Rate' mod='roja45productrental'}"
                       prefix="{$currency->sign|escape:'htmlall':'UTF-8'}"
                       on-change="this.value = this.value.replace(/,/g, '.');"
                       hint="{l s='Set the rate associated with this rate type.' mod='roja45productrental'}"></ps-input-text>
        <ps-panel-footer>
            <ps-panel-footer-link title="{l s='Cancel' mod='roja45productrental'}" icon="process-icon-cancel" href="{$admin_link|escape:'htmlall':'UTF-8'}" direction="left" name="cancelUpdateProductRentalModel"></ps-panel-footer-link>
            <ps-panel-footer-link title="{l s='Save Rate' mod='roja45productrental'}" icon="process-icon-save" href="#" direction="right" name="saveRate"></ps-panel-footer-link>
        </ps-panel-footer>
    </ps-panel>
</div> <!-- roja45productrental_model_block -->

{include file='./productrental_extras.tpl'}