{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{capture assign=priceDisplayPrecisionFormat}{'%.'|cat:$smarty.const._PS_PRICE_DISPLAY_PRECISION_|cat:'f'|escape:'htmlall':'UTF-8'}{/capture}
<div class="form-group">
    <label class="control-label col-lg-3">
        <span class="label-tooltip" data-toggle="tooltip" data-html="true" title=""
              data-original-title="{l s='List of current seasonal rates for this model.' mod='roja45productrental'}">{l s='Seasonal Rates' mod='roja45productrental'}</span>
    </label>
    <div class="col-lg-9">
        <div class="panel">
            <div id="period_rates_list">
                <div class="table-responsive-row clearfix">
                    <table id="table-periods-list" class="table configuration">
                        <thead>
                        <tr class="nodrag nodrop">
                            <th class="left"><span class="title_box">{l s='Rate Type' mod='roja45productrental'}</span></th>
                            <th class="left"><span class="title_box">{l s='Period' mod='roja45productrental'}</span></th>
                            <th class="left"><span class="title_box">{l s='Price' mod='roja45productrental'}</span></th>
                            <th class="left"></th>
                        </tr>
                        </thead>
                        <tbody>
                        {if isset($period_rates) }
                            {foreach $period_rates as $period}
                                <tr class="period-row"
                                    data-id="{$period.id_roja45_product_periodrate|escape:'htmlall':'UTF-8'}" {if isset($period.id_roja45_product_periodrate)}
                                    data-id-period="{$period.id_roja45_product_period|escape:'htmlall':'UTF-8'}"{/if}
                                    data-id-type="{$period.id_rate|escape:'htmlall':'UTF-8'}"
                                    data-start-date="{$period.start_date|escape:'htmlall':'UTF-8'}"
                                    data-end-date="{$period.end_date|escape:'htmlall':'UTF-8'}"
                                    data-value="{toolsConvertPrice price=$period.rate}">
                                    <td data-id="id_rate" data-value="{$period.id_rate|escape:'htmlall':'UTF-8'}">
                                        {$period.ratetype_name|escape:'html':'UTF-8'}
                                    </td>
                                    <td data-id="period"
                                        data-value="{$period.name|escape:'htmlall':'UTF-8'}">{$period.name|escape:'html':'UTF-8'}</td>
                                    <td data-id="rate"
                                        data-value="{toolsConvertPrice price=$period.rate}">
                                        <input type="text" name="ROJA45_PRODUCTRENTALS_RATE_VALUE"
                                               value="{toolsConvertPrice price=$period.rate}"
                                               class="form-control fixed-width-lg"
                                               onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                               onkeydown='javascript: if(event.keyCode == 13)roja45productrental.updateProductPeriodRate(event);'
                                               onblur="roja45productrental.updateProductPeriodRate(event);">
                                    </td>
                                    <td>
                                        <button type="button" class="btn btn-default btn-sm deletePeriodRate pull-right">
                                            <i class="icon-trash"></i> {l s='Delete' mod='roja45productrental'}
                                        </button>
                                    </td>
                                </tr>
                            {/foreach}
                        {/if}
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>