{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{capture assign=priceDisplayPrecisionFormat}{'%.'|cat:$smarty.const._PS_PRICE_DISPLAY_PRECISION_|cat:'f'|escape:'htmlall':'UTF-8'}{/capture}

<div class="panel">
    <div id="rates_list">
        <div class="table-responsive-row clearfix">
            <table id="table-rates-list" class="table configuration">
                <thead>
                <tr class="nodrag nodrop">
                    <th class="left">
                        <span class="title_box">{l s='Rate Type' mod='roja45productrental'}</span></th>
                    <th class="left">
                        <span class="title_box">{l s='Rate' mod='roja45productrental'}</span>
                    </th>
                    <th class="left">
                        <span class="title_box">{l s='Groups' mod='roja45productrental'}</span>
                    </th>
                    <th class="left"></th>
                </tr>
                </thead>
                <tbody>
                {if isset($productrental_model_rates) }
                    {foreach $productrental_model_rates as $rate}
                        <tr class="rate-row" data-id="{$rate.id_roja45_product_rate|escape:'htmlall':'UTF-8'}"
                            data-id-type="{$rate.id_type|escape:'htmlall':'UTF-8'}"
                            data-rate="{{toolsConvertPrice price=$rate.rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}"
                            data-rate-formatted="{{toolsConvertPrice price=$rate.rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}"
                            data-group-ids="{foreach $rate.groups as $group}{$group.id_group|escape:'htmlall':'UTF-8'},{/foreach}">
                            <td data-id="id_type"
                                data-value="{$rate.id_type|escape:'htmlall':'UTF-8'}">{$rate.name|escape:'htmlall':'UTF-8'}</td>
                            <td data-id="rate"
                                data-value="{$rate.rate|escape:'htmlall':'UTF-8'}">
                                <div class="input-group">
                                    <span class="input-group-addon">{$currency->sign|escape:'html':'UTF-8'}</span>
                                    <input type="text" name="ROJA45_PRODUCTRENTAL_RATE_VALUE"
                                           value="{{toolsConvertPrice price=$rate.rate}|string_format:$priceDisplayPrecisionFormat|escape:'htmlall':'UTF-8'}""
                                           class="form-control fixed-width-lg"
                                           disabled="disabled"/>
                                           <!--onkeyup='javascript: roja45productrental.validate_number(this);'
                                           onkeydown='javascript: if(event.keyCode == 13)roja45productrental.updateProductModelRate(event);'
                                           onblur="roja45productrental.updateProductModelRate(event);">-->
                                </div>
                            </td>
                            <td>{foreach $rate.groups as $group}{$group.name|escape:'htmlall':'UTF-8'},{/foreach}</td>
                            <td>
                                <button type="button" class="btn btn-default btn-sm deleteRate pull-right">
                                    <i class="icon-trash"></i> {l s='Delete' mod='roja45productrental'}
                                </button>
                                <button type="button" class="btn btn-default btn-sm editRate pull-right">
                                    <i class="icon-trash"></i> {l s='Edit' mod='roja45productrental'}
                                </button>
                            </td>
                        </tr>
                    {/foreach}
                {/if}
                </tbody>
            </table>
        </div>
    </div>
</div>

<div id="rate-delete-dialog-confirm" title="{l s='Are you sure?' mod='roja45productrental'}"
     style="display:none;">
    <p><span class="ui-icon ui-icon-alert"
             style="float:left; margin:0 7px 20px 0;"></span>{l s='This rate and all period rates associated to this rate will be deleted.  Are you sure?' mod='roja45productrental'}
    </p>
</div>


