{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<script type="text/javascript">
    var roja45_rental_controller = '{$roja45_rental_controller}';
    var roja45_calendar_controller = '{$roja45_calendar_controller}';
    var roja45_productrental_dateformat = '{$roja45_productrental_dateformat|escape:'html':'UTF-8'}';
    var roja45_productrental_unknown_error = "{l s='An unknown error has occurred, please try again and if the problem persists contact your support provider.' mod='roja45productrental' js=1}";
</script>


<div class="col-lg-12">
    <div class="row">
        <div class="rental-content clearfix">
            {if count($list)}
            <div class="rental-content-products-container">
                <div class="rental-content-products">
                    {foreach $list as $tr}
                        {foreach $tr.rental_data.models as $model}
                            <div class="rental-content-product">
                                <div class="rental-content-product-cell">
                                    {if $model@index==0}
                                        <div class="rental-content-product-cell-row rental-content-product-name">
                                            <span class="title pull-left">{$tr.name|escape:'html':'UTF-8'}</span>
                                        </div>
                                    {/if}
                                    <div class="rental-content-product-cell-row rental-content-product-model"
                                         data-id-roja45-product="{$tr.id_roja45_product}"
                                         data-id-roja45-product-model="{$model.id_roja45_product_model}">
                                        <span class="title pull-right"> {$model.name|escape:'html':'UTF-8'} ({$model.available|escape:'html':'UTF-8'})</span>
                                    </div>
                                </div>
                            </div>
                        {/foreach}
                    {/foreach}
                </div>
                <div class="rental-content-products-navigation clearfix" style="z-index: 499;width: 200px;">
                    <div class="btn-group btn-group-justified">
                        <a href="#" class="btn btn-default btn-change-period btn-two-week {if $period==14}active{/if}" data-period="14">{l s='14 Days' mod='roja45productrental'}</a>
                        <a href="#" class="btn btn-default btn-change-period btn-month {if $period==31}active{/if}" data-period="31">{l s='Month' mod='roja45productrental'}</a>
                        <a href="#" class="btn btn-default btn-change-period btn-three-months {if $period==93}active{/if}" data-period="93">{l s='3 Months' mod='roja45productrental'}</a>
                    </div>
                </div>
            </div>
            <div class="rental-content-calendar-container"
                 data-start-date="{$start_date}"
                 data-end-date="{$end_date}"
                 data-days="{$days}">
                <div class="rental-content-calendar-container-columns clearfix" style="width:1450px;">
                    {foreach $dates as $date}
                    <div class="rental-content-calendar-container-column {$date.type} {$date.weekday} {$date.weekend}" data-date="{$date.date}" style="width:96.666px;">
                        {foreach $list as $tr}
                            {foreach $tr.rental_data.models as $model}
                                {if $model@index==0}
                                    <div class="rental-content-calendar-column-cell">
                                        <div class="rental-content-calendar-cell day {$date.type} {$date.weekday} {$date.weekend} {if ($date.type!='past') || ($past_selectable==1)}day-selectable{/if}"
                                             data-date="{$date.date}"
                                             data-date-formatted="{$date.date_formatted}"
                                             data-id-roja45-product="{$tr.id_roja45_product}"
                                             data-id-roja45-product-model="0">
                                        </div>
                                    </div>
                                {/if}
                                <div class="rental-content-calendar-column-cell">
                                    <div class="rental-content-calendar-cell day {if count($model.custom_rates) && isset($model.custom_rates[$date.date])}special-rate{/if} {$date.type} {$date.weekday} {$date.weekend} {if ($date.type!='past') || ($past_selectable==1)}day-selectable{/if} {if count($model.custom_rates) && isset($model.custom_rates[$date.date])}special-rate{/if}"
                                         data-date="{$date.date}"
                                         data-date-formatted="{$date.date_formatted}"
                                         data-id-roja45-product="{$tr.id_roja45_product}"
                                         data-id-roja45-product-model="{$model.id_roja45_product_model}">
                                        <div class="rate-details" style="display: none;">
                                            {if count($model.custom_rates) && isset($model.custom_rates[$date.date])}
                                                {foreach $model.custom_rates[$date.date] as $rate}
                                                    <div class="row">
                                                        <div class="calendar-rate custom">
                                                            <span>{$rate.name} : {$rate.rate_formatted} ({$rate.original_rate_formatted})</span>
                                                        </div>
                                                    </div>
                                                {/foreach}
                                            {else}
                                                {foreach $model.rates as $rate}
                                                    <div class="row">
                                                        <div class="calendar-rate standard">
                                                            <span>{$rate.name} : {$rate.rate_formatted}</span>
                                                        </div>
                                                    </div>
                                                {/foreach}
                                            {/if}
                                        </div>
                                    </div>
                                </div>
                            {/foreach}
                        {/foreach}
                    </div>
                    {/foreach}
                </div>
                <div class="rental-content-calendar-container-navigation clearfix" style="z-index: 1039;width:1450px;">
                    <div class="btn-group btn-group-justified">
                        <a href="#" class="btn btn-default btn-prev-page"> &lt;&lt;</a>
                        <a href="#" class="btn btn-default btn-prev-days"> &lt;</a>
                        <a href="#" class="btn btn-default btn-today">{l s='Today' mod='roja45productrental'}</a>
                        <a href="#" class="btn btn-default btn-select-date icon">
                            <i class="icon-calendar" aria-hidden="true"></i>
                        </a>
                        <input type="input" id="hiddenField" class="datepicker" style="display:none;"/>
                        <a href="#" class="btn btn-default btn-next-days"> &gt;</a>
                        <a href="#" class="btn btn-default btn-next-page"> &gt;&gt;</a>
                    </div>
                </div>
                <div class="rental-content-calendar-container-dates clearfix" style="top: 200px;z-index: 1039;margin-left: 425px;width:1450px;">
                    <div class="rental-content-calendar-container-header"></div>
                    <div class="rental-content-calendar-container-days rental-content-calendar-container-days-{$period} {$date.type}">
                    {foreach $dates as $date}
                        <div class="rental-content-calendar-container-column {$date.type}" data-date="{$date.date}" style="width:96.666px;">
                            <div class="rental-content-calendar-day-column">
                                <div class="day">{$date.day_formatted}</div>
                                <div class="day-name">{if $period==93}{$date.day_name|truncate:2:"":true}{else}{$date.day_name}{/if}</div>
                            </div>
                        </div>
                    {/foreach}
                    </div>
                </div>
                <div class="rental-content-calendar-container-rentals clearfix" style="width:1450px;">
                    {foreach $rentals as $rental}
                        <div class="rental-content-rental-container {if isset($rental.active) && $rental.active}active{/if}" style="opacity:0;"
                             data-id-roja45-product-rental="{$rental.id_roja45_product_rental}"
                             data-id-roja45-product="{$rental.id_roja45_product}"
                             data-id-roja45-product-model="{$rental.id_roja45_product_model}"
                             data-collection-date="{$rental.start_date}"
                             data-collection-time="{$rental.collection_time}"
                             data-return-date="{$rental.end_date}"
                             data-return-time="{$rental.return_time}"
                             data-preparation="{$rental.preparation}"
                             data-recondition="{$rental.recondition}"
                             data-number-of-days="{$rental.periods}">
                            <a class="rental-calendar-entry-link"
                               title="[{$rental.status_full}] [{$rental.collection_formatted} - {$rental.return_formatted}] {$rental.reference} : {$rental.customer_name}"
                               data-id-roja45-product-rental="{$rental.id_roja45_product_rental}">
                                <div class="rental-content-rental" style="background-color:{$rental.color};">
                                    <span>[{$rental.code}] {$rental.reference} : {$rental.customer_name}</span>
                                </div>
                            </a>
                        </div>
                    {/foreach}
                </div>
                <div class="rental-content-calendar-container-unavailable clearfix" style="width:1450px;">
                    {foreach $unavailables as $unavailable}
                        <div class="rental-content-unavailable-container" style="opacity:0;"
                             data-id-roja45-product="{$unavailable.id_roja45_product}"
                             data-id-roja45-product-model="{$unavailable.id_roja45_product_model}"
                             data-start-date="{$unavailable.start_date}"
                             data-end-date="{$unavailable.end_date}">
                            <a class="rental-calendar-unavailable-link"
                               title="{$unavailable.start_date} : {$unavailable.end_date}"
                               data-id-roja45-product-unavailable="{$unavailable.id_roja45_product_unavailable}">
                                <div class="rental-content-unavailable" style="background-color:red;">
                                    <span>{l s='Unavailable' mod='roja45productrental'} [{$unavailable.start_date} : {$unavailable.end_date}]</span>
                                </div>
                            </a>
                        </div>
                    {/foreach}
                </div>
            </div>
            <div class="rental-content-loading-overlay">
                <div class="modal-wait-container">
                    <div class="modal-wait-icon">
                        <i class="icon-refresh icon-spin"></i>
                    </div>
                    <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
                </div>
            </div>
            {else}
                <div class="row">
                    <div class="center-block col-xs-12">
                        {l s='No rental products available.' mod='roja45productrental'}
                    </div>
                </div>
            {/if}
        </div>
    </div>
</div>

<div id="rental_calendar_modal" class="rental_calendar_modal modal" aria-hidden="false" style="display: none;">
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_PRODUCT_ID"/>
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_PRODUCT_MODEL_ID"/>
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_START_DATE"/>
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_END_DATE"/>
    <div class="modal-dialog dates">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">
            </div>
            <div class="modal-footer">
                <a class="btn btn-default" data-dismiss="modal">{l s='Close' mod='roja45productrental'}</a>
            </div>
            <div class="rental-content-loading-overlay">
                <div class="modal-wait-container">
                    <div class="modal-wait-icon">
                        <i class="icon-refresh icon-spin"></i>
                    </div>
                    <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="rental_entry_modal" class="rental_entry_modal modal" aria-hidden="false" style="display: none;">
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_ID"/>
    <div class="modal-dialog entry">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">

            </div>
            <div class="modal-footer">
                <a class="btn btn-primary btn-calendar-delete">{l s='Delete' mod='roja45productrental'}</a>
                <a class="btn btn-primary btn-calendar-cancel">{l s='Cancel' mod='roja45productrental'}</a>
                <a class="btn btn-secondary pull-left" data-dismiss="modal">{l s='Close' mod='roja45productrental'}</a>
            </div>
            <div class="rental-content-loading-overlay">
                <div class="modal-wait-container">
                    <div class="modal-wait-icon">
                        <i class="icon-refresh icon-spin"></i>
                    </div>
                    <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="rental_unavailable_modal" class="rental_unavailable_modal modal" aria-hidden="false" style="display: none;">
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_ID_UNAVAILABLE"/>
    <div class="modal-dialog entry">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">

            </div>
            <div class="modal-footer">
                <a class="btn btn-default" data-dismiss="modal">{l s='Close' mod='roja45productrental'}</a>
            </div>
            <div class="rental-content-loading-overlay">
                <div class="modal-wait-container">
                    <div class="modal-wait-icon">
                        <i class="icon-refresh icon-spin"></i>
                    </div>
                    <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="calendar_day_modal" class="calendar_day_modal modal" aria-hidden="false" style="display: none;">
    <input type="hidden" name="ROJA45_PRODUCT_RENTAL_ID_UNAVAILABLE"/>
    <div class="modal-dialog calendar-day">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
            </div>
            <div class="modal-body row">

            </div>
            <div class="modal-footer">
                <a class="btn btn-default" data-dismiss="modal">{l s='Close' mod='roja45productrental'}</a>
            </div>
            <div class="rental-content-loading-overlay">
                <div class="modal-wait-container">
                    <div class="modal-wait-icon">
                        <i class="icon-refresh icon-spin"></i>
                    </div>
                    <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
                </div>
            </div>
        </div>
    </div>
</div>

{addJsDefL name=roja45_productrental_cancelbutton}{l s='Close' mod='roja45productrental' js=1}{/addJsDefL}
{addJsDefL name=roja45_productrental_yes}{l s='Yes' mod='roja45productrental' js=1}{/addJsDefL}
{addJsDefL name=roja45_productrental_areyousure}{l s='Are you sure?' mod='roja45productrental' js=1}{/addJsDefL}
{addJsDefL name=roja45_productrental_no}{l s='No' mod='roja45productrental' js=1}{/addJsDefL}
{addJsDefL name=roja45_productrental_preparation}{l s='Preparation' mod='roja45productrental' js=1}{/addJsDefL}
{addJsDefL name=roja45_productrental_recondition}{l s='Recondition' mod='roja45productrental' js=1}{/addJsDefL}