{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file="helpers/form/form.tpl"}

{block name="other_fieldsets"}

	<div class="panel col-lg-6">

		<div id="conditions">
			<div id="condition_group_list"></div>
		</div>

		<a class="btn btn-default" href="#" id="add_condition_group">
			<i class="icon-plus-sign"></i> {l s='Add a new condition group' mod='roja45productrental'}
		</a>
		<div class="clearfix">&nbsp;</div>
		<div class="panel" id="conditions-panel" style="display:none;">
			<h3><i class="icon-tasks"></i> {l s='Conditions' mod='roja45productrental'}</h3>
			<div class="form-group">
				<label for="id_category" class="control-label col-lg-3">{l s='Category' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="col-lg-8">
						<select id="id_category" name="id_category">
							{foreach $categories as $category}
							<option value="{$category.id_category|intval|escape:'htmlall':'UTF-8'}">({$category.id_category|intval|escape:'htmlall':'UTF-8'}) {$category.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
					<div class="col-lg-1">
						<a class="btn btn-default" href="#" id="add_condition_category">
							<i class="icon-plus-sign"></i> {l s='Add condition' mod='roja45productrental'}
						</a>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label for="id_roja45product" class="control-label col-lg-3">{l s='Rental Product' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="col-lg-8">
						<select id="id_roja45product" name="id_roja45_product">
							{foreach $products as $product}
								<option value="{$product.id_roja45_product|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
					<div class="col-lg-1">
						<a class="btn btn-default" href="#" id="add_condition_roja45product">
							<i class="icon-plus-sign"></i> {l s='Add condition' mod='roja45productrental'}
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="panel col-lg-6">
		<div id="discount">
			<div id="discount_list"></div>
		</div>
		<a class="btn btn-default" href="#" id="add_discount_profile">
			<i class="icon-plus-sign"></i> {l s='Add a new discount profile' mod='roja45productrental'}
		</a>
		<div class="clearfix">&nbsp;</div>
		<div class="panel" id="discounts-panel" style="display:none;">
			<h3><i class="icon-tasks"></i> {l s='Discount Profile' mod='roja45productrental'}</h3>
            <input type="hidden" name="id_discount"/>

			<div class="form-group">
				<label class="control-label col-lg-3">{l s='From' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="input-group col-lg-4">
						<select id="period_start" name="period_start">
							{for $period_val=0 to $period_upper_limit}
								<option value="{$period_val|intval|escape:'htmlall':'UTF-8'}">{$period_val|escape:'htmlall':'UTF-8'}</option>
							{/for}
						</select>
						<span class="input-group-addon">{$period_txt|escape:'htmlall':'UTF-8'}</span>
					</div>
				</div>
			</div>
			<div class="form-group">
                <label class="control-label col-lg-3">{l s='Until' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="input-group col-lg-4">
						<select id="period_end" name="period_end">
                            {for $period_val=0 to $period_upper_limit}
								<option value="{$period_val|intval|escape:'htmlall':'UTF-8'}">{$period_val|escape:'htmlall':'UTF-8'}</option>
                            {/for}
						</select>
                        <span class="input-group-addon">{$period_txt|escape:'htmlall':'UTF-8'}</span>
					</div>
				</div>
			</div>
            <div class="form-group">
                <label class="control-label col-lg-3">{l s='Applies discount of' mod='roja45productrental'}</label>
                <div class="col-lg-9">
                    <div class="input-group col-lg-4">
                        <input id="discount" type="text" name="discount"/>
                        <span class="input-group-addon">%</span>
                    </div>
                </div>
            </div>
            <div class="form-group">
                <div class="col-lg-3">
                    <a class="btn btn-default" href="#" id="add_discount">
                        <i class="icon-plus-sign"></i> {l s='Add discount' mod='roja45productrental'}
                    </a>
                </div>
			</div>
		</div>
	</div>
{/block}

{block name="script"}
	var current_id_condition_group = 0;
	var last_condition_group = 0;
	var conditions = new Array();
	var discounts = new Array();

	function toggle_condition_group(id_condition_group)
	{
		$('.condition_group').removeClass('alert-info');
		$('.condition_group > table').removeClass('alert-info');
		$('#condition_group_'+id_condition_group+' > table').addClass('alert-info');
		$('#condition_group_'+id_condition_group).addClass('alert-info');
		current_id_condition_group = id_condition_group;
	}

	function toggle_discount_block()
	{
		$('.discount_profile').removeClass('alert-info');
		$('.discount_profile > table').removeClass('alert-info');
		$('#discount_profile'+' > table').addClass('alert-info');
		$('#discount_profile').addClass('alert-info');
	}

    function add_discount(id, period_start, period_end, value)
    {
        //var id_discount = id+'_'+period_start+'_'+period_end+'_'+value+'_0';
        var id_discount = id+'_'+period_start+'_'+period_end+'_0';
        var discount = new Array();
        if (!id) {
            id = 0;
        }
        discount.id = id;
        discount.period_start = period_start;
        discount.period_end = period_end;
        discount.value = value;
        discount.to_delete = 0;
        discounts[id_discount] = discount;
        return id_discount;
    }

    function appendDiscountToProfile(html)
    {
        $('#discount_profile table tbody').append(html);
    }

    function delete_discount(id_discount)
    {
        var discount = discounts[id_discount];
        discount.to_delete = 1;
        $('#discount_profile table tr[data-id-row='+id_discount+']').remove();
        return false;
    }

	function update_discount(id_discount)
	{
		var discount = discounts[id_discount];
		var discount_amount = $('#discount_profile table tr[data-id-row='+id_discount+'] input[name=discount_amount]').val();
		var id_roja45_product_discount = $('#id_roja45_product_discount').val();
		$.ajax({
			url: $('#roja45_productrental_discount_form').attr('action'),
			type: 'post',
			dataType: 'json',
			data: {
				'ajax' : 1,
				'action': 'updateDiscountProfileAmount',
				'id_roja45_product_discount' : id_roja45_product_discount,
				'id_discount' : id_discount,
				'discount_amount' : discount_amount,
			},
			beforeSend: function () {
			},
			success: function (data) {
				if (data.result) {
				} else {
				}
			},
			error: function (data) {
			},
			complete: function (data) {
			}
		});
	}

    function isInt(value) {
        return !isNaN(value) && (function(x) { return (x | 0) === x; })(parseFloat(value))
    }

	function add_condition(id_condition_group, type, value)
	{
		var id_condition = id_condition_group+'_'+type+'_'+value;
		if (typeof conditions[id_condition] != 'undefined') {
            return false;
        }
		var condition = new Array();
		condition.type = type;
		condition.value = value;
		condition.id_condition_group = id_condition_group;
		conditions[id_condition] = condition;
		return id_condition;
	}

	function delete_condition(condition)
	{
		delete conditions[condition];

		to_delete = $('#'+condition).prev();
		if ($(to_delete).children().hasClass('btn_delete_condition'))
			$(to_delete).remove();
		else
			$('#'+condition).next().remove();

		$('#'+condition).remove();
		return false;
	}

	function new_condition_group()
	{
		$('#conditions-panel').show();
		var html = '';

		if (last_condition_group > 0)
			html += '<div class="row condition_separator text-center">{l s='OR' mod='roja45productrental'}</div><div class="clearfix">&nbsp;</div>';

		last_condition_group++;
		html += '<div id="condition_group_'+last_condition_group+'" class="panel condition_group alert-info"><h3><i class="icon-tasks"></i> {l s='Condition group' mod='roja45productrental'} '+last_condition_group+'</h3>';
		html += '<table class="table alert-info"><thead><tr><th class="fixed-width-md"><span class="title_box">{l s='Type' mod='roja45productrental'}</span></th><th><span class="title_box">{l s='Value' mod='roja45productrental'}</span></th><th></th></tr></thead><tbody></tbody></table>';
		html += '</div>';
		$('#condition_group_list').append(html);
		toggle_condition_group(last_condition_group);
	}

	function new_discount_profile()
	{
		$('#discounts-panel').show();

        if ($('#discount_profile').length>0) {
            return;
        }
		var html = '';

		html += '<div id="discount_profile" class="panel discount_profile alert-info"><h3><i class="icon-tasks"></i> {l s='Discount profile' mod='roja45productrental'}</h3><div class="alert alert-warning">{l s='Please ensure the profile periods do not overlap.' mod='roja45productrental'}</div>';
		html += '<table class="table alert-info"><thead><tr><th class="fixed-width-md"><span class="title_box">{l s='From' mod='roja45productrental'} ({$period_txt|escape:'htmlall':'UTF-8'})</span></th><th class="fixed-width-md"><span class="title_box">{l s='Until' mod='roja45productrental'} ({$period_txt|escape:'htmlall':'UTF-8'})</span></th><th><span class="title_box">{l s='% Discount' mod='roja45productrental'}</span></th><th></th></tr></thead><tbody></tbody></table>';
		html += '</div>';
		$('#discount_list').append(html);
		toggle_discount_block();
		$('#add_discount_profile').hide();
	}

    function appendConditionToGroup(html)
    {
        if ($('#condition_group_'+current_id_condition_group+' table tbody tr').length > 0)
            $('#condition_group_'+current_id_condition_group+' table tbody').append('<tr><td class="text-center btn_delete_condition" colspan="3"><b>{l s='AND' mod='roja45productrental' js=1}</b></td></tr>');
        $('#condition_group_'+current_id_condition_group+' table tbody').append(html);
    }

$(document).ready(function() {
	$('#leave_bprice_on').click(function() {
		if (this.checked)
			$('#price').attr('disabled', 'disabled');
		else
			$('#price').removeAttr('disabled');
	});

	$('#roja45_productrental_discount_form').on('submit', function(e) {
		var html = '';
		for (i in conditions) {
            html += '<input type="hidden" name="condition_group_'+conditions[i].id_condition_group+'[]" value="'+conditions[i].type+'_'+conditions[i].value+'" />';
        }
		$('#conditions').append(html);

        var html = '';
		for (i in discounts) {
			html += '<input type="hidden" name="discounts[]" value="'+discounts[i].id+'_'+discounts[i].period_start+'_'+discounts[i].period_end+'_'+discounts[i].value+'_'+discounts[i].to_delete+'"/>';
		}
		$('#discount').append(html);
	});

    $('#add_discount').click(function() {
        var id_discount = add_discount($('input[name=id_discount]').val(), $('select[name=period_start] option:selected').val(), $('select[name=period_end] option:selected').val(), $('input[name=discount]').val());
        var html = '<tr data-id-row="'+id_discount+'" data-id="'+$('input[name=id_discount]').val()+'"><td>'+$('select[name=period_start] option:selected').val()+'</td><td>'+$('select[name=period_end] option:selected').val()+'</td><td><input type="text" name="discount_amount" value="'+$('input[name=discount]').val()+'"></td><td><a href="#" onclick="update_discount(\''+id_discount+'\');" class="btn btn-default"><i class="icon-save"></i> {l s='Update' mod='roja45productrental'}</a></td><td><a href="#" onclick="delete_discount(\''+id_discount+'\');" class="btn btn-default"><i class="icon-remove"></i> {l s='Delete' mod='roja45productrental'}</a></td></tr>';
        appendDiscountToProfile(html);
        $('input[name=id_discount]').val(0);
        $('select[name=period_start] option:selected').val(0)
        $('select[name=period_end] option:selected').val(0)
        $('input[name=discount]').val(0);
        return false;
    });

	$('#add_condition_category').click(function() {
		var id_condition = add_condition(current_id_condition_group, 'category', $('#id_category option:selected').val());
		if (!id_condition)
			return false;

		var html = '<tr id="'+id_condition+'"><td>{l s='Category' mod='roja45productrental'}</td><td>'+$('#id_category option:selected').html()+'</td><td><a href="#" onclick="delete_condition(\''+id_condition+'\');" class="btn btn-default"><i class="icon-remove"></i> {l s='Delete' mod='roja45productrental'}</a></td></tr>';
		appendConditionToGroup(html);

		return false;
	});

	$('#add_condition_roja45product').click(function() {
		var id_condition = add_condition(current_id_condition_group, 'roja45product', $('#id_roja45product option:selected').val());
		if (!id_condition)
			return false;

		var html = '<tr id="'+id_condition+'"><td>{l s='Rental Product' mod='roja45productrental'}</td><td>'+$('#id_roja45product option:selected').html()+'</td><td><a href="#" onclick="delete_condition(\''+id_condition+'\');" class="btn btn-default"><i class="icon-remove"></i> {l s='Delete' mod='roja45productrental'}</a></td></tr>';
		appendConditionToGroup(html);
		return false;
	});

	$('#add_condition_group').click(function() {
		new_condition_group();
		return false;
	});

	$('#add_discount_profile').click(function() {
		new_discount_profile();
		return false;
	});

	$('.condition_group').on('click', function() {
		var id = this.id.split('_');
		toggle_condition_group(id[2]);
		return false;
	});

	{foreach $conditions as $condition_group}
		new_condition_group();
		{foreach $condition_group as $condition}
            $('#id_{$condition.type|escape:'htmlall':'UTF-8'} option[value="{$condition.value|escape:'htmlall':'UTF-8'}"]').attr('selected', true);
			$('#add_condition_{$condition.type|escape:'htmlall':'UTF-8'}').click();
		{/foreach}
	{/foreach}

    {if isset($discounts) && $discounts}
		new_discount_profile();
        {foreach $discounts as $discount}
            $('select[name=period_start] option:selected').val({$discount.period_start|escape:'htmlall':'UTF-8'});
            $('select[name=period_end] option:selected').val({$discount.period_end|escape:'htmlall':'UTF-8'});
            $('input[name=discount]').val({$discount.value|escape:'htmlall':'UTF-8'});
            $('input[name=id_discount]').val({$discount.id_roja45_product_discountprofile|escape:'htmlall':'UTF-8'});
			$('#add_discount').click();
        {/foreach}
    {/if}
});
{/block}
