{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file="helpers/form/form.tpl"}

{block name="other_fieldsets"}

	<div class="panel col-lg-6">

		<div id="conditions">
			<div id="condition_group_list"></div>
		</div>

		<a class="btn btn-default" href="#" id="add_condition_group">
			<i class="icon-plus-sign"></i> {l s='Add a new condition group' mod='roja45productrental'}
		</a>
		<div class="clearfix">&nbsp;</div>
		<div class="panel" id="conditions-panel" style="display:none;">
			<h3><i class="icon-tasks"></i> {l s='Conditions' mod='roja45productrental'}</h3>
			<div class="form-group">
				<label for="id_category" class="control-label col-lg-3">{l s='Category' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="col-lg-8">
						<select id="id_category" name="id_category">
							{foreach $categories as $category}
							<option value="{$category.id_category|intval|escape:'htmlall':'UTF-8'}">({$category.id_category|intval|escape:'htmlall':'UTF-8'}) {$category.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
					<div class="col-lg-1">
						<a class="btn btn-default" href="#" id="add_condition_category">
							<i class="icon-plus-sign"></i> {l s='Add condition' mod='roja45productrental'}
						</a>
					</div>
				</div>
			</div>
			<div class="form-group">
				<label for="id_roja45product" class="control-label col-lg-3">{l s='Rental Product' mod='roja45productrental'}</label>
				<div class="col-lg-9">
					<div class="col-lg-8">
						<select id="id_roja45product" name="id_roja45_product">
							{foreach $products as $product}
								<option value="{$product.id_roja45_product|escape:'htmlall':'UTF-8'}">{$product.name|escape:'htmlall':'UTF-8'}</option>
							{/foreach}
						</select>
					</div>
					<div class="col-lg-1">
						<a class="btn btn-default" href="#" id="add_condition_roja45product">
							<i class="icon-plus-sign"></i> {l s='Add condition' mod='roja45productrental'}
						</a>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="panel col-lg-6">
		<div id="pricerule">
			<div id="pricerule_list"></div>
		</div>
		<a class="btn btn-default" href="#" id="add_pricerule_profile">
			<i class="icon-plus-sign"></i> {l s='Add a new price rule profile' mod='roja45productrental'}
		</a>
		<div class="clearfix">&nbsp;</div>
		<div class="panel" id="pricerules-panel" style="display:none;">
			<h3><i class="icon-tasks"></i> {l s='Price Rule Profile' mod='roja45productrental'}</h3>
			<div class="alert alert-warning"> {l s='The value you provide for a day will be the discount applied to the rate set for that day.' mod='roja45productrental'}</div>
            <input type="hidden" name="id_pricerule"/>
			<div class="form-group">
				<table class="table table-responsive price_rule_day_table">
					<thead>
						<tr>
							<th>{l s='Mon' mod='roja45productrental'}</th>
							<th>{l s='Tue' mod='roja45productrental'}</th>
							<th>{l s='Wed' mod='roja45productrental'}</th>
							<th>{l s='Thu' mod='roja45productrental'}</th>
							<th>{l s='Fri' mod='roja45productrental'}</th>
							<th>{l s='Sat' mod='roja45productrental'}</th>
							<th>{l s='Sun' mod='roja45productrental'}</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><input data-day="1" data-name="{l s='Mon' mod='roja45productrental'}" type="text" name="price_rule_day_1"/></td>
							<td><input data-day="2" data-name="{l s='Tue' mod='roja45productrental'}" type="text" name="price_rule_day_2"/></td>
							<td><input data-day="3" data-name="{l s='Wed' mod='roja45productrental'}" type="text" name="price_rule_day_3"/></td>
							<td><input data-day="4" data-name="{l s='Thu' mod='roja45productrental'}" type="text" name="price_rule_day_4"/></td>
							<td><input data-day="5" data-name="{l s='Fri' mod='roja45productrental'}" type="text" name="price_rule_day_5"/></td>
							<td><input data-day="6" data-name="{l s='Sat' mod='roja45productrental'}" type="text" name="price_rule_day_6"/></td>
							<td><input data-day="7" data-name="{l s='Sun' mod='roja45productrental'}" type="text" name="price_rule_day_7"/></td>
						</tr>
					</tbody>
				</table>
			</div>
            <div class="form-group">
                <div class="col-lg-3">
                    <a class="btn btn-default" href="#" id="add_pricerule">
                        <i class="icon-plus-sign"></i> {l s='Add price rule' mod='roja45productrental'}
                    </a>
                </div>
			</div>
		</div>
	</div>
{/block}

{block name="script"}
$(document).ready(function() {
	{if isset($conditions)}
	{foreach $conditions as $condition_group}
		roja45productrentals_pricerules.new_condition_group();
		{foreach $condition_group as $condition}
            $('#id_{$condition.type|escape:'htmlall':'UTF-8'} option[value="{$condition.value|escape:'htmlall':'UTF-8'}"]').attr('selected', true);
			$('#add_condition_{$condition.type|escape:'htmlall':'UTF-8'}').click();
		{/foreach}
	{/foreach}
	{/if}

    {if isset($price_rules) && count($price_rules)}
		roja45productrentals_pricerules.new_pricerule_profile();
        {foreach $price_rules as $price_rule}
			$('input[name=id_pricerule]').val({$price_rule.id_roja45_product_priceruleprofile|escape:'htmlall':'UTF-8'});
			{foreach $price_rule.days as $day}
				$('input[name=price_rule_day_{$day.day}').val({$day.value|escape:'htmlall':'UTF-8'});
			{/foreach}
			$('#add_pricerule').click();
        {/foreach}
    {/if}
});
{/block}
