{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div id="apply_discount_percent_div" class="form-group">
	<label class="control-label col-lg-3">{l s='Value' d='Admin.Global'}</label>
	<div class="col-lg-9">
		<div class="input-group col-lg-2">
			<input type="text" id="reduction_percent" class="input-mini" name="reduction_percent" value="{$voucher->reduction_percent|floatval}" />
			<span class="input-group-addon">%</span>
		</div>
		<span class="help-block"><i class="icon-warning-sign"></i> {l s='Will be applied to each affected product for each day of the rental.' mod='roja45productrental'}</span>
	</div>
</div>

<div id="apply_discount_amount_div" class="form-group">
	<label class="control-label col-lg-3">{l s='Amount' mod='roja45productrental'}</label>
	<div class="col-lg-9">
		<div class="row">
			<div class="col-lg-4">
				<input type="text" id="reduction_amount" name="reduction_amount" value="{$voucher->reduction_amount|floatval}" onchange="this.value = this.value.replace(/,/g, '.');" />
			</div>
		</div>
		<span class="help-block"><i class="icon-warning-sign"></i> {l s='Will be applied to each affected product for each day of the rental.' mod='roja45productrental'}</span>
	</div>
</div>

<div class="form-group">
	<label class="control-label col-lg-3">{l s='Reduce Extras' mod='roja45productrental'}</label>
	<div class="col-lg-9">
		<span class="switch prestashop-switch fixed-width-lg">
			<input type="radio" name="reduction_extras" id="reduction_extras_on" value="1" {if $voucher->reduction_extras|intval}checked="checked"{/if} />
			<label class="t" for="reduction_extras_on">
				{l s='Yes' mod='roja45productrental'}
			</label>
			<input type="radio" name="reduction_extras" id="reduction_extras_off" value="0" {if !$voucher->reduction_extras|intval}checked="checked"{/if} />
			<label class="t" for="reduction_extras_off">
				{l s='No' mod='roja45productrental'}
			</label>
			<a class="slide-button btn"></a>
		</span>
		<span class="help-block"><i class="icon-warning-sign"></i> {l s='Apply the reduction to the extras as well.' mod='roja45productrental'}</span>
	</div>
</div>
<div class="form-group">
	<label class="control-label col-lg-3">{l s='Include Free Extra' mod='roja45productrental'}</label>
	<div class="col-lg-9">
		<span class="switch prestashop-switch fixed-width-lg">
			<input type="radio" name="free_extras" id="free_extras_on" value="1" {if $voucher->free_extras|intval}checked="checked"{/if} />
			<label class="t" for="free_extras_on">
				{l s='Yes' mod='roja45productrental'}
			</label>
			<input type="radio" name="free_extras" id="free_extras_off" value="0" {if !$voucher->free_extras|intval}checked="checked"{/if} />
			<label class="t" for="free_extras_off">
				{l s='No' mod='roja45productrental'}
			</label>
			<a class="slide-button btn"></a>
		</span>
	</div>
</div>

<div id="free_extras_div" class="form-group" {if !$voucher->free_extras|intval}style="display:none"{/if}>
	<label class="control-label col-lg-3">{l s='Search extras' mod='roja45productrental'}</label>
	<div class="col-lg-9">
		<div class="input-group col-lg-5">
			<input type="text" id="extrasFilter" value="">
			<span class="input-group-addon"><i class="icon-search"></i></span>
		</div>
	</div>
</div>
<div id="extras_found" class="form-group" style="display:none">
	<div id="extras_list" class="form-group">
		<label class="control-label col-lg-3">{l s='Select Extra' mod='roja45productrental'}</label>
		<div class="input-group col-lg-5">
			<select name="select_free_extra" id="select_free_extra" class="control-form">
				{foreach $extras as $extra}
				<option value="{$extra.id_roja45_product_extra}">{$extra.name}</option>
				{/foreach}
			</select>
			<span class="input-group-btn">
				<a href="#addextra" class="btn btn-default btn-add-extra-to-voucher"> {l s='Add' mod='roja45productrental'}</a>
			</span>
		</div>
	</div>
</div>
<div id="extras_selected" class="form-group" {if !count($selected_extras)}style="display:none"{/if}>
	<label class="control-label col-lg-3">{l s='Included Extras' mod='roja45productrental'}</label>
	<div class="col-lg-5">
		<table id="extras_selected_table" class="table table-bordered">
			{foreach $selected_extras as $selected_extra}
				<tr data-id-roja45-product-extra="{$selected_extra.id_roja45_product_extra}">
					<input  type="hidden"
							name="selected_extras[]"
							value="{$selected_extra.id_roja45_product_extra}"/>
					<td>
						{$selected_extra.name}
					</td>
					<td class="text-right">
						<a class="btn btn-default btn-remove-extra-from-voucher" data-id-roja45-product-extra="{$selected_extra.id_roja45_product_extra}" href="#">
							<i class="icon-remove"></i>
						</a>
					</td>
				</tr>
			{/foreach}
		</table>
	</div>
</div>
<div id="extras_err" class="alert alert-warning" style="display:none"></div>
