{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="page-three">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <span aria-hidden="true">X</span>
                <span class="sr-only">{l s='Close' mod='roja45productrental'}</span>
            </button>
            <h3 id="modalTitle" class="modal-title">{l s='Add Rental' mod='roja45productrental'}</h3>
        </div>
        <div class="modal-body row">
            <div class="col-lg-12">
                {if $availability > 0}
                    <div id="available_models_container" class="available-models-container col-lg-12">
                        <input type="hidden" name="collection_date" autocomplete="off" value="{$collection_date|escape:'htmlall':'UTF-8'}"/>
                        <input type="hidden" name="collection_time" autocomplete="off" value="{$collection_time|escape:'htmlall':'UTF-8'}"/>
                        <input type="hidden" name="return_date" autocomplete="off" value="{$return_date|escape:'htmlall':'UTF-8'}"/>
                        <input type="hidden" name="return_time" autocomplete="off" value="{$return_time|escape:'htmlall':'UTF-8'}"/>
                        {foreach $periods as $period}
                            <div data-period="{$period->period}"></div>
                        {/foreach}
                        <div class="product-rental-model-list list">
                            {foreach $models as $model}
                                <div class="panel ajax-block-product-rental-model product-rental-list col-lg-6"
                                    data-qty-available="{$model.qty_available|escape:'html':'UTF-8'}"
                                    data-id-roja45-product="{$model.id_roja45_product|escape:'html':'UTF-8'}"
                                    data-id-roja45-product-model="{$model.id_roja45_product_model|escape:'html':'UTF-8'}"
                                    data-id-product-attribute="{$model.id_product_attribute|escape:'html':'UTF-8'}"
                                    {if isset($model.payment_profile)}
                                    data-payment-profile-enabled="{$model.payment_profile->type|escape:'html':'UTF-8'}"
                                    data-payment-profile-value="{$model.payment_profile->action1|escape:'html':'UTF-8'}"
                                    {else}
                                    data-payment-profile-enabled="0"
                                    {/if}>
                                    <div class="product-rental-model-container row">
                                        <div class="col-xs-4">
                                            {if isset($model.image)}
                                                <img src="{$model.image.src|escape:'html':'UTF-8'}"
                                                     alt="{$model.image.title|escape:'html':'UTF-8'}"
                                                     title="{$model.image.title|escape:'html':'UTF-8'}"
                                                     width="{$model.image.width|escape:'html':'UTF-8'}"
                                                     height="{$model.image.height|escape:'html':'UTF-8'}">
                                            {/if}
                                            <h4>{$model.model_name|escape:'html':'UTF-8'}</h4>
                                        </div>
                                        <div class="col-xs-8">
                                            {if ($model.availability>0)}
                                                <select name="rate_durations">
                                                    {foreach $rate_durations as $rate_duration}
                                                        <option value="{$rate_duration['id_roja45_product_rateduration']}">{$rate_duration['name']}</option>
                                                    {/foreach}
                                                </select>
                                                <div class="periods">
                                                {foreach $model.periods as $period}
                                                    <div class="period" data-period="{$period->period}"></div>
                                                {/foreach}
                                                </div>
                                                <div id="available-models-rates" class="col-lg-12 table-responsive">
                                                    <table class="table">
                                                        <thead>
                                                        <tr>
                                                            <th>{l s='Rate' mod='roja45productrental'}</th>
                                                            <th>{l s='Unit Price' mod='roja45productrental'}</th>
                                                            <th>{l s='Quantity' mod='roja45productrental'}</th>
                                                        </tr>
                                                        </thead>
                                                        <tbody>
                                                        {foreach $model.rates as $rate}
                                                            <tr data-id-roja45-product-model="{$model.id_roja45_product_model|escape:'html':'UTF-8'}"
                                                                data-id-roja45-product-rate="{$rate.id_roja45_product_rate|escape:'html':'UTF-8'}"
                                                                data-id-roja45-product-rateduration="{$rate.id_roja45_product_rateduration|escape:'html':'UTF-8'}"
                                                                data-qty-available="{$model.availability|escape:'html':'UTF-8'}"
                                                                data-id-product-attribute="{$model.id_product_attribute|escape:'html':'UTF-8'}">
                                                                <td>{$rate.rate_name|escape:'html':'UTF-8'}</td>
                                                                <td>{displayPrice price={toolsConvertPrice price=$rate.rate}}{if isset($model.has_seasonal_rates) && $model.has_seasonal_rates==1}<sup>*</sup>{/if}</td>
                                                                <td>
                                                                    <input name="quantity" type="number" value="0" min="0" max="{$model.availability}"/>
                                                                </td>
                                                            </tr>
                                                        {/foreach}
                                                        </tbody>
                                                    </table>
                                                </div>
                                            {/if}
                                        </div>
                                    </div>
                                    <div class="panel-footer">
                                        <a class="btn btn-primary btn-add-rental-product-model">{l s='Add' mod='roja45productrental'}</a>
                                    </div>
                                </div>
                            {/foreach}
                        </div>
                    </div>
                    {else}
                    <div class="alert alert-warning">{l s='No models available for your selected dates.' mod='roja45productrental'}</div>
                {/if}
            </div>
        </div>
        <div class="modal-footer">
            <a type="button" class="btn btn-default pull-left"
               data-dismiss="modal">{l s='Close' mod='roja45productrental'}</a>
        </div>
    </div>
</div>
