{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}
<div class="leadin"></div>
<div class="panel kpi-container hidden-print">
    <div class="row">
        {if isset($rental->title)}
            <div class="col-xs-6 col-sm-2 box-stats color1">
                <a href="#roja45_product_rental_form">
                    <div class="kpi-content">
                        <i class="icon-book"></i>
                        <span class="title">{l s='For' mod='roja45productrental'}</span>
                        <span class="value">{$rental->title|escape:"html":"UTF-8"}</span>
                    </div>
                </a>
            </div>
        {/if}
        <div class="col-xs-6 col-sm-2 box-stats color3">
            <div class="kpi-content">
                <i class="icon-calendar-empty"></i>
                <span class="title">{l s='Received' mod='roja45productrental'}</span>
                <span class="value">{if isset($rental)}{dateFormat date=$rental->date_add full=1}{/if}</span>
            </div>
        </div>
        <div class="col-xs-6 col-sm-2 box-stats color4">
            <div class="kpi-content">
                <i class="icon-money"></i>
                {if $display_without_tax}
                    <span class="title">{l s='Total Rental (exc.)' mod='roja45productrental'}</span>
                    <span class="value">{if isset($rental)}{displayPrice price=$total_to_pay currency=$default_currency->id}{/if}</span>
                {else}
                    <span class="title">{l s='Total Rental (inc.)' mod='roja45productrental'}</span>
                    <span class="value">{if isset($rental)}{displayPrice price=$total_to_pay_inc currency=$default_currency->id}{/if}</span>
                {/if}
            </div>
        </div>
        <div class="col-xs-6 col-sm-2 box-stats color4">
            <div class="kpi-content">
                <i class="icon-money"></i>
                {if $display_without_tax}
                    <span class="title">{l s='Total Paid (exc.)' mod='roja45productrental'}</span>
                    <span class="value">{if isset($rental)}{displayPrice price=$total_paid currency=$default_currency->id}{/if}</span>
                {else}
                    <span class="title">{l s='Total Paid (inc.)' mod='roja45productrental'}</span>
                    <span class="value">{if isset($rental)}{displayPrice price=$total_paid_inc currency=$default_currency->id}{/if}</span>
                {/if}
                {if $total_paid_confirmed < $total_paid}
                    <span class="note">({displayPrice price=$total_paid_confirmed currency=$default_currency->id}{l s=' confirmed' mod='roja45productrental'})</span>
                {/if}
            </div>
        </div>
        <div class="col-xs-6 col-sm-2 box-stats color4">
            <div class="kpi-content">
                <i class="icon-money"></i>
                {if $display_without_tax}
                    {if $total_outstanding>=0}
                        <span class="title">{l s='Total Outstanding (exc.)' mod='roja45productrental'}</span>
                        <span class="value">{if isset($rental)}{displayPrice price=$total_outstanding currency=$default_currency->id}{/if}</span>
                    {elseif $total_outstanding<0}
                        <span class="title">{l s='Refund Required (exc.)' mod='roja45productrental'}</span>
                        <span class="value">{if isset($rental)}{displayPrice price=$total_outstanding currency=$default_currency->id}{/if}</span>
                    {/if}
                {else}
                    {if $total_outstanding>=0}
                        <span class="title">{l s='Total Outstanding (inc.)' mod='roja45productrental'}</span>
                        <span class="value">{if isset($rental)}{displayPrice price=$total_outstanding_inc currency=$default_currency->id}{/if}</span>
                    {elseif $total_outstanding<0}
                        <span class="title">{l s='Refund Required (inc.)' mod='roja45productrental'}</span>
                        <span class="value">{if isset($rental)}{displayPrice price=$total_outstanding_inc currency=$default_currency->id}{/if}</span>
                    {/if}
                {/if}
            </div>
        </div>
        <div class="col-xs-6 col-sm-2 box-stats color2">
            <div class="kpi-content">
                <i class="icon-comments"></i>
                <span class="title">{l s='Messages' mod='roja45productrental'}</span>
                <span class="value">{if isset($messages) && is_array($messages)}{count($messages)}{else}0{/if}</span>
            </div>
        </div>
        <div class="col-xs-6 col-sm-2 box-stats color3">
            <div class="kpi-content">
                <i class="icon-calendar-empty"></i>
                <span class="title">{l s='Last Update' mod='roja45productrental'}</span>
                <span class="value">{if isset($rental)}{dateFormat date=$rental->date_upd full=1}{/if}</span>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="panel clearfix">
        <div class="panel-heading">
            <span {if $cancelled}style="color: grey !important;font-style:italic !important;"{/if}>
            <i class="icon-inbox"></i>
                {l s='Summary' mod='roja45productrental'}
                <span class="badge">#{$rental->id_roja45_product_rental|escape:"html":"UTF-8"}</span>{if isset($rental->reference)}<span class="badge">#{$rental->reference|escape:"html":"UTF-8"}</span>{/if}
                <span id="current_status" style="background-color:{$current_status->color|escape:'html':'UTF-8'};" class="badge">{$current_status->status|escape:"html":"UTF-8"}</span>
            </span>
            {if $customer->id && $rental->id_customer}
            <div class="panel-heading-action">
                <div class="btn-group">
                    <a class="btn btn-default btn-lg dropdown-toggle"  data-toggle="dropdown">
                        <span class="caret"></span>
                    </a>
                    <ul class="dropdown-menu pull-right" role="menu" style="">
                        <li>
                            <a class="btn-add-rental"
                               style="font-size:15px;cursor: pointer;position:relative;"
                               title="{l s='Add Rental' mod='roja45productrental'}">
                                {l s='Add Rental' mod='roja45productrental'}
                            </a>
                            {if $rental->id > 0}
                            <a class="btn-process-rental"
                               style="font-size:15px;cursor: pointer;position:relative;"
                               title="{l s='Process Rental' mod='roja45productrental'}">
                                {l s='Process Rental' mod='roja45productrental'}
                            </a>
                            <a class="btn-print" href="javascript:window.print()"
                               style="font-size:15px;cursor: pointer;position:relative;"
                               title="{l s='Print' mod='roja45productrental'}">
                                {l s='Print' mod='roja45productrental'}
                            </a>
                            {/if}
                        </li>
                    </ul>
                </div>
            </div>
            {/if}
        </div>

        {if isset($rental_products) && count($rental_products)}
            <form id="roja45_productrental_form" class="defaultForm form-horizontal" action="{$roja45_productrental_controller|escape:'html':'UTF-8'}&submitAddroja45_product_rental_form=1" method="post" enctype="multipart/form-data" novalidate="">
                <div class="form-horizontal">
                    <input type="hidden" name="ROJA45_PRODUCTRENTAL_RENTAL_ID" value="{$rental->id|escape:"html":"UTF-8"}"/>
                    <div class="row">
                        {if $rental_products|@count gt 1}
                            {assign var='colWidth' value=6}
                        {else}
                            {assign var='colWidth' value=12}
                        {/if}
                        <div class="rental-products-panel col-xs-9">
                            {foreach $rental_products as $rental_product}
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="panel rental-product-panel"
                                             data-id-roja45-product="{$rental_product.id_roja45_product|escape:'htmlall':'UTF-8'}"
                                             data-id-roja45-product-rental-product="{$rental_product.id_roja45_product_rental_product|escape:'htmlall':'UTF-8'}">
                                            <div class="panel-heading">
                                                <a data-toggle="collapse" href="#collapse_rental_product_panel_{$rental_product@index}" class="{if count($rental_products)>1}collapsed{/if}">{if count($rental_products)>1}{else}{/if}</a>
                                                {$rental_product.product->name|escape:'htmlall':'UTF-8'}
                                                <div class="panel-heading-action">
                                                    <div class="btn-group">
                                                        <a class="btn btn-default btn-lg dropdown-toggle"  data-toggle="dropdown">
                                                            <span class="caret"></span>
                                                        </a>
                                                        <ul class="dropdown-menu pull-right" role="menu" style="">
                                                            <li>
                                                                <a class="btn-delete-rental-product"
                                                                   style="font-size:15px;cursor: pointer;position:relative;"
                                                                   title="{l s='Delete' mod='roja45productrental'}">
                                                                    {l s='Delete' mod='roja45productrental'}
                                                                </a>
                                                            </li>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>
                                            <div id="collapse_rental_product_panel_{$rental_product@index}" class="panel-collapse collapse {if count($rental_products)==1}in{/if}">
                                                <div class="panel-body">
                                                    <div class="col-xs-12">
                                                        {foreach $rental_product.models as $key=>$model}
                                                            <div class="rental-model-panel col-xs-12 {if $model.returned}returned {elseif $model.overdue}overdue {elseif $model.return_due}return-due{/if} "
                                                                 data-id-roja45-product-model="{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}"
                                                                 data-id-roja45-product-rental-model="{$model.id_roja45_product_rental_model|escape:'htmlall':'UTF-8'}"
                                                                 data-collection-date="{$model.collection_date|escape:'htmlall':'UTF-8'}"
                                                                 data-return-date="{$model.return_date|escape:'htmlall':'UTF-8'}">
                                                                <div class="row">
                                                                    <div class="col-xs-12">
                                                                        <div class="panel" {if $model.returned}{elseif $model.overdue}style="box-shadow: 0px 0px 0px 5px {$overdue_status->color|escape:'htmlall':'UTF-8'};" {elseif $model.return_due}style="box-shadow: 0px 0px 0px 5px {$return_status->color|escape:'htmlall':'UTF-8'};"{/if}>
                                                                            <div class="panel-heading">
                                                                                <a data-toggle="collapse" href="#collapse_rental_model_panel_{$model@index}" class="{if count($rental_product.models)>1}collapsed{/if}">
                                                                                    <span class="heading">[{$model.model_name|escape:'htmlall':'UTF-8'}]</span><span class="summary">{if $model.returned}{elseif $model.overdue}[{l s='OVERDUE' mod='roja45productrental'}]{/if}{$model.collection_date|escape:'htmlall':'UTF-8'} - {$model.return_date|escape:'htmlall':'UTF-8'} : [{l s='Total (exc.)' mod='roja45productrental'} : {$model.total_formatted|escape:'htmlall':'UTF-8'}] : [{l s='Total Paid(exc.)' mod='roja45productrental'} : {$model.total_paid_formatted|escape:'htmlall':'UTF-8'}]</span>{if $model.returned}<span style="background-color:{$overdue_status->color|escape:'htmlall':'UTF-8'};" class="badge">{l s='Returned' mod='roja45productrental'}</span>{elseif $model.overdue}<span style="background-color:{$overdue_status->color|escape:'htmlall':'UTF-8'};" class="badge">{l s='Overdue' mod='roja45productrental'}</span>{elseif $model.return_due}<span style="background-color:{$return_status->color|escape:'htmlall':'UTF-8'};" class="badge">{l s='Return Due' mod='roja45productrental'}</span>{/if}
                                                                                </a>
                                                                                <div class="panel-heading-action">
                                                                                    <div class="btn-group">
                                                                                        <a class="btn btn-default btn-lg dropdown-toggle"  data-toggle="dropdown">
                                                                                            <span class="caret"></span>
                                                                                        </a>
                                                                                        <ul class="dropdown-menu pull-right" role="menu" style="">
                                                                                            <li>
                                                                                                <a class="btn-return-model"
                                                                                                   style="font-size:15px;cursor: pointer;position:relative;"
                                                                                                   title="{l s='Returned' mod='roja45productrental'}">
                                                                                                    {l s='Returned' mod='roja45productrental'}
                                                                                                </a>
                                                                                            </li>
                                                                                            <li>
                                                                                                <a class="btn-change-dates"
                                                                                                   style="font-size:15px;cursor: pointer;position:relative;"
                                                                                                   title="{l s='Change Dates' mod='roja45productrental'}">
                                                                                                    {l s='Change Dates' mod='roja45productrental'}
                                                                                                </a>
                                                                                            </li>
                                                                                            <li>
                                                                                                <a class="btn-add-rental-model-extra"
                                                                                                   style="font-size:15px;cursor: pointer;position:relative;"
                                                                                                   title="{l s='Add Extra' mod='roja45productrental'}">
                                                                                                    {l s='Add Extra' mod='roja45productrental'}
                                                                                                </a>
                                                                                            </li>
                                                                                            <li>
                                                                                                <a class="btn-delete-rental-product-model"
                                                                                                   style="font-size:15px;cursor: pointer;position:relative;"
                                                                                                   title="{l s='Delete' mod='roja45productrental'}">
                                                                                                    {l s='Delete' mod='roja45productrental'}
                                                                                                </a>
                                                                                            </li>
                                                                                        </ul>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div id="collapse_rental_model_panel_{$model@index}" class="panel-collapse collapse {if count($rental_product.models)==1}in{/if}">
                                                                                <div class="panel-body">
                                                                                    <div class="col-xs-3">
                                                                                        <div class="panel rental-summary">
                                                                                            <div class="panel-heading">
                                                                                                {l s='Summary' mod='roja45productrental'}
                                                                                            </div>
                                                                                            <div class="panel-body">
                                                                                                <div>
                                                                                                    <dt>{l s='Collection' mod='roja45productrental'}</dt>
                                                                                                    <dd>{$model.collection_date|escape:'htmlall':'UTF-8'} - {$model.collection_time|escape:'htmlall':'UTF-8'}</dd>
                                                                                                </div>
                                                                                                <div>
                                                                                                    <dt>{l s='Return' mod='roja45productrental'}</dt>
                                                                                                    <dd>{$model.return_date|escape:'htmlall':'UTF-8'} - {$model.return_time|escape:'htmlall':'UTF-8'}</dd>
                                                                                                </div>
                                                                                                <div>
                                                                                                    <dt>{l s='Total Model (exc.)' mod='roja45productrental'}</dt>
                                                                                                    <dd>{$model.total_formatted|escape:'htmlall':'UTF-8'}</dd>
                                                                                                </div>
                                                                                                <div>
                                                                                                    <dt>{l s='Total Paid (exc.)' mod='roja45productrental'}</dt>
                                                                                                    <dd>{$model.total_paid_formatted|escape:'htmlall':'UTF-8'}</dd>
                                                                                                </div>
                                                                                                <div>
                                                                                                    <dt>{l s='Taxes' mod='roja45productrental'}</dt>
                                                                                                    <dd>{$model.tax_formatted|escape:'htmlall':'UTF-8'}</dd>
                                                                                                </div>
                                                                                                {if $model.damage_deposit>0}
                                                                                                    <div>
                                                                                                        <dt>{l s='Damage Deposit (exc.)' mod='roja45productrental'}</dt>
                                                                                                        <dd>{$model.damage_deposit_formatted|escape:'htmlall':'UTF-8'}</dd>
                                                                                                    </div>
                                                                                                {/if}
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-xs-9">
                                                                                        <div class="col-xs-12">
                                                                                            {include file='./rentalview_modelrental_line.tpl'}
                                                                                        </div>
                                                                                        <div class="col-xs-12">
                                                                                        {include file='./rentalview_modelrental_extras.tpl'}
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        {/foreach}
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            {/foreach}
                        </div>
                        <div class="col-xs-3 hidden-print">
                            <div class="panel">
                                <div class="panel-heading">{l s='Rental Process' mod='roja45productrental'}</div>
                                <ul id="rental-pipeline" class="form-control-static">
                                    {foreach $process as $status}
                                        <li style="background-color:{$status->color|escape:'html':'UTF-8'};">
                                        <span class="label">
                                            {$status->status|escape:"html":"UTF-8"}
                                        </span>
                                        </li>
                                    {/foreach}
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="panel-footer">
                    <div id="roja45_productrental_buttons" class="row">
                        {include file='./rentalview_buttons_all.tpl'}
                    </div>
                </div>
            </form>
        {/if}
    </div>

    {if $rental->id > 0}
        <div id="reponse-selection-panel" class="panel" style="display:none;">
            <div class="panel-heading">
                <i class="icon-eye-close"></i> {l s='Send Customer Message' mod='roja45productrental'}
            </div>
            <div class="panel-body">
                <div class="form-horizontal">
                    <div class="form-group">
                        <label class="control-label col-lg-3">
                            {l s='Select answer' mod='roja45productrental'}
                        </label>
                        <div class="col-lg-5">
                            <select class="form-control" name="select_rental_answer"
                                    id="select_rental_answer">
                                <option value="roja45_productrental_blank"
                                        selected="selected">{l s='Blank' mod='roja45productrental'}</option>
                                {if isset($templates)}
                                    {foreach $templates AS $template}
                                        <option value="{$template.id|escape:'html':'UTF-8'}">{$template.name|escape:"html":"UTF-8"}</option>
                                    {/foreach}
                                {/if}
                            </select>
                        </div>
                        <div class="col-lg-3">
                            <button type="submit" id="loadMessageTemplate" class="btn btn-default">
                                <i class="icon-download"></i>
                                {l s='Load' mod='roja45productrental'}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            <form id="sendMessageForm" method="post" action="{$roja45_productrental_controller|escape:'html':'UTF-8'}" enctype="multipart/form-data" novalidate="">
                <div id="rental-response-panel" class="panel" style="display:none;">
                    <input type="hidden" name="submitSendMessageForm" value="1">
                    <input type="hidden" name="id_roja45_product_rental" value="{$rental->id|escape:"html":"UTF-8"}">
                    <div class="panel-heading">
                        <i class="icon-eye-close"></i> {l s='Review Message' mod='roja45productrental'}
                    </div>
                    <div id="loaded-rental-answer" class="panel-body">
                        <div class="form-horizontal">
                            <div class="form-group">
                            <textarea id="final-rental-response"
                                      name="response_content"
                                      class="rte autoload_rte"></textarea>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer">
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit" id="cancelSendMessageToCustomer"
                                        class="btn btn-default btn-lg pull-left" disabled="disabled">
                                    <i class="icon-remove"></i>
                                    {l s='Cancel' mod='roja45productrental'}
                                </button>
                                <button type="submit"
                                        id="sendMessageToCustomer"
                                        class="btn btn-default btn-lg pull-right"
                                        disabled="disabled">
                                    <i class="icon-save"></i>
                                    {l s='Send' mod='roja45productrental'}
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    {/if}
</div>
<div class="row">
    <!-- Left column -->
    <div class="col-lg-6">
        {if $rental->id > 0}
        {if isset($payments) && count($payments)}
            <ps-panel icon="icon-eye-close" header="{l s='Payments' mod='roja45productrental'}">
                <ps-alert-hint>{l s='All payments made by a customer for a reservtion will be displayed here. Only accepted payments will be used to determine balances outstanding.' mod='roja45productrental'}</ps-alert-hint>
                {if !$prereserved && !$confirmed}<ps-alert-warn>{l s='You need to pre-reserve or confirm the rental before requesting payments or creating orders.' mod='roja45productrental'}</ps-alert-warn>{/if}
                <div class="panel panel-total" {if isset($payments) && !$payments} style="display:none;"{/if}>
                    <div id="payments_table">
                        {include file='./rentalview_payments_table.tpl'}
                    </div>
                </div>
            </ps-panel>
        {/if}
        {if count($payment_types)>0 && isset($rental_products) && count($rental_products)}
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-eye-close"></i> {l s='Create Payment' mod='roja45productrental'}</span>
            </div>
            <table class="table">
                <thead>
                <tr>
                    <th><span class="title_box ">{l s='Amount To Request (exc.)' mod='roja45productrental'}</span></th>
                    <th><span class="title_box ">{l s='Payment Type' mod='roja45productrental'}</span></th>
                    <th><span class="title_box ">{l s='Due Date' mod='roja45productrental'}</span></th>
                    <th><span class="title_box ">{l s='Note' mod='roja45productrental'}</span></th>
                    <th></th>
                </tr>
                </thead>
                <tbody>
                <tr class="payment_request_row" data-id-roja45-property-reservation="{$rental->id|escape:"html":"UTF-8"}">
                    <td>
                        <div class="input-group">
                            <span class="input-group-addon">{$default_currency->sign|escape:"html":"UTF-8"}</span>
                            <input type="text"
                                   name="amount_to_request"
                                   id="amount_to_request"
                                   value="0"/>
                        </div>
                    </td>
                    <td>
                        <select name="create_payment_paymenttype" id="create_payment_paymenttype">
                            {foreach $payment_types as $payment_type}
                                <option value="{$payment_type.id_roja45_product_payment_type|escape:'html':'UTF-8'}">{$payment_type.name|escape:'html':'UTF-8'}</option>
                            {/foreach}
                        </select>
                    </td>
                    <td>
                        <div class="input-group">
                            <input name="create_payment_due_date"
                                   id="create_payment_due_date"
                                   type="text"
                                   class="form-control datepicker"
                                   value=""
                                   placeholder="{$roja45_productrental_dateformat|escape:'html':'UTF-8'}"/>
                            <span class="input-group-addon">
                                <i class="icon-calendar"></i>
                            </span>
                        </div>
                    </td>
                    <td>
                        <input name="create_payment_note"
                               id="create_payment_note"
                               type="text"
                               class="form-control"/>
                    </td>
                    <td>
                        <button type="button" class="btn btn-default btn-sml createPayment">
                            <i class="icon-edit"></i>{l s='Create' mod='roja45productrental'}
                        </button>
                    </td>
                </tr>
                <tr>
                    <td><a href="#" class="select-full-amount">{l s='select full amount' mod='roja45productrental'}</a></td>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td></td>
                </tr>
                </tbody>
            </table>
        </div>
        {/if}
        {/if}
        {if ($rental->id_customer && $customer->id)}
        <ps-panel icon="icon-eye-close" header="{l s='Status' mod='roja45productrental'}" class="hidden-print">
            <form class="form-horizontal">
                <ps-select label="{l s='Select Status' mod='roja45productrental'}" name="updateStatus" chosen='true'>
                    {foreach $statuses as $status}
                        <option value="{$status.id_roja45_product_rental_status|escape:'html':'UTF-8'}" {if $status.id_roja45_product_rental_status==$rental->id_roja45_product_rental_status}selected="selected"{/if}>{$status.status|escape:'html':'UTF-8'}</option>
                    {/foreach}
                </ps-select>
                <ps-panel-footer>
                    <ps-panel-footer-link title="{l s='Update' mod='roja45productrental'}" icon="icon-save" href="#" direction="right" name="submitStatusUpdate"></ps-panel-footer-link>
                </ps-panel-footer>
            </form>
        </ps-panel>
        {/if}
    </div>

    <div class="col-lg-6">
        <div class="panel">
            {if $customer->id && $rental->id_customer}
                <div class="panel-heading">
                    <i class="icon-user"></i>
                    {l s='Contact Details' mod='roja45productrental'}
                    <span class="badge">
                        <a href="?tab=AdminCustomers&amp;id_customer={$customer->id|escape:'html':'UTF-8'}&amp;viewcustomer&amp;token={getAdminToken tab='AdminCustomers'}" target="_blank">
                            {if Configuration::get('PS_B2B_ENABLE')}{$customer->company|escape:'html':'UTF-8'} - {/if}
                            {$gender->name|escape:'html':'UTF-8'}
                            {$customer->firstname|escape:'html':'UTF-8'}
                            {$customer->lastname|escape:'html':'UTF-8'}
                        </a>
                    </span>
                </div>
                <div class="row">
                    <div class="col-xs-6">
                        <dl class="well list-detail">
                            <dt>{l s='Email' mod='roja45productrental'}</dt>
                            <dd><a href="mailto:{$customer->email|escape:'html':'UTF-8'}"><i class="icon-envelope-o"></i> {$customer->email|escape:'html':'UTF-8'}</a></dd>
                            <dt>{l s='Account registered' mod='roja45productrental'}</dt>
                            <dd class="text-muted"><i class="icon-calendar-o"></i> {dateFormat date=$customer->date_add full=false}</dd>
                            <dt>{l s='Valid orders placed' mod='roja45productrental'}</dt>
                            <dd><span class="badge">{$customerStats['nb_orders']|intval|escape:'html':'UTF-8'}</span></dd>
                            <dt>{l s='Total spent since registration' mod='roja45productrental'}</dt>
                            <dd><span class="badge badge-success">{displayPrice price=Tools::ps_round(Tools::convertPrice($customerStats['total_orders'], $default_currency), 2) currency=$default_currency->id}</span></dd>
                            {if Configuration::get('PS_B2B_ENABLE')}
                                <dt>{l s='Siret' mod='roja45productrental'}</dt>
                                <dd>{$customer->siret|escape:'html':'UTF-8'}</dd>
                                <dt>{l s='APE' mod='roja45productrental'}</dt>
                                <dd>{$customer->ape|escape:'html':'UTF-8'}</dd>
                            {/if}
                        </dl>
                    </div>
                    <div class="col-xs-6">
                        {foreach $customer_addresses as $address}
                            <dl class="well list-detail">
                                <dt>{l s='Address' mod='roja45productrental'} {if isset($address.alias)}: {$address.alias}{/if}</dt>
                                <dd>{if !empty($address['address1'])}{$address['address1']|escape:'html':'UTF-8'},{/if}{if !empty($address['city'])}{$address['city']|escape:'html':'UTF-8'}{/if}{if !empty($address['State:name'])}, {$address['State:name']|escape:'html':'UTF-8'}{/if}</dd>
                                {if !empty($address['postcode'])}
                                    <dt>{l s='Post Code' mod='roja45productrental'}</dt>
                                    <dd>{$address['postcode']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($address['Country:name'])}
                                    <dt>{l s='Country' mod='roja45productrental'}</dt>
                                    <dd>{$address['Country:name']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($address['phone'])}
                                    <dt>{l s='Phone' mod='roja45productrental'}</dt>
                                    <dd>{$address['phone']|escape:'html':'UTF-8'}</dd>
                                {/if}
                            </dl>
                        {/foreach}
                    </div>
                </div>
            {elseif ($rental->id_customer && !$customer->id)}
                <div class="panel-heading">
                    <i class="icon-user"></i>
                    {l s='Principal Contact' mod='roja45productrental'}
                </div>
                <div class="alert alert-warning">{l s='This customer no longer appears to exists, is this rental sill valid?' mod='roja45productrental'}</div>
            {elseif !$rental->id_customer}
                <div class="panel-heading">
                    <i class="icon-user"></i>
                    {l s='Contact Details' mod='roja45productrental'}
                </div>
                <div class="alert alert-warning">{l s='Please select, or create, a customer account for this rental.' mod='roja45productrental'}</div>
                <div class="row">
                    <div class="col-xs-6">
                        <form id="create_contact_form" class="row contact-form">
                            <dl class="list-detail">
                                <dt>{l s='Email' mod='roja45productrental'}</dt>
                                <dd>
                                    <input type="text"
                                           name="email"
                                           class="form-control"
                                           value=""
                                           style="display: inline-block;width:80%;vertical-align: top;"/><button type="button"
                                                                class="btn btn-default btn-sml btn-find-account"
                                                                style="display: inline-block;width:20%;vertical-align: top;">
                                        {l s='Find' mod='roja45productrental'}
                                    </button>
                                </dd>
                                <dt>{l s='First Name' mod='roja45productrental'}</dt>
                                <dd><input type="text" name="first_name" class="form-control" value=""/></dd>
                                <dt>{l s='Last Name' mod='roja45productrental'}</dt>
                                <dd><input type="text" name="last_name" class="form-control" value=""/></dd>
                            </dl>
                            <button type="button" class="btn btn-default btn-sml btn-create-account">
                                {l s='Create Account' mod='roja45productrental'}
                            </button>
                        </form>
                    </div>
                </div>
            {else}
                <div class="panel-heading">
                    <i class="icon-user"></i>
                    {l s='Principal Contact' mod='roja45productrental'}
                </div>
                <div class="alert alert-warning">{l s='No customer account available, select the option above to create a system account for the principal rental contact.' mod='roja45productrental'}</div>
            {/if}
        </div>
        {if isset($delivery_address) || isset($collection_address)}
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-user"></i>
                {l s='Delivery/Collection' mod='roja45productrental'}
            </div>
            <div class="row">
                <div class="col-xs-12">
                    <div class="row">
                        {if isset($delivery_address)}
                        <div class="col-xs-6">
                            <dl class="well list-detail">
                                <dt>{l s='Delivery Address' mod='roja45productrental'}</dt>
                                <dt>{l s='Address' mod='roja45productrental'} {if isset($delivery_address['alias'])}: {$delivery_address['alias']}{/if}</dt>
                                <dd>{if !empty($delivery_address['address1'])}{$delivery_address['address1']|escape:'html':'UTF-8'},{/if}{if !empty($delivery_address['city'])}{$delivery_address['city']|escape:'html':'UTF-8'}{/if}{if !empty($delivery_address['State:name'])}, {$delivery_address['State:name']|escape:'html':'UTF-8'}{/if}</dd>
                                {if !empty($delivery_address['postcode'])}
                                    <dt>{l s='Post Code' mod='roja45productrental'}</dt>
                                    <dd>{$delivery_address['postcode']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($delivery_address['Country:name'])}
                                    <dt>{l s='Country' mod='roja45productrental'}</dt>
                                    <dd>{$delivery_address['Country:name']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($delivery_address['phone'])}
                                    <dt>{l s='Phone' mod='roja45productrental'}</dt>
                                    <dd>{$delivery_address['phone']|escape:'html':'UTF-8'}</dd>
                                {/if}
                            </dl>
                        </div>
                        {/if}
                        {if isset($collection_address)}
                        <div class="col-xs-6">
                            <dl class="well list-detail">
                                <dt>{l s='Collection Address' mod='roja45productrental'}</dt>
                                <dt>{l s='Address' mod='roja45productrental'} {if isset($collection_address['alias'])}: {$collection_address['alias']}{/if}</dt>
                                <dd>{if !empty($collection_address['address1'])}{$collection_address['address1']|escape:'html':'UTF-8'},{/if}{if !empty($collection_address['city'])}{$collection_address['city']|escape:'html':'UTF-8'}{/if}{if !empty($collection_address['State:name'])}, {$collection_address['State:name']|escape:'html':'UTF-8'}{/if}</dd>
                                {if !empty($collection_address['postcode'])}
                                    <dt>{l s='Post Code' mod='roja45productrental'}</dt>
                                    <dd>{$collection_address['postcode']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($collection_address['Country:name'])}
                                    <dt>{l s='Country' mod='roja45productrental'}</dt>
                                    <dd>{$collection_address['Country:name']|escape:'html':'UTF-8'}</dd>
                                {/if}
                                {if !empty($collection_address['phone'])}
                                    <dt>{l s='Phone' mod='roja45productrental'}</dt>
                                    <dd>{$collection_address['phone']|escape:'html':'UTF-8'}</dd>
                                {/if}
                            </dl>
                        </div>
                        {/if}
                    </div>
                </div>
            </div>
        </div>
        {/if}
        {if $rental->id > 0}
            <div class="panel">
                <div class="panel-heading">
                    <i class="icon-eye-close"></i> {l s='Customer Notes' mod='roja45productrental'} <span class="badge">{if isset($notes) && $notes}{count($notes)|escape:"html":"UTF-8"}{else}0{/if}</span>
                </div>
                <div class="alert alert-info">{l s='Notes will be displayed to all employees but not to customers.' mod='roja45productrental'}</div>
                <div class="panel panel-total" {if isset($notes) && !$notes} style="display:none;"{/if}>
                    <div id="notes_table">
                        {include file='./rentalview_notes_table.tpl'}
                    </div>
                </div>
                <div class="panel panel-total">
                    <div class="panel-heading">
                        {l s='Add a private note' mod='roja45productrental'}
                    </div>
                    <form id="customer_note" class="form-horizontal" method="post" action="{$roja45_productrental_controller|escape:'html':'UTF-8'}">
                        <div class="form-group">
                            <div class="col-lg-12">
                                <textarea name="note"
                                          id="noteContent"
                                          class=" {if $editing_disabled}disabled{/if}"
                                          onkeyup="$('#submitRentalNote').removeAttr('disabled');">{if isset($customer_note)}{$customer_note|escape:"html":"UTF-8"}{/if}</textarea>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-lg-12">
                                <button type="submit"
                                        id="submitRentalNote"
                                        class="btn btn-default btn-lg pull-right {if $editing_disabled}disabled{/if}"
                                        disabled="disabled">
                                    <i class="icon-save"></i>
                                    {l s='Save' mod='roja45productrental'}
                                </button>
                            </div>
                        </div>
                        <span id="note_feedback"></span>
                    </form>
                </div>
            </div>
        {/if}
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-envelope"></i> {l s='Last Message' mod='roja45productrental'}
            </div>
            <table class="table">
                {if isset($last_message)}
                    <div class="message-item" style="height:500px;overflow-y:scroll;">
                        <div class="message-avatar">
                            <div class="avatar-md">
                                <i class="icon-user icon-3x"></i>
                            </div>
                        </div>
                        <div class="message-body">
                            <h4 class="message-item-heading">
                                {$last_message.customer_name|escape:"html":"UTF-8"}
                                &nbsp;({$last_message.email|escape:"html":"UTF-8"})
                            </h4>
                            <span class="message-date">&nbsp;<i class="icon-calendar"></i> - 07/13/2015 - <i
                                        class="icon-time"></i> 13:31</span>
                            <p class="message-item-text">
                                {$last_message.message|escape:'html':'UTF-8'|nl2br}
                            </p>
                        </div>
                    </div>
                {/if}
            </table>
        </div>
        <div class="panel">
            <div class="panel-heading">
                <i class="icon-envelope"></i> {l s='Message History' mod='roja45productrental'} <span
                        class="badge">{if isset($messages) && is_array($messages)}{count($messages)|escape:"html":"UTF-8"}{else}0{/if}</span>
            </div>
            {if isset($messages) && is_array($messages)}
                <table class="table">
                    <thead>
                    <th><span class="title_box">{l s='Received' mod='roja45productrental'}</span></th>
                    <th><span class="title_box">{l s='Message' mod='roja45productrental'}</span></th>
                    <th></th>
                    </thead>
                    {foreach $messages AS $message}
                        <tr>
                            <td>{$message['date_add']|escape:'html':'UTF-8'}</td>
                            <td>
                                <a href="index.php?tab=AdminCustomerThreads&amp;id_customer_thread={$message.id_customer_thread|escape:"html":"UTF-8"}&amp;viewcustomer_thread&amp;token={getAdminToken tab='AdminCustomerThreads'}">
                                    {$message['message']|truncate:100|escape:"html":"UTF-8"}...
                                </a>
                            </td>
                            <td>
                                <a href="#" class="delete-customer-message"
                                   onclick="{literal}if (confirm('Delete selected item?')){return true;}else{event.stopPropagation(); event.preventDefault();}{/literal}"
                                   title="{l s='Delete' mod='roja45productrental'}" class="delete">
                                    <i class="icon-trash"></i>
                                </a>
                            </td>
                        </tr>
                    {/foreach}
                </table>
            {elseif isset($customer)}
                <p class="text-muted text-center">
                    {l s='%1$s %2$s has never contacted you' sprintf=[$customer->firstname, $customer->lastname] mod='roja45productrental'}
                </p>
            {/if}
        </div>
    </div>
</div>