{*
* 2016 ROJA45.COM
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45 <support@roja45.com>
*  @copyright  		2016 roja45.com
*}
<div class="panel rental-model-extras">
    <div class="panel-heading">
        {l s='Extras' mod='roja45productrental'}
    </div>

    <table class="table">
        <thead>
        <tr>
            <th><span class="title_box ">{l s='Extra' mod='roja45productrental'}</span></th>
            <th><span class="title_box ">{l s='Type' mod='roja45productrental'}</span></th>
            <th><span class="title_box ">{l s='Qty' mod='roja45productrental'}</span></th>
            <th><span class="title_box ">{l s='Price (exc.)' mod='roja45productrental'}</span></th>
            <th><span class="title_box ">{l s='Total (exc.)' mod='roja45productrental'}</span></th>
            {if !$display_without_tax}
                <th><span class="title_box ">{l s='Tax' mod='roja45productrental'}</span></th>
            {/if}
            <th class="edit_extra"></th>
        </tr>
        </thead>
        <tbody>
        {if isset($model.extras)}
            {foreach $model.extras as $extra}
                <tr class="extra-row"
                    data-id-product-extra="{$extra.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                    data-id-product-rental-model-extra="{$extra.id_roja45_product_rental_extra|escape:'htmlall':'UTF-8'}">
                    <td class="extra_name">
                        {$extra.name|escape:'htmlall':'UTF-8'}
                    </td>
                    <td class="extra_rate_name">
                        {$extra.rate_name|escape:'htmlall':'UTF-8'}
                    </td>
                    <td class="extra_qty">
                        <span class="fixed-width-xs quantity_show">{$extra.qty|escape:'html':'UTF-8'}</span>
                        <span class="extra_qty_edit" style="display:none;">
                            <input type="number" name="extra_qty" class="form-control fixed-width-xs edit_extra_qty" value="{$extra.qty|escape:'html':'UTF-8'}"/>
                        </span>
                    </td>
                    <td>
                        <span class="rate_show">
                            {displayPrice price=Tools::ps_round(Tools::convertPrice($extra.rate, $default_currency), 2) currency=$default_currency->id}
                        </span>
                    </td>
                    <td>
                        <span class="rate_show">
                            {displayPrice price=Tools::ps_round(Tools::convertPrice($extra.total, $default_currency), 2) currency=$default_currency->id}
                        </span>
                    </td>
                    <td>
                        {if !$display_without_tax}
                        <span class="rate_show">
                        {$extra.tax_formatted}
                        </span>
                        {/if}
                    </td>
                    <td class="rate_action text-right">
                        <div class="btn-group">
                            <a class="btn btn-default btn-delete-extra {if $editing_disabled}disabled{/if}" title="{l s='Delete Extra' mod='roja45productrental'}">
                                <i class="icon-trash"></i>
                            </a>
                        </div>
                    </td>
                </tr>
            {/foreach}
        {/if}
        </tbody>
    </table>
</div>

