{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div class="table-responsive">
    <table class="table">
        <thead>
        <tr>
            <th class="pointer text-center"><span class="title_box ">{l s='Type' mod='roja45productrental'}</span></th>
            <th class="pointer text-center"><span class="title_box ">{l s='Due' mod='roja45productrental'}</span></th>
            <th class="pointer text-center"><span class="title_box ">{l s='Received' mod='roja45productrental'}</span></th>
            <th class="pointer text-center"><span class="title_box ">{l s='Amount (exc.)' mod='roja45productrental'}</span></th>
            <th class="pointer fixed-width-sm text-center"><span class="title_box ">{l s='Requested' mod='roja45productrental'}</span></th>
            <th class="pointer fixed-width-sm text-center"><span class="title_box ">{l s='Paid' mod='roja45productrental'}</span></th>
            <th class="pointer fixed-width-sm text-center"><span class="title_box ">{l s='Confirmed' mod='roja45productrental'}</span></th>
            <th class="pointer text-center"></th>
            <th class="pointer text-center"></th>
        </tr>
        </thead>
        <tbody>
        {foreach $payments as $payment}
            <tr class="payment_row"
                data-id-payment="{$payment['id_roja45_product_rental_payment']|escape:"html":"UTF-8"}"
                data-payment-total="{$payment['total']|escape:"html":"UTF-8"}"
                data-payment-total-currency="{Tools::convertPrice($payment['total'], $default_currency)}">
                <td class="pointer text-center">
                    {$payment['type']|escape:"html":"UTF-8"}
                </td>
                <td class="pointer text-center">
                    {dateFormat date=$payment['date_due'] full=false}
                </td>
                <td class="pointer text-center">
                    {dateFormat date=$payment['date_paid'] full=false}
                </td>
                <td class="pointer text-center">
                    {if isset($payment['total'])}{displayPrice price=$payment['total'] currency=$default_currency->id}{/if}
                </td>
                <td class="pointer fixed-width-sm text-center">
                    {if (!empty($payment['requested']) && $payment['requested']==1)}
                        <span class="label color_field" style="color:#06c000">{$payment['number_requests']}</span>
                    {else}
                        <span class="label color_field" style="color:#ef4444"><i class="icon-remove"></i></span>
                    {/if}
                </td>
                <td class="pointer fixed-width-sm text-center">
                    <a class="list-action-enable ajax_table_link update-payment-received-link {if ($payment['completed']==0)}action-disabled{else}action-enabled{/if}"
                       href="#"
                       data-action="updatePaymentReceivedStatus">
                        {if (!empty($payment['paid']) && $payment['paid']==1)}
                            <i class="icon-check {if ($payment['paid']==0)}hidden{/if}" style="color:#06c000"></i>
                        {else}
                            <i class="icon-remove {if ($payment['paid']==1)}hidden{/if}" style="color:#ef4444"></i>
                        {/if}
                    </a>
                </td>
                <td class="pointer fixed-width-sm text-center">
                    {if (!empty($payment['paid']))}
                    <a class="list-action-enable ajax_table_link update-confirm-payment-link {if ($payment['completed']==0)}action-disabled{else}action-enabled{/if}"
                       href="#"
                       data-action="updatePaymentConfirmedStatus">
                        {if (!empty($payment['confirmed']) && $payment['confirmed']==1)}
                        <i class="icon-check {if ($payment['confirmed']==0)}hidden{/if}" style="color:#06c000"></i>
                        {else}
                        <i class="icon-remove {if ($payment['confirmed']==1)}hidden{/if}" style="color:#ef4444"></i>
                        {/if}
                    </a>
                    {else}
                        <span class="label"><i class="icon-remove" style="color:#bebcbc"></i></span>
                    {/if}
                </td>
                <td class="pointer text-center">
                    {if (empty($payment['paid']))}
                        <a class="btn btn-default request_payment_link {if !$prereserved && !$confirmed}disabled{/if}" title="{l s='Request this payment' mod='roja45productrental'}">
                            <i class="icon-arrow-right"></i>
                        </a>
                        <a class="btn btn-default create_order_link {if !$prereserved && !$confirmed}disabled{/if}" title="{l s='Create customer order' mod='roja45productrental'}">
                            <i class="icon-credit-card"></i>
                        </a>
                    {elseif (!empty($payment['paid']) && $payment['confirmed']==0)}
                        <a class="btn btn-default request_payment_link" title="{l s='Re-request this payment' mod='roja45productrental'}">
                            <i class="icon-refresh"></i>
                        </a>
                    {else}
                    {/if}
                    {if !empty($payment['reference'])}
                        <a class="btn btn-default view_payment_order" href="{$payment['link']|escape:"html":"UTF-8"}" target="_blank" title="{l s='View order' mod='roja45productrental'}">
                            <i class="icon-eye"></i>
                        </a>
                    {/if}
                    {if ($payment['completed']==0)}
                        <a class="btn btn-default delete_payment_link" title="{l s='Delete this payment' mod='roja45productrental'}">
                            <i class="icon-trash"></i>
                        </a>
                    {/if}
                </td>
                <td class="pointer text-center">
                    {if ($payment['id_order'])}
                    <a target="_blank" href="{$roja45_productrental_controller|escape:'html':'UTF-8'}&action=downloadPaymentPDF&id_roja45_product_rental={$rental->id|escape:'html':'UTF-8'}&id_roja45_product_rental_payment={$payment['id_roja45_product_rental_payment']|escape:'html':'UTF-8'}" class="btn btn-default download_payment_pdf" title="{l s='Download Invoice' mod='roja45productrental'}">
                        <i class="icon-file-text"></i>
                    </a>
                    {/if}
                </td>
            </tr>
        {/foreach}
        </tbody>
    </table>
</div>
<div id="note-detail-div"></div>