{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file='page.tpl'}

{block name='page_content_container'}

<div class="row">
    <div id="roja45_rental_product" class="roja45-rental-product roja45-rental-product-17 col-lg-12">
        <form id="roja45productrental_reserve_form"
              method="post"
              action="{$roja45_productrental_controller}">
            <input type="hidden"
                   name="ROJA45_PRODUCTRENTAL_ID"
                   value="{$ROJA45_PRODUCTRENTAL_ID}"/>
            <input type="hidden" name="ROJA45_PRODUCTRENTAL_REQUEST" value=""/>
            <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATE_DURATION" value="{$ROJA45_PRODUCTRENTAL_RATE_DURATION}">
            <input type="hidden" name="ROJA45_PRODUCTRENTAL_MINIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MINIMUM_DURATION}">
            <input type="hidden" name="ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION}">
            <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATEPERIOD" value="{$roja45_productrental_rateperiods[$default_id].id_rate_period|escape:'html':'UTF-8'}"/>
            <div class="col-md-12">
                <div class="roja45productrental-search-bar">
                    <h3>{l s='Search' mod='roja45productrental'}</h3>
                    <span class="cross" title="{l s='Close window' mod='roja45productrental'}"></span>
                    <div class="row row-40">
                        <div class="form-field {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}col-md-7{else}col-md-12{/if}">
                            <label class="label">
                                <span>{l s='Collection Date' mod='roja45productrental'}</span>
                            </label>
                            <div class="input-group">
                                <input name="ROJA45_PRODUCTRENTAL_COLLECTION_DATE"
                                       type="text"
                                       class="form-control datepicker required"
                                       placeholder="{$roja45_productrental_dateformat}"
                                       autocomplete="off"
                                       required="required"
                                       {if !empty($ROJA45_PRODUCTRENTAL_COLLECTION_DATE)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_DATE|escape:'htmlall':'UTF-8'}"{/if}
                                       required/>
                                <span class="input-group-addon"><svg class="svgic svgic-calendar-full"><use xlink:href="#si-calendar-full"></use></svg></span>
                            </div>
                        </div>
                        {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
                            <div class="form-field col-md-5">
                                <label class="label">
                                    <span>{l s='Time' mod='roja45productrental'}</span>
                                </label>
                                <div class="input-group">
                                    <input name="ROJA45_PRODUCTRENTAL_COLLECTION_TIME"
                                           type="text"
                                           class="form-control timepicker"
                                           placeholder="{$roja45_productrental_timeformat}"
                                           autocomplete="off"
                                           {if isset($ROJA45_PRODUCTRENTAL_COLLECTION_TIME)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                                    <span class="input-group-addon"><i class="material-icons">access_time</i></span>
                                </div>
                            </div>
                        {/if}
                    </div>
                    <div class="row row-40">
                        <div class="form-field {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}col-md-7{else}col-md-12{/if}">
                            <label class="label">
                                <span>{l s='Return Date' mod='roja45productrental'}</span>
                            </label>
                            <div class="input-group">
                                <input name="ROJA45_PRODUCTRENTAL_RETURN_DATE"
                                       type="text"
                                       class="form-control datepicker"
                                       placeholder="{$roja45_productrental_dateformat}"
                                       autocomplete="off"
                                       required="required"
                                       {if isset($ROJA45_PRODUCTRENTAL_RETURN_DATE)}value="{$ROJA45_PRODUCTRENTAL_RETURN_DATE|escape:'htmlall':'UTF-8'}"{/if}/>
                                <span class="input-group-addon"><svg class="svgic svgic-calendar-full"><use xlink:href="#si-calendar-full"></use></svg></span>
                            </div>
                        </div>
                        {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
                            <div class="form-field col-md-5">
                                <label class="label">
                                    <span>{l s='Time' mod='roja45productrental'}</span>
                                </label>
                                <div class="input-group">
                                    <input name="ROJA45_PRODUCTRENTAL_RETURN_TIME"
                                           type="text"
                                           class="form-control timepicker"
                                           placeholder="{$roja45_productrental_timeformat}"
                                           autocomplete="off"
                                           {if isset($ROJA45_PRODUCTRENTAL_RETURN_TIME)}value="{$ROJA45_PRODUCTRENTAL_RETURN_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                                    <span class="input-group-addon"><i class="material-icons">access_time</i></span>
                                </div>
                            </div>
                        {/if}
                    </div>
                    <div class="row row-20">
                        <div class="form-field col-md-6 product-quantity">
                            <label class="label">
                                <span>{l s='Quantity' mod='roja45productrental'}</span>
                            </label>
                            <input type="text" name="qty" id="ROJA45_PRODUCTRENTAL_QTY" value="{if isset($qty)}{$qty|escape:'htmlall':'UTF-8'}{else}1{/if}" class="rental_quantity_wanted input-group form-control" min="1" max="{$total_availability}" aria-label="Quantity">
                        </div>
                        <div class="form-field col-md-6">
                            <label class="label">&nbsp;</label>
                            <button type="submit"
                                    name="getAvailability"
                                    value="1"
                                    class="btn btn-primary btn-productrental btn-search float-md-right">
                                <span>{l s='Update' mod='roja45productrental'}</span>
                            </button>
                        </div>
                    </div>
                </div>
                <div  class="roja45productrental-form-messages collection" style="display: none;">
                    <h3>{l s='Store closed on selected rental start date.' mod='roja45productrental'}</h3>
                    <p class="collection">{l s='Your selected rental start date is when the store is closed.  Please collect your rental at the close of business on the previous open day.' mod='roja45productrental'}</p>
                </div>
                <div class="roja45productrental-form-messages return" style="display: none;">
                    <h3>{l s='Store closed on selected rental end date.' mod='roja45productrental'}</h3>
                    <p class="return">{l s='You have selected a date for return of your rental when the store is closed.  For returns, please return the item at the start of business on the following open day.' mod='roja45productrental'}</p>
                </div>
                {if isset($errors) && $errors}
                <section id="roja45_rental_messages" class="page-content">
                    <div class="row">

                        <div class="rental-messages col-lg-12">

                            <div class="alert alert-danger">
                                <p>{if $errors|@count > 1}{l s='There are %d errors' sprintf=[$errors|@count] mod='roja45productrental'}{else}{l s='There is %d error' sprintf=[$errors|@count] mod='roja45productrental'}{/if}</p>
                                <ol>
                                    {foreach $errors as $error}
                                        <li>{$error}</li>
                                    {/foreach}
                                </ol>
                            </div>


                        </div>

                    </div>
                </section>
                {/if}
            </div>
            {if $rates_available>0}
                <div class="right-column totals-scroll-anchor col-lg-4 col-md-12">
                    <div class="totals-scroll-content">
                        <h4 class="title">{l s='Rental Summary' mod='roja45productrental'}</h4>
                        <section class="card rental-totals-content">
                            <section id="rental_totals" class="">
                                <div class="rental-totals-container">
                                    {include file="module:roja45productrental/views/templates/front/PS17_booking-page-totals.tpl"}
                                </div>
                                <hr class="separator">
                                <div class="card-block">
                                    <button type="submit"
                                            class="{if !$rental_valid}disabled{/if} btn btn-default btn-productrental btn-productrental-selectextras no-print roja45-page-loading"
                                            style="{if $roja45_productrental_hasextras}display: block;{else}display: none;{/if}">
                                        <span>{l s='Select Extras' mod='roja45productrental'}</span>
                                    </button>
                                    <button type="submit"
                                            class="{if !$rental_valid}disabled{/if} btn btn-default btn-productrental btn-productrental-reserve no-print roja45-page-loading"
                                            {if $roja45_productrental_hasextras}style="display: none;"{/if}>
                                        <span>{l s='Continue' mod='roja45productrental'}</span>
                                    </button>
                                </div>
                                <div id="rental_totals_updating">
                                    <div class="modal-wait-container">
                                        <i class="material-icons spin">sync</i>
                                        <h4>{l s='Updating prices..' mod='roja45productrental'}</h4>
                                    </div>
                                </div>
                            </section>
                        </section>


                    </div>
                </div>
            <div class="left-column col-lg-8 col-md-12">

                <section id="rental_summary" class="page-content rental-summary-container">
                    <div class="left-block content">
                        <div class="row">
                            <div class="col-xs-12 col-lg-5">
                                <div class="images-container">
                                    <img class="img-fluid"
                                         src="{$product->cover_image.src}"
                                         alt="{$product->cover_image.title}"
                                         title="{$product->cover_image.title}"
                                         width="{$product->cover_image.width}"
                                         height="{$product->cover_image.height}">
                                </div>
                            </div>
                            <div class="col-xs-12 col-lg-7">
                                <div class="row">
                                    <div class="rental-summary-product-details-container">
                                        <h3><a href="{$roja45_product_url}">{$product->name}</a></h3>
                                        {$product->description_short nofilter}
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>


                <section id="roja45productrental_available_models" class="hidden">
                    <div class="content">
                        <div class="row">
                            {hook h="displayRoja45ProductRentalBookingHeader" rental_product=$rental_product}
                            <div id="available_models_container" class="available-models-container col-lg-12">
                                {foreach $models as $model}
                                    <article class="ajax-block-product-rental-model rental-item page-content {if ($model.availability<=0)}unavailable{/if} {if isset($selected_rate) && isset($selected_rate[$model.id_roja45_product_model]) && $model.availability>0}has-quantity{/if}"
                                             data-qty-available="{if $model.availability> 0}{$model.availability}{else}0{/if}"
                                             data-id-roja45-product-model="{$model.id_roja45_product_model}"
                                             data-id-product-attribute="{$model.id_product_attribute}">
                                        <div class="row">
                                            <div class="col-12 col-md-4">
                                                <div class="col-8 offset-2 offset-md-0 col-md-12">
                                                    {if isset($model.image)}
                                                        <img class="img-fluid"
                                                             src="{$model.image.src}"
                                                             alt="{$model.image.title}"
                                                             title="{$model.image.title}"
                                                             width="{$model.image.width}"
                                                             height="{$model.image.height}">
                                                    {/if}
                                                </div>
                                            </div>
                                            <div class="col-4 col-sm-5 col-md-4">
                                                <h3 class="title">{$product->name}: {$model.model_name}</h3>
                                                {if ($model.availability<=0)}
                                                    <p class="warning-message sold-out">{l s='Out Of Stock' mod='roja45productrental'}</p>
                                                {elseif ($model.availability==1)}
                                                    <p class="warning-message last-products">{l s='Last chance, only 1 left.' mod='roja45productrental'}</p>
                                                {elseif ($model.availability<=$ROJA45_PRODUCTRENTAL_QTYWARNING)}
                                                    <p class="warning-message last-products">{l s='Only %s left, book now.' mod='roja45productrental' sprintf=[$model.availability]}</p>
                                                {else}
                                                    <p class="info-message quantity">{l s='Quantity Available: ' mod='roja45productrental'}{$model.availability}</p>
                                                {/if}
                                                {if ($model.availability>0)}
                                                    <ul class="modal-info-links">
                                                        {if isset($model.description)}
                                                            <li class="modal-info-link"><a href="#modal-info-{$model.id_roja45_product_model}" data-toggle="modal"><i class="material-icons">add_circle</i>{l s='Model Info' mod='roja45productrental'}</a></li>
                                                        {/if}
                                                        {if $rates_available}
                                                            <li class="modal-info-link"><a href="#rate-info-{$model.id_roja45_product_model}" data-toggle="modal"><i class="material-icons">add_circle</i>{l s='Rate Info' mod='roja45productrental'}</a></li>
                                                        {/if}
                                                    </ul>
                                                {/if}
                                            </div>
                                            <div class="col-8 col-sm-7 col-md-4 price">
                                                <div class="row rate-row">
                                                    <div class="product-rental-quantity-container">
                                                        <div class="product-rental-quantity-title">
                                                            <h4>{l s='Quantity' mod='roja45productrental'} ({$model.availability})</h4>
                                                        </div>
                                                        {if ($model.availability>0)}
                                                            <div class="product-rental-quantity-select">
                                                                <input type="text" id="selected_qty_{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}" name="selected_qty" max="data-qty-available="{if $model.availability> 0}{$model.availability}{else}0{/if}" value="{if isset($selected_rate[$model.id_roja45_product_model]) && $selected_rate[$model.id_roja45_product_model]['qty']>0}{$selected_rate[$model.id_roja45_product_model]['qty']}{else}0{/if}"/>
                                                            </div>
                                                        {/if}
                                                    </div>
                                                </div>
                                                {foreach $model.rates as $rate}
                                                    <div class="row rate-row">
                                                        <div class="text-right mr-md-4 pr-md-3">
                                                            <h4>{$rate.name}</h4>
                                                        </div>
                                                        <div class="rate-selector" data-id-roja45-product-rate="{$rate.id_roja45_product_rate|escape:'htmlall':'UTF-8'}">
                                                            <a href="#"
                                                               class="btn btn-default btn-productrental btn-productrental-selectrate {if ($model.availability<=0)}disabled{/if} no-print {if isset($selected_rate[$model.id_roja45_product_model]) && $model.availability>0 && $rate.id_roja45_product_rate==$selected_rate[$model.id_roja45_product_model]['id_roja45_product_rate']}selected{else}unselected{/if}"
                                                               data-id-roja45-product-rate="{$rate.id_roja45_product_rate|escape:'htmlall':'UTF-8'}">
                                                                <span class="rate-total">{if $display_tax}{$rate.total_rate_inc_formatted}{else}{$rate.total_rate_formatted}{/if}<span class="rate-tax-status">{if $display_tax}{l s='(inc.)' mod='roja45productrental'}{else}{l s='(exc.)' mod='roja45productrental'}{/if}</span></span>
                                                                {if ($model.availability>0)}
                                                                    <span class="rate-action selected">{l s='Selected' mod='roja45productrental'}</span>
                                                                    <span class="rate-action unselected">{l s='Click To Select' mod='roja45productrental'}</span>
                                                                {else}
                                                                    <span class="rate-action">{l s='Out Of Stock' mod='roja45productrental'}</span>
                                                                {/if}
                                                            </a>
                                                        </div>
                                                    </div>
                                                {/foreach}
                                            </div>
                                        </div>
                                        {if isset($model.description)}
                                            <div tabindex="-1" role="dialog" id="modal-info-{$model.id_roja45_product_model}" class="modal fade modal-info" style="display: none;" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                <i class="material-icons">close</i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <h5>{$model.model_name}</h5>
                                                            {$model.description nofilter}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}
                                        {if $rates_available}
                                            <div tabindex="-1" role="dialog" id="rate-info-{$model.id_roja45_product_model}" class="modal fade modal-rates" style="display: none;" aria-hidden="true">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                <i class="material-icons">close</i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="product-rental-rate-list row list">
                                                                {foreach $model.rates as $rate}
                                                                    <div class="product-rental-rate-list-container"
                                                                         data-id-roja45-product-rate="{$rate.id_roja45_product_rate|escape:'htmlall':'UTF-8'}">
                                                                        <div class="product-rental-rate-container-header">
                                                                            <div class="product-rental-rate">
                                                                                {$rate.name}
                                                                            </div>
                                                                        </div>
                                                                        <div class="rental-periods clearfix">
                                                                            <div class="rental-periods-content rental-periods-content-{$rate.duration_type}">
                                                                                <ul>
                                                                                    {foreach $rate.periods as $period}<li class="rental-periods-content-column-container list-group-item rate-period" data-period="{$period->period}" {if isset($period->rule_modifier)}data-rule-modifier="{$period->rule_modifier}"{/if}>
                                                                                        <div class="period">{if $period->period_type==2}{l s='Day' mod='roja45productrental'}&nbsp;{/if}{$period@iteration} ({$period->period_name} - {$period->period_start_formatted})</div>
                                                                                        <table class="table">
                                                                                            <tbody>
                                                                                            <tr>
                                                                                                <td>{l s='Rate' mod='roja45productrental'}</td><td>{$period->original_rate_formatted}</td>
                                                                                            </tr>
                                                                                            {if isset($period->discount_formatted)}
                                                                                                <tr>
                                                                                                    <td>{l s='Discount' mod='roja45productrental'}</td><td>{$period->discount_formatted}</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <td>{l s='Final Rate' mod='roja45productrental'}</td><td>{$period->rate_formatted}</td>
                                                                                                </tr>
                                                                                            {/if}
                                                                                            {if isset($period->tax_formatted)}
                                                                                                <tr>
                                                                                                    <td>{l s='Tax' mod='roja45productrental'}</td><td>{$period->tax_formatted}</td>
                                                                                                </tr>
                                                                                            {/if}
                                                                                            </tbody>
                                                                                        </table>
                                                                                        </li> {/foreach}
                                                                                </ul>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                {/foreach}
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {/if}
                                    </article>
                                {/foreach}
                            </div>
                        </div>
                    </div>
                    {hook h="displayRoja45ProductRentalBookingFooter" rental_product=$rental_product}
                </section> <!-- End Available models section -->
                <section id="roja45productrental_available_extras" class="" style="display: none;">
                    <div class="content">
                        {foreach $models as $model}
                            <article class="ajax-block-product-rental-extra product-rental-list col-lg-12 page-content"
                                data-id-roja45-product-model="{$model.id_roja45_product_model}"
                                data-id-product-attribute="{$model.id_product_attribute}"
                                style="display: none;">
                                <h3 class="title">{$product->name}: {$model.model_name}</h3>
                                <div class="product-rental-extra-container row">
                                    {if isset($model.addons)}
                                        {foreach $model.addons as $addon}
                                            <div class="extra col-lg-6">
                                                <div class="roja45productrental-addon row"
                                                     data-id-roja45-product-extra="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                     data-deselect-warning="{$addon.deselect_warning|escape:'htmlall':'UTF-8'}">
                                                    <div class="col-lg-5">
                                                        {$addon.image_url}
                                                        <p class="text-center mt-1">
                                                            <a href="#modal-extra-info-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                               data-toggle="modal"
                                                               class="more-info">
                                                                <i class="material-icons">add_circle</i>{l s='More Info' mod='roja45productrental'}</a>
                                                        </p>
                                                    </div>
                                                    <div class="col-lg-7">
                                                        <h4 class="title">
                                                            {$addon.name}
                                                        </h4>
                                                        {if $addon.id_roja45_productrental_extra_type==1}
                                                            <p class="roja45productrental-addon-title">
                                                                {l s='Per Period Rate' mod='roja45productrental'}
                                                            </p>
                                                            <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                {l s='This extra will be charged daily.' mod='roja45productrental'}
                                                            </p>
                                                        {elseif $addon.id_roja45_productrental_extra_type==2}
                                                            <p class="roja45productrental-addon-title">
                                                                {l s='Per Rental Rate' mod='roja45productrental'}
                                                            </p>
                                                            <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                {l s='This extra will be applied once for the entire rental period.' mod='roja45productrental'}
                                                            </p>
                                                        {elseif $addon.id_roja45_productrental_extra_type==3}
                                                            <p class="roja45productrental-addon-title">
                                                                {l s='Per Rental Item' mod='roja45productrental'}
                                                            </p>
                                                            <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                {l s='This extra will be applied once for the entire rental period, per item.' mod='roja45productrental'}
                                                            </p>
                                                        {elseif $addon.id_roja45_productrental_extra_type==4}
                                                            <p class="roja45productrental-addon-title">
                                                                {l s='Per Rental Item, Per Period' mod='roja45productrental'}
                                                            </p>
                                                            <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                {l s='This extra will be applied once per item, per day' mod='roja45productrental'}
                                                            </p>
                                                        {/if}

                                                        <div class="roja45productrental-addon-checkbox">
                                                            <a href="#" class="btn btn-default btn-productrental btn-productrental btn-productrental-selectextra no-print {if $addon.required}selected disabled{elseif $addon.id_roja45_productrental_extra_type==3}selected{else}{if isset($addon.default_selected) && ($addon.default_selected==1)}selected{else}unselected{/if}{/if}" data-id-roja45-product-extra="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}">
                                                                <span class="price standard mt-2">
                                                                    {if $display_tax}{$addon.rate_inc_formatted}{else}{$addon.rate_formatted}{/if}<span class="rate-tax-status">{if $display_tax}{l s='(inc.)' mod='roja45productrental'}{else}{l s='(exc.)' mod='roja45productrental'}{/if}</span>
                                                                </span>
                                                                <span class="price free-voucher mt-2" style="display:none;">
                                                                    {l s='FREE' mod='roja45productrental'}
                                                                </span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div tabindex="-1" role="dialog" id="modal-extra-info-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra}" class="modal fade modal-specs" style="display: none;" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                    <i class="material-icons">close</i>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <h5>{$addon.name}</h5>
                                                                <div class="row description">
                                                                    <div class="col-md-5">
                                                                        <div>
                                                                            {$addon.image_url}
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-md-7">
                                                                        {$addon.description nofilter}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div tabindex="-1" role="dialog" id="modal-deselect-warning-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra}" class="modal fade modal-specs" style="display: none;" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                    <i class="material-icons">close</i>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <h5>{l s='Are you sure?' mod='roja45productrental'}</h5>
                                                                <div class="row description">
                                                                    <div class="col-md-7">
                                                                        {$addon.deselect_warning_text nofilter}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        {/foreach}
                                    {/if}
                                </div>
                            </article>
                        {/foreach}
                    </div>
                    <div>
                        <a href="#back" class="btn-back-to-models"><i class="material-icons">keyboard_arrow_left</i>{l s='Back' mod='roja45productrental'}</a>
                    </div>
                </section>
            </div>
            {else}
                NO RATES TBD
            {/if}
        </form>
    </div>
</div>

<div id="immersive-modal-dialog" class="immersive-modal-dialog">
    <div class="modal-wait-container">
        <i class="material-icons spin">refresh</i>
        <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
    </div>
</div>

<div id="immersive-confirm-dialog" class="ui-dialog"  style="display:none">
    <div class="ui-dialog-titlebar"></div>
    <div class="ui-dialog-content">
        <p>{l s='You have warnings' mod='roja45productrental'}</p>
    </div>
    <div class="ui-dialog-buttonpane"></div>
</div>

<style type="text/css" style="display: none">
    #immersive-modal-dialog {
        display:none;
        position:fixed;
        top:0;
        left:0;
        background:black;
        width:100%;
        height:100%;
        z-index: 9999;
        opacity: 0.7;
    }

    #immersive-modal-dialog .modal-wait-container
    {
        text-align:center;
        position:absolute;
        left: 50%;
        top: 50%;
        margin-left:-10px;
        margin-top: -10px;
        color: white;
    }

    #immersive-modal-dialog .modal-wait-container i
    {
        font-size: 50px;
    }

    .spin {
        -webkit-animation-name: spin;
        -webkit-animation-duration: 3000ms;
        -webkit-animation-iteration-count: infinite;
        -webkit-animation-timing-function: linear;
        -moz-animation-name: spin;
        -moz-animation-duration: 3000ms;
        -moz-animation-iteration-count: infinite;
        -moz-animation-timing-function: linear;
        -ms-animation-name: spin;
        -ms-animation-duration: 3000ms;
        -ms-animation-iteration-count: infinite;
        -ms-animation-timing-function: linear;
        -o-transition: rotate(3600deg);
    }

    .immersive-message-dialog {
        width: 200px;
        height: 50px;
        border-radius: 3px;
        position: absolute;
        z-index: 999;
        right: 0;
        bottom: 0;
    }

    .immersive-message-dialog.error {
    background-color: rgba(232, 30, 27, 0.5);
    }
    .immersive-message-dialog.warning {
    background-color: rgba(226, 173, 61, 0.5);
    }
    .immersive-message-dialog.success {
    background-color: rgba(40, 226, 10, 0.50);
    }
    #immersive-error-dialog {

    }

    #immersive-warning-dialog {

    }

    #growls.immersive {
    top: 95px;
    right: 10px;
    }
</style>

{/block}
