{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file='page.tpl'}

{block name='page_title'}
    {l s='Your Rentals' mod='roja45productrental'}
{/block}

{block name='page_content_top'}
    <div class="roja45-productrental-customer-bookings">
        <p class="info-title">Poniżej znajdziesz historię najmu od czasu założenia przez Ciebie konta.</p>
        <div class="block-center" id="block_booking_history">
            {if $rentals && count($rentals)}
                <table id="order-list"
                       class="table table-striped table-bordered footab">
                    <thead>
                    <tr>
                        <th class="first_item" ></th>
                        <th class="item" data-sort-ignore="true">Kod referencyjny</th>
                        <th class="item">{l s='Received' mod='roja45productrental'}</th>
                        <th class="item">{l s='Status' mod='roja45productrental'}</th>
                        <th class="item">Całkowity koszt rezerwacji najmu</th>
                        <th class="item">Całkowity poniesiony koszt najmu</th>
                        <th data-sort-ignore="true">&nbsp;</th>
                        <th data-sort-ignore="true">&nbsp;</th>
                        <th data-sort-ignore="true" class="last_item">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    {foreach $rentals as $rental}
                        <tr class="{if $rental@first}first_item{elseif $rental@last}last_item{else}item{/if} {if $rental@index % 2}alternate_item{/if}"
                            data-booking-reference="{$rental.reference}">
                            <td>
                                {if $rental.payment_due}<a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['view_rental_payments' => 1, 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}" title="{l s='Payment Due' mod='roja45productrental'}"><i class="material-icons" style="color: orange">warning</i></a>{/if}
                            </td>
                            <td class="bold">
                                <a class="show-booking" href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['view_customer_rental' => '1', 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}">
                                    {$rental.reference}
                                </a>
                            </td>
                            <td data-value="" class="bold">
                                {$rental.date_add}
                            </td>
                            <td class="bold">
                                {$rental.status}
                            </td>
                            <td data-value="" class="bold">
                                {$rental.totals.total_to_pay_inc_formatted}
                            </td>
                            <td data-value="" class="bold">
                                {$rental.totals.total_paid_inc_formatted}
                            </td>
                            <td data-value="" class="history_date bold">
                                <a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['view_customer_rental' => '1', 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}" class="show-booking">
                                    <i class="icon-eye"></i><span>Szczegóły</span>
                                </a>
                            </td>
                            <td data-value="" class="history_date bold">
                                <a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['view_rental_payments' => 1, 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}" class="pay-rental">
                                    <i class="icon-money"></i><span>Dokonane płatności</span>
                                </a>
                            </td>
                            <td data-value="" class="bold">
                                {if $rental.payment_due}<a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['view_rental_payments' => 1, 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}" title="{l s='Payment Due' mod='roja45productrental'}">
                                    <i class="icon-money"></i><span>Zapłacić teraz</span>
                                    </a>
                                {/if}
                            </td>
                        </tr>
                    {/foreach}
                    </tbody>
                </table>
            {/if}
        </div>
        <div class="block-center" id="block_booking_summary">
        </div>
    </div>
{/block}

{block name='page_footer'}
    {block name='my_account_links'}
        <a href="{$my_account_url}" class="account-link btn">
            <span>WRÓĆ</span>
        </a>

    {/block}
{/block}

