{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file='customer/page.tpl'}

{block name='page_title'}
    {l s='Open Rentals' mod='roja45productrental'}
{/block}

{block name='page_content'}

<div class="roja45-productrental-customer-bookings">
    <div class="roja45-productrental-customer-bookings">
        {if $rentals && count($rentals)}
        {foreach $rentals as $rental}
        <div class="customer-rental-block">
            <div class="box">
                <div class="row vertical-center">
                    <div class="col-md-4 col-xs-12 text-xs-center text-md-left">
                        <span class="label label-pill bright" style="background-color:{$rental.status_color}">{$rental.status}</span>
                    </div>
                    <div class="col-md-4 col-xs-12 ">
                        <h4>
                            Kod referencyjny: <strong>{$rental.reference}</strong>

                        </h4>
                    </div>
                    <div class="col-md-4 col-xs-12 ">
                        <h4>
                            Należne płatności: {$rental.totals.total_outstanding_inc_formatted}
                        </h4>
                    </div>

                    <div class="clearfix"></div>
                </div>
            </div>
            {if isset($addresses) && count($addresses)}
            <div class="addresses">
                {if $addresses.delivery}
                    <div class="col-lg-6 col-md-6 col-sm-6">
                        <article id="delivery-address" class="box">
                            <h4>{l s='Delivery address' mod='roja45productrental'}</h4>
                            <address>{$addresses.delivery.formatted nofilter}</address>
                        </article>
                    </div>
                {/if}

                <div class="col-lg-6 col-md-6 col-sm-6">
                    <article id="invoice-address" class="box">
                        <h4>{l s='Delivery address' mod='roja45productrental'}</h4>
                        <address>{$addresses.invoice.formatted nofilter}</address>
                    </article>
                </div>
                <div class="clearfix"></div>
            </div>
            {/if}
            {foreach $rental.products as $rental_product}
            {foreach $rental_product.models as $model}
            <article class="rental-item box">
                <div class="row">
                    <div class="col-12 col-md-12">
                        <div class="col-md-2">
                            {if isset($model.images)}
                                <img class="img-fluid"
                                     src="{$model.images['cart_default'].src}"
                                     alt="{$model.images['cart_default'].title}"
                                     title="{$model.images['cart_default'].title}"
                                     width="{$model.images['cart_default'].width}"
                                     height="{$model.images['cart_default'].height}">
                            {/if}
                        </div>
                        <div class="col-md-10">

                            <div class="row">
                                <div class="col-md-12">
                                <h4 class="title">{$rental_product.name}</h4>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-3 col-xs-6">
                                    <span class="heading date title">Od</span>
                                    <span class="heading date value">{$model.start_date}</span>
                                </div>
                                <div class="col-md-3 col-xs-6">
                                    <span class="heading date title">Do</span>
                                    <span class="heading date value">{$model.end_date}</span>
                                </div>
                                <div class="col-md-3 col-xs-6">
                                    <span class="heading date title">Ilość</span>
                                    <span class="heading date value">{$model.qty}</span>
                                </div>
                                <div class="col-md-3 col-xs-6">
                                    <span class="heading date title">Łącznie</span>
                                    <span class="heading date value">{$model.total_formatted}</span>
                                </div>
                            </div>
                        </div>

                    </div>


                </div>
            </article>
            {/foreach}
            {/foreach}
            {if isset($rental.totals.delivery_address) || isset($rental.totals.collection_address)}
            <div class="delivery-collection-address payments">
                <form method="POST" action="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['ajax' => 1, 'action' =>'submitCustomDeliveryCollectionAddress', 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}">
                    <input name="use_same_address" id="use_same_address" type="hidden" value="0">
                {if isset($rental.totals.delivery_address)}
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <article class="box">
                        <div id="delivery-address" class="address-block">
                            <h3>{l s='Delivery Address' mod='roja45productrental'}</h3>
                            <section class="form-fields">
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Address' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="delivery_address1" type="text" value="{$rental.totals.delivery_address.address1}" maxlength="128" required="">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label">
                                        {l s='Address Line 2' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="delivery_address2" type="text" value="{$rental.totals.delivery_address.address2}" maxlength="128">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='City' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="delivery_city" type="text" value="{$rental.totals.delivery_address.city}" maxlength="64" required="">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Zip/Postal Code' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="delivery_postcode" type="text" value="{$rental.totals.delivery_address.postcode}" maxlength="12" required="">
                                    </div>
                                </div>
                            </section>
                            <input type="hidden" name="id_delivery_address" value="{$rental.totals.delivery_address.id_address}">
                            <input type="hidden" name="submitAddress" value="1">
                            <button type="button" class="continue btn btn-primary btn-update-address" name="save-addresses" value="1">
                                {l s='Update' mod='roja45productrental'}
                            </button>
                        </div>
                    </article>
                </div>
                {/if}
                {if isset($rental.totals.collection_address)}
                <div class="col-lg-6 col-md-6 col-sm-6">
                    <article class="box">
                        <div id="delivery-address" class="address-block">
                            <h3>{l s='Collection Address' mod='roja45productrental'}</h3>
                            <section class="form-fields">
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Address' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="collection_address1" type="text" value="{$rental.totals.collection_address.address1}" maxlength="128" required="">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label">
                                        {l s='Address Line 2' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="collection_address2" type="text" value="{$rental.totals.collection_address.address2}" maxlength="128">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='City' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="collection_city" type="text" value="{$rental.totals.collection_address.city}" maxlength="64" required="">
                                    </div>
                                </div>
                                <div class="form-group row ">
                                    <label class="col-md-3 form-control-label required">
                                        {l s='Zip/Postal Code' mod='roja45productrental'}
                                    </label>
                                    <div class="col-md-9">
                                        <input class="form-control" name="collection_postcode" type="text" value="{$rental.totals.collection_address.postcode}" maxlength="12" required="">
                                    </div>
                                </div>

                            </section>
                            <input type="hidden" name="id_collection_address" value="{$rental.totals.collection_address.id_address}">
                            <button type="button" class="continue btn btn-primary btn-update-address" name="save-addresses" value="1">
                                {l s='Update' mod='roja45productrental'}
                            </button>
                        </div>
                    </article>
                </div>
                {/if}
                </form>
            </div>
            {/if}

            <div >
                <div class="row">
                    <div class="col-xs-6">
                    </div>
                    <div class="col-md-6 col-xs-12 text-md-right text-xs-center" >
                        {if $rental.download_pdf}
                        <a style="margin-top:5px" class=" btn btn-primary btn-request-cancellation" href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['get_rental_confirmation_pdf' => 1, 'id_roja45_product_rental' => $rental.id_roja45_product_rental]}">
                            <span>{l s='Confirmation PDF' mod='roja45productrental'}</span>
                        </a>
                        {/if}
                        <a style="margin-top:5px" class="btn btn-primary btn-request-cancellation" href="https://marekbazarek.com/pl/module/kbmarketplace/product">
                            <span>Dodaj produkty</span>
                        </a>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
            <hr>
        {/foreach}
        {else}
            <h3>W chwili obecnej brak zarezerwowanego / opłaconego terminu najmu.</h3>
            <div class="block center-title">
                <h4 class="module-title moj-konto-title">
                    <span>REZERWUJ MODUŁ</span>
                </h4>
            </div>
            <div class="row">
                <div class="pts-container-wrap sell-product-display">
                    <div class="pts-inner ps-container page-width">

                        <div class="page-width">
                            <div class="row-inner row-level-1 container">
                                <div class="row clearfix">
                                    <div class="col-xl-6 col-lg-6 col-sm-12 col-xs-12">
                                        <div class="col-inner  sell-featured-prod widgets-center widgets-column">
                                            <div class="pk-widget widget-image">
                                                <div class="pts-widget" id="wid-key_1558692703841"><div class="widget-images relative block sell-featured-prod-img  title_left">
                                                        <div class="widget-inner block_content text-left justify-content-left">
                                                            <div class="image-item psp-image-item animated default" data-animation="default">
                                                                <a href="https://www.marekbazarek.com/pl/moduly/21-pol-stojaka-modul-podstawowy.html" class="pts-btnlink oh db img-animation">
                                                                    <img class="smooth05 w-100" src="/modules/pspagebuilder/views/img/spolka.jpg" width="100" height="100" alt="">
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="pk-widget widget-html">
                                                <div class="pts-widget" id="wid-key_1558692689377"><div class="widget-html block   title_left">
                                                        <div class="widget-inner block_content text-left justify-content-left">
                                                            <p class="roboto sell-featured-l1" style="text-align: center;">½ stojaka moduł podstawowy&nbsp;<br> <span class="sell-featured-l2"><strong>(do 25 wieszaków)</strong></span></p>
                                                            <ul class="sell-featured-l3" style="text-align: center;">
                                                                <li style="list-style: none;">na bluzki, spódnice, spodnie, swetry, kurtki, etc.</li>
                                                                <li style="list-style: none; text-align: left;">
                                                                    <table>
                                                                        <tbody>
                                                                        <tr>
                                                                            <td style="text-align: left;">1-14 dzień</td>
                                                                            <td style="text-align: left;">7,50 zł / dzień</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: left;">15-21 dzień</td>
                                                                            <td style="text-align: left;">rabat 20%</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: left;">od 22-ego dnia</td>
                                                                            <td style="text-align: left;">rabat 30%</td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </li>
                                                            </ul>
                                                            <h3 class="Domylne" style="text-align: center;"><span lang="PL" style="font-size: 10.0pt; font-family: 'Helvetica',sans-serif; mso-bidi-font-family: 'Arial Unicode MS'; background: white; mso-ansi-language: PL;"><b><span lang="PL" style="font-size: 10pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;"><a href="https://www.marekbazarek.com/pl/moduly/21-pol-stojaka-modul-podstawowy.html" class="btn btn-default">SPRAWDŹ KOSZT</a><br></span></b></span></h3>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col-xl-6 col-lg-6 col-sm-12 col-xs-12">
                                        <div class="col-inner  sell-featured-prod widgets-center widgets-column">
                                            <div class="pk-widget widget-image">
                                                <div class="pts-widget" id="wid-key_1558693063263"><div class="widget-images relative block sell-featured-prod-img  title_left">
                                                        <div class="widget-inner block_content text-left justify-content-left">
                                                            <div class="image-item psp-image-item animated default" data-animation="default">
                                                                <a href="https://www.marekbazarek.com/pl/moduly/20-polka-modul-podstawowy-58-cm-x-34-cm.html" class="pts-btnlink oh db img-animation">
                                                                    <img class="smooth05 w-100" src="/modules/pspagebuilder/views/img/polka.jpg" width="100" height="100" alt="">
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="pk-widget widget-html">
                                                <div class="pts-widget" id="wid-key_1558692876940"><div class="widget-html block   title_left">
                                                        <div class="widget-inner block_content text-left justify-content-left">
                                                            <p class="roboto sell-featured-l1" style="text-align: center;">Półka moduł podstawowy<br> <span class="sell-featured-l2"><strong>(58cm x 34cm)</strong></span></p>
                                                            <ul class="sell-featured-l3" style="text-align: center;">
                                                                <li style="list-style: none;">na akcesoria: buty, torebki, czapki, etc.</li>
                                                                <li style="list-style: none; text-align: left;">
                                                                    <table>
                                                                        <tbody>
                                                                        <tr>
                                                                            <td style="text-align: left;">1-14 dzień</td>
                                                                            <td style="text-align: left;">2,50 zł / dzień</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: left;">15-21 dzień</td>
                                                                            <td style="text-align: left;">rabat 20%</td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td style="text-align: left;">od 22-ego dnia</td>
                                                                            <td style="text-align: left;">rabat 30%</td>
                                                                        </tr>
                                                                        </tbody>
                                                                    </table>
                                                                </li>
                                                            </ul>
                                                            <p style="text-align: center;"></p>
                                                            <h3 class="Domylne" style="text-align: center;"><span lang="PL" style="font-size: 10.0pt; font-family: 'Helvetica',sans-serif; mso-bidi-font-family: 'Arial Unicode MS'; background: white; mso-ansi-language: PL;"><b><span lang="PL" style="font-size: 10pt; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;"><a href="https://www.marekbazarek.com/pl/moduly/20-polka-modul-podstawowy-58-cm-x-34-cm.html" class="btn btn-default">SPRAWDŹ KOSZT</a><br></span></b></span></h3>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        {/if}
    </div>
</div>
{/block}

{block name='page_footer'}
    {block name='my_account_links'}
        <a href="{$my_account_url}" class="account-link btn">
            <span>WRÓĆ</span>
        </a>
    {/block}
{/block}

