{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<div id="roja45_productrental_booking_details"
     class="roja45productrental roja45_productrental_booking_details shopping-cart-footer product_column clearfix">
    <h2>{l s='Rental Summary' mod='roja45proRental Summary' mod='roja45productrental'}</h2>
    <div class="roja45_productrental_booking_details_container col-lg-12">
        <div class="row">
            {foreach $rental_products as $rental_product}
                <div class="roja45-rental-product-container col-lg-12">
                    <ul class="row list">
                        {foreach $rental_product.models as $model}
                            {if $model@iteration==1}
                                <li class="col-lg-12 product-rental-list roja45_productrental_product_block">
                                    <div class="row">
                                        <div class="column col-lg-2 col-xs-12 roja45_productrental_product_image">
                                            <div class="column-content row">
                                                <div class="column-header"></div>
                                            </div>
                                        </div>
                                        <div class="column col-lg-5 col-xs-12 roja45_productrental_product_title">
                                            <div class="column-content row">
                                                <div class="column-header">
                                                    {l s='Product' mod='roja45productrental'}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="column col-lg-4 col-xs-12 roja45_productrental_product_rates">
                                            <div class="column-content row">
                                                <div class="column-header">
                                                    {l s='Sub-Total' mod='roja45productrental'}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="column col-lg-1 col-xs-12 ">
                                            <div class="column-content row">
                                                <div class="column-header">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            {/if}
                            <li class="col-lg-12 product-rental-list roja45_productrental_product_block">
                                <div class="row">
                                    <div class="col-lg-2 col-xs-12 column roja45_productrental_product_image">
                                        <div class="column-content row">
                                            <div class="column-value">
                                                <a href="{$rental_product.product_link|escape:'html':'UTF-8'}">
                                                    <!--<img src="{$rental_product.image_url|escape:'html':'UTF-8'}"-->
                                                    <img src="{$link->getImageLink($rental_product.product->link_rewrite, $model.id_image, 'small_default')|escape:'html':'UTF-8'}"
                                                         alt="{$rental_product.product->name|escape:'html':'UTF-8'}"
                                                         {if isset($smallSize)}width="{$smallSize.width|escape:'html':'UTF-8'}px"
                                                         height="{$smallSize.height|escape:'html':'UTF-8'}px" {/if} />
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-5 col-xs-12 column roja45_productrental_product_title">
                                        <div class="column-content row">
                                            <div class="column-value">
                                                <p class="product-name">({$model.qty|escape:'html':'UTF-8'}) {$rental_product.product->name|escape:'html':'UTF-8'}</p>
                                                <small>{$model.model_name|escape:'html':'UTF-8'}</small>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 col-xs-12 column roja45_productrental_product_title">
                                        <div class="column-content row">
                                            <div class="column-value">
                                                <p class="product-name">{$model.total_model_formatted|escape:'html':'UTF-8'}</p>
                                                {if ($rental_product.deposit < 100)}<small>{l s='%s%% deposit required' sprintf=[$rental_product.deposit] mod='roja45productrental'}</small>{/if}
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-1 col-xs-12 column roja45_productrental_product_delete">
                                        <div class="column-content row">
                                            <div class="column-value">
                                                {if isset($delete_product_link)}
                                                    <a class="delete-rental-entry" href="{$delete_product_link|escape:'html':'UTF-8'}&id_roja45_product_rental={$rental_product.id_roja45_product_rental}&id_product={$rental_product.id_product}&id_product_attribute={$model.id_product_attribute}">
                                                        <i class="material-icons">delete</i>
                                                    </a>
                                                {/if}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </li>
                        {/foreach}
                    </ul>
                </div>
            {/foreach}
        </div>
        <div class="row">
            <div class="roja45_productrental_product_block col-lg-12">
                <div class="row">
                    <div class="offset-lg-7 col-lg-5 col-xs-12 roja45_productrental_totals_block">
                        <div class="row">
                            <table class="table table-bordered">
                                <tfoot>
                                <tr>
                                    <td class="text-right">{l s='Total' mod='roja45productrental'}
                                        <span class="tax-inc">{l s='(exc.)' mod='roja45productrental'}</span>
                                    </td>
                                    <td class="price">{$total_to_pay_formatted|escape:'html':'UTF-8'}</td>
                                </tr>
                                {if $taxes > 0}
                                    <tr>
                                        <td class="text-right">{l s='Taxes' mod='roja45productrental'}</td>
                                        <td class="price">{$taxes_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                {/if}
                                {if !$display_without_tax}
                                    <tr>
                                        <td class="text-right">{l s='Total To Pay' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(inc.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{$total_to_pay_inc_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-right">{l s='Total To Pay Now' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(inc.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{$total_to_pay_now_inc_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                {else}
                                    <tr>
                                        <td class="text-right">{l s='Total To Pay' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(exc.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{$total_to_pay_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-right">{l s='Total To Pay Now' mod='roja45productrental'}
                                            <span class="tax-inc">{l s='(exc.)' mod='roja45productrental'}</span>
                                        </td>
                                        <td class="price">{$total_to_pay_now_exc_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                {/if}
                                {if isset($total_damage_deposit_exc) && ($total_damage_deposit_exc > 0)}
                                    <tr>
                                        <td class="text-right">{l s='Damage Deposit' mod='roja45productrental'}</td>
                                        <td class="price">{$total_damage_deposit_formatted|escape:'html':'UTF-8'}</td>
                                    </tr>
                                {/if}
                                <tr>
                                    <td class="text-right total-to-pay-header">{l s='Total To Pay' mod='roja45productrental'}{if ($display_without_tax)}{l s='(tax exc.)' mod='roja45productrental'}{else}{l s='(tax inc.)' mod='roja45productrental'}{/if}</td>
                                    <td class="price total-to-pay">{if ($display_without_tax)}{$total_exc_formatted|escape:'html':'UTF-8'}{else}{$total_inc_formatted|escape:'html':'UTF-8'}{/if}</td>
                                </tr>
                                <tr>
                                    <td class="text-right" colspan="2">
                                        {if isset($total_deposit_to_pay) && total_deposit_to_pay > 0}
                                            <p class="roja45_productrental_notes">{l s='The required payment has been calculated and added to your cart, any remainder should be paid on collection.' mod='roja45productrental'}</p>
                                        {/if}
                                    </td>
                                </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12 roja45_productrental_summary_block">
                <div class="row">
                    <div class="roja45_productrental_section_title">
                        <h2>{l s='Your Rental Details' mod='roja45productrental'}</h2>
                        <a class=""
                           role="button"
                           data-toggle="collapse"
                           href="#roja45_productrental_spaces_block"
                           aria-expanded="false"
                           aria-controls="collapseExample">
                            <i class="icon-chevron-down"></i>
                            <span class="collapsed-text">({l s='click to show' mod='roja45productrental'})</span>
                        </a>
                    </div>

                    <div id="roja45_productrental_spaces_block" class="col-lg-12 collapse">
                        {foreach $rental_products as $rental_product}
                            {foreach $rental_product.models as $model}
                                <div class="row">
                                    <div class="col-lg-12 roja45_productrental_space_block">
                                        <div class="roja45_productrental_rates_block col-xs-12">
                                            <div class="row">
                                                {foreach $model.rates as $rate}
                                                    <div class="item box">
                                                        <h3 class="page-subheading">
                                                            {$rental_product.product->name|escape:'html':'UTF-8'} : {$model.model_name|escape:'html':'UTF-8'} [{$rate.name|escape:'html':'UTF-8'}]
                                                        </h3>
                                                        <ul class="product-rental-rate-list">
                                                            {foreach $rate.periods as $period}
                                                                <li class="ajax-block-product-model-rate roja45_productrental_rate_block"
                                                                    data-id-roja45-product-rental-rate="{$period.id_roja45_product_rental_rate|escape:'htmlall':'UTF-8'}"
                                                                    data-id-roja45-product-rental-model="{$period.id_roja45_product_rental_model|escape:'htmlall':'UTF-8'}">
                                                                    <div class="heading">
                                                                        {$period.period_formatted|escape:'htmlall':'UTF-8'}
                                                                    </div>
                                                                    <div class="content">
                                                                        <p>{if ($period.period_name|count_characters>0)}{if isset($period.period_name)}{$period.period_name|escape:'html':'UTF-8'}{else}{l s='Seasonal Rate' mod='roja45productrental'}{/if}{else}{l s='Std Rate' mod='roja45productrental'}{/if}</p>
                                                                        <p>{l s='Rate :' mod='roja45productrental'} {$period.value_formatted|escape:'htmlall':'UTF-8'}</p>
                                                                        <p>{l s='Discount :' mod='roja45productrental'} {$period.discount_formatted|escape:'htmlall':'UTF-8'}</p>
                                                                        <p>{l s='Total :' mod='roja45productrental'} {$period.total_formatted|escape:'htmlall':'UTF-8'}</p>
                                                                        <p>{l s='Qty :' mod='roja45productrental'} {$period.entry|escape:'htmlall':'UTF-8'}</p>
                                                                    </div>
                                                                </li>
                                                            {/foreach}
                                                        </ul>
                                                    </div>
                                                {/foreach}
                                            </div>
                                        </div>
                                        <div class="roja45_productrental_block extras_block col-xs-12">
                                            <ul class="row list">
                                                {foreach $model.extras as $extra}
                                                    <li class="ajax-block-product-model-extra product-rental-list col-xs-12">
                                                        <div class="row">
                                                            <div class="column col-xs-6 col-sm-6 col-md-3">
                                                                <div class="column-content row">
                                                                    {if $extra@iteration==1}
                                                                        <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                            {l s='Extra' mod='roja45productrental'}
                                                                        </div>
                                                                    {/if}
                                                                    <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        <span>{$extra.name|escape:'html':'UTF-8'}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="column col-xs-6 col-sm-6 col-md-3">
                                                                <div class="column-content row">
                                                                    {if $extra@iteration==1}
                                                                        <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                            {l s='Charged' mod='roja45productrental'}
                                                                        </div>
                                                                    {/if}
                                                                    <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        <span>{$extra.rate_name|escape:'html':'UTF-8'}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="column col-xs-6 col-sm-6 col-md-3">
                                                                <div class="column-content row">
                                                                    {if $extra@iteration==1}
                                                                        <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                            {l s='Cost' mod='roja45productrental'}
                                                                        </div>
                                                                    {/if}
                                                                    <div class="column-value column-value-{$rate@iteration|escape:'htmlall':'UTF-8'}">
                                                                        <span>{$extra.rate_formatted} (x {$extra.qty|escape:'html':'UTF-8'})</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="column col-xs-6 col-sm-6 col-md-3">
                                                                <div class="column-content row">
                                                                    {if $extra@iteration==1}
                                                                        <div class="column-header column-header-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                            {l s='Total' mod='roja45productrental'}
                                                                        </div>
                                                                    {/if}
                                                                    <div class="column-value column-value-{$rate@iteration|escape:'html':'UTF-8'}">
                                                                        <span>{$extra.total_formatted}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                {/foreach}
                                            </ul>
                                        </div>
                                        <div class="roja45_productrental_block totals_block col-xs-12">
                                            <ul class="product-rental-list row list">
                                                <li class="ajax-block-product-model-total {if !isset($model.deposit)}last-item{/if} col-md-offset-6 col-xs-12 col-md-6">
                                                    <div class="row">
                                                        <div class="total header col-xs-6">
                                                            {l s='Total' mod='roja45productrental'}&nbsp;{l s='(exc.)' mod='roja45productrental'}
                                                        </div>
                                                        <div class="total value col-xs-6">
                                                            {$model.total_formatted|escape:'html':'UTF-8'}
                                                        </div>
                                                    </div>
                                                </li>
                                                {if isset($model.deposit)}
                                                    <li class="ajax-block-product-model-total col-md-offset-6 col-xs-12 col-md-6">
                                                        <div class="row">
                                                            <div class="total header col-xs-6">
                                                                {l s='Payment Required' mod='roja45productrental'}
                                                            </div>
                                                            <div class="total value col-xs-6">
                                                                {$model.deposit|number_format:0|escape:'html':'UTF-8'}%
                                                            </div>
                                                        </div>
                                                    </li>
                                                    <li class="ajax-block-product-model-total last-item col-md-offset-6 col-xs-12 col-md-6">
                                                        <div class="row">
                                                            <div class="total header col-xs-6">
                                                                {l s='Total To Pay Now' mod='roja45productrental'}
                                                            </div>
                                                            <div class="total value col-xs-6">
                                                                {$model.total_to_pay_now_formatted|escape:'html':'UTF-8'}
                                                            </div>
                                                        </div>
                                                    </li>
                                                {/if}
                                            </ul>
                                        </div> <!-- End roja45_productrental_nights_block -->
                                    </div><!-- End roja45_productrental_space_block -->
                                </div>
                            {/foreach}
                        {/foreach}
                    </div>
                </div>
            </div> <!-- End roja45_productrental_summary_block -->
        </div>
    </div> <!-- End roja45_productrental_booking_details_container -->
