{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file='page.tpl'}

{block name="page_content"}

<div id="roja45productrental_summary" class="roja45productrental_rental table_block table-responsive">
    <div class="roja45_productrental_summary_container col-lg-12">
        <div class="row">
            {if isset($payment_required) && $payment_required}
                <p class="info-title">{l s='Please find here a summary of your selection.  If you are happy you can add this rental selection to your cart.' mod='roja45productrental'}</p>
            {else}
                <p class="info-title">{l s='Many thanks, we have received your request. Once you confirm your rental request below, we will confirm with you and notify you of any payment required.' mod='roja45productrental'}</p>
            {/if}
        </div>
    </div>
    {include file="module:roja45productrental/views/templates/front/PS17_rental-summary.tpl"}

    <form id="roja45productrental_customerconfirmation_form"
          method="post"
          action="{url entity='module' name='roja45productrental' controller='ProductRentalFront'}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_RENTAL_ID" value="{$rental->id|escape:'html':'UTF-8'}"/>
        {if isset($enable_cod) && $enable_cod}
            <div class="roja45_productrental_summary_container col-lg-12">
                <div class="row">
                    <h2>{l s='Pay On Collection' mod='roja45productrental'}</h2>
                    <p class="info-title">{l s='If you would like to pay the balance on collection of your products in store, please check the option below.' mod='roja45productrental'}</p>
                    <span class="custom-checkbox">
                    <input class="js-codcheckbox" id="input_cod" name="enable_cod" type="checkbox" value="1" {if $cod_enabled}checked="checked"{/if}/>
                    <span><i class="material-icons rtl-no-flip checkbox-checked">&#xE5CA;</i></span>
                        <label for="input_cod">{l s='Pay On Collection' mod='roja45productrental'}</label >
                    </span>
                    <br/>
                    <p class="info-title">{l s='NB. Selecting this option may change the total to be paid during checkout.  The total to pay will be displayed on the next screen.' mod='roja45productrental'}</p>
                </div>
            </div>
        {/if}
        <div class="roja45_productrental_summary_container col-lg-12">
        <p class="rental_navigation clearfix">
            <a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['getAvailability' => 1]}" title="{l s='Previous' mod='roja45productrental'}" class="button-exclusive btn btn-default">
                <i class="icon-chevron-left"></i>
                {l s='Back' mod='roja45productrental'}
            </a>
            {if isset($payment_required) && $payment_required}
                <button type="submit" name="submitPayment" value="1" class="btn btn-default btn-confirm pull-right">
                    <span>{l s='Confirm and Pay' mod='roja45productrental'}<i class="icon-chevron-right right"></i></span>
                </button>
            {else}
                <button type="submit" name="confirmRental" value="1" class="button btn btn-default btn-confirm pull-right">
                    <span>{l s='Confirm Rental' mod='roja45productrental'}<i class="icon-chevron-right right"></i></span>
                </button>
                <a href="{url entity='index'}" class="btn btn-default btn-continue pull-right">
                    <span>{l s='Continue Shopping' mod='roja45productrental'}<i class="icon-chevron-right right"></i></span>
                </a>
            {/if}
        </p>
        </div>
    </form>
</div>

{/block}