{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{extends file='page.tpl'}

{block name='page_title'}
    Dokonane płatności
{/block}

{block name='page_content_top'}
    <div class="roja45-productrental-customer-bookings">
        <div class="block-center" id="block_booking_history">
            {if $payments && count($payments)}
                <table id="order-list"
                       class="table table-bordered footab">
                    <thead>
                    <tr>
                        <th class="item">{l s='Payment Due By' mod='roja45productrental'}</th>
                        <th class="item">{l s='Date Paid' mod='roja45productrental'}</th>
                        <th class="item">{l s='Total (exc.)' mod='roja45productrental'}</th>
                        <th data-sort-ignore="true" class="last_item">&nbsp;</th>
                    </tr>
                    </thead>
                    <tbody>
                    {if isset($payments)}
                    {foreach $payments as $payment}
                        <tr class="{if $payment@first}first_item{elseif $payment@last}last_item{else}item{/if} {if $payment@index % 2}alternate_item{/if}">
                            <td data-value="" class="bold">
                                {$payment.date_due}
                            </td>
                            <td data-value="" class="bold">
                                {$payment.date_paid}
                            </td>
                            <td data-value="" class="bold">
                                {$payment.total_formatted}
                            </td>
                            {if $payment.payment_due && !$payment.paid}
                                <td data-value="" class="history_date bold">
                                    <a href="{url entity='module' name='roja45productrental' controller='ProductRentalFront' params = ['pay_customer_rental' => 1, 'id_roja45_product_rental' => $id_roja45_product_rental, 'id_roja45_product_rental_payment' => $payment.id_roja45_product_rental_payment]}" class="pay-rental">
                                        <i class="material-icons">payment</i><span>{l s='Pay' mod='roja45productrental'}</span>
                                    </a>
                                </td>
                            {else}
                                <td data-value="" class="history_date bold">
                                </td>
                            {/if}
                        </tr>
                    {/foreach}
                    {/if}
                    </tbody>
                </table>
            {/if}
        </div>
        <div class="block-center" id="block_booking_summary">
        </div>
    </div>
{/block}

{block name='page_footer'}
    {block name='my_account_links'}
        <a href="{$my_rentals_url}" class="account-link">
            <i class="material-icons">&#xE5CB;</i>
            <span>{l s='Back to your rentals' mod='roja45productrental'}</span>
        </a>
        <a href="{$home_url}" class="account-link">
            <i class="material-icons">&#xE88A;</i>
            <span>{l s='Home' mod='roja45productrental'}</span>
        </a>
    {/block}
{/block}

