{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

{if !count($rental_details->errors)}
    <div class="product-rental-messages-row success">
        <p class="center-block-content-message ">
            {l s='Great! Everything looks good, click Add To Rental to continue.' mod='roja45productrental'}
        </p>
    </div>
{elseif $rental_details->no_models}
    <div class="content product-rental-messages-row general-message">
        <p class="center-block-content-message">
            {l s='Please select at least one model from the list.' mod='roja45productrental'}
        </p>
    </div>
{/if}
{foreach $rental_details->info as $info}
    {if $info=='INFO_INSTANT_RENTAL'}
        <div class="product-rental-messages-row info">
            <p class="center-block-content-message">
                {l s='Instant Confirmation - Your rental will be confirmed automatically on successful payment.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $info=='INFO_NON_INSTANT_RENTAL'}
        <div class="product-rental-messages-row info">
            <p class="center-block-content-message">
                {l s='Availability Confirmation Required - Your rental will be confirmed manually prior to any deposit payment is taken.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $info=='INFO_LOCAL_TAXES' && isset($rental_details.local_tax_rate)}
        <div class="product-rental-messages-row info">
            <p class="center-block-content-message ">
                {l s='A local tax rate of %s%% may be required to be paid when you arrive.' mod='roja45productrental' sprintf=$rental_details.local_tax_rate}
            </p>
        </div>
    {/if}
{/foreach}

{foreach $rental_details->warnings as $warning}

{/foreach}

{foreach $rental_details->errors as $error}
    {if $error=='ERROR_INSUFFICIENT_AVAILABILITY'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='You have selected more items than are currently available, please check your selection.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='ERROR_INSUFFICIENT_DAYS'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='This property has a minimum rental duration of %s days, please review your dates .' sprintf=[$rental_details.minimum_stay] mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_INVALID'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, this voucher is not applicable for this rental.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_DOES_NOT_EXIST'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, this voucher does not exist.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_NOT_LOGGED_IN'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, you need to be logged in to use this voucher.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_NOT_OWNER'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, this voucher is not yours.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_EXPIRED'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, this voucher has expired.' mod='roja45productrental'}
            </p>
        </div>
    {elseif $error=='VOUCHER_USED'}
        <div class="product-rental-messages-row error">
            <p class="center-block-content-message ">
                {l s='Sorry, you cannot use this voucher again.' mod='roja45productrental'}
            </p>
        </div>
    {/if}
{/foreach}