{*
* 2016 ROJA45
* All rights reserved.
*
* DISCLAIMER
*
* Changing this file will render any support provided by us null and void.
*
*  @author 			Roja45
*  @copyright  		2016 Roja45
*  @license          /license.txt
*}

<section class="roja45-rental-product">
    <form id="roja45productrental_reserve_form"
          method="post"
          action="{$roja45_productrental_controller|escape:'html':'UTF-8'}">
        <input type="hidden"
               name="ROJA45_PRODUCTRENTAL_ID"
               value="{$ROJA45_PRODUCTRENTAL_ID|escape:'html':'UTF-8'}"/>
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_REQUEST" value=""/>
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATE_DURATION" value="{$ROJA45_PRODUCTRENTAL_RATE_DURATION}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_MINIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MINIMUM_DURATION}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION" value="{$ROJA45_PRODUCTRENTAL_MAXIMUM_DURATION}">
        <input type="hidden" name="ROJA45_PRODUCTRENTAL_RATEPERIOD" value="{$roja45_productrental_rateperiods[$default_id].id_rate_period|escape:'html':'UTF-8'}"/>

        <section class="roja45productrental-search-bar col-md-12">
            <div class="row">
                <h3>{l s='Search' mod='roja45productrental'}</h3>
                <span class="cross" title="{l s='Close window' mod='roja45productrental'}"></span>
                <div class="row row-40">
                    <div class="form-field {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}col-sm-7{else}col-sm-12{/if}">
                        <label class="label">
                            <span>{l s='Collection Date' mod='roja45productrental'}</span>
                        </label>
                        <div class="input-group">
                            <input name="ROJA45_PRODUCTRENTAL_COLLECTION_DATE"
                                   type="text"
                                   class="form-control datepicker required"
                                   placeholder="{$roja45_productrental_dateformat}"
                                   autocomplete="off"
                                   required="required"
                                   {if !empty($ROJA45_PRODUCTRENTAL_COLLECTION_DATE)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_DATE|escape:'htmlall':'UTF-8'}"{/if}
                                   required/>
                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                        </div>
                    </div>
                    {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
                        <div class="form-field col-sm-5">
                            <label class="label">
                                <span>{l s='Time' mod='roja45productrental'}</span>
                            </label>
                            <div class="input-group">
                                <input name="ROJA45_PRODUCTRENTAL_COLLECTION_TIME"
                                       type="text"
                                       class="form-control timepicker"
                                       placeholder="{$roja45_productrental_timeformat}"
                                       autocomplete="off"
                                       {if isset($ROJA45_PRODUCTRENTAL_COLLECTION_TIME)}value="{$ROJA45_PRODUCTRENTAL_COLLECTION_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                                <span class="input-group-addon"><i class="icon-clock-o"></i></span>
                            </div>
                        </div>
                    {/if}
                </div>
                <div class="row row-40">
                    <div class="form-field {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}col-sm-7{else}col-sm-12{/if}">
                        <label class="label">
                            <span>{l s='Return Date' mod='roja45productrental'}</span>
                        </label>
                        <div class="input-group">
                            <input name="ROJA45_PRODUCTRENTAL_RETURN_DATE"
                                   type="text"
                                   class="form-control datepicker"
                                   placeholder="{$roja45_productrental_dateformat}"
                                   autocomplete="off"
                                   required="required"
                                   {if isset($ROJA45_PRODUCTRENTAL_RETURN_DATE)}value="{$ROJA45_PRODUCTRENTAL_RETURN_DATE|escape:'htmlall':'UTF-8'}"{/if}/>
                            <span class="input-group-addon"><i class="icon-calendar"></i></span>
                        </div>
                    </div>
                    {if $ROJA45_PRODUCTRENTAL_ENABLECUSTOMERTIMESELECT}
                        <div class="form-field col-sm-5">
                            <label class="label">
                                <span>{l s='Time' mod='roja45productrental'}</span>
                            </label>
                            <div class="input-group">
                                <input name="ROJA45_PRODUCTRENTAL_RETURN_TIME"
                                       type="text"
                                       class="form-control timepicker"
                                       placeholder="{$roja45_productrental_timeformat}"
                                       autocomplete="off"
                                       {if isset($ROJA45_PRODUCTRENTAL_RETURN_TIME)}value="{$ROJA45_PRODUCTRENTAL_RETURN_TIME|escape:'htmlall':'UTF-8'}"{/if}/>
                                <span class="input-group-addon"><i class="icon-clock-o"></i></span>
                            </div>
                        </div>
                    {/if}
                </div>
                <div class="row row-20">
                    <div class="form-field col-sm-7">
                        <label class="label">
                            <span>{l s='Quantity' mod='roja45productrental'}</span>
                        </label>
                        <div class="quantity table-row"
                             data-field-name="qty"
                             data-field-min-value="1"
                             data-field-max-value="-1"
                             data-field-add-total="1"
                             data-field-current-value="{if isset($qty)}{$qty|escape:'htmlall':'UTF-8'}{else}1{/if}">
                            <div class="table-cell decrement text-container">
                                <button type="button" class="btn btn-default btn-number-spinner decrement disabled" disabled="">
                                    <span>-</span>
                                </button>
                            </div>
                            <div class="table-cell value text-container">
                                <input type="hidden" name="qty" value="{if isset($qty)}{$qty|escape:'htmlall':'UTF-8'}{else}1{/if}" />
                                <span>{if isset($qty)}{$qty|escape:'htmlall':'UTF-8'}{else}1{/if}</span>
                            </div>
                            <div class="table-cell increment text-container">
                                <button type="button" class="btn btn-default btn-number-spinner increment">
                                    <span>+</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <div class="form-field col-sm-5">
                        <label class="label">&nbsp;</label>
                        <button type="submit" class="btn btn-primary btn-update pull-right">
                            <span>{l s='Update' mod='roja45productrental'}</span>
                        </button>
                    </div>
                </div>
            </div>
        </section>
        <section class="col-md-12">
            <div class="row">
                {if isset($errors) && $errors}
                <div class="alert alert-danger">
                    <p>{if $errors|@count > 1}{l s='There are %d errors' sprintf=$errors|@count mod='roja45productrental'}{else}{l s='There is %d error' sprintf=$errors|@count mod='roja45productrental'}{/if}</p>
                    <ol>
                        {foreach $errors as $error}
                            <li>{$error|escape:'html':'UTF-8'}</li>
                        {/foreach}
                    </ol>
                </div>
                {else}
                <div class="general_message">
                    {if $rates_available}
                        <div class="general_message_icon success"></div>
                        <span class="general_message_header">{l s='Please find below products that meet your search criteria.' mod='roja45productrental'}</span>
                        <div class="general_message_body">{l s='If you can\'t find anything suitable, please adjust your search or choose a different product.' mod='roja45productrental'}</div>
                    {else}
                        <div class="general_message_icon warning"></div>
                        <span class="general_message_header">{l s='We were not able to find sufficient availability' mod='roja45productrental'}</span>
                        <div class="general_message_body">{l s='Please adjust your search or choose a different product.' mod='roja45productrental'}</div>
                    {/if}
                </div>
                {/if}
            </div>
        </section>
        <section class="col-md-12">
            <div class="row">
            {if $rates_available>0}
                <section class="right-column totals-scroll-anchor col-md-4">
                    <div class="totals-scroll-content">
                        <section class="card rental-totals-content">
                            <section id="rental_totals" class="">
                                <div class="rental-totals-container">
                                    {include file="./booking-page-totals.tpl"}
                                </div>
                                <hr class="separator">
                                <div class="card-block">
                                    <button type="submit"
                                            class="{if !$rental_valid}disabled{/if} btn btn-default btn-productrental-selectextras no-print"
                                            style="{if $roja45_productrental_hasextras}display: block;{else}display: none;{/if}">
                                        <span>{l s='Select Extras' mod='roja45productrental'}</span>
                                    </button>
                                    <button type="submit"
                                            class="{if !$rental_valid}disabled{/if} btn btn-default btn-productrental-reserve no-print"
                                            {if $roja45_productrental_hasextras}style="display: none;"{/if}>
                                        <span>{l s='Continue' mod='roja45productrental'}</span>
                                    </button>
                                </div>
                                <div id="rental_totals_updating">
                                    <div class="modal-wait-container">
                                        <i class="icon-refresh spin"></i>
                                        <h4>{l s='Updating prices..' mod='roja45productrental'}</h4>
                                    </div>
                                </div>
                            </section>
                        </section>
                        <section id="rental_messages" class="page-content rental-messages-container ">
                            {include file='./booking-page-messages.tpl'}
                        </section>
                        <section id="block-rental-reassurance">
                            <ul>
                                {if isset($rental_details->damage_deposit) && $rental_details->damage_deposit->id_deposit_type==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_FIXED_TYPE}
                                    <li>
                                        <div class="block-reassurance-item">
                                            {if $rental_details->damage_deposit->id_deposit_method==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_ASIS_METHOD}
                                                <span class="h5">{l s='Damage deposit will be as specified for your rental.' mod='roja45productrental'}</span>
                                            {elseif ($rental_details->damage_deposit->id_deposit_method==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEM_METHOD)}
                                                <span class="h5">{l s='Damage deposit calculated for each item of this type in your rental.' mod='roja45productrental'}</span>
                                            {elseif ($rental_details->damage_deposit->id_deposit_method==ProductRentalDamageDeposit::DAMAGE_DEPOSIT_PERITEMPERDAY_METHOD)}
                                                <span class="h5">{l s='Damage deposit calculated for each item of this type, per day, in your rental.' mod='roja45productrental'}</span>
                                            {/if}
                                        </div>
                                    </li>
                                {/if}
                                {if !$roja45_productrental_singleitemrentals}
                                    <li>
                                        <div class="block-reassurance-item">
                                            <span class="h5">{l s='If you would like to add more products to your rental, select Continue, and then select the Continue Shopping option on the next page.' mod='roja45productrental'}</span>
                                        </div>
                                    </li>
                                {/if}
                                <li>
                                    <div class="block-reassurance-item">
                                        <span class="h5">{l s='You will have the opportunity to review your rental before payment.' mod='roja45productrental'}</span>
                                    </div>
                                </li>
                            </ul>
                        </section>
                    </div>
                </section>
                <section class="left-column col-md-8">
                    <section id="roja45_rental_requirements" class="page-content">
                        <section id="rental_summary" class="rental-summary-container">
                            <div class="left-block row">
                                <div class="col-xs-12 col-lg-5">
                                    <div class="row">
                                        <img src="{$product->cover_image.src|escape:'html':'UTF-8'}"
                                             alt="{$product->cover_image.title|escape:'html':'UTF-8'}"
                                             title="{$product->cover_image.title|escape:'html':'UTF-8'}"
                                             width="{$product->cover_image.width|escape:'html':'UTF-8'}"
                                             height="{$product->cover_image.height|escape:'html':'UTF-8'}">
                                    </div>
                                </div>
                                <div class="col-xs-12 col-lg-7">
                                    <div class="row">
                                        <div class="rental-summary-product-details-container">
                                            <h3>{$product->name|escape:'html':'UTF-8'}</h3>
                                            {$product->description}
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>
                        <section id="roja45productrental_available_models">
                            <div class="content">
                                <div class="row">
                                    <div id="roja45productrental_available_models" class="table_block table-responsive">
                                        {hook h="displayRoja45ProductRentalBookingHeader" rental_product=$rental_product}
                                        <div id="available_models_container" class="available-models-container col-lg-12">
                                            <ul class="product-rental-room-list row list">
                                                {foreach $models as $model}
                                                <li class="ajax-block-product-rental-model product-rental-list col-lg-12 {if ($model.availability<=0)}unavailable{/if} {if isset($selected_rate) && isset($selected_rate[$model.id_roja45_product_model]) && $model.availability>0}has-quantity{/if}"
                                                    data-qty-available="{$model.availability|escape:'html':'UTF-8'}"
                                                    data-id-roja45-product-model="{$model.id_roja45_product_model|escape:'html':'UTF-8'}"
                                                    data-id-product-attribute="{$model.id_product_attribute|escape:'html':'UTF-8'}"
                                                    data-num-selected-rates="{$selected_rate|@count}">
                                                    <div class="product-rental-model-container row">
                                                        <div class="left-block col-lg-12">
                                                            <div class="left-block-content row">
                                                                <div class="column-one col-xs-12 col-sm-6 col-md-4 col-lg-12">
                                                                    <div class="row">
                                                                        {if isset($model.image)}
                                                                            <img src="{$model.image.src|escape:'html':'UTF-8'}"
                                                                                 alt="{$model.image.title|escape:'html':'UTF-8'}"
                                                                                 title="{$model.image.title|escape:'html':'UTF-8'}"
                                                                                 width="{$model.image.width|escape:'html':'UTF-8'}"
                                                                                 height="{$model.image.height|escape:'html':'UTF-8'}">
                                                                        {/if}
                                                                    </div>
                                                                </div>
                                                                <div class="column-one col-xs-12 col-sm-6 col-md-4 col-lg-12">
                                                                    <div class="row">
                                                                        <h4>{$model.model_name|escape:'html':'UTF-8'}</h4>
                                                                        {if ($model.availability<=0)}
                                                                            <p class="warning-message sold-out">{l s='Out Of Stock' mod='roja45productrental'}</p>
                                                                        {elseif ($model.availability==1)}
                                                                            <p class="warning-message last-products">{l s='Last chance, only 1 left.' mod='roja45productrental'}</p>
                                                                        {elseif ($model.availability<=$ROJA45_PRODUCTRENTAL_QTYWARNING)}
                                                                            <p class="warning-message last-products">{l s='Only %s left, book now.' mod='roja45productrental' sprintf=$model.availability}</p>
                                                                        {else}
                                                                            <p class="info-message quantity">{l s='Quantity Available: ' mod='roja45productrental'}{$model.availability|escape:'html':'UTF-8'}</p>
                                                                        {/if}
                                                                    </div>
                                                                </div>
                                                                <div class="column-one col-xs-12 col-sm-6 col-md-4 col-lg-12">
                                                                    <div class="row">
                                                                        {*HTML Content*} {html_entity_decode($model.description|escape:'htmlall':'UTF-8')}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {if ($model.availability>0)}
                                                        <div class="right-block col-lg-12">
                                                            <div class="right-block-content row">
                                                                <div id="available-models-rates" class="col-lg-12">
                                                                    <div class="row">
                                                                        <div class="product-rental-quantity-container">
                                                                            <div class="product-rental-quantity">
                                                                                {l s='Quantity' mod='roja45productrental'}
                                                                            </div>
                                                                            <div class="product-rental-quantity">
                                                                                <input id="selected_qty_{$model.id_roja45_product_model|escape:'htmlall':'UTF-8'}" name="selected_qty" type="number" min="1" max="{$model.availability}" value="{if isset($selected_rate[$model.id_roja45_product_model]) && isset($selected_rate[$model.id_roja45_product_model]['qty'])}{$selected_rate[$model.id_roja45_product_model]['qty']|escape:'htmlall':'UTF-8'}{else}1{/if}"/>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="product-rental-rate-list row list" id="rate-info-{$model.id_roja45_product_model}">
                                                                    {if $rates_available}
                                                                        {foreach $model.rates as $rate}
                                                                        <div class="product-rental-rate-list-container rate-selector {if isset($selected_rate[$model.id_roja45_product_model]) && $rate.id_roja45_product_rate==$selected_rate[$model.id_roja45_product_model]['id_roja45_product_rate']}selected{/if}"
                                                                             data-id-roja45-product-rate="{$rate.id_roja45_product_rate|escape:'htmlall':'UTF-8'}">
                                                                            <div class="product-rental-rate-container-header">
                                                                                <div class="product-rental-rate">
                                                                                    <input type="checkbox" id="product_rental_rate_{$rate.id_roja45_product_rate}" name="product_rental_rate" class="checkbox" {if isset($selected_rate[$model.id_roja45_product_model]) && $rate.id_roja45_product_rate==$selected_rate[$model.id_roja45_product_model]['id_roja45_product_rate']}checked="checked"{/if}/>
                                                                                </div>
                                                                                <div class="product-rental-rate">
                                                                                    {$rate.name}
                                                                                </div>
                                                                            </div>
                                                                            <div class="rental-periods clearfix">
                                                                                <div class="rental-periods-content rental-periods-content-{$rate.duration_type}">
                                                                                    {foreach $rate.periods as $period}
                                                                                        <div class="rental-periods-content-column-container" data-period="{$period->period}">
                                                                                            <div class="rental-periods-content-column-header">
                                                                                                <div class="period"><p>{if $period->period_type==2}{l s='Day' mod='roja45productrental'}&nbsp;{/if}{$period@iteration}</p></div>
                                                                                            </div>
                                                                                            <div class="rental-periods-content-column-row">
                                                                                                <div class="rate"><p>{$period->rate_formatted}</p></div>
                                                                                            </div>
                                                                                        </div>
                                                                                    {/foreach}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        {/foreach}
                                                                        {else}
                                                                        <div class="row">
                                                                            <div class="column-one col-lg-12">
                                                                                TODO - NO RATES AVAILABLE
                                                                            </div>
                                                                        </div>
                                                                        {/if}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {hook h="displayRoja45ProductRentalModelAdditionalContent" rental_product=$rental_product address=$address model=$model}
                                                        {if (isset($model.has_seasonal_rates) && $model.has_seasonal_rates==1) || isset($model.payment_profile)}
                                                        <div class="footer-block col-lg-12">
                                                            <div id="roja45productrental_addons_block">
                                                                <div class="roja45productrental-addons-container col-lg-12">
                                                                    <div class="row">
                                                                        <div class="header">
                                                                            <span>{l s='Important Information' mod='roja45productrental'}</span>
                                                                        </div>
                                                                        <div id="roja45productrental_message_block">
                                                                        {if isset($model.has_seasonal_rates) && $model.has_seasonal_rates==1}
                                                                            <div class="product-rental-warning">
                                                                                <p>{l s='Rental includes seasonal rates' mod='roja45productrental'}</p>
                                                                            </div>
                                                                        {/if}
                                                                        {if $model.payment_profile_enabled==1}
                                                                            <div class="product-rental-info">
                                                                                {if isset($model.payment_profile) && ($model.payment_profile->type==1)}
                                                                                    <p>{l s='Deposit Amount Required: ' mod='roja45productrental'}{displayPrice price={toolsConvertPrice price=$model.payment_profile->action1}}</p>
                                                                                {/if}
                                                                                {if isset($model.payment_profile) && ($model.payment_profile->type==2)}
                                                                                    <p>{l s='Deposit Amount Required: ' mod='roja45productrental'}{$model.payment_profile->action1|escape:'html':'UTF-8'}%</p>
                                                                                {/if}
                                                                            </div>
                                                                        {/if}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        {/if}
                                                        {/if}
                                                    </div>
                                                </li>
                                                {/foreach}
                                            </ul>
                                        </div>
                                        {hook h="displayRoja45ProductRentalBookingFooter" rental_product=$rental_product}
                                    </div>
                                </div>
                            </div>
                        </section>
                        <section id="roja45productrental_available_extras" class="" style="display: none;">
                            <div class="content row">
                                <a href="#back" class="btn btn-default btn-back-to-models"><i class="icon-chevron-left"></i>{l s='Back' mod='roja45productrental'}</a>
                            </div>
                            <div class="content row">
                                {foreach $models as $model}
                                    <article class="ajax-block-product-rental-extra product-rental-list col-lg-12 page-content"
                                             data-id-roja45-product-model="{$model.id_roja45_product_model}"
                                             data-id-product-attribute="{$model.id_product_attribute}"
                                             style="display: none;">
                                        <h3 class="title">{$model.model_name}</h3>
                                        <div class="product-rental-extra-container row">
                                            {if isset($model.addons)}
                                                {foreach $model.addons as $addon}
                                                    <div class="extra col-lg-6">
                                                        <div class="roja45productrental-addon row"
                                                             data-id-roja45-product-extra="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                             data-deselect-warning="{$addon.deselect_warning|escape:'htmlall':'UTF-8'}">
                                                            <div class="col-lg-5">
                                                                {$addon.image_url nofilter}
                                                                <p class="text-center mt-1">
                                                                    <a href="#modal-extra-info-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}"
                                                                       data-toggle="modal"
                                                                       class="more-info">
                                                                        <i class="icon-plus-square-o"></i>{l s='More Info' mod='roja45productrental'}</a>
                                                                </p>
                                                            </div>
                                                            <div class="col-lg-7">
                                                                <h4 class="title">
                                                                    {$addon.name}
                                                                </h4>
                                                                {if $addon.id_roja45_productrental_extra_type==1}
                                                                    <p class="roja45productrental-addon-title">
                                                                        {l s='Per Period Rate' mod='roja45productrental'}
                                                                    </p>
                                                                    <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                        {l s='This extra will be charged daily.' mod='roja45productrental'}
                                                                    </p>
                                                                {elseif $addon.id_roja45_productrental_extra_type==2}
                                                                    <p class="roja45productrental-addon-title">
                                                                        {l s='Per Rental Rate' mod='roja45productrental'}
                                                                    </p>
                                                                    <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                        {l s='This extra will be applied once for the entire rental period.' mod='roja45productrental'}
                                                                    </p>
                                                                {elseif $addon.id_roja45_productrental_extra_type==3}
                                                                    <p class="roja45productrental-addon-title">
                                                                        {l s='Per Rental Item' mod='roja45productrental'}
                                                                    </p>
                                                                    <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                        {l s='This extra will be applied once for the entire rental period.' mod='roja45productrental'}
                                                                    </p>
                                                                {elseif $addon.id_roja45_productrental_extra_type==4}
                                                                    <p class="roja45productrental-addon-title">
                                                                        {l s='Per Rental Item, Per Period' mod='roja45productrental'}
                                                                    </p>
                                                                    <p for="{$addon.id_roja45_product_extra|escape:'html':'UTF-8'}" class="roja45productrental-addon-description">
                                                                        {l s='This extra will be applied once for the entire rental period.' mod='roja45productrental'}
                                                                    </p>
                                                                {/if}
                                                                <p class="price standard mt-2">
                                                                    {$addon.rate_formatted}
                                                                </p>
                                                                <p class="price free-voucher mt-2" style="display:none;">
                                                                    {l s='FREE (Included with your voucher)' mod='roja45productrental'}
                                                                </p>
                                                                <div class="roja45productrental-addon-checkbox">
                                                                    {if $addon.required}
                                                                        <div class="checkbox checked-box" data-checked="checked"></div>
                                                                    {elseif $addon.id_roja45_productrental_extra_type==3}
                                                                        <label>{l s='Select' mod='roja45productrental'}</label>
                                                                        <input type="checkbox" name="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}" class="checkbox" checked="checked"/>
                                                                    {else}
                                                                        <label>{l s='Select' mod='roja45productrental'}</label>
                                                                        <input type="checkbox" class="checkbox" name="{$addon.id_roja45_product_extra|escape:'htmlall':'UTF-8'}" {if isset($addon.default_selected) && ($addon.default_selected==1)}checked="checked"{/if}>
                                                                    {/if}
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div tabindex="-1" role="dialog" id="modal-extra-info-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra}" class="modal fade modal-specs" style="display: none;" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                            <i class="icon-times"></i>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <h5>{$addon.name|escape:'html':'UTF-8'}</h5>
                                                                        <div class="row description">
                                                                            <div class="col-md-5">
                                                                                <div>
                                                                                    {$addon.image_url|escape:'html':'UTF-8'}
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-7">
                                                                                {$addon.description}
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div tabindex="-1" role="dialog" id="modal-deselect-warning-{$model.id_roja45_product_model}-{$addon.id_roja45_product_extra}" class="modal fade modal-specs" style="display: none;" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <button type="button" data-dismiss="modal" aria-label="Close" class="close">
                                                                            <i class="icon-times"></i>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <h5>{l s='Are you sure?' mod='roja45productrental'}</h5>
                                                                        <div class="row description">
                                                                            <div class="col-md-7">
                                                                                {$addon.deselect_warning_text}
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                {/foreach}
                                            {/if}
                                        </div>
                                    </article>
                                {/foreach}
                            </div>
                        </section>
                    </section>
                </section>
            </div>
        </section>
    </form>
</section>
{/if}

<div id="immersive-modal-dialog" class="immersive-modal-dialog">
    <div class="modal-wait-container">
        <div class="modal-wait-icon spin"></div>
        <h2>{l s='Please Wait..' mod='roja45productrental'}</h2>
    </div>
</div>

<div id="immersive-confirm-dialog" class="ui-dialog"  style="display:none">
    <div class="ui-dialog-titlebar"></div>
    <div class="ui-dialog-content">
        <p>{l s='You have warnings' mod='roja45productrental'}</p>
    </div>
    <div class="ui-dialog-buttonpane"></div>
</div>

<style type="text/css" style="display: none">
    #roja45_module_header {
        position: relative;
        background-color: white;
        padding: 20px;
        margin-bottom: 20px;
        border: solid 1px #DA4646;
        -webkit-border-radius: 5px;
        border-radius: 5px;
    }

    #roja45_module_header .logo-block {
        position: absolute;
        left: 15px;
        top: -7px;
    }

    #roja45_module_header a {
        text-decoration: none;
    }

    #roja45_module_header .logo-block h1 {
        font-size: 40px;
        margin-top: 5px;
        margin-bottom: 5px;
        font-weight: 700;
    }

    #roja45_module_header .logo-block h1 .r1 {
        color: black;
    }
    #roja45_module_header .logo-block h1 .r2 {
        color: red;
    }
    #roja45_module_header .logo-block a:hover h1 .r1 {
        color: black;
        text-decoration: underline;
    }
    #roja45_module_header .logo-block a:hover h1 .r2 {
        color: red;
        text-decoration: underline;
    }

    #roja45_module_header .support-block {
        position: absolute;
        right: 15px;
        color: red;
        top: 10px;
    }
    #roja45_module_header .support-block a {
        font-size: 15px;
        margin-top: 5px;
        margin-right: 5px;
        margin-bottom: 5px;
        font-weight: 700;
        color: red;
        text-transform: uppercase;
    }
    #roja45_module_header .support-block a:hover {
        text-decoration: underline;
    }
    #immersive-modal-dialog {
        display:none;
        position:fixed;
        top:0;
        left:0;
        background:black;
        width:100%;
        height:100%;
        z-index: 9999;
        opacity: 0.7;
    }

    #immersive-modal-dialog .modal-wait-container
    {
        text-align:center;
        position:absolute;
        left: 50%;
        top: 50%;
        margin-left:-10px;
        margin-top: -10px;
    }

    #immersive-modal-dialog .modal-wait-container .modal-wait-icon
    {
        width: 60px;
        height: 60px;
        font-size: 60px;
        margin-left: auto;
        margin-right: auto;
    }

    #immersive-modal-dialog .modal-wait-container .modal-wait-icon:before
    {
        font-size: 50px;
        line-height: 50px;
        content: '\f021';
        font-family: "FontAwesome";
    }

    .spin {
        -webkit-animation-name: spin;
        -webkit-animation-duration: 3000ms;
        -webkit-animation-iteration-count: infinite;
        -webkit-animation-timing-function: linear;
        -moz-animation-name: spin;
        -moz-animation-duration: 3000ms;
        -moz-animation-iteration-count: infinite;
        -moz-animation-timing-function: linear;
        -ms-animation-name: spin;
        -ms-animation-duration: 3000ms;
        -ms-animation-iteration-count: infinite;
        -ms-animation-timing-function: linear;
        -o-transition: rotate(3600deg);
        transform: initial;
    }

    .immersive-message-dialog {
        width: 200px;
        height: 50px;
        border-radius: 3px;
        position: absolute;
        z-index: 999;
        right: 0;
        bottom: 0;
    }

    .immersive-message-dialog.error {
        background-color: rgba(232, 30, 27, 0.5);
    }
    .immersive-message-dialog.warning {
        background-color: rgba(226, 173, 61, 0.5);
    }
    .immersive-message-dialog.success {
        background-color: rgba(40, 226, 10, 0.50);
    }
    #immersive-error-dialog {

    }

    #immersive-warning-dialog {

    }

    #growls.immersive {
        top: 95px;
        right: 10px;
    }
</style>
